^TI^'
^TITW^format 
^TIS^formatString 
^TIS^arg... 
^TI^' Command
^P^
^B^format
 takes data contained in the 
^S^arg
 arguments, and formats this data into a single result string suitable for 
output (or other use) according to the format specified by 
^S^formatString
. The command operates by scanning 
^S^formatString
 from left to right. Each character from the format string is appended 
to the result string unless it is a percent sign. If the 
character is a % then it is not copied to the result 
string. Instead, the characters following the % character 
are treated as a 
^I^conversion specifier
. The conversion specifier controls the conversion of the next unprocessed  
^S^arg
 to a particular format, and the result is appended to 
the result string in place of the conversion specifier. 
If there are multiple conversion specifiers in the format 
string, then each one controls the conversion of one additional 
^S^arg
. The 
^B^format
 command must be given enough 
^S^arg
s to meet the needs of all of the conversion specifiers in 
^S^formatString
.
^P^
Each conversion specifier may contain up to six different
parts: a 
^I^position specifier
, a set of 
^I^flags
, a 
^I^minimum field width
, a 
^I^precision
, a 
^I^length modifier
, and a 
^I^conversion character
. Any of these fields may be omitted 
except for the conversion character. The fields that are 
present must appear in the order given above. The subsections  
below discuss each of these fields in turn.
^P^
^TI^Position Specifier
^P^
If the % is followed by a decimal number and a $, as in 
"%2$d", then the value to convert is not taken from the 
next sequential argument. Instead, it is taken from the 
argument indicated by the number, where 1 corresponds to 
the first 
^S^arg
. If the conversion specifier requires multiple arguments 
because of * characters (described later) in the specifier, 
then successive arguments are used, starting with the 
argument given by the number. 
^B^Note:
 If there are 
^I^any 
positional specifiers in 
^S^formatString
 then 
^I^all
 of the specifiers must be positional.
^P^
^TI^Flags
^P^
The second portion of a conversion specifier may contain 
any of the following flag characters, in any order:
^P^
^B^-
 : Specifies that the converted argument should be 
left-justified in its field (numbers are normally 
right-justified with leading spaces if needed).
^P^
^B^+
 : Specifies that a number should always be printed 
with a sign, even if positive.
^P^
' ' (space character) : Specifies that a space should be added to the 
beginning of the number if the first character isn't a sign.
^P^
^B^0
 : Specifies that a number should be padded on 
the left with zeroes instead of spaces.
^P^
^B^#
 : Requests an alternate output form. For 
^B^o
 and 
^B^O
 conversions it guarantees that the first digit 
^S^d
 is always "0". For 
^B^x
 or 
^B^X
 conversions, "0x" or "0X" (respectively) will be added to the beginning of 
the result unless it is zero. For all floating-point 
conversions (
^B^e
, 
^B^E
, 
^B^f
, 
^B^g
, and 
^B^G
) it guarantees that the result always has a decimal point. For 
^B^g
 and 
^B^G
 conversions it specifies that trailing zeroes should not be removed.
^P^
^TI^Minimum Field Width
^P^
The third portion of a conversion specifier is a number 
giving a minimum field width for this conversion. It is 
typically used to make columns line up in tabular printouts. 
If the converted argument contains fewer characters 
than the minimum field width then it will be padded so 
that it is as wide as the minimum field width. Padding 
normally occurs by adding extra spaces on the left of the 
converted argument, but the 
^B^0
 and 
^B^-
 flags may be used to specify padding with zeroes on the left or with 
spaces on the right, respectively. If the minimum field width is 
specified as 
^B^*
 rather than a number, then the next argument to the 
^B^format
 command determines the minimum field width; it must be a numeric string.
^P^
^TI^Precision
^P^
The fourth portion of a conversion specifier is a precision, 
which consists of a period followed by a number. 
The number is used in different ways for different conversions. 
For 
^B^e
, 
^B^E
, 
and 
^B^f
 conversions it specifies the number of digits to 
appear to the right of the decimal point. 
For 
^B^g
 and 
^B^G
 conversions it specifies the total number of 
digits to appear, including those on both sides of the 
decimal point (but trailing zeroes after the decimal 
point will still be omitted unless the 
^B^#
 flag has been specified). For integer conversions, it specifies a 
minimum number of digits to print (leading zeroes will be 
added if necessary). For 
^B^s
 conversions it specifies the maximum number of characters to be printed; 
if the string is longer than this then the trailing characters will be 
dropped. If the precision is specified with 
^B^*
 rather than a number then the next argument to the 
^B^format
 command determines the precision; it must be a numeric string. 
^P^
^TI^Length Modifier
^P^
The fifth part of a conversion specifier is a length modifier, 
which must be 
^B^h
 or 
^B^l
. If it is 
^B^h
 it specifies that 
the numeric value should be truncated to a 16-bit value 
before converting. This option is rarely useful. The 
^B^l
 modifier currently is ignored.
^P^
^TI^Conversion Character (required)
^P^
The last thing in a conversion specifier (and the only part of the 
specifier that is mandatory) is an alphabetic 
character that determines what kind of conversion to perform. 
The following conversion characters are currently supported:
^P^
^B^d
 : Convert integer to signed decimal string.
^P^
^B^u
 : Convert integer to unsigned decimal string.
^P^
^B^i
 : Convert integer to signed decimal string; the
 integer may either be in decimal, in octal (with
 a leading 0) or in hexadecimal (with a leading
 0x).
^P^
^B^o
 : Convert integer to unsigned octal string.
^P^
^B^x
 or 
^B^X
 : Convert integer to unsigned hexadecimal string,
 (using digits "0123456789abcdef" for 
^B^x
 and
 "0123456789ABCDEF" for 
^B^X
).
^P^
^B^c
 : Convert integer to the 8-bit character it represents.
^P^
^B^s
 : No conversion; just insert the string.
^P^
^B^f
 : Convert a floating-point number to a signed decimal
 string of the form 
^I^xx .yyy
, where the number of  
^I^y
's is determined by the precision (default: 6).
 If the precision is 0 then no decimal point is
 output.
^P^
^B^e
 or 
^B^E
 : Convert floating-point number to scientific
 notation in the form 
^I^x .yyy
^B^e
+-
^I^zz
, where the number of 
^I^y
's is determined by the precision (default: 6). If the precision is 0 then no
 decimal point is output. If the 
^B^E
 form is used
 then 'E' is printed in the result string instead of 'e'.
.
^P^
^B^g
 or 
^B^G
 : If the exponent is less than -4 or greater than
 or equal to the precision, then convert a
 floating-point number as for %e or %E. Otherwise convert as for %f. 
Trailing zeroes and a trailing decimal point are omitted.
^P^
^B^%
 : No conversion: just insert %.
^P^
For the numerical conversions the argument being converted 
must be an integer or floating-point string; 
^B^format 
converts the argument to binary and then converts it back to 
a string according to the conversion specifier.
^P^
^P^
^TI^Differences from ANSI 'sprintf'
^P^
This section will only be of interest to those users familiar with the 
'sprintf' command as used in the C programming language.
^P^
The behavior of the 
^B^format
 command is the same as the ANSI 
C sprintf procedure except for the following differences: 
^P^
[1] %p and %n specifiers are not currently supported.
^P^
[2] For %c conversions the argument must be a decimal 
string, which will then be converted to the corresponding character value.
^P^
[3] The l modifier is ignored; integer values are 
always converted as if there were no modifier present and real values are 
always converted as if the l modifier were present (i.e. type 'double' is used 
for the internal representation). If the h modifier is specified then integer 
values are truncated to 'short' before conversion.


