# FrameWidget.tcl - itcl base class for widgets with their own frame
#
# Copyright (C) 1994 Allan Brighton (allan@piano.sta.sub.org)


itcl_class FrameWidget {

    # Create a frame with the same name as this object

    constructor {config} {
	set class [$this info class]
	::rename $this $this-tmp-
	frame $this -class $class -relief $relief -bd $bd
	::rename $this $this-win
	::rename $this-tmp- $this

	# catch destroy and remove the object's command, therefore
	# removing the object
	bind $this <Destroy> "\
		[bind [winfo class $this] <Destroy>] ;
		[bind $this <Destroy>] ;
		rename $this-win {}"

	#  Explicitly handle config's that may have been ignored earlier
	foreach attr $config {
	    config -$attr [set $attr]
	}
    }

    #  used to change public attributes

    method config {config} {}


    #  destroy window containing widget
    
    destructor {
	destroy $this
    }


    # run the given tcl command while displaying the busy cursor

    method busy {cmd} {
	global errorInfo errorCode

	set w [winfo toplevel $this]
	if {[incr busy_count_] == 1} {
	    blt_busy hold $w
	    update idletasks
	}

	# save any errors and report them later
	if {[set code [catch [list uplevel $cmd] msg]]} {
	    set info $errorInfo
	} 

	if {[incr busy_count_ -1] == 0} {
	    blt_busy release $w
	}

	if {$code} {
	    uplevel [list error $msg $info $code]
	}
    }


    # -- public variables --

    # set the borderwidth on the frame
    public bd {0} {
	if {[winfo exists $this-win]} {
	    $this-win configure -bd $bd
	}
    }

    # set the relief on the frame
    public relief {flat} {
	if {[winfo exists $this-win]} {
	    $this-win configure -relief $relief
	}
    }
	

    # -- protected variables --

    # count used for busy cursor
    protected busy_count_ {0}
}
