# DoubleTableList.tcl - itcl widget for displaying 2 TableLists with arrows between
#                  them for moving items back and forth.
#
# You can access the left and right TableLists as $w.left and $w.right,
# where $w is the name of the DoubleTableList widget.
#
# Copyright (C) 1994 Allan Brighton (allan@piano.sta.sub.org)


itcl_class DoubleTableList {
    inherit FrameWidget


    # move the selected elements from the left to the right TableList

    method move_right {} {
	$this.right append_rows [$this.left remove_selected]
    }


    # move the selected elements from the right to the left TableList

    method move_left {} {
	$this.left append_rows [$this.right remove_selected]
    }


    # move the selected elements from the right to the left TableList

    method move_up {} {
	$this.left move_up
    }


    # move the selected elements from the right to the left TableList

    method move_down {} {
	$this.left move_down
    }


    # make the TableLists empty

    method clear {} {
	$this.left clear
	$this.right clear
    }


    #  create a new object of this class

    constructor {config} {
	FrameWidget::constructor
	global app_library
	
	pack [TableList $this.left \
		-title $left_title \
		-show_menubutton 0 \
		-exportselection $exportselection \
		-single_select $single_select] \
		-side left -fill both -expand 1

	pack [frame $this.arrows -bd 1m] \
		-side left -fill y -ipadx 0.5m

	pack [label $this.arrows.fill -text " "] \
		-side top -fill x

	pack [button $this.arrows.right \
		-bitmap @$app_library/bitmaps/right.xbm \
		-command "$this move_right"] \
		-side top -fill y -expand 1

	pack [button $this.arrows.left \
		-bitmap @$app_library/bitmaps/left.xbm \
		-command "$this move_left"] \
		-side top -fill y -expand 1 -pady 1m

	if {$up_down} {
	    pack [button $this.arrows.up \
		-bitmap @$app_library/bitmaps/up.xbm \
		-command "$this move_up"] \
		-side top -fill y -expand 1

	    pack [button $this.arrows.down \
		-bitmap @$app_library/bitmaps/down.xbm \
		-command "$this move_down"] \
		-side top -fill y -expand 1 -pady 1m
	}

	pack [TableList $this.right \
		-title $right_title \
		-show_menubutton 0 \
		-exportselection $exportselection \
		-single_select $single_select] \
		-side right -fill both -expand 1

	# disable table configure here
	bind $this.left.headbox <1> { }
	bind $this.right.headbox <1> { }

	set initialized_ 1

	#  Explicitly handle config's that may have been ignored earlier
	foreach attr $config {
	    config -$attr [set $attr]
	}
    }


    # Destructor: called when this object is deleted

    destructor {
	$this.left delete
	$this.right delete
    }


    # -- public member variables --

    # titles for left ane right tables
    public left_title {} {
	if {$initialized_} {
	    $this.left config -title $left_title
	}
    }
    public right_title {} {
	if {$initialized_} {
	    $this.right config -title $right_title
	}
    }

    # field names for heading (same for both left and right)
    # - Note: specify before "-left_info or -right_info"
    public headings {} {
	if {$initialized_} {
	    $this.left config -headings $headings
	    $this.right config -headings $headings
	}
    }

    # info for left and right lists: 
    # list of lists, one per line to display in table/list
    public left_info {} {
	if {$initialized_} {
	    $this.left config -info $info
	}
    }
    public right_info {} {
	if {$initialized_} {
	    $this.right config -info $info
	}
    }

    # flag: if true, also display up and down buttons for moving
    # table items vertically
    public up_down 1

    
    # passed on to tk
    public exportselection {0}

    # flag: single selection mode
    public single_select {0}


    # -- protected members --

    # flag: true after initialization
    protected initialized_ 0
}


