source parray.tcl
source stooop.tcl

### check that optional arguments in constructors and multiple inheritance work together

# expected output:
## a::a 1
## b::b 1
## c::c 1
## a(1,_derived) = c
## a(1,m) = x y
## b(1,_derived) = c
## b(1,n) = z
## c(1,o) = x y
## c(1,p) = z
## c::~c 1
## b::~b 1
## a::~a 1
## a::a 2
## b::b 2
## c::c 2
## a(2,_derived) = c
## a(2,m) = 2
## b(2,_derived) = c
## b(2,n) = 3
## c(2,o) = 2
## c(2,p) = 3

proc a::a {this {p 0}} {
    puts "a::a $this"
    set a($this,m) $p
}
proc a::~a {this} {
    puts "a::~a $this"
}
proc b::b {this {p 1}} {
    puts "b::b $this"
    set b($this,n) $p
}
proc b::~b {this} {
    puts "b::~b $this"
}
proc c::c {this {p 2} {q 3}} a {$p} b {$q} {
    puts "c::c $this"
    set c($this,o) $p
    set c($this,p) $q
}
proc c::~c {this} {
    puts "c::~c $this"
}

set o [new c {x y} z]
printArrays a b c
delete $o
set o [new c]
printArrays a b c
