source parray.tcl
source stooop.tcl

### check multiple inheritance construction order, destruction order and data deallocation with a common indirect base class

# expected output:
## a::a 1
## b::b 1
## c::c 1
## a::a 1
## b::b 1
## d::d 1
## e::e 1
## a(1,_derived) = d
## a(1,m) = z
## b(1,_derived) = d
## b(1,n) = z
## c(1,_derived) = e
## c(1,o) = 1 2
## d(1,_derived) = e
## d(1,p) = z
## e(1,q) = z
## e::~e 1
## d::~d 1
## b::~b 1
## a::~a 1
## c::~c 1
## b::~b 1
## a::~a 1

proc a::a {this p} {
    puts "a::a $this"
    set a($this,m) $p
}
proc a::~a {this} {
    puts "a::~a $this"
}
proc b::b {this p} {
    puts "b::b $this"
    set b($this,n) $p
}
proc b::~b {this} {
    puts "b::~b $this"
}
proc c::c {this p q r} a {$p} b {$q} {
    puts "c::c $this"
    set c($this,o) $r
}
proc c::~c {this} {
    puts "c::~c $this"
}
proc d::d {this p q r} a {$p} b {$q} {
    puts "d::d $this"
    set d($this,p) $p
}
proc d::~d {this} {
    puts "d::~d $this"
}
proc e::e {this p q r} c {$p $q $r} d {$q $q $r} {
    puts "e::e $this"
    set e($this,q) $q
}
proc e::~e {this} {
    puts "e::~e $this"
}

set o [new e {x y} z {1 2}]
printArrays a b c d e
delete $o
printArrays a b c d e
