source parray.tcl
source stooop.tcl

### check normal and user defined cloning operation with multiple inheritance and member objects

# expected output:
## a(1,_derived) = d
## a(1,m) = z
## a(3,_derived) = d
## a(3,m) = z
## b(1,_derived) = d
## b(1,n) = z
## b(3,_derived) = d
## b(3,n) = z
## c(1,O) = 2
## c(1,_derived) = e
## c(1,o) = 1 2
## c(3,O) = 4
## c(3,_derived) = e
## c(3,o) = 1 2
## d(1,_derived) = e
## d(1,p) = z
## d(3,_derived) = e
## d(3,p) = z
## e(1,q) = z
## e(3,q) = z

proc a::a {this p} {
    set a($this,m) $p
}
proc b::b {this p} {
    set b($this,n) $p
}
proc c::c {this p q r} a {$p} b {$q} {
    set c($this,o) $r
    set c($this,O) [new f]
}
proc c::c {this copy} a {$a($copy,m)} b 1 {
    set c($this,o) $c($copy,o)
    set c($this,O) [new f]
}
proc d::d {this p q r} a {$p} b {$q} {
    set d($this,p) $p
}
proc e::e {this p q r} c {$p $q $r} d {$q $q $r} {
    set e($this,q) $q
}
proc f::f {this} {
    set e($this,x) 0
}

new [new e {x y} z {1 2}]
printArrays a b c d e
