#
# $Id: simpletext.tcl,v 1.2 1995/03/21 03:46:09 sls Exp $
#
# A text wrapped in a frame with a scrollbar and title
#
# This software is copyright (C) 1995 by the Lawrence Berkeley Laboratory.
# 
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that: (1) source code distributions
# retain the above copyright notice and this paragraph in its entirety, (2)
# distributions including binary code include the above copyright notice and
# this paragraph in its entirety in the documentation or other materials
# provided with the distribution, and (3) all advertising materials mentioning
# features or use of this software display the following acknowledgement:
# ``This product includes software developed by the University of California,
# Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
# the University nor the names of its contributors may be used to endorse
# or promote products derived from this software without specific prior
# written permission.
# 
# THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
#

widget simpletext {
    param title ""
    param width  40
    param height 20
    method create {} {
	set w $self
	$w config -relief raised -bd 2
	label $w.title -anchor w -bd 0
	pack $w.title -in $w -side top -fill x
	scrollbar $w.sb -command "$w.text yview"
	text $w.text -yscroll "$w.sb set" -relief sunken -bd 2 -padx 0 \
	    -pady 0
	pack $w.sb -in $w -side right -fill y
	pack $w.text -in $w -side right -fill both -expand 1
    }
    method reconfig {} {
	$self.title config -text $slot(title)
	$self.text config -width $slot(width) -height $slot(height)
    }
    method text args {
	uplevel [concat $self.text $args]
    }
}
