#
# $Id: dial.tcl,v 1.4 1995/06/22 22:09:14 sls Exp $
#
# Provide a colored dial
#
# This software is copyright (C) 1995 by the Lawrence Berkeley Laboratory.
# 
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that: (1) source code distributions
# retain the above copyright notice and this paragraph in its entirety, (2)
# distributions including binary code include the above copyright notice and
# this paragraph in its entirety in the documentation or other materials
# provided with the distribution, and (3) all advertising materials mentioning
# features or use of this software display the following acknowledgement:
# ``This product includes software developed by the University of California,
# Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
# the University nor the names of its contributors may be used to endorse
# or promote products derived from this software without specific prior
# written permission.
# 
# THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
#

set dial_priv(pi) [expr 4*atan(1)]

if [string length [info commands option]] {
    option add *Dial.c.highlightThickness 0
}

widget dial {
    member c
    param orient horiz
    param from 0
    param to 100
    param yellow 85
    param red 95
    param extent 270
    param width 50
    param height 50
    param format %d
    param font -*-helvetica-medium-r-*-*-8-*-*-*-*-*-iso8859-*
    param step .3
    param slewdelay 50
    member target_angle
    member current_angle
    member incr
    method angle {val} {
	set extent $slot(extent)
	set result [expr {
	    1.0*$val/($slot(to)-$slot(from))*$extent
	}]
	set result [expr {(270.0-(360-$extent)/2.0)-$result}]
	return $result
    }
    method create {} {
	set width $slot(width)
	set height $slot(height)
	set w $self
	set slot(c) [canvas $w.c -width [expr $width+1] -height $height]
	pack $w.c -in $w
	$w.c config -background gray71
	set green_start [$self angle 0]
	set yellow_start [$self angle $slot(yellow)]
	set red_start [$self angle $slot(red)]
	$w.c create arc 0 0 $width $height \
	    -start $green_start -extent [expr $yellow_start-$green_start] \
	    -fill green
	$w.c create arc 0 0 $width $height \
	    -start $yellow_start -extent [expr $red_start-$yellow_start] \
	    -fill yellow
	$w.c create arc 0 0 $width $height \
	    -start $red_start \
	    -extent [expr [$self angle $slot(to)]-$red_start] \
	    -fill red
	$w.c create arc [expr 0.15*$width] [expr 0.15*$height] \
	    [expr 0.85*$width] [expr 0.85*$height] -start $green_start \
	    -extent -$slot(extent) -fill gray71 -style chord
	set slot(cx) [set cx [expr $width/2.0]]
	set slot(cy) [set cy [expr $height/2.0]]
	set slot(radius) $cx
	$w.c create text $cx $height -tag label \
	    -anchor s -font $slot(font)
	$w.c create line $cx $cy $cx 0 -arrow last -tag needle \
	    -width 2 -arrowshape "4 7 3" -capstyle round
	global dial_priv
	set slot(current_angle) [expr [$self angle $slot(to)]*$dial_priv(pi)/180.0]
	$self set $slot(from)
    }
    method reconfig {} {
    }
    method set {val} {
	global dial_priv
	set slot(target_angle) [set ta [expr [$self angle $val]*$dial_priv(pi)/180.0]]
	$slot(c) itemconfig label -text [format $slot(format) $val]
	if {$ta > $slot(current_angle)} {
	    set slot(incr) $slot(step)
	} else {
	    set slot(incr) -$slot(step)
	}
	$self slew
    }
    method slew {} {
	set angle $slot(current_angle)
	set cx $slot(cx)
	set cy $slot(cy)
	set radius $slot(radius)
	$slot(c) coords needle $cx $cy \
	    [expr $cx+$radius*cos($angle)] [expr $cy-$radius*sin($angle)]
	set ta $slot(target_angle)
	if {$angle == $ta} return
	set angle [expr $angle+[set inc $slot(incr)]]
	if {($inc > 0 && $angle > $ta) || ($inc < 0 && $angle < $ta)} {
	    set slot(current_angle) $ta
	} else {
	    set slot(current_angle) $angle
	}
	after $slot(slewdelay) "$self slew"
    }
}
