#!/bin/sh
#\
exec @tclsh@ "$0" ${1+"$@"}
#
# $Id: tcl2c.tcl,v 1.7 1995/06/11 09:24:10 sls Exp $
#
# Take tcl source files and convert them to C source code.
#
# This software is copyright (C) 1995 by the Lawrence Berkeley Laboratory.
# 
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that: (1) source code distributions
# retain the above copyright notice and this paragraph in its entirety, (2)
# distributions including binary code include the above copyright notice and
# this paragraph in its entirety in the documentation or other materials
# provided with the distribution, and (3) all advertising materials mentioning
# features or use of this software display the following acknowledgement:
# ``This product includes software developed by the University of California,
# Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
# the University nor the names of its contributors may be used to endorse
# or promote products derived from this software without specific prior
# written permission.
# 
# THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
#

if [file isdir @stl_library@] {
    lappend auto_path @stl_library@
} else {
    lappend auto_path .
}

document_program tcl2c.tcl "convert Tcl source files into C source files" {

    #tcl2c.tcl# generates a C source file that converts Tcl source
    files to C source files.  #tcl2c.tcl# should be invoked as
    #tcl2c.tcl# `package-name' `c-source-output' `tcl-source-files'
    `...'.  The generated C defines a function `package-name'#_Init#
    that executes the Tcl source code.

    When the Tcl code is executed from C, the Tcl global variable
    #package_name# will contain `package-name'.  If you need different
    behavoir depending on how the Tcl code is run you can test for the
    existence of #package_name#.  See the STL library file
    #widgets.tcl# for an example.

}
if [info exists document] return

run {
    msg_verbose
    if {$argc < 3} {
	puts stderr "usage: $argv0 package-name c-source-output-file tcl-source-files ..."
	exit 1
    }
    set name [lindex $argv 0]
    msg "Writing package $name to [lindex $argv 1]"
    set cfp [open [lindex $argv 1] w]
    puts $cfp "#include <tcl.h>"
    foreach file [lrange $argv 2 end] {
	msg "Processing $file"
	set c_file $file
	regsub -all "\\.|-|/" $file "_" c_file
	puts $cfp "static char $c_file\[\] = "
	set i 0
	set tfp [open $file r]
	set tcl_code [read $tfp]
	close $tfp
	while {[string length $tcl_code] > 0} {
	    set chunk [string range $tcl_code 0 64]
	    regsub -all "\\\\" $chunk "\\\\\\" chunk
	    regsub -all "\n" $chunk "\\n" chunk
	    regsub -all "\t" $chunk "\\t" chunk
	    regsub -all "\"" $chunk "\\\"" chunk
	    puts $cfp "\"$chunk\""
	    set tcl_code [string range $tcl_code 65 end]
	}
	puts $cfp ";"
	lappend c_files $c_file
    }
    msg "Writing ${name}_Init function"
    puts $cfp "int ${name}_Init(Tcl_Interp* interp)"
    puts $cfp "{"
    puts $cfp \
	"    Tcl_SetVar(interp, \"package_name\", \"$name\", TCL_GLOBAL_ONLY);"
    foreach file $c_files {
	puts $cfp \
	   "    if (Tcl_GlobalEval(interp, $file) != TCL_OK) return TCL_ERROR;"
    }
    puts $cfp \
	"    Tcl_UnsetVar(interp, \"package_name\", TCL_GLOBAL_ONLY);"
    puts $cfp "    return TCL_OK;"
    puts $cfp "}"
    close $cfp
}
