#
# $Id: notify.tcl,v 1.5 1995/03/21 03:49:16 sls Exp $
#
# This software is copyright (C) 1995 by the Lawrence Berkeley Laboratory.
# 
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that: (1) source code distributions
# retain the above copyright notice and this paragraph in its entirety, (2)
# distributions including binary code include the above copyright notice and
# this paragraph in its entirety in the documentation or other materials
# provided with the distribution, and (3) all advertising materials mentioning
# features or use of this software display the following acknowledgement:
# ``This product includes software developed by the University of California,
# Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
# the University nor the names of its contributors may be used to endorse
# or promote products derived from this software without specific prior
# written permission.
# 
# THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
#

document_title notify "register and trigger events" {
    These procedures maintain a registry of events and commands.
}

set notify_priv(counter) -1

document_proc register {
    arranges for `command' to be executed (at the toplevel) when
    `event' is triggered.  Returns a registered command cookie.
}
proc register {event command} {
    global notify_priv
    set cookie R[incr notify_priv(counter)]
    lappend notify_priv(cookies_of.$event) $cookie
    set notify_priv(event_of.$cookie) $event
    set notify_priv(command_of.$cookie) $command
    if ![info exists notify_priv(flag_of.$event)] {
        set notify_priv(flag_of.$event) 0
        trace variable notify_priv(flag_of.$event) w do_notify
    }
    return $cookie
}

proc do_notify {name1 name2 op} {
    global notify_priv
    regexp "\[^/\]+" $name2 event
    if [info exists notify_priv(cookies_of.$event)] {
        foreach cookie $notify_priv(cookies_of.$event) {
	    set command $notify_priv(command_of.$cookie)
            if {[string length $command] > 40} {
                set txt "[string range $command 0 40]..."
            } else {
                set txt $command
            }
            if [catch {uplevel #0 $command}] {
                global errorInfo
                puts stderr "registered command on $event failed:\n$errorInfo"
            }
        }
    }
}

document_proc unregister {
    unregisters a event/command.  `cookie' is the cookie returned by
    the call the #register#.
}
proc unregister {cookie} {
    global notify_priv
    unset notify_priv(command_of.$cookie)
    set event $notify_priv(event_of.$cookie)
    unset notify_priv(event_of.$cookie)
    set ndx [lsearch -exact $cookie $notify_priv(cookies_of.$event)]
    set notify_priv(cookies_of.$event) \
	[lreplace $notify_priv(cookies_of.$event) $ndx $ndx]
}

document_proc notify {
    executes all commands registered on event `event'.  #notify# executes
    commands in order of when they are register (the first command registered
    is the first command executed, and so on.)  #notify# reports any
    errors on #stderr#, but does not itself throw any errors.
}
proc notify event {
    global notify_priv
    if [info exists notify_priv($event/flag)] {
        incr notify_priv($event/flag)
    }
}
