#!/bin/sh
#\
exec @tclsh@ "$0" ${1+"$@"}
#
# $Id: chlog2html.tcl,v 1.6 1995/06/06 01:28:47 sls Exp $
#
# This software is copyright (C) 1995 by the Lawrence Berkeley Laboratory.
# 
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that: (1) source code distributions
# retain the above copyright notice and this paragraph in its entirety, (2)
# distributions including binary code include the above copyright notice and
# this paragraph in its entirety in the documentation or other materials
# provided with the distribution, and (3) all advertising materials mentioning
# features or use of this software display the following acknowledgement:
# ``This product includes software developed by the University of California,
# Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
# the University nor the names of its contributors may be used to endorse
# or promote products derived from this software without specific prior
# written permission.
# 
# THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
#
# HTML-ify a GNU-style ChangeLog
#

if [file isdir @stl_library@] {
    lappend auto_path @stl_library@
} else {
    lappend auto_path .
}

document_program chlog2html.tcl "generate a HTML version of a ChangeLog" {
    #chlog2html.tcl# generates a HTML version of a GNU-style ChangeLog.
}
if [info exists document] return

run {
    msg_verbose
    set title "ChangeLog"
    args_parse $argv {
	args_arg -title string "Use STRING as title of generated document." {
	    args_gset title $string
	}
	args_error { args_usage; exit }
    }
    html_set_file_sink "ChangeLog.html"
    html_begin $title
    html_heading $title
    set state date
    foreach_line line "ChangeLog" {
	while 1 {
	    if {$state == "date"} {
	    	if ![string length [string trim $line]] break
		html_heading $line 2
		html "<UL>"
		set state item
	    } elseif {$state == "item"} {
		if ![string length [string trim $line]] break
		if ![regexp "^\[ \t\]+\\*" $line] {
		    html "</UL>"
		    set state date
		    continue
		} elseif {[regexp "\\* (\[^:\]+):(.*)" $line match files comment]} {
		    html "<LI>"
		    html_style strong $files
		    html " : "
		    set state comment
		} else {
		    regexp "^\[ \t\]\\* (.*)" $line match files
		    set state files_cont
		}
	    } elseif {$state == "files_cont"} {
		if [regexp "^\[ \t\]+(\[^:\]*):(.*)" $line match tmp comment] {
		    append files $tmp
		    html "<LI>"
		    html_style strong $files
		    html " : "
		    set state comment
		} else {
		    append files " [string trim $line]"
		}
	    } elseif {$state == "comment"} {
		set line [string trim $line]
		if [string length $line] {
		    append comment " $line"
		} else {
		    html_dnl
		    html_set_style em
		    html_quote $comment
		    html_set_style normal
		    html_nl
		    set state item
		}
	    }
	    break
	}
    }
    if {$state == "item"} {
	html "</UL>"
    }
    html_end
}
