################################################################
####       Usefull procedures for handling text items       ####
################################################################


################################################################
####		    basic procedures                        ####
################################################################

proc ct_move_to_char {index} {
  [cv] icursor [[cv] focus] $index
}

proc ct_cursor_position_in_line {} {
  set focus [[cv] focus]
  set sxx [ct_search_backward_char "\n"]
  set cxx [[cv] index $focus insert]
  return ([expr $cxx - $sxx])
}

proc ct_search_forward_char {char} {

  # search forward from the current insertion cursor position
  
  if {![lempty [set focus [[cv] focus]]]} {
    set text [lindex [[cv] itemconfigure $focus -text] 4]
    loop i [[cv] index $focus insert] [[cv] index $focus end] {
      if {$char == [string index $text $i]} {
	return $i
      }
    }
    return [[cv] index $focus end]
  }
  return -1
}

proc ct_search_backward_char {char} {

  # search backward from the current insertion cursor position
    
  if {![lempty [set focus [[cv] focus]]]} {
    set text  [lindex [[cv] itemconfigure $focus -text] 4]
    loop i [expr "[[cv] index $focus insert] - 1"] 0 -1 {
      if {$char == [string index $text $i]} {
	return $i
      }
    }
  }
  return -1
}

proc ct_move_forward_orEnd {n} {

  set focus [[cv] focus]
  set start [[cv] index $focus insert]
  set end [expr $start + $n]
  set text  [lindex [[cv] itemconfigure $focus -text] 4]

  for { set pos $start } {[expr {$pos < $end}]} {incr pos 1} {
    if { [string index $text $pos] != "\n" } {
      ct_forward_char 1
    } else {
      return
    }
  }
}

################################################################
####		   moving in the text                       ####
################################################################

proc ct_insert_char {char} {
  [cv] insert [[cv] focus] insert $char
}

proc ct_beginning_of_text {} {
  [cv] icursor [[cv] focus] 0
}

proc ctEnd_of_text {} {
  [cv] icursor [[cv] focus] end
}

proc ct_forward_char {n} {
  set focus [[cv] focus]
  set position [[cv] index $focus insert]
  [cv] icursor $focus [expr $position + $n]
}

proc ct_backward_char {n} {
  set focus [[cv] focus]
  set position [[cv] index $focus insert]
  [cv] icursor $focus [expr $position - $n]
}

proc ct_delete_char {} {
  set focus [[cv] focus]
  set position [[cv] index $focus insert]
  [cv] dchar $focus [expr $position]
}

proc ct_backward_delete_char {} {
  set focus [[cv] focus]
  set position [[cv] index $focus insert]
  [cv] dchars $focus [expr $position - 1]
}

proc ct_kill_line {} {
  set text [lindex [[cv] itemconfigure [[cv] focus] -text] 4]
  set ins [[cv] index [[cv] focus] insert]
  if {[string index $text $ins] == "\n"} {
    [cv] dchars [[cv] focus] $ins
  } else {
    [cv] dchars [[cv] focus] $ins [expr "[ct_search_forward_char "\n"] - 1"]
  }
}

proc ct_beginning_of_line {} {
  set nindex [ ct_search_backward_char "\n" ]
  ct_move_to_char [expr {[expr $nindex] + 1}]
}

proc ctEnd_of_line {} {
  set nindex [ ct_search_forward_char "\n" ]      
  ct_move_to_char [expr $nindex]
}

proc ct_next_line {} {
  set offset [ct_cursor_position_in_line]
  ctEnd_of_line
  ct_forward_char 1
  ct_move_forward_orEnd [expr $offset -1]
}

proc ct_previous_line {} {
  set offset [expr [ct_cursor_position_in_line] - 1]
  ct_beginning_of_line
  ct_backward_char 1
  ct_beginning_of_line
  ct_move_forward_orEnd $offset
}

################################################################
####	 emacs-like bindings for the text items             ####
################################################################

proc bind_item_emacs_like { item } {

  #  Abort object creation  #
  [cv] bind $item <Control-g>  {
    [cv] dchars inCreation 0 end
    switch $CurrentMode {
      TextMode { ctextEnd }
      LatexMode { clatexEnd }
    }
  }
  
  [cv] bind $item <KeyPress>   { ct_insert_char %A }
  [cv] bind $item <Control-d>  { ct_delete_char }
  [cv] bind $item <Delete>     { ct_backward_delete_char }
  [cv] bind $item <BackSpace>  { ct_backward_delete_char }
  [cv] bind $item <Control-k>  { ct_kill_line }
  [cv] bind $item <Control-n>  { ct_next_line }
  [cv] bind $item <Control-p>  { ct_previous_line }
  [cv] bind $item <Control-a>  { ct_beginning_of_line }
  [cv] bind $item <Control-e>  { ctEnd_of_line }
  [cv] bind $item <Control-f>  { ct_forward_char 1 }
  [cv] bind $item <Control-b>  { ct_backward_char 1 }
  [cv] bind $item <Meta-a>     { ct_beginning_of_text }
  [cv] bind $item <Meta-e>     { ctEnd_of_text }
  [cv] bind $item <Return>     { ct_insert_char "\n" }
}
