
########  Main Window  ########

keylset HelpEntries {top} {{Picasso Help} {

  Picasso is an object oriented drawing tool in the style of idraw.

  Besides basic object types like lines or rectangles, Picasso is able to load and manipulate\
image objects. Currently supported image formats are Inrimage, Postscript, PPM, GIF, Pict, XPM, X Bitmap, grabbed X Window, grabbed X Region.

  Picasso drawings may be saved and restored, and may also be written in Encapsulated Postscript format, suitable for inclusion by latex.

****  Help  ****

Pressing mouse button 3 anywhere in the application provides help information related to the widget you clicked over. For example, help concerning latex objects can be obtained by pressing button 3 over the "latex" mode button.

****  Customization  ****

  The option "Create customization file" in the File menu creates a file ".picassorc" in your home directory. You can then edit this file, override variable definitions, and insert tcl code. The file will be evaluated each time you start a new picasso session.

****  Global bindings  ****

Control q       Quit Picasso
Control s       Save current drawing
Control w       Save current drawing in specified file
Control f       Load a new drawing

Control - 	Undo
Control d 	Delete selected objects
Control 2 	Duplicate selected objects
Control p 	Set selected object parameters
Control = 	Align selected objects
Control a	Select all
Control g 	Group selected objects together
Control u 	Ungroup selected groups
Control r	Raise selected objects
Control l 	Lower selected objects

Key UpArrow     Move selected objects 1 pixel upwards
Key DownArrow   Move selected objects 1 pixel downwards
Key RightArrow  Move selected objects 1 pixel to the right
Key LeftArrow   Move selected objects 1 pixel to the left

**** Group tags resetting ****

If selection doesn't work normally (e.g. there is an item you can't select), picasso probably got lost with group tags management. You can reset group tags using the "Group Reset" action in the Edit menu.
Resetting group tags will also be necessary when loading a drawing saved with picasso version 3.5 or earlier, due to a bug in group tag management.
}}

########  Edit Button  ########

keylset HelpEntries {top_frame1_editBt} {{Edit Menu Shortcuts} {

Undo			Control -
Delete			Control d
Duplicate		Control 2
Object Parameters 	Control p
Align			Control =
Select all		Control a
Group			Control g
Ungroup			Control u
Raise			Control r
Lower			Control l
}}

########  Latex mode  ########

keylset HelpEntries top_optionFr_latexFr {{Latex Mode} {

  This mode is intended for interactive creation of  Latex Objects.

  In Latex Mode, pressing button one in the drawing area starts the creation of a Latex object. You can then enter Latex source as it would appear in a Latex source file.

  To end up creation, click anywhere with button 2

  Already created Latex objects can be modified by pressing button 1 over them.

  Two representations are available for latex objects, "compiled" and "uncompiled".

  ****  Uncompiled latex objects  ****

  When you end up the creation of a latex object, it is represented uncompiled:

    - the bounding box of the object is displayed as a green rectangle.
    - the latex source text is displayed in this rectangle.

  The bounding box has the dimensions of the postscript that would be generated by compiling the latex source with the document style given by the "Latex Style" parameter. This parameter can be set in the Latex control pannel (Control button).

  Uncompiled representation of latex objects is intended for automatic latex generation. Uncompiled objects can't be rescaled or rotated (since latex doesn't support these operations). See Latex generation below for more details.

  ****  Compiled latex objects  ****

  You can compile any latex object using the "Compile Latex" action in the Edit menu. Compiled objects are represented as an image displaying the result of latex'ing the source text.
  The "Latex Resolution" parameter (Control pannel) defines the size of the image: high resolutions will lead big, high quality images, but the compilation process may become extremely slow.
  
  Compiled objects can be rescaled or rotated as any image.

  ****  Latex generation  ****

  The "Write Latex" action in the File menu will generate two files:
    - a latex file, containing a latex picture
    - a postscript file, included by the latex file.

  The latex file is to be included in a latex document using the
    \input{<file>} command.

  When generating latex, compiled latex objects will be written as images: uncompile them if you wan't them written as latex source code.

  Uncompiled latex objects are "\put" in the picture.

  **  Sizing issues  **

  There are two ways of resizing the included picture:
  
  * You can simply resize the picture by using the command

      \epsfxsize=<dimension> \input{<picasso latex file>}
   or
      \epsfysize=<dimension> \input{<picasso latex file>}

   The positionning of the anchor points (see Anchor below) of latex objects will remain correct in every case. However the sizes of the bounding boxes that were displayed by picasso won't be preserved in the final picture.

  * You can also use the "Latex Drawing Ratio" parameter in picasso (Control pannel):
    the dimensions of the generated picture will be multiplied by this ratio. The advantage of this approach is that it allows picasso to display the right bounding box dimensions for uncompiled latex objects.
  Even when using this feature, you can still resize the picture when including it in the latex document as described before.

  **  Latex Object Anchor  **

  The latex generated by picasso is such that the position of latex object anchor points will remain correct even if the picture is resized using the \epsf<x|y>size facility in the latex document. For this reason, anchors should be choosen carefully: if you wan't to have a latex comment appear on the rigth of an image for example, set the anchor to w.

  Carefully setting anchors will allow you to resize drawings from your latex document without reloading the drawing in picasso.

  ****  Postscript generation  ****

  Latex source has nothing to do in a postscript file, so uncompiled latex objects are just ignored when generating postscript. Compile them first if you wan't to get them in the final document.
}}

keylset HelpEntries [translit {.} {_} "top[SN LatexMode]"] \
  [keylget HelpEntries top_optionFr_latexFr]

set ModeHelp(LatexMode) [keylget HelpEntries top_optionFr_latexFr]

########  Image mode button  ########

set entry {{Image Objects} {

  Image objects are created from image files in Inrimage, Postscript, PPM, GIF, Pict, XPM or X Bitmap format.

  The internal representation of images consists in an array of floating-point pixel values between 0.0 and 1.0. The array dimensions are defined by the image source file. Once created, an image object is independent of the source image file used to create it.

****  Image object configuration  ****

width, height:

  Define image object dimensions. Requested values are achieved by shrinking or expanding the image internal representation. If only one of width and height is specified, the other dimension is chosen so as to preserve the aspect ratio of the image.

brightness:

  The brightness parameter takes its value between -1.0 and 1.0. With a value of 0.0, the lowest pixel value of the image is displayed as black and the highest one is displayed as white.

contrast:

  The contrast parameter takes its values between -1.0 and 1.0. A value of 0.0 means no contrast modification of the source data.
}}

keylset HelpEntries [translit {.} {_} "top[SN ImageMode]"] $entry
keylset HelpEntries top_imloadDg $entry
set ModeHelp(ImageMode) $entry

########  Rotate Mode  ########

set entry {{Rotate Mode} {

  This mode allows you to interactively rotate polyline, rectangle, filled rectangle, arc, filled arc, spline and polygon objects . Rotations of ovals, images, bitmaps, text and latex objects is not implemented.

  Pressing button 1 in the drawing area start a rotation. The set of currently selected objects, eventually augmented with the object you clicked on, is rotated around the center of the set bounding box.
}}

keylset HelpEntries [translit {.} {_} "top[SN RotateMode]"] $entry
set ModeHelp(RotateMode) $entry
  
########  Control Frame  ########

keylset HelpEntries top_optionFr {{Control Panel} {

  Options set via the control panel are generally immediately applied to the set of selected objects, and remain in effect for future object creations.

  Exceptions to this rule are:

  - Latex and Postscript resolution aren't applied to selected objects, because changing this parameter implies heavy computations. To modify the resolution of an existing Latex or Postscript object, modify the resolution in the control panel, then force the object to be re-created.

  - Image brightness and contrast only allows to update existing images parameters, and thus have no effect on image object creation.
}}

########  Control Button  ########

keylset HelpEntries top_optionFr_btf {{Option set display control} {

  As many option sets as possible are simultaneously displayed in the control panel. Selection an option set from the "Control" menu causes this set to be displayed first in the panel.
}}

########  Modes  ########

set ModeHelp(SelectMode) {{Select Mode} {

  Select mode bindings:

  ButtonPress-1       	On an object, select this object alone,
  			  otherwise deselect all and start region selection

  Shift-ButtonPress-1 	Adds object under the pointer to the
  			  set of selected objects

  Button-2            	Move the set of selected objects. If over an object,
  			  moves it along with selected objects.  

  ButtonPress-3		Help

  **** Note ****

  If selection doesn't work normally (e.g. there is an item you can't
    select), picasso probably got lost with group tags management.
  You can reset group tags using the "Group Reset" action in the Edit
    menu.
  Resetting group tags will also be necessary when loading a drawing
    saved with picasso version 3.5 or earlier, due to a bug in group
    tag management.
  
}}

keylset HelpEntries [translit {.} {_} "top[SN SelectMode]"] $ModeHelp(SelectMode)

################################################################
####		   Help Box procedure                       ####
################################################################

#  Retrieves the first help entry in the widget hierarchy, starting  #
#  with passed widget in ascending order, and displays it in a popup box  #

proc help {widget} {
  global HelpEntries helpUpList helpDownList

  if {$widget == ""} { set widget {top} }

  set helpUpList [split "top$widget" {.}]
  set helpDownList {}
  
  while {! [keylget HelpEntries [join $helpUpList {_}] hentry]} {
    lvarpush helpDownList [lvartail helpUpList]
  }
  
  catch {destroy .helpBox}
  toplevel .helpBox -borderwidth 0
  wm geometry .helpBox 600x400 
  wm title .helpBox {Help box}
  wm maxsize .helpBox 1000 1000
  wm minsize .helpBox 100 100

  label .helpBox.titleLb \
    -relief raised \
    -borderwidth 2 \
    -text "[lindex $hentry 0]"
    
  frame .helpBox.textFr -borderwidth 0

  scrollbar .helpBox.textFr.scrollbar \
    -command {.helpBox.textFr.text yview} \
    -relief raised \
    -borderwidth 2

  text .helpBox.textFr.text \
    -borderwidth 2 \
    -relief raised \
    -wrap word \
    -yscrollcommand {.helpBox.textFr.scrollbar set}

  .helpBox.textFr.text insert 1.0 "[lindex $hentry 1]"
  .helpBox.textFr.text configure -state disabled
  
  pack append .helpBox.textFr \
    .helpBox.textFr.scrollbar {left frame center filly} \
    .helpBox.textFr.text      {top frame center expand fill}

  frame .helpBox.butFr -borderwidth 0

  frame .helpBox.butFr.updownFr -borderwidth 0

  button .helpBox.butFr.updownFr.upBt \
    -relief raised \
    -borderwidth 2 \
    -text {Up} \
    -command { helpUp }

  button .helpBox.butFr.updownFr.downBt \
    -relief raised \
    -borderwidth 2 \
    -text {Down} \
    -command { helpDown }

  pack append .helpBox.butFr.updownFr \
    .helpBox.butFr.updownFr.upBt {left expand fill} \
    .helpBox.butFr.updownFr.downBt {left expand fill}
  
  button .helpBox.butFr.dismissBt \
    -relief raised \
    -borderwidth 2 \
    -text {Dismiss} \
    -command { destroy .helpBox }

  pack append .helpBox.butFr \
    .helpBox.butFr.updownFr {left expand fill} \
    .helpBox.butFr.dismissBt {left expand fill}
  
  pack append .helpBox \
    .helpBox.titleLb {top fill} \
    .helpBox.textFr {top expand fill} \
    .helpBox.butFr {top fill}
}
  

proc helpUp {} {
  global HelpEntries helpUpList helpDownList

  if {$helpUpList == {top}} { return }
  
  lvarpush helpDownList [lvartail helpUpList]

  while {! [keylget HelpEntries [join $helpUpList {_}] hentry]} {
    lvarpush helpDownList [lvartail helpUpList]
  }

  .helpBox.titleLb configure -text "[lindex $hentry 0]"

  .helpBox.textFr.text configure -state normal
  .helpBox.textFr.text delete 1.0 end
  .helpBox.textFr.text insert 1.0 "[lindex $hentry 1]"
  .helpBox.textFr.text configure -state disabled
  update
}
  
proc helpDown {} {
  global HelpEntries helpUpList helpDownList

  if {[lempty $helpDownList]} { return }

  lappend helpUpList [lvarpop helpDownList]

  while {! [keylget HelpEntries [join $helpUpList {_}] hentry]} {
    if {[lempty $helpDownList]} { return }
    lappend helpUpList [lvarpop helpDownList]
  }

  .helpBox.titleLb configure -text "[lindex $hentry 0]"

  .helpBox.textFr.text configure -state normal
  .helpBox.textFr.text delete 1.0 end
  .helpBox.textFr.text insert 1.0 "[lindex $hentry 1]"
  .helpBox.textFr.text configure -state disabled
  update
}
  
