##  Combined object creation  ##

set currentShadowW 4

proc Shadow {} {
  global currentShadowW

  set item [[cv] find withtag s]
  if {[llength $item] == 0} {
    warn "No item selected"
    return
  }

  if {[llength $item] > 1} {
    warn "Can only shadow single objects"
    return
  }

  switch [[cv] type $item] {
    drectangle {
      lassign [eval "rectangularShadow [[cv] coords $item] $currentShadowW"] upsh downsh
    }
    default {
      lassign [eval "rectangularShadow [[cv] bbox $item] $currentShadowW"] upsh downsh
    }
  }
  ####  Group components together  ####
  createEnd_hook
  deselect_all

  foreach it "$item $upsh $downsh" {
    set gtag [getTopGroupTags $it]
    [cv] addtag s withtag $gtag
    [cv] addtag sOfr withtag $gtag
    putFrame $gtag
  }

  Group
}

proc rectangularShadow {x1 y1 x2 y2 sw} {

  set upsh [[cv] create polygon \
	    [expr $x1-$sw] [expr $y1-$sw] \
	      [expr $x2+$sw]  [expr $y1-$sw] \
	      $x2 $y1 \
	      $x1 $y1 \
	      $x1 $y2 \
	      [expr $x1-$sw] [expr $y2+$sw] \
	      -fill gray90 \
	      -tags {shadow inCreation}]
  incr x2 -1
  set downsh [[cv] create polygon \
	      [expr $x2+1] [expr $y1-1] \
		[expr $x2+$sw] [expr $y1-$sw] \
		[expr $x2+$sw] [expr $y2+$sw] \
		[expr $x1-$sw] [expr $y2+$sw] \
		$x1 $y2 \
		[expr $x2+1] $y2 \
		-fill black \
		-tags {shadow inCreation}]
  return "$upsh $downsh"
}


