################################################################
####		  Building main window                      ####
################################################################

proc ShowWindow. {args} {
  global PicassoLib
  # Window manager configurations
  global tkVersion
  wm positionfrom . ""
  wm sizefrom . ""
  wm geometry . 980x742
  wm maxsize . 1152 900
  wm minsize . 0 0
  wm title . Picasso
  wm iconname . {Picasso}
  
  # build widget .frame0
  frame .frame0 \
    -borderwidth {2}\
    -relief {raised}
  
  frame .frame0.modeFr \
    -borderwidth 0

  global {symbolicName}

  set i 0
  set y 0
  
  foreach mode {
    {SelectMode     {-text select}}
    {ScaleMode      {-text scale}}
    {RotateMode     {-text rotate}}
    {StretchMode    {-text "  stretch  "}}
    {ReshapeMode    {-text "  reshape  "}}
    {LineMode       {-bitmap [mkbitmap picl]}}
    {RectangleMode  {-bitmap [mkbitmap picr]}}
    {FrectangleMode {-bitmap [mkbitmap picfrect]}}
    {OvalMode	    {-bitmap [mkbitmap pico]}}
    {ArcMode	    {-bitmap [mkbitmap picarc]}}
    {PieMode        {-bitmap [mkbitmap picpie]}}
    {CurveMode      {-bitmap [mkbitmap piccurv]}}
    {CloseLineMode  {-bitmap [mkbitmap picclosel]}}
    {CloseCurveMode {-bitmap [mkbitmap picclosec]}}
    {TextMode       {-text A}}
    {ImageMode      {-text image}}
    {LatexMode      {-text latex}}
  } {
    frame .frame0.modeFr.mode${i}Fr \
      -borderwidth 0

    eval "button .frame0.modeFr.mode${i}Fr.mode${i}Bt \
	-command [list "ChangeMode  [lindex $mode 0]"] \
	-relief raised \
        [lindex $mode 1]"     
    
    set symbolicName([lindex $mode 0]) .frame0.modeFr.mode${i}Fr.mode${i}Bt

    label .frame0.modeFr.mode${i}Fr.mode${i}Lb \
      -font {*-times-bold-i-*--12-*} \
      -width 1 -text [getAccel [lindex $mode 0]]

    pack append .frame0.modeFr.mode${i}Fr \
      .frame0.modeFr.mode${i}Fr.mode${i}Lb {left fill} \
      .frame0.modeFr.mode${i}Fr.mode${i}Bt  {top expand fill}

    pack append .frame0.modeFr \
      .frame0.modeFr.mode${i}Fr {top expand pady 10 fill}

    incr i
  }

  ################################################################
  ####		    packing .frame0                         ####
  ################################################################
  
  pack append .frame0 \
    .frame0.modeFr {top fill}
  
  ################################################################
  ####		  La barre superieure                       ####
  ################################################################
  
  # build widget .frame1
  frame .frame1 \
    -borderwidth {2}\
    -relief {raised}
  
  # build widget dummy
  label .frame1.name \
    -relief flat -borderwidth 0 \
    -width 10 \
    -font {-adobe-helvetica-bold-r-normal--18-180-*}
  
  ####  File button  ####
  menubutton .frame1.fileBt \
    -text {File} \
    -menu .frame1.fileBt.m \
    -relief raised

  ####  File button menu  ####
  menu .frame1.fileBt.m

  .frame1.fileBt.m add command \
    -label {  Load drawing  } \
    -command {LoadDrawing} \
    -accelerator [getAccel LoadDrawing]
    
  .frame1.fileBt.m add command \
    -label {  Include drawing  } \
    -command {IncludeDrawing} \
    -accelerator [getAccel LoadDrawing]
    
  .frame1.fileBt.m add command \
    -label {  Save drawing  } \
    -command {SaveDrawing} \
    -accelerator [getAccel SaveDrawing]

  .frame1.fileBt.m add command \
    -label {  Save drawing as ...  } \
    -command {SaveDrawingAs} \
    -accelerator [getAccel SaveDrawingAs]

  .frame1.fileBt.m add command \
    -label {  Write Latex  } \
    -command {WriteLatex} \
    -accelerator [getAccel WriteLatex]

  .frame1.fileBt.m add command \
    -label {  Write Postcript  } \
    -command {WritePostscript} \
    -accelerator [getAccel WritePostscript]

  .frame1.fileBt.m add command \
    -label {  Create custom file  } \
    -command {customFileCreate}

  .frame1.fileBt.m add sep

  .frame1.fileBt.m add command \
    -label {  Quit  } \
    -command {Quit} \
    -accelerator [getAccel Quit]
  
  label .frame1.warnLb \
    -borderwidth {0}
  
  ####  Edit button  ####
  menubutton .frame1.editBt \
    -text {Edit} \
    -menu .frame1.editBt.m \
    -relief raised

  bind .frame1.editBt <ButtonPress-3> { help .frame1.editBt }
  
  menu .frame1.editBt.m

  ####  UNDO DISABLED  ####
#  .frame1.editBt.m add command \
#    -label {  Undo  } \
#    -command { Undo } \
#    -accelerator [getAccel Undo]

  .frame1.editBt.m add command \
    -label {  Delete  } \
    -command { ApplyOnSelection delete } \
    -accelerator [getAccel Delete]

  .frame1.editBt.m add command \
    -label {  Duplicate  } \
    -command {Duplicate} \
    -accelerator [getAccel Duplicate]

  .frame1.editBt.m add command \
    -label {  Object Parameters  } \
    -command { Configure } \
    -accelerator [getAccel Configure]

  .frame1.editBt.m add command \
    -command { Align } \
    -label {  Align  } \
    -accelerator [getAccel Align]

  .frame1.editBt.m add command \
    -command { AlignToGrid } \
    -label {  Align to grid } \
    -accelerator [getAccel AlignToGrid]

  .frame1.editBt.m add command \
    -command {SelectAll} \
    -label {  Select All  } \
    -accelerator [getAccel SelectAll]
  
  .frame1.editBt.m add separator 
  
  .frame1.editBt.m add command \
    -command { Group } \
    -label {  Group  } \
    -accelerator [getAccel Group]

  .frame1.editBt.m add command \
    -command { Ungroup } \
    -label {  Ungroup  } \
    -accelerator [getAccel Ungroup]

  .frame1.editBt.m add command \
    -command { UngroupAll } \
    -label {  Group Reset } \
    -accelerator [getAccel Ungroup]

  .frame1.editBt.m add command \
    -label {  Raise  } \
    -command {  ApplyOnSelection raise  } \
    -accelerator [getAccel Raise]

  .frame1.editBt.m add command \
    -label {  Lower  } \
    -command { ApplyOnSelection lower } \
    -accelerator [getAccel Lower]

  .frame1.editBt.m add separator

  .frame1.editBt.m add command \
    -label {  Rotate 90  } \
    -command { Rotate 90 } \
    -accelerator [getAccel "Rotate 90"]

  .frame1.editBt.m add command \
    -label {  Rotate -90  } \
    -command { Rotate -90 } \
    -accelerator [getAccel "Rotate -90"]

  .frame1.editBt.m add command \
    -label {  Horizontal Flip  } \
    -command { FlipHorizontal } \
    -accelerator [getAccel "FlipHorizontal"]

  .frame1.editBt.m add command \
    -label {  Vertical Flip  } \
    -command { FlipVertical } \
    -accelerator [getAccel "FlipVertical"]

  .frame1.editBt.m add command \
    -label {  Axial Symetry  } \
    -command { AxialSymetry } \
    -accelerator [getAccel "AxialSymetry"]

  .frame1.editBt.m add separator

  .frame1.editBt.m add command \
    -label {  Compile Latex  } \
    -command { LatexCompile } \
    -accelerator [getAccel LatexCompile]

  .frame1.editBt.m add command \
    -label {  Uncompile Latex  } \
    -command { LatexUncompile } \
    -accelerator [getAccel LatexUncompile]

  # pack widget .frame1
  pack append .frame1 \
    .frame1.name  {left fill} \
    .frame1.fileBt {padx 60 pady 6 left fill} \
    .frame1.editBt {padx 60 pady 6 left fill} \
    .frame1.warnLb {left fill expand}
  
  # build widget .frame2
  frame .frame2 \
    -borderwidth {2}
  
  frame .frame2.frame22 -borderwidth 0

  global drawAreaWidth drawAreaHeight
  
  canvas .frame2.frame22.canvas \
    -insertofftime {600}\
    -selectborderwidth {1}\
    -background white \
    -closeenough 2.0 \
    -width $drawAreaWidth \
    -height $drawAreaHeight \
    -scrollregion "0 0 $drawAreaWidth $drawAreaHeight" \
    -xscrollcommand {.frame2.frame22.bottomSc set} \
    -yscrollcommand {.frame2.frame22.rightSc set}

  scrollbar .frame2.frame22.bottomSc \
    -orient horizontal \
    -foreground {#8ba3ce} \
    -width 15 \
    -command {.frame2.frame22.canvas xview}

  scrollbar .frame2.frame22.rightSc \
    -foreground {#8ba3ce} \
    -orient vertical \
    -width 15 \
    -command {.frame2.frame22.canvas yview}
  
  pack append .frame2.frame22 \
    .frame2.frame22.canvas {left} 

  # pack widget .frame2
  pack append .frame2 \
    .frame2.frame22 {bottom expand fill}  
  
  
  ################################################################
  ####	The option area : right vertical area in              ####
  ####       application, contains a button and frames.       ####
  ####      Each frame displays one option group (style,      ####
  ####      alignment, gridding, ...). As much frames as      ####
  ####      possible are displayed given the main window      ####
  ####			 size.                                ####
  ################################################################

  frame .optionFr \
    -borderwidth {2}\
    -relief {raised}

  ########  Option button  ########
  frame .optionFr.btf -borderwidth 0
  menubutton .optionFr.btf.optionBt \
    -relief raised -borderwidth 2 \
    -menu .optionFr.btf.optionBt.m \
    -text {Control} \
    -width 12
  
  pack append .optionFr.btf \
    .optionFr.btf.optionBt {top fill frame center padx 40 pady 12}
  
  ##  menu  entries ##
  menu .optionFr.btf.optionBt.m

  global optionViewOrder
  global optionBtVar
  global optionBtState
  
  ##  initially active buttons  ##
  set optionBtState {0 1 2}

  set optionViewOrder {}

  set nopt 0
  foreach opt {{styles} {align mode} {grid} {text} {latex} {images}} {

    lappend optionViewOrder $nopt
    if {$nopt < 3} { set optionBtVar($nopt) 1 }

    .optionFr.btf.optionBt.m add checkbutton \
    -label $opt \
    -variable optionBtVar($nopt) \
    -command [list optionViewRaise $nopt]

    incr nopt
  }
  
  ########  the optionFr separators  ########

  frame .optionFr.sep -borderwidth 3 \
      -relief raised -height 6

  loop i 0 $nopt {
    frame .optionFr.sep$i -borderwidth 3 \
      -relief raised -height 6
  }
  
  ##  Build all possible option frames  ##
  
  optionBuildStyle 
  optionBuildAlign 
  optionBuildGrid
  
  ##  Pack optionFr with three initial option frames  ##
  
  pack append .optionFr \
    .optionFr.btf      {top pady 12} \
    .optionFr.sep      {top fillx} \
    [SN optionFrame0]  {top fillx} \
    .optionFr.sep0     {top fillx} \
    [SN optionFrame1]  {top fillx} \
    .optionFr.sep1     {top fillx} \
    [SN optionFrame2]  {top fillx} \
    .optionFr.sep2     {top fillx}
    
  # pack widget .
  pack append . \
    .frame1 {top fillx} \
    .frame0 {left frame n filly} \
    .optionFr {right frame n} \
    .frame2 {right frame center expand fill}
}

################################################################
####		 Building option frames                     ####
################################################################

########  Latex frame : latex compilation parameters  ########
proc optionBuildLatex {} {
  
  frame .optionFr.latexFr -borderwidth 0

  ########  Label  ########
  
  label .optionFr.latexFr.label \
    -relief flat \
    -text {Latex parameters:}

  ####  Resolution ####

  scale .optionFr.latexFr.resolSc \
    -orient horiz \
    -width 10 \
    -sliderlength 16 \
    -length 20 \
    -label {Resolution:} \
    -command {set LatexResolution} \
    -from  {72} \
    -showvalue 1 \
    -to    {1000}

  global LatexResolution
  set LatexResolution 200
  .optionFr.latexFr.resolSc set 200

  ####  Document style  ####

  frame .optionFr.latexFr.docstFr \
    -borderwidth 0

  label .optionFr.latexFr.docstFr.docstLb \
    -relief flat \
    -text "Document style:"

  global LatexDocStyle
  entry .optionFr.latexFr.docstFr.docstEn \
    -borderwidth 1 -relief sunken \
    -width 13 \
    -textvariable LatexDocStyle

  pack append .optionFr.latexFr.docstFr \
    .optionFr.latexFr.docstFr.docstLb {top frame w} \
    .optionFr.latexFr.docstFr.docstEn {top expand fill}
  
  ####  Latex drawing ratio  ####
  
  label .optionFr.latexFr.ratioLb \
    -text {Latex drawing ratio: }

  global LatexDrawingRatio
  entry .optionFr.latexFr.ratioEn \
    -borderwidth {1} \
    -relief {sunken} \
    -textvariable {LatexDrawingRatio} \
    -width {13}

  ####  Anchor  ####

  label .optionFr.latexFr.anchorLb \
    -relief flat \
    -text {Latex anchor:}

  frame .optionFr.latexFr.anchorFr \
    -borderwidth 0

  frame .optionFr.latexFr.anchorFr.f1 \
    -borderwidth 0
  frame .optionFr.latexFr.anchorFr.f2 \
    -borderwidth 0
  frame .optionFr.latexFr.anchorFr.f3 \
    -borderwidth 0

  global LatexAnchor
  radiobutton .optionFr.latexFr.anchorFr.f1.nw \
    -value nw \
    -text {nw} \
    -variable LatexAnchor \
    -command {SetLatexAnchor}
  
  radiobutton .optionFr.latexFr.anchorFr.f1.w \
    -value w \
    -text {w} \
    -variable LatexAnchor \
    -command {SetLatexAnchor}
  
  radiobutton .optionFr.latexFr.anchorFr.f1.sw \
    -value sw \
    -text {sw} \
    -variable LatexAnchor \
    -command {SetLatexAnchor}
  
  radiobutton .optionFr.latexFr.anchorFr.f2.n \
    -value n \
    -text {n} \
    -variable LatexAnchor \
    -command {SetLatexAnchor}
  
  radiobutton .optionFr.latexFr.anchorFr.f2.c \
    -value center \
    -text {c} \
    -variable LatexAnchor \
    -command {SetLatexAnchor}
  
  radiobutton .optionFr.latexFr.anchorFr.f2.s \
    -value s \
    -text {s} \
    -variable LatexAnchor \
    -command {SetLatexAnchor}
  
  radiobutton .optionFr.latexFr.anchorFr.f3.ne \
    -value ne \
    -text {ne} \
    -variable LatexAnchor \
    -command {SetLatexAnchor}
  
  radiobutton .optionFr.latexFr.anchorFr.f3.e \
    -value e \
    -text {e} \
    -variable LatexAnchor \
    -command {SetLatexAnchor}
  
  radiobutton .optionFr.latexFr.anchorFr.f3.se \
    -value se \
    -text {se} \
    -variable LatexAnchor \
    -command {SetLatexAnchor}

  pack append .optionFr.latexFr.anchorFr.f1 \
    .optionFr.latexFr.anchorFr.f1.nw {top fill} \
    .optionFr.latexFr.anchorFr.f1.w  {top fill} \
    .optionFr.latexFr.anchorFr.f1.sw  {top fill}

  pack append .optionFr.latexFr.anchorFr.f2 \
    .optionFr.latexFr.anchorFr.f2.n {top fill} \
    .optionFr.latexFr.anchorFr.f2.c  {top fill} \
    .optionFr.latexFr.anchorFr.f2.s  {top fill}

  pack append .optionFr.latexFr.anchorFr.f3 \
    .optionFr.latexFr.anchorFr.f3.ne {top fill} \
    .optionFr.latexFr.anchorFr.f3.e  {top fill} \
    .optionFr.latexFr.anchorFr.f3.se  {top fill}

  pack append .optionFr.latexFr.anchorFr \
    .optionFr.latexFr.anchorFr.f1 {left fill} \
    .optionFr.latexFr.anchorFr.f2 {left fill} \
    .optionFr.latexFr.anchorFr.f3 {left fill}
    
  ##  Packing  ##
  pack append .optionFr.latexFr \
    .optionFr.latexFr.label {top frame n fill pady 10} \
    .optionFr.latexFr.docstFr {top fillx frame n pady 6} \
    .optionFr.latexFr.ratioLb {top frame w} \
    .optionFr.latexFr.ratioEn {top frame n pady 6 fillx} \
    .optionFr.latexFr.anchorLb {top frame w} \
    .optionFr.latexFr.anchorFr {top frame n pady 6} \
    .optionFr.latexFr.resolSc {top fillx frame s pady 6}

  ##  Entry Bindings  ##

  bind .optionFr.latexFr.ratioEn <Return> {
    if {[isfpnum $LatexDrawingRatio]} {
      focus .

      global LatexText
      set ltIds [[cv] find withtag latex]
      eval "updateLatexBboxes $ltIds"
      foreach id $ltIds {
	set both [[cv] find withtag \
		  [getTopGroupTags $id]]
	if {[lindex $both 0] == $id} {
	  set frameId [lindex $both 1]
	} else {
	  set frameId [lindex $both 0]
	}
	[cv] itemconfigure $id \
	  -text [keylget LatexText $id]
	eval "fitTextInRect $id [[cv] coords $frameId]"
      }
    }
  }
}

######## Image Frame ########

proc optionBuildImage {} {
  
  frame .optionFr.imageFr -borderwidth 0

  ########  Label  ########
  
  label .optionFr.imageFr.label \
    -relief flat \
    -text {Image parameters:}

  ########  Brightness  ########

  frame .optionFr.imageFr.brightFr -borderwidth 0

  label .optionFr.imageFr.brightLb \
    -relief flat \
    -text {Brightness:} \
    -anchor w \
    -width 10

  button .optionFr.imageFr.brightFr.frwdBt \
    -relief raised \
    -bitmap [mkbitmap "frwd"] \
    -command { setSelectionBrightness -0.2 }

  button .optionFr.imageFr.brightFr.rwdBt \
    -relief raised \
    -bitmap [mkbitmap "rwd"] \
    -command { setSelectionBrightness -0.015 }

  button .optionFr.imageFr.brightFr.fwdBt \
    -relief raised \
    -bitmap [mkbitmap "fwd"] \
    -command { setSelectionBrightness 0.015 }

  button .optionFr.imageFr.brightFr.ffwdBt \
    -relief raised \
    -bitmap [mkbitmap "ffwd"] \
    -command { setSelectionBrightness 0.2 }

  pack append .optionFr.imageFr.brightFr \
    .optionFr.imageFr.brightFr.frwdBt   {left filly frame e padx 20} \
    .optionFr.imageFr.brightFr.rwdBt   {left filly} \
    .optionFr.imageFr.brightFr.fwdBt   {left filly} \
    .optionFr.imageFr.brightFr.ffwdBt   {left filly}

  ########  Contrast  ########

  frame .optionFr.imageFr.contrastFr -borderwidth 0

  label .optionFr.imageFr.contrastLb \
    -relief flat \
    -text {Contrast:} \
    -anchor w \
    -width 10

  button .optionFr.imageFr.contrastFr.frwdBt \
    -relief raised \
    -bitmap [mkbitmap "frwd"] \
    -command { setSelectionContrast -0.2 }

  button .optionFr.imageFr.contrastFr.rwdBt \
    -relief raised \
    -bitmap [mkbitmap "rwd"] \
    -command { setSelectionContrast -0.015 }

  button .optionFr.imageFr.contrastFr.fwdBt \
    -relief raised \
    -bitmap [mkbitmap "fwd"] \
    -command { setSelectionContrast 0.015 }

  button .optionFr.imageFr.contrastFr.ffwdBt \
    -relief raised \
    -bitmap [mkbitmap "ffwd"] \
    -command { setSelectionContrast 0.2 }

  pack append .optionFr.imageFr.contrastFr \
    .optionFr.imageFr.contrastFr.frwdBt   {left filly frame e padx 20} \
    .optionFr.imageFr.contrastFr.rwdBt   {left fill} \
    .optionFr.imageFr.contrastFr.fwdBt   {left fill} \
    .optionFr.imageFr.contrastFr.ffwdBt   {left fill}

  ########  packing  ########

  pack append .optionFr.imageFr \
    .optionFr.imageFr.label {top frame n fillx pady 4} \
    .optionFr.imageFr.brightLb {top fillx frame w pady 8} \
    .optionFr.imageFr.brightFr {top pady 8 padx 4 frame n} \
    .optionFr.imageFr.contrastLb {top fillx frame w pady 8} \
    .optionFr.imageFr.contrastFr {top pady 8 padx 4 frame n}

  ########  bindings  ########

  foreach w {
    .optionFr.imageFr.brightFr.frwdBt
    .optionFr.imageFr.brightFr.rwdBt
    .optionFr.imageFr.brightFr.fwdBt
    .optionFr.imageFr.brightFr.ffwdBt
    .optionFr.imageFr.contrastFr.fwdBt
    .optionFr.imageFr.contrastFr.ffwdBt
    .optionFr.imageFr.contrastFr.frwdBt
    .optionFr.imageFr.contrastFr.rwdBt } {
      bind $w <Leave> \
	[list $w configure -state normal -relief raised]
    }
}

########  Style frame: displays a small canvas showing  ########
########  the effect of current style settings  ########

proc optionBuildStyle {} {

  frame .optionFr.styleFr -borderwidth 0
  
  ########  Style object  ########
  
  canvas .optionFr.styleFr.object \
    -relief raise \
    -width 48 -height 72 \
    -background {#8ba3ce}

  ####  button bars  ####
  frame .optionFr.styleFr.barsFr -borderwidth 0
  
  frame .optionFr.styleFr.barsFr.bar1Fr -borderwidth 0
  frame .optionFr.styleFr.barsFr.bar2Fr -borderwidth 0

  ####  menu buttons  ####

  menubutton .optionFr.styleFr.barsFr.bar1Fr.lineBt \
    -text {line} \
    -width 7 \
    -menu {.optionFr.styleFr.barsFr.bar1Fr.lineBt.m} \
    -relief raised

  menubutton .optionFr.styleFr.barsFr.bar2Fr.arrowBt \
    -relief raised \
    -width 7 \
    -text {arrow} \
    -menu {.optionFr.styleFr.barsFr.bar2Fr.arrowBt.m}

  menubutton .optionFr.styleFr.barsFr.bar1Fr.fgBt \
    -relief raised \
    -text {fg} \
    -menu {.optionFr.styleFr.barsFr.bar1Fr.fgBt.m}

  menubutton .optionFr.styleFr.barsFr.bar2Fr.bgBt \
    -relief raised \
    -text {bg} \
    -menu {.optionFr.styleFr.barsFr.bar2Fr.bgBt.m}

  menubutton .optionFr.styleFr.barsFr.bar1Fr.dashesBt \
    -relief raised \
    -text {dashes} \
    -menu {.optionFr.styleFr.barsFr.bar1Fr.dashesBt.m}

  menubutton .optionFr.styleFr.barsFr.bar2Fr.stippleBt \
    -relief raised \
    -text {stipple} \
    -menu {.optionFr.styleFr.barsFr.bar2Fr.stippleBt.m}

  ####  packing the menu button bars  ####

  pack append .optionFr.styleFr.barsFr.bar1Fr \
    .optionFr.styleFr.barsFr.bar1Fr.lineBt   {top fill pady 4} \
    .optionFr.styleFr.barsFr.bar1Fr.fgBt     {top fill pady 4} \
    .optionFr.styleFr.barsFr.bar1Fr.dashesBt {top fill pady 4}

  pack append .optionFr.styleFr.barsFr.bar2Fr \
    .optionFr.styleFr.barsFr.bar2Fr.arrowBt   {top fill pady 4} \
    .optionFr.styleFr.barsFr.bar2Fr.bgBt      {top fill pady 4} \
    .optionFr.styleFr.barsFr.bar2Fr.stippleBt {top fill pady 4}

  ####  Menus  ####

  #  line menu  #

  menu .optionFr.styleFr.barsFr.bar1Fr.lineBt.m

  global lineMenuVar
  set lineMenuVar 1

  global theLineWidth
  foreach width $theLineWidth {
    .optionFr.styleFr.barsFr.bar1Fr.lineBt.m add radiobutton \
      -bitmap [mkbitmap width $width]  \
      -variable {lineMenuVar} \
      -value $width \
      -command [list SetStyle lineWidth $width]
  }

  #  arrow menu  #
  
  menu .optionFr.styleFr.barsFr.bar2Fr.arrowBt.m

  global arrowMenuVar
  set arrowMenuVar none

  .optionFr.styleFr.barsFr.bar2Fr.arrowBt.m add radiobutton \
    -bitmap [mkbitmap width 1]  \
    -variable {arrowMenuVar} \
    -value none \
    -command {SetStyle arrow none}

  .optionFr.styleFr.barsFr.bar2Fr.arrowBt.m add radiobutton \
    -bitmap [mkbitmap rlinearrow]  \
    -variable {arrowMenuVar} \
    -value last \
    -command {SetStyle arrow last}
  
  .optionFr.styleFr.barsFr.bar2Fr.arrowBt.m add radiobutton \
    -bitmap [mkbitmap llinearrow]  \
    -variable {arrowMenuVar} \
    -value first \
    -command {SetStyle arrow first}
  
  .optionFr.styleFr.barsFr.bar2Fr.arrowBt.m add radiobutton \
    -bitmap [mkbitmap rllinearrow]  \
    -variable {arrowMenuVar} \
    -value both \
    -command {SetStyle arrow both}

  #  foreground color menu  #

  menu .optionFr.styleFr.barsFr.bar1Fr.fgBt.m

  .optionFr.styleFr.barsFr.bar1Fr.fgBt.m add command \
    -label {   none   } \
    -command { SetStyle lineColor "" }

  global theForegroundColors
  foreach color $theForegroundColors {
      .optionFr.styleFr.barsFr.bar1Fr.fgBt.m add command \
	-background $color \
	-activebackground $color \
	-command [list SetStyle lineColor $color]
    }

  #  background color menu  #

  menu .optionFr.styleFr.barsFr.bar2Fr.bgBt.m

  .optionFr.styleFr.barsFr.bar2Fr.bgBt.m add command \
    -label {   none   } \
    -command { SetStyle fillColor "" }

  global theBackgroundColors
  foreach color $theBackgroundColors {
      .optionFr.styleFr.barsFr.bar2Fr.bgBt.m add command \
	-background $color \
	-activebackground $color \
	-command [list SetStyle fillColor $color]
    }

  # dashes menu #

  menu .optionFr.styleFr.barsFr.bar1Fr.dashesBt.m

  global theDashes

  foreach spec $theDashes {
    .optionFr.styleFr.barsFr.bar1Fr.dashesBt.m add command \
      -bitmap [eval "mkbitmap dashes $spec"]  \
      -command [list SetStyle dashes $spec]
  }
  
  # stipple menu #

  menu .optionFr.styleFr.barsFr.bar2Fr.stippleBt.m

  global theStipples
  foreach st $theStipples {
    set bitmap [mkbitmap $st]
    .optionFr.styleFr.barsFr.bar2Fr.stippleBt.m add command \
      -bitmap $bitmap  \
      -command "SetStyle stipple $bitmap"
  }
  
  ####  pack bars frame  ####

  pack append .optionFr.styleFr.barsFr \
    .optionFr.styleFr.barsFr.bar1Fr {left fill expand} \
    .optionFr.styleFr.barsFr.bar2Fr {left fill expand}
  
  ########  Packing style frame  ########
  
  pack append .optionFr.styleFr \
    .optionFr.styleFr.object    {top fill} \
    .optionFr.styleFr.barsFr    {top fill}
}

########  Align options frame  ########
########  displays vert. and horiz. button modes  ########
########  and 3 little objects showing the effect  ########
########  of current settings  ########

proc optionBuildAlign {} {
  frame .optionFr.alignFr -borderwidth 0 -relief flat
  
  ####  Label  ####
  label .optionFr.alignFr.label \
    -text {Align mode:} \
    -relief flat
  
  ####  control buttons and canvas  ####
  frame .optionFr.alignFr.f -borderwidth 0 -relief flat
  
  ####  vertical bar  ####
  frame .optionFr.alignFr.f.vbarFr -borderwidth 0
  button .optionFr.alignFr.f.vbarFr.frame39 \
    -activebackground grey85 \
    -bitmap [mkbitmap emptyarrow]  \
    -borderwidth 1 \
    -relief flat
  
  frame .optionFr.alignFr.f.vbarFr.frame40 -borderwidth 0
  button .optionFr.alignFr.f.vbarFr.frame40.none \
    -activebackground {#85a3ca} \
    -activeforeground {grey85} \
    -borderwidth 1 \
    -relief sunken \
    -bitmap [mkbitmap tdarrow]  \
    -command {
      eval "[SN alignVBar].$vertAlignMode configure \
              -relief raised"
      set vertAlignMode none
      [SN alignVBar].none configure -relief sunken
      alignShowMode
    }
  button .optionFr.alignFr.f.vbarFr.frame40.top \
    -activebackground {#85a3ca} \
    -activeforeground {grey85} \
    -borderwidth 1 \
    -bitmap [mkbitmap uparrow]  \
    -command {
      eval "[SN alignVBar].$vertAlignMode configure \
              -relief raised"
      set vertAlignMode top
      [SN alignVBar].top configure -relief sunken
      alignShowMode
    }
  button .optionFr.alignFr.f.vbarFr.frame40.center \
    -activebackground {#85a3ca} \
    -activeforeground {grey85} \
    -borderwidth 1 \
    -bitmap [mkbitmap vcarrow]  \
    -command {
      eval "[SN alignVBar].$vertAlignMode configure \
              -relief raised"
      set vertAlignMode center
      [SN alignVBar].center configure -relief sunken
      alignShowMode
    }
  button .optionFr.alignFr.f.vbarFr.frame40.bottom \
    -activebackground {#85a3ca} \
    -activeforeground {grey85} \
    -borderwidth 1 \
    -bitmap [mkbitmap darrow]  \
    -command {
      eval "[SN alignVBar].$vertAlignMode configure \
              -relief raised"
      set vertAlignMode bottom
      [SN alignVBar].bottom configure -relief sunken
      alignShowMode
    }
  pack append .optionFr.alignFr.f.vbarFr.frame40 \
    .optionFr.alignFr.f.vbarFr.frame40.none { \
      top fill frame center} \
    .optionFr.alignFr.f.vbarFr.frame40.top { \
      top fill frame center} \
    .optionFr.alignFr.f.vbarFr.frame40.center { \
      top fill frame center} \
    .optionFr.alignFr.f.vbarFr.frame40.bottom { \
      top fill frame center}
  
  ####  packing vertical bar  ####
  pack append .optionFr.alignFr.f.vbarFr \
    .optionFr.alignFr.f.vbarFr.frame39 {top frame center} \
    .optionFr.alignFr.f.vbarFr.frame40 { \
      top frame center expand filly}
  
  ####  horizontal bar and canvas  ####
  frame .optionFr.alignFr.f.frame36 -borderwidth 0
  
  ####  canvas  ####
  canvas .optionFr.alignFr.f.frame36.canvas41 \
    -insertbackground {maroon} \
    -relief {raised} \
    -selectbackground {#85a3ca} \
    -selectforeground {grey85} \
    -width 10 -height 10 \
    -borderwidth 1 \
    -insertofftime {600} 
  
  ####  horizontal bar  ####
  frame .optionFr.alignFr.f.frame36.frame37 -borderwidth 0
  button .optionFr.alignFr.f.frame36.frame37.none \
    -activebackground {#85a3ca} \
    -activeforeground {grey85} \
    -borderwidth 1 \
    -relief sunken \
    -bitmap [mkbitmap rlarrow]  \
    -command {
      eval "[SN alignHBar].$horizAlignMode configure \
              -relief raised"
      set horizAlignMode none
      [SN alignHBar].none configure -relief sunken
      alignShowMode
    }
  button .optionFr.alignFr.f.frame36.frame37.left \
    -activebackground {#85a3ca} \
    -activeforeground {grey85} \
    -borderwidth 1 \
    -bitmap [mkbitmap larrow]  \
    -command {
      eval "[SN alignHBar].$horizAlignMode configure \
              -relief raised"
      set horizAlignMode left
      [SN alignHBar].left configure -relief sunken
      alignShowMode
    }
  button .optionFr.alignFr.f.frame36.frame37.center \
    -activebackground {#85a3ca} \
    -activeforeground {grey85} \
    -borderwidth 1 \
    -bitmap [mkbitmap hcarrow]  \
    -command {
      eval "[SN alignHBar].$horizAlignMode configure \
              -relief raised"
      set horizAlignMode center
      [SN alignHBar].center configure -relief sunken
      alignShowMode
    }
  button .optionFr.alignFr.f.frame36.frame37.right \
    -activebackground {#85a3ca} \
    -activeforeground {grey85} \
    -borderwidth 1 \
    -bitmap [mkbitmap rarrow]  \
    -command {
      eval "[SN alignHBar].$horizAlignMode configure \
              -relief raised"
      set horizAlignMode right
      [SN alignHBar].right configure -relief sunken
      alignShowMode
    }
  
  # pack widget .optionFr.alignFr.f.frame36.frame37
  pack append .optionFr.alignFr.f.frame36.frame37 \
    .optionFr.alignFr.f.frame36.frame37.none { \
      left fill frame center} \
    .optionFr.alignFr.f.frame36.frame37.left { \
      left fill frame center} \
    .optionFr.alignFr.f.frame36.frame37.center {\
      left fill frame center} \
    .optionFr.alignFr.f.frame36.frame37.right { \
      left fill frame center}
  
  ####  pack hbar and canvas frame  ####
  pack append .optionFr.alignFr.f.frame36 \
    .optionFr.alignFr.f.frame36.frame37 {top frame center fillx} \
    .optionFr.alignFr.f.frame36.canvas41 { \
      top frame center expand fill}
  
  ####  pack bars and canvas  ####
  pack append .optionFr.alignFr.f \
    .optionFr.alignFr.f.vbarFr {left frame center filly} \
    .optionFr.alignFr.f.frame36 {right frame center expand fill}
  
  ####  pack alignFr  ####
  pack append .optionFr.alignFr \
    .optionFr.alignFr.label {top fill} \
    .optionFr.alignFr.f {top frame s pady 8}
}

####		  Grid options frame:                       ####
####	      one entry for grid spacing,                   ####
####	     and radiobuttons for grid unit                 ####

proc optionBuildGrid {} {
  global GridUnit GridSpacing gridEntryVar
  global PicassoLib
  
  frame .optionFr.gridFr -borderwidth 0
  
  ####  Label  ####
  label .optionFr.gridFr.label \
    -relief flat \
    -text {Grid options:}
  
  ####  show grid button  ####
  button .optionFr.gridFr.showBt \
    -command { toggleShowGrid } \
    -text { Show grid }
  
  ####  Gridding button  ####
  global GriddingMode
  set GriddingMode 0
  
  checkbutton .optionFr.gridFr.griddingBt \
    -variable GriddingMode \
    -text {gridding} \
    -command { gridSpacingUpdate }
  
  ####  Grid spacing  ####
  
  label .optionFr.gridFr.label1 \
    -text {Grid spacing: }
  
  entry .optionFr.gridFr.entry2 \
    -borderwidth {1} \
    -relief {sunken} \
    -textvariable {gridEntryVar} \
    -width {13}
  
  ####  Grid unit  ####
  
  label .optionFr.gridFr.label3 \
    -text {Grid unit:}
  
  menubutton .optionFr.gridFr.unitBt \
    -menu {.optionFr.gridFr.unitBt.m} \
    -relief raised \
    -width 13 \
    -text {millimeters}
  
  #  unit popup menu  #
  menu .optionFr.gridFr.unitBt.m
  
  global GridUnit
  .optionFr.gridFr.unitBt.m add radiobutton \
    -label { pixels } \
    -variable GridUnit \
    -value {pixel} \
    -command {
      .optionFr.gridFr.unitBt configure -text {pixels}
      gridSpacingUpdate
    }
  
  .optionFr.gridFr.unitBt.m add radiobutton \
    -label { centimeters } \
    -variable GridUnit \
    -value {cm} \
    -command {
      .optionFr.gridFr.unitBt configure -text { centimeters }
      gridSpacingUpdate
    }
  
  .optionFr.gridFr.unitBt.m add radiobutton \
    -label { millimeters } \
    -variable GridUnit \
    -value {mm} \
    -command {
      .optionFr.gridFr.unitBt configure -text {millimeters}
      gridSpacingUpdate
    }
  
  .optionFr.gridFr.unitBt.m add radiobutton \
    -label { inches } \
    -variable GridUnit \
    -value {inch} \
    -command {
      .optionFr.gridFr.unitBt configure -text {inches}
      gridSpacingUpdate
    }
  
  .optionFr.gridFr.unitBt.m add radiobutton \
    -label { picas } \
    -variable GridUnit \
    -value {pica} \
    -command {
      .optionFr.gridFr.unitBt configure -text {picas}
      gridSpacingUpdate
    }
  
  # pack widget .optionFr.gridFr
  pack append .optionFr.gridFr \
    .optionFr.gridFr.label  {top frame n pady 6} \
    .optionFr.gridFr.showBt {top pady 6 frame n} \
    .optionFr.gridFr.griddingBt {top pady 6 frame n} \
    .optionFr.gridFr.label1 {top frame sw pady 10} \
    .optionFr.gridFr.entry2 {top frame center} \
    .optionFr.gridFr.label3 {top frame sw pady 10} \
    .optionFr.gridFr.unitBt {top frame center}
  
  bind .optionFr.gridFr.entry2 <Key-Return> \
    { gridSpacingUpdate }
}


################################################################
####	    Font Selection for text objects                 ####
################################################################

set currentFName [lindex $theFNames 0]
set currentFSize [lindex $theFSizes 0]
set currentFWeight [lindex $theFWeights 0]
set currentFSlant [lindex $theFSlants 0]

set currentFont [getFontName $currentFName $currentFSize $currentFWeight $currentFSlant]

proc optionBuildText {} {
  global theFNames theFSizes theFWeights theFSlants
  global currentFName
  global currentFont
  
  frame .optionFr.fontFr -borderwidth 0

  #### show ####
  canvas .optionFr.fontFr.showCv \
    -relief raised \
    -width 48 -height 36 \
    -background {#8ba3ce}


  ####  font button  ####

  button .optionFr.fontFr.fontBt \
    -relief raised \
    -text {font}

  bind .optionFr.fontFr.fontBt <ButtonPress-1> {
    if {[winfo ismapped .optionFr.fontFr.fontBt.m]} {
      .optionFr.fontFr.fontBt.m unpost
      grab release .optionFr.fontFr.fontBt
    } else {
      .optionFr.fontFr.fontBt.m post \
	[winfo rootx .optionFr.fontFr.fontBt] \
	[expr "[winfo rooty .optionFr.fontFr.fontBt]+[winfo height .optionFr.fontFr.fontBt]"]
      grab -global .optionFr.fontFr.fontBt
    }
  }

  menu .optionFr.fontFr.fontBt.m

  set i 0
  foreach name $theFNames {
    foreach weight $theFWeights {
      foreach slant $theFSlants {
	set font [getFontName $name 18 $weight $slant]
	if {$font != ""} {
	  button .optionFr.fontFr.fontBt.m.b${i}Bt \
	    -text "$name $weight $slant" \
	    -font $font

	  pack append .optionFr.fontFr.fontBt.m \
	    .optionFr.fontFr.fontBt.m.b${i}Bt {top fill}

	  bind .optionFr.fontFr.fontBt.m.b${i}Bt <ButtonRelease-1> " \
              %W configure -relief raised
              .optionFr.fontFr.fontBt.m unpost
	      grab release .optionFr.fontFr.fontBt
              set currentFName $name
	      set currentFWeight $weight
	      set currentFSlant $slant
	      setCurrentFont name weight slant
	      SetStyle font \$currentFont
              .optionFr.fontFr.showCv itemconfigure all \
                -text \$currentFName
	    "
	  incr i
	}
      }
    }
  }

  ####  buttons  ####
  frame .optionFr.fontFr.butFr -borderwidth 0
  frame .optionFr.fontFr.but1Fr -borderwidth 0
  frame .optionFr.fontFr.but2Fr -borderwidth 0

  menubutton .optionFr.fontFr.but1Fr.nameBt \
    -relief raised \
    -text {name} \
    -menu .optionFr.fontFr.but1Fr.nameBt.m

  menu .optionFr.fontFr.but1Fr.nameBt.m
  
  foreach name $theFNames {
    .optionFr.fontFr.but1Fr.nameBt.m add radiobutton \
      -label $name \
      -variable {currentFName} \
      -value $name \
      -command "
        setCurrentFont name
	SetStyle font \$currentFont
	.optionFr.fontFr.showCv itemconfigure all \
	  -text \$currentFName
      "
  }

  menubutton .optionFr.fontFr.but2Fr.sizeBt \
    -relief raised \
    -text {size} \
    -menu .optionFr.fontFr.but2Fr.sizeBt.m

  menu .optionFr.fontFr.but2Fr.sizeBt.m
  
  foreach size $theFSizes {
    .optionFr.fontFr.but2Fr.sizeBt.m add radiobutton \
      -label $size \
      -variable {currentFSize} \
      -value $size \
      -command "
        setCurrentFont size
	SetStyle font \$currentFont
	.optionFr.fontFr.showCv itemconfigure all \
	  -text \$currentFName
      "
  }

  menubutton .optionFr.fontFr.but1Fr.weightBt \
    -relief raised \
    -text {weight} \
    -menu .optionFr.fontFr.but1Fr.weightBt.m

  menu .optionFr.fontFr.but1Fr.weightBt.m
  
  foreach weight $theFWeights {
    .optionFr.fontFr.but1Fr.weightBt.m add radiobutton \
      -label $weight \
      -variable {currentFWeight} \
      -value $weight \
      -command "
        setCurrentFont weight
	SetStyle font \$currentFont
	.optionFr.fontFr.showCv itemconfigure all \
	  -text \$currentFName
      "
  }

  menubutton .optionFr.fontFr.but2Fr.slantBt \
    -relief raised \
    -text {slant} \
    -menu .optionFr.fontFr.but2Fr.slantBt.m

  menu .optionFr.fontFr.but2Fr.slantBt.m
  
  foreach slant $theFSlants {
    .optionFr.fontFr.but2Fr.slantBt.m add radiobutton \
      -label $slant \
      -variable {currentFSlant} \
      -value $slant \
      -command "
        setCurrentFont slant
	SetStyle font \$currentFont
	.optionFr.fontFr.showCv itemconfigure all \
	  -text \$currentFName
      "
  }

  pack append .optionFr.fontFr.but1Fr \
    .optionFr.fontFr.but1Fr.nameBt {top expand fill} \
    .optionFr.fontFr.but1Fr.weightBt {top expand fill}

  pack append .optionFr.fontFr.but2Fr \
    .optionFr.fontFr.but2Fr.sizeBt {top expand fill} \
    .optionFr.fontFr.but2Fr.slantBt {top expand fill}
  pack append .optionFr.fontFr.butFr \
    .optionFr.fontFr.but1Fr {left expand fill} \
    .optionFr.fontFr.but2Fr {left expand fill}
  

  ####  packing  ####

  pack append .optionFr.fontFr \
    .optionFr.fontFr.showCv {top fill} \
    .optionFr.fontFr.fontBt {top fill} \
    .optionFr.fontFr.butFr  {top fillx frame s pady 4}

  ####  Show text object  ####
  update
  .optionFr.fontFr.showCv create text 10 10 \
    -text $currentFName

  bind .optionFr.fontFr.showCv <Configure> {
    .optionFr.fontFr.showCv coords all \
      [expr "[winfo width .optionFr.fontFr.showCv]/2"] \
      [expr "[winfo height .optionFr.fontFr.showCv]/2"]
  }
}

################################################################
####		 Image loading options                      ####
################################################################

proc buildImloadDialog {} {

  toplevel .imloadDg
  
  # Window manager configurations
  global tkVersion
  wm positionfrom .imloadDg ""
  wm sizefrom .imloadDg ""
  wm maxsize .imloadDg 1000 900
  wm minsize .imloadDg 10 10
  wm title .imloadDg {Picasso Load}

  ####  Label  ####

  label .imloadDg.titleLb \
    -text {Image Loading Options}

  ####  Path  ####

  frame .imloadDg.pathFr \
    -borderwidth 0

  label .imloadDg.pathFr.lb \
    -text {Image file:} \
    -relief flat

  entry .imloadDg.pathFr.pathEn \
    -relief sunken \
    -width 40

  button .imloadDg.pathFr.fsbBt \
    -relief raised \
    -text {File Box} \
    -command {
      FSBox {Image File Name:} [.imloadDg.pathFr.pathEn get] \
	{ .imloadDg.pathFr.pathEn delete 0 end
	  .imloadDg.pathFr.pathEn insert 0 $fsBox(path)/$fsBox(name)
	  focus . } {}
    }

  #  packing  #

  pack append .imloadDg.pathFr \
    .imloadDg.pathFr.lb {left padx 12} \
    .imloadDg.pathFr.pathEn {left} \
    .imloadDg.pathFr.fsbBt {left padx 12}

  ####  Dimensions  ####

  frame .imloadDg.dimFr -borderwidth 0

  label .imloadDg.dimFr.dimLb \
    -text {Image dimensions:} \
    -relief flat

  label .imloadDg.dimFr.parFr -borderwidth 0
  
  frame .imloadDg.dimFr.parFr.labelFr -borderwidth 0
  label .imloadDg.dimFr.parFr.labelFr.widthLb \
    -text {width:} -relief flat
  label .imloadDg.dimFr.parFr.labelFr.heightLb \
    -text {height:} -relief flat

  pack append .imloadDg.dimFr.parFr.labelFr \
    .imloadDg.dimFr.parFr.labelFr.widthLb {top fill} \
    .imloadDg.dimFr.parFr.labelFr.heightLb {top fill}

  frame .imloadDg.dimFr.parFr.entryFr -borderwidth 0
  entry .imloadDg.dimFr.parFr.entryFr.widthEn \
    -relief sunken -width 10
  entry .imloadDg.dimFr.parFr.entryFr.heightEn \
    -relief sunken -width 10
  pack append .imloadDg.dimFr.parFr.entryFr \
    .imloadDg.dimFr.parFr.entryFr.widthEn {top fill} \
    .imloadDg.dimFr.parFr.entryFr.heightEn {top fill}

  frame .imloadDg.dimFr.parFr.dflFr -borderwidth 0
  label .imloadDg.dimFr.parFr.dflFr.curWidthLb \
    -text {(natural image width)}
  label .imloadDg.dimFr.parFr.dflFr.curHeightLb \
    -text {(natural image height)}
  pack append .imloadDg.dimFr.parFr.dflFr \
    .imloadDg.dimFr.parFr.dflFr.curWidthLb {top fill} \
    .imloadDg.dimFr.parFr.dflFr.curHeightLb {top fill}
  
  #  packing  #

  pack append .imloadDg.dimFr.parFr \
    .imloadDg.dimFr.parFr.labelFr {left padx 20 frame e} \
    .imloadDg.dimFr.parFr.entryFr {left padx 8 frame w} \
    .imloadDg.dimFr.parFr.dflFr   {left frame w expand}

  pack append .imloadDg.dimFr \
    .imloadDg.dimFr.dimLb {top frame w} \
    .imloadDg.dimFr.parFr {top fillx expand}
  
  ####  Image Format  ####

  frame .imloadDg.fmtFr -borderwidth 0

  label .imloadDg.fmtFr.label \
    -text {Image file format:} \
    -relief flat

  global currentImageFormat
  menubutton .imloadDg.fmtFr.fmtMBt \
    -text $currentImageFormat \
    -menu .imloadDg.fmtFr.fmtMBt.m \
    -relief raised

  #  image fmt menu  #

  menu .imloadDg.fmtFr.fmtMBt.m

  global theImageFmt
  
  foreach fmt $theImageFmt {
    .imloadDg.fmtFr.fmtMBt.m add radiobutton \
      -label $fmt \
      -variable selectedFmt \
      -value "$fmt" \
      -command [list .imloadDg.fmtFr.fmtMBt configure -text $fmt]
  }
  
  #  packing  #
  pack .imloadDg.fmtFr.label \
    -in .imloadDg.fmtFr \
    -side left -padx 4 \
    -anchor w -fill both

  pack .imloadDg.fmtFr.fmtMBt \
    -after .imloadDg.fmtFr.label \
    -side left \
    -ipadx 10 -ipady 4
  
  ####  Buttons frame  ####

  frame .imloadDg.butFr -borderwidth 0

  button .imloadDg.butFr.okBt \
    -text {Ok} \
    -command {
      imloadSetWidth
      imloadSetHeight
      set currentImageFile [.imloadDg.pathFr.pathEn get]
      set currentImageFormat \
	[lindex [.imloadDg.fmtFr.fmtMBt configure -text] 4]
      set currentImageWidth \
	[string trim [.imloadDg.dimFr.parFr.entryFr.widthEn get]]
      set currentImageHeight \
	[string trim [.imloadDg.dimFr.parFr.entryFr.heightEn get]]

      focus .
      destroy .imloadDg
      
      cimage
    } \
    -relief raised

  button .imloadDg.butFr.cancelBt \
    -text {Cancel} \
    -command {
      focus .
      destroy .imloadDg
    } \
    -relief raised

  #  packing  #
  pack append .imloadDg.butFr \
    .imloadDg.butFr.okBt {left fill expand} \
    .imloadDg.butFr.cancelBt {left fill expand}
  
  ####  Packing toplevel  ####

  pack append .imloadDg \
    .imloadDg.titleLb {top frame n fillx pady 10} \
    .imloadDg.fmtFr  {top fillx expand pady 16} \
    .imloadDg.pathFr {top fillx expand pady 16} \
    .imloadDg.dimFr  {top fillx expand pady 16} \
    .imloadDg.butFr  {top fillx expand frame s pady 10}

  ####  Entry bindings  ####

  foreach action {<Return> <Tab> <Control-n> <Control-p>} {
    bind .imloadDg.dimFr.parFr.entryFr.widthEn \
      $action { imloadSetWidth }
    bind .imloadDg.dimFr.parFr.entryFr.heightEn \
      $action { imloadSetHeight }
  }

  circEntryBind {<Tab> <Return> <Control-n>} \
    {<Control-p>} \
    {.imloadDg.pathFr.pathEn .imloadDg.dimFr.parFr.entryFr.widthEn \
      .imloadDg.dimFr.parFr.entryFr.heightEn}
  
  ##  Active format radiobutton  ##
  global selectedFmt
  set selectedFmt $currentImageFormat
}

################################################################
####       Image Load Dialog entry binding procedures       ####
################################################################

proc imloadSetWidth {} {
  set accept 1
  
  set w [string trim [.imloadDg.dimFr.parFr.entryFr.widthEn get]]
  if {($w != "") && ![regexp {[0-9]*[.]?[0-9]*} $w]} {
    set accept 0
  }
  
  set h [.imloadDg.dimFr.parFr.entryFr.heightEn get]
  if {($w == "") || ($w == 0)} {
    #  no width specified  #
    .imloadDg.dimFr.parFr.entryFr.widthEn delete 0 end
    if {$h == ""} {
      .imloadDg.dimFr.parFr.dflFr.curWidthLb configure \
	-text {(natural image width)}
      .imloadDg.dimFr.parFr.dflFr.curHeightLb configure \
	-text {(natural image height)}
    } else {
      .imloadDg.dimFr.parFr.dflFr.curWidthLb configure \
	-text {(preserve aspect ratio)}
    }
  } else {
    # width specified #
    .imloadDg.dimFr.parFr.entryFr.widthEn delete 0 end
    .imloadDg.dimFr.parFr.entryFr.widthEn insert 0 $w
    .imloadDg.dimFr.parFr.dflFr.curWidthLb configure \
      -text {}
    if {$h == ""} {
      .imloadDg.dimFr.parFr.dflFr.curHeightLb configure \
	-text {(preserve aspect ratio)}
    } else {
      .imloadDg.dimFr.parFr.dflFr.curHeightLb configure \
	-text {}
    }
  }

  if {! $accept} {
    warn "Floating-point value required"
  }
}

proc imloadSetHeight {} {

  set accept 1
  set w [string trim [.imloadDg.dimFr.parFr.entryFr.heightEn get]]
  if {($w != "") && ![regexp {[0-9]*[.]?[0-9]*} $w]} {
    set accept 0
  }
  
  set h [.imloadDg.dimFr.parFr.entryFr.widthEn get]
  if {($w == "") || ($w == 0)} {
    #  no height specified  #
    .imloadDg.dimFr.parFr.entryFr.heightEn delete 0 end
    if {$h == ""} {
      .imloadDg.dimFr.parFr.dflFr.curHeightLb configure \
	-text {(natural image height)}
      .imloadDg.dimFr.parFr.dflFr.curWidthLb configure \
	-text {(natural image width)}
    } else {
      .imloadDg.dimFr.parFr.dflFr.curHeightLb configure \
	-text {(preserve aspect ratio)}
    }
  } else {
    # height specified #
    .imloadDg.dimFr.parFr.entryFr.heightEn delete 0 end
    .imloadDg.dimFr.parFr.entryFr.heightEn insert 0 $w
    .imloadDg.dimFr.parFr.dflFr.curHeightLb configure \
      -text {}
    if {$h == ""} {
      .imloadDg.dimFr.parFr.dflFr.curWidthLb configure \
	-text {(preserve aspect ratio)}
    } else {
      .imloadDg.dimFr.parFr.dflFr.curWidthLb configure \
	-text {}
    }
  }
  if {! $accept} {
    warn "Floating-point value required"
  }
}
