/* 
 * Copyright (c) 1994 Open Software Foundation, Inc.
 * 
 * Permission is hereby granted to use, copy, modify and freely distribute
 * the software in this file and its documentation for any purpose without
 * fee, provided that the above copyright notice appears in all copies, and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation.  Further, provided that the name of Open
 * Software Foundation, Inc. ("OSF") not be used in advertising or
 * publicity pertaining to distribution of the software without prior
 * written permission from OSF.  OSF makes no representations about the
 * suitability of this software for any purpose.  It is provided "AS IS"
 * without express or implied warranty.
 */ 

/*
 * OT 3.0.2
 */

/*
 *	otInit.c
 *
 */


/*
#include <stdlib.h>
*/
#include <string.h>
#include <ctype.h>
#include <stdio.h>
#include <tcl.h>
#include <tclInt.h>
#include "ot.h"
#include "otInt.h"


#ifndef LINT
static char RCSid_otInit[] =
    "$RCSfile: otInit.c,v $ $Revision: 1.1.4.2 $ $Date: 1993/11/09 20:58:28 $";

#endif

/* 
 *		List of functions defined in the otInit.c
 *
 *	otInitialInit()
 *	otFreeControlBlock()
 *	otMallocQCB()
 *	otMallocECB()
 *	otEFreeMemory()
 *	otQFreeMemory()
 *	otClearControlBlock()
 *	otClearPrivateCB()
 *	otClearEnterCB()
 *	otClearQueryCB()
 *	otInitEnter()
 *
 */

void  otCleanForServer();



OTErr
otInitialInit(argc, argv)
int * argc;
char ** argv;
{
    OTPrivateCB	   * pcb;
    OTEnterCB	   * ecb;
    OTQueryCB	   * qcb;
    char *cp1;
    char * project;
    char * dbpath;
    char * layout;
    char * prompt;
    OTErr errCode = OT_SUCCESS;

    otTraceLevel();

    /* Allocate space for the OTControlBlock structure */

    if ( (otCB = (OTControlBlock *) malloc(sizeof(OTControlBlock)) ) == NULL ) {
	otPutPostedMessage(OT_MALLOC_LOCATION, "otInitialInit()"); 
	return OT_MALLOC_LOCATION;
    }



    /* Clear OTControlBlock structure, Initialize TCL interpreter */
    /* Allocate and initialize OTPrivateCB structure */

    otClearControlBlock(); 

    if ( (pcb = (OTPrivateCB *) calloc(1, sizeof(OTPrivateCB)) ) == NULL ) {
	otPutPostedMessage(OT_MALLOC_LOCATION, "otInitialInit()");
	return OT_MALLOC_LOCATION;
    }

    otCB->cb_pcb = pcb; 
    otClearPrivateCB();

    otTclInitInterp();

    /* Allocate space for OTEnterCB and OTQueryCB structures */

    if (((qcb = otMallocQCB()) == NULL) || ((ecb = otMallocECB()) == NULL) )  {
	otPutPostedMessage(OT_MALLOC_LOCATION, "otInitialInit()");
	return OT_MALLOC_LOCATION;
    }

    /* Store OTEnterCB and OTQueryCB control block pointers */

    otCB->cb_qcb = qcb;
    otCB->cb_ecb = ecb;

     otClearEnterCB();
     otClearQueryCB();

     /* Get environment variables (OT_PROJECT, OT_LAYOUT, OT_DBPATH, etc. */

    if (getenv("OT_PROJECT")) {
        project = strdup(getenv("OT_PROJECT"));
        otCB->cb_project = project;
    }

    if (getenv("OT_DBPATH")) {
        dbpath = strdup(getenv("OT_DBPATH"));
        otCB->cb_dbpath = dbpath;
    }

    if (getenv("OT_LAYOUT")) {
        layout = strdup(getenv("OT_LAYOUT"));
        otCB->cb_layout = layout;
    }

    if (getenv("OT_PROMPT")) {
        prompt = strdup(getenv("OT_PROMPT"));
        otCB->cb_prompt = prompt;
    }

    /* Put user name into the control block structure */
    errCode = otGetUserName();
    if (errCode) {
	cp1 = otGetPostedMessage();
	fprintf(stderr, "otGetUserName: %s\n", cp1);
	otPutPostedMessage(OT_WHO_ARE_YOU);
	return OT_WHO_ARE_YOU;
    }

    /* Get project and alternate template names from command line */
    errCode = otPreparseInput(argc, argv); 

    return errCode;
}



void
otFreeControlBlock()
{

    if (!otCB)
	return;

    if (otCB->cb_project) 
	free(otCB->cb_project);
    if (otCB->cb_altTname) 
        free(otCB->cb_altTname);
    if (otCB->cb_templFile) 
        free(otCB->cb_templFile);
    if (otCB->cb_dbpath) 
        free(otCB->cb_dbpath);
    if (otCB->cb_layout) 
        free(otCB->cb_layout);
    if (otCB->cb_prompt) 
        free(otCB->cb_prompt);
    if (otCB->cb_tclString) 
        free(otCB->cb_tclString);
    if (otCB->cb_tclOtrc)
        free(otCB->cb_tclOtrc);
    if (otCB->cb_tclFile)
        free(otCB->cb_tclFile);

    if (otCB->cb_pcb) {
	otPFreeMemory();
        free(otCB->cb_pcb);
    }

    if (otCB->cb_ecb) {
	otEFreeMemory();
        free(otCB->cb_ecb);
    }

    if (otCB->cb_qcb) {
	otQFreeMemory();
        free(otCB->cb_qcb);
    }

    otClearControlBlock();

    free(otCB);
    otCB = 0;

    return;
}


OTErr
otInitEnter(tmpfile)
char *tmpfile;
{
    OTErr errCode = OT_SUCCESS;
    char command[COMMAND];

    tmpfile[0] = 0;

    if (otCB->cb_CRNumber) {
	otPutPostedMessage(OT_ENTER_NUMBER, otCB->cb_pcb->pcb_project->object_name);
	return OT_ENTER_NUMBER;
    }

    otClearEnterCB();

    errCode = otInitTemplate();
    if (errCode)
	return errCode;

    otCB->cb_ecb->ecb_origStruct = otCB->cb_ecb->ecb_blankStruct;

    errCode = otInitTemplate();
    if (errCode)
	return errCode;

    /* append function requires template file */
    if (otCB->cb_append && (!otCB->cb_templFile)) {
	otPutPostedMessage(OT_APPEND_USAGE);
	return OT_APPEND_USAGE;
    }

    /* "ot -e" is handled by "otEditForCLI" */

    if (otCB->cb_templFile && !otCB->cb_append) {
	/* ot -e file, ot -e -x str file */
	errCode = otCopyTemplateFileToTmp(otCB->cb_templFile, tmpfile);
	if (errCode)
	    return errCode;
    } 
    else {
	if ((!otCB->cb_templFile && otCB->cb_tclString) || otCB->cb_append) {
	    /* ot -e -x str, ot -e -k foo, ot -e -x str -k foo */

	    tmpfile[0] = 0;
	    tmpnam(tmpfile);
	    strcpy(rmTfile, tmpfile);

	    errCode = otWriteTemplateToFilename(otCB->cb_ecb->ecb_origStruct,
		tmpfile);
	    if (errCode)
		return errCode;
	}
	if (otCB->cb_append) {
	    sprintf(command, "(cat %s >> %s) 2> /dev/null",
		otCB->cb_templFile, tmpfile);
	    if (system(command)) {
		otPutPostedMessage(OT_TEMPLATE_MOVE_DB, otCB->cb_templFile);
		errCode = OT_TEMPLATE_MOVE_DB;
	    }
	}
    }
    return errCode;
}



OTErr
otInitValidate()
{
    OTTemplate * tStruct;
    OTErr errCode = OT_SUCCESS;

    if (!otCB->cb_templFile) {
	otPutPostedMessage(OT_VALIDATE_USAGE);
	return OT_VALIDATE_USAGE;
    }

    otClearEnterCB();

    errCode = otInitTemplate();
    if (errCode)
	return errCode;

    otCB->cb_ecb->ecb_origStruct = otCB->cb_ecb->ecb_blankStruct; 

    /* Fill in template structure from the template file */
    errCode = otReadTemplateFromFilename(&tStruct, otCB->cb_templFile,
	TRUE, FALSE);
    if (errCode)
	return errCode;

    otCB->cb_ecb->ecb_tStruct = tStruct;

    return errCode;
}

OTQueryCB *
otMallocQCB()
{
    OTQueryCB * qcb;

    /* Allocate space for OTQueryCB control block structure */

    if ( (qcb = (OTQueryCB *) malloc(sizeof(OTQueryCB)) ) == NULL ) {
	otPutPostedMessage(OT_MALLOC_LOCATION, "otMallocQCB()");
	return (OTQueryCB *)0;
    }
    else
        return (qcb);
}



OTEnterCB *
otMallocECB()
{
    OTEnterCB * ecb;

    /* Allocate space for OTEnterCB control block structure */
     
    if ( (ecb = (OTEnterCB *) malloc(sizeof(OTEnterCB)) ) == NULL ) {
	otPutPostedMessage(OT_MALLOC_LOCATION, "otMallocECB()");
	return (OTEnterCB *)0;
    }
    else
        return (ecb);
}



void
otPFreeMemory()
{

    OTPrivateCB * pcb = otCB->cb_pcb;	/* private control block structure */

    if (pcb->pcb_efp) {
        fclose(pcb->pcb_efp);
	pcb->pcb_efp = 0;
    }
    if (pcb->pcb_project) {
	otFreeProject(pcb->pcb_project);
	pcb->pcb_project = 0;
    }
    if (pcb->pcb_template) {
        otFreeTemplate(pcb->pcb_template);
	pcb->pcb_template = 0;
    }
    if (pcb->pcb_interp) {
        Tcl_DeleteInterp(pcb->pcb_interp);
	pcb->pcb_interp = 0;
    }

    return;
}



void
otEFreeMemory()
{

    OTEnterCB * ecb = otCB->cb_ecb;	/* enter control block structure */

    if (ecb->ecb_origStruct) 
        otFreeTemplate(ecb->ecb_origStruct);
    if (ecb->ecb_tStruct) 
        otFreeTemplate(ecb->ecb_tStruct);
    if (ecb->ecb_blankStruct) 
        otFreeTemplate(ecb->ecb_blankStruct);
    if (ecb->ecb_fname) 
        free(ecb->ecb_fname);

    otClearEnterCB();

    return;
}



void
otQFreeMemory()
{

    otClearQueryCB();
    return;

}



void
otClearControlBlock()
{
    otCB->cb_project = 0;
    otCB->cb_altTname = 0;
    otCB->cb_CRNumber = 0;
    otCB->cb_operation = INITIAL;
    otCB->cb_notify = TRUE;
    otCB->cb_append = FALSE;
    otCB->cb_templFile = 0;
    otCB->cb_dbpath = 0;
    otCB->cb_layout = 0;
    otCB->cb_prompt = 0;
    otCB->cb_tclString = 0;
    otCB->cb_tclFile = 0;
    otCB->cb_tclOtrc = 0;
    otCB->cb_pcb = 0;
    otCB->cb_qcb = 0;
    otCB->cb_ecb = 0;

    return;
}


void
otClearPrivateCB()
{

    OTPrivateCB * pcb = otCB->cb_pcb;

    pcb->pcb_ui = INIT;
    if ( pcb->pcb_uName ) {
	free(pcb->pcb_uName);
	pcb->pcb_uName = 0;
    }
    pcb->pcb_CRNumber = 0;
    pcb->pcb_operation = INITIAL;
    pcb->pcb_imTheServer = FALSE;
    pcb->pcb_nopened = FALSE;
    pcb->pcb_lopened = FALSE;
    pcb->pcb_efp = 0;
    pcb->pcb_logPid[0] = 0;
    pcb->pcb_rcsCmd[0] = 0;
    pcb->pcb_notify  = FALSE;
    pcb->pcb_forceUpdate = FALSE;
    
    otClearForSummary();

    pcb->pcb_quiet = FALSE;
    pcb->pcb_tclBegin = TRUE;
    pcb->pcb_tclEnd = FALSE;
    pcb->pcb_bugCount = 0;
    pcb->pcb_filterNum[0] = 0;
    pcb->pcb_sortPipe = 0;
    pcb->pcb_topNumber = 0;

    pcb->pcb_project = 0;
    pcb->pcb_template = 0;
    pcb->pcb_kwikPixSock = 0;

    pcb->pcb_fileIn = pcb->pcb_fileOut = pcb->pcb_kwikPixSock = (OpenFile *)0;
    memset(pcb->pcb_fileInName, 0, SHORTSTR);
    memset(pcb->pcb_fileOutName, 0, SHORTSTR);
    memset(pcb->pcb_kwikPix, 0, SHORTSTR);

    return;
} 


void
otClearEnterCB()
{
    OTEnterCB * ecb = otCB->cb_ecb;

    ecb->ecb_origStruct = 0;
    ecb->ecb_tStruct = 0;
    ecb->ecb_blankStruct = 0;
    ecb->ecb_fname = 0;

    return;
    
}


void
otClearQueryCB()
{
    OTQueryCB * qcb = otCB->cb_qcb;

    qcb->qcb_skipHeader = FALSE;
    qcb->qcb_count = FALSE;
    qcb->qcb_summary = FALSE;
    qcb->qcb_tabSeparate = FALSE;
    qcb->qcb_fullText = FALSE;
    qcb->qcb_historyLines = FALSE;
    qcb->qcb_keywordMatchFound = FALSE;
    qcb->qcb_outwidth = 80;
    qcb->qcb_outputFile = stdout;
    qcb->qcb_sortField = 0;
    qcb->qcb_nsens = 0;
    qcb->qcb_keyInText = 0;
    qcb->qcb_loRange = 0;
    qcb->qcb_hiRange = 1000000;
    qcb->qcb_filter = 0;
    qcb->qcb_kwikPixMatches = 0;
    qcb->qcb_nextMatch = 0;

    return;
}


void
otClearForSummary()
{
    OTPrivateCB * pcb = otCB->cb_pcb;
    int i;

    for (i=0; i<= MAXNUMVAL; i++) {
	pcb->pcb_sumPrior[i] = 0;
	pcb->pcb_sumSever[i] = 0;
	pcb->pcb_sumStat[i] = 0;
    }

    for (i=0; i<=MAXNUMSTAT; i++)
	pcb->pcb_statName[i][0] = 0;

    pcb->pcb_bugCount = 0;

    return;
}



void
otCleanForServer()
{
    otCB->cb_pcb->pcb_nopened = FALSE;
    otCB->cb_pcb->pcb_lopened = FALSE;
    otCB->cb_pcb->pcb_logPid[0] = 0;
    otCB->cb_pcb->pcb_rcsCmd[0] = 0;
#ifdef notdef
    otCB->cb_pcb->pcb_imTheServer = FALSE;

    if (otCB->cb_pcb->pcb_efp) {
	fclose(otCB->cb_pcb->pcb_efp);
	otCB->cb_pcb->pcb_efp = 0;
    }
#endif
    return;
}



void
otCleanAfterEnter(stat)
OTErr stat;
{

    otCB->cb_pcb->pcb_operation = otCB->cb_operation;

    otEFreeMemory();

    otCleanForServer();

    if (stat)
        otCleanup();

    return;
}



OTErr
otCleanAfterUpdate(stat)
OTErr stat;
{
    OTErr errCode = OT_SUCCESS;

    otCB->cb_pcb->pcb_CRNumber = 0;

    if (gotCRfile[0] && (!otUnlockObject()) ) {
        otPutPostedMessage(OT_RCS_UNLOCK, gotCRfile);
        errCode = OT_RCS_UNLOCK;
    }

    otCleanAfterEnter(stat);

    return errCode;
}



void
otCleanAfterDelete(stat)
OTErr stat;
{

    otCleanAfterEnter(stat);

    return;
}



void
otCleanAfterQuery()
{
    OTQueryCB * qcb = otCB->cb_qcb;     /* query control block structure */
    OTPrivateCB * pcb = otCB->cb_pcb;   /* private control block structure */

    if (qcb->qcb_filter) {
	otFreeMetaTemplate(qcb->qcb_filter);
	qcb->qcb_filter = 0;
    }

    if ( qcb->qcb_kwikPixMatches )
	free(qcb->qcb_kwikPixMatches);

    qcb->qcb_kwikPixMatches = 0;
    qcb->qcb_nextMatch = 0;

    qcb->qcb_outputFile = stdout;
    qcb->qcb_loRange = 0;
    qcb->qcb_hiRange = 1000000;

    if (otCB->cb_tclString) {
	free(otCB->cb_tclString);
	otCB->cb_tclString = 0;
    }

    if (pcb->pcb_template) {
	otFreeTemplate(pcb->pcb_template);
	pcb->pcb_template = 0;
    }

    otClearForSummary();

    pcb->pcb_quiet = FALSE;
    pcb->pcb_filterNum[0] = 0;
    pcb->pcb_sortPipe = 0;
    pcb->pcb_topNumber = 0;

    return;
}



void
otCleanAfterValidate()
{

    otEFreeMemory();

    return;
}



void
otCleanAfterTemplate()
{

    otEFreeMemory();

    return;
}

