proc EmacsBindings {} {
    bind Text  <Map> 	{%W configure -exportselection true}
    bind Entry <Map> 	{%W configure -exportselection true}

    set left  {%W mark set insert insert-1c; %W yview -pickplace insert}
    set right {%W mark set insert insert+1c; %W yview -pickplace insert}
    set up    {%W mark set insert insert-1l; %W yview -pickplace insert}
    set down  {%W mark set insert insert+1l; %W yview -pickplace insert}
    set start {%W mark set insert "insert linestart";%W yview -pickplace insert}
    set end   {%W mark set insert "insert lineend";%W yview -pickplace insert}
    set cut   {catch "%W delete sel.first sel.last"}
    set paste {catch "%W insert insert [selection get]";%W yview -pickplace insert}
    bind Text <Left>  	  $left
    bind Text <Control-f> $left
    bind Text <Right> 	  $right
    bind Text <Control-b> $right
    bind Text <Up>  	  $up
    bind Text <Control-p> $up
    bind Text <Down>  	  $down
    bind Text <Control-n> $down
    bind Text <Control-a> $start
    bind Text <Control-e> $end
    bind Text <Control-w> $cut
    bind Text <Control-y> $paste
    bind Text <Button-2>  $paste

    set left  {%W icursor [expr [%W index insert]-1] }
    set right {%W icursor [expr [%W index insert]+1] }
    set start {%W icursor 0; %W view 0 }
    set end   {%W icursor end; %W view end }
    set cut   {catch "%W delete sel.first sel.last"}
    set paste {catch "%W insert insert [selection get]"}
    bind Entry <Left>  	   $left
    bind Entry <Control-f> $left
    bind Entry <Right> 	   $right
    bind Entry <Control-b> $right
    bind Entry <Control-a> $start
    bind Entry <Control-e> $end
    bind Entry <Control-w> $cut
    bind Entry <Control-y> $paste
    bind Entry <Button-2>  $paste
}

