
#ifndef __OBJECTIFY_H
#define __OBJECTIFY_H

extern "C" {
#include "tcl.h"
#include "tk.h"
}

#define TCL_OBJECT(tclcmd, name, type, h) name

#define TCL_METHOD(tcl, c, hlp) \
	int c
#define TCL_SLOT_FULL(type, ctype, var, arg, db, class, def, flags, cust, h1, h2) \
	ctype var
#define TCL_SLOT(ctype, var, def, h1) \
	ctype var

extern int Objectify_Configure(Tcl_Interp* interp, Tk_Window tkwin,
			       Tk_ConfigSpec* specs, int ac, char** av,
			       char* object, int flags, int* eaten, int which);

extern int Objectify_Get(Tcl_Interp* interp, Tk_Window tkwin,
			 Tk_ConfigSpec* specs, char* name, char* object,
			 int* got);

extern int Objectify_DeleteObject(Tcl_Interp* interp, void* ob);

extern void Objectify_NewName(char* obtype, char* ret, void* ob);
extern void Objectify_SetName(char* name, void* ob);
extern void Objectify_DeleteName(char* name);
extern void* Objectify_LookupName(char* name);
extern char* Objectify_LookupPtr(void* ptr);

extern int
Objectify_PointerParse(ClientData cld, Tcl_Interp* interp, Tk_Window win,
		       char* value, char* record, int offset);
extern char*
Objectify_PointerPrint(ClientData cld, Tk_Window win, char* record, int offset,
		       Tcl_FreeProc **freep);

#endif
