#include <varargs.h>

#include "config.h"
#include "menu.h"
#include "keymap.h"
#include "nn_term.h"
#include "options.h"
#include "proto.h"
#include "articles.h"
#include "stdio.h"


#ifdef TK
#include "tk.h"
#endif /* TK */


#ifdef TK
static Tk_Window w; 			/* main window */
static Tcl_Interp *interp;     		/* tcl interpreter */
#endif /* TK */

extern int curxy_c,curxy_l;
extern int prompt_line;

extern int grp_menu();
extern int grp_list();
extern char *tk_set_var();
static int prompt_delete();
extern int rec_c();
static int folder_list();
static int more_lines();
static int option_values();
static int application_destroyed();
static int nn_variables();
static int nn_set_var();
static int nn_get_var();
static int lookup_group_pos();

extern char *nn_directory,*lib_directory,*help_directory;;
export int menu_max,menu_min;		/* max,min sizes for menu panel */
export int mk_grp_menu = 1;             /* create group menu */

export int tk_more_lines;		/* number of article lines to display
					   in one go */
export int tk_default_lines;		/* default number of article lines to display
					   in one go */
export int mime_handling;               /* action to take on articles with mime headers */
export int internal_editor;             /* flags internal editor as default */
export char xterm_path[100];            /* path to execute xterm */

export int group_list_read, group_list_unsub, group_list_all, group_list_width,
 group_menu_read,group_menu_unsub;      /* whats displayed in group list/menu */
export int nntp_progress;               /* report nntp progress every n lines */

static char tkb[500], *tkb_pt;		/* buffer for display using tk */
static char buf[500];			/* misc buffer */
static int tk_np = 0;			/* flag distinguishes group or
					   article prompt from others  */
static int prompt_unmaped = 1;		/* flag prompt window not displayed */

#ifdef TK
int
xfile(txt)
char *txt;
{
        int code;
	char b[500];


        code = Tcl_EvalFile(interp,txt);

        if (code != TCL_OK) {
		if (strncmp(".couldn't read file",interp->result,
		    strlen(".couldn't read file"))) {
                	printf("Error in file %s [%s]\n", txt, interp->result);
			printf("%s",tk_get_var("errorInfo"));
			exit(1);
		} else {
			return 0;
		}
        }
	return 1;
}

void
tk_init()
{
       char  lib[500],nn[500],cwd[500];
       char *x_dir, *x_file;
       char *getwd();
       FILE *f;

  	sprintf(lib,"%s/tcl/nn.tcl",lib_directory);
  	sprintf(nn,"%s/tcl/nn.tcl",nn_directory);

        interp = Tcl_CreateInterp();

        w = Tk_CreateMainWindow(interp,0,"nn","nn");
        if (w == NULL) {
            fprintf(stderr, "%s\n", interp->result);
            exit(1);
        }

        Tk_SetClass(w, "NN");

	tk_set_var("nn_directory",nn_directory);
	tk_set_var("help_directory",help_directory);

        Tcl_CreateCommand(interp,"option_values",option_values,NULL,NULL);
        Tcl_CreateCommand(interp,"grp_menu",grp_menu,NULL,NULL);
        Tcl_CreateCommand(interp,"nn_set_var",nn_set_var,NULL,NULL);
        Tcl_CreateCommand(interp,"nn_get_var",nn_get_var,NULL,NULL);

        if (f = fopen("./tcl/nn.tcl","r")) {
	  x_dir = ".";
	  x_file = "tcl/nn.tcl";
	} else if (f = fopen(nn,"r")) {
	  x_dir = nn_directory;
	  x_file = nn;
	} else if (f = fopen(lib,"r")) {
	  x_dir = lib_directory;
	  x_file = lib;
	} else {
	  fprintf(stderr,"tcl directtory not found in ., %s, %s\n"
		  ,nn_directory,lib_directory);
	  exit(1);
	} 
        fclose(f);

	tk_set_var("nn_x_dir",x_dir);

        xfile(x_file);
       

        Tcl_CreateCommand(interp,"prompt_delete",prompt_delete,NULL,NULL);
        Tcl_CreateCommand(interp,"grp_list",grp_list,NULL,NULL);
        Tcl_CreateCommand(interp,"rec_c",rec_c,NULL,NULL);
        Tcl_CreateCommand(interp,"folder_list",folder_list,NULL,NULL);
        Tcl_CreateCommand(interp,"more_lines",more_lines,NULL,NULL);
        Tcl_CreateCommand(interp,"application_destroyed",application_destroyed,NULL,NULL);
        Tcl_CreateCommand(interp,"nn_variables",nn_variables,NULL,NULL);
        Tcl_CreateCommand(interp,"lookup_group_pos",lookup_group_pos,NULL,NULL);
}

#endif /* TK */
/* read a tcl variable */
char *tk_get_var(var)
char *var; 
{
#ifdef TK
	char *s;

	s = Tcl_GetVar(interp,var,TCL_GLOBAL_ONLY|TCL_LEAVE_ERR_MSG);
	if (!s) {
                printf("GetVar[%s]\n", interp->result);
        }
	return s;
#else /* TK */
	return 0;
#endif /* TK */
}

/* set a tcl variable */
char *tk_set_var(var,n)
char *var; char *n;
{
#ifdef TK
	char *s;
	s = Tcl_SetVar(interp,var,n,TCL_GLOBAL_ONLY);
	if (!s) {
                printf("SetVar[%s]\n", interp->result);
        }
	return s;
#else /* TK */
	return 0;
#endif /* TK */
}


/* Execute a tcl command */
char  
*tk(va_alist)
	va_dcl
{
#ifdef TK
  int code;
  va_list args;
  char *name;
  char *format;
  char buf[500];

  va_start(args);
  format = va_arg(args,char *);
  vsprintf(buf,format,args);
/*  fprintf(stderr,"<%s>\n",buf);*/
  code = Tcl_Eval(interp,buf);

  if (code != TCL_OK) {
    printf(">%s[%s]\n", buf, interp->result);
    printf("%s",tk_get_var("errorInfo"));
    return NULL;
  } else {
    /*                code = Tcl_Eval(interp,"update"); */
    return interp->result;
  }
#else  /* TK */
  return 0;
#endif /* TK */
}

/* return a result in a proc called from tcl */
int
tk_result(txt)
char *txt;
{
#ifdef TK
	strcpy(interp->result, txt);
	return TCL_OK;
#endif /* TK */
}

void  
y_prompt(va_alist)
	va_dcl
{
	int code;
	va_list args;

	char *name;
	char *format;
	char b[500];

	va_start(args);
	format = va_arg(args,char *);
	vsprintf(b,format,args);
#ifdef TK
	tk_set_var("prompt_buf",b);
	tk("y_prompt");
#else /* TK */
	prompt(b);
#endif /* TK */

}

/* bold header in article window */
void
tk_more_b(txt)
char *txt;
{
	sprintf(buf,"%s: ",txt);
	tk_set_var("more_l_t",buf);

	tk("more_b");
}

/* display text in article window */
void
tk_more_l(txt)
char *txt;
{
	sprintf(buf,"%s\n",txt);
	tk_set_var("more_l_t",buf);

	tk("more_l");
}

/* flag prompt as article or menu */
void tk_normal_prompt()
{
	tk_np = 1;
}

/* flag prompt as something else */
void tk_c_normal_prompt()
{
	tk_np = 0;
}

/* decide where to display prompt */
static char *pr_sel()
{
	int n;
	n = curxy_l - prompt_line;
	if (tk_np) 
		return ".menu-prompt";
	else if (n == 0) 
		return ".prompt.pr1";
	else if (n == 1)
		return ".prompt.pr2";
	else
		return ".prompt.pr3";

}	

/* prompt window has been deleted */
static int
prompt_delete() {
	prompt_unmaped = 1;
	return tk_result("1");
}

/* clear and remove prompt window */	
void 
prompt_clear() {
	if (tk_np) {
		tk("prompt_clear");
		prompt_unmaped = 1;
	}
}

/* clear line in prompt window */
void
tk_clrline() 
{
	if (prompt_unmaped && !tk_np) {
		tk("prompt_restore");
		prompt_unmaped = 0;
	}
	tk("%s delete 1.%d end",pr_sel(),curxy_c);
}
/* write text to prompt popup */
void
tk_txt_a(str)
char *str;
{
        int n;
	char *sel;
	char buf[300];

	if (prompt_unmaped && !tk_np) {
		tk("prompt_restore");
		prompt_unmaped = 0;
	}
	if (str[0] == '\r') {
		tk("%s delete 1.0 end",pr_sel());
		str++;
	}
	tk("%s delete 1.%d end",pr_sel(),curxy_c);
	tk_set_var("text_ent_t",str);
	tk("text_add %s", pr_sel());
	tk("update");
}

/* write character to prompt popup */
void
tk_txt_c(c)
char c;
{
        int n;
	char  *sel;
	char buf[300];

	if (prompt_unmaped && !tk_np) {
		tk("prompt_restore");
		prompt_unmaped = 0;
	}
	if (c == '\b') {
	    tk("text_delc %s",pr_sel());
	} else if (c == '\r') {
		tk("%s delete 1.0 end",pr_sel());
	} else {
	    buf[0] = c;
	    buf[1] = 0;
	    tk_set_var("text_ent_t",buf);
	    tk("text_add %s", pr_sel());
	}
/*	tk("update");*/
}

/* clear tkb buffer */
void
tkb_clear()
{
	tkb_pt = tkb;
}

/* put string to buffer (and call so_printf) */
void
tkb_so_printf(va_alist)
	va_dcl
{
        char *format;
	va_list args;

        va_start(args);
        format = va_arg(args,char *);
        vsprintf(tkb_pt,format,args);
        so_printf("%s",tkb_pt);
        tkb_pt += strlen(tkb_pt);
}

/* put string to buffer (and call ttprintf) */
void
tkb_tprintf(va_alist)
	va_dcl
{
        char *format;
	va_list args;

        va_start(args);
        format = va_arg(args,char *);
        vsprintf(tkb_pt,format,args);
        ttprintf("%s",tkb_pt);
        tkb_pt += strlen(tkb_pt);
}

/* put character to buff (and call ttputc) */
void
tkb_ttputc(c)
char c;
{
	*tkb_pt = c;
	tkb_pt++;
	*tkb_pt = 0;
	ttputc(c);
}

/* put character to buffer */
void
tkb_c(c)
char c;
{
	*tkb_pt = c;
	tkb_pt++;
	*tkb_pt = 0;
}

/* put string to buffer */
void
tkb_s(s)
char *s;
{
        sprintf(tkb_pt,"%s",s);
        tkb_pt += strlen(tkb_pt);
}

/* return current postion in buffer */
int
tkb_curr()
{
	return tkb_pt - tkb;
}

/* show buffer in display popup */
void
tkb_display()
{
	tk_set_var("display_l_t",tkb);

	tk("display_l");
	tkb_pt = tkb;
	*tkb_pt = 0;

}

/* show buffer in prompt */
void
tkb_txt_a()
{
	tk_txt_a(tkb);
	tkb_clear();
}

/* show buffer in group header */
void
tkb_menu_g()
{
	tk_set_var("text_ent_t",tkb);
	tk("text_ent .menu-g");
}

/* show buffer in article menu */
void
tkb_menu(l,c)
int l,c;
{
	tk_set_var("menu_ent_t",tkb);
        tk("menu_ent %d %d",l-1,c);
}

/* show buffer in article window */
void
tkb_more()
{
	tk_more_l(tkb);
}

void
tkb_bmore()
{
	tk_more_b(tkb);
}

/* show buffer as y/n prompt */
void
tkb_y_prompt()
{
	y_prompt(tkb);
}

static char read_mode[2];   /* flag indicating where get_c called from */

void
tk_read_mode(c)
char c;
{
  read_mode[1] = 0;
  read_mode[0] = c;
  tk_set_var("read_mode",read_mode);
}

#ifdef TK
/*
	Handle input
*/

extern int do_macro_processing;

typedef struct event_r event;

struct event_r {			/* record for input passed */
	char typ;			/* from tk 		   */
	char val;
	event *next_event;
};

event *events,*cur_event;		/* event list, end pointer */

/* Called by tk when event to be passed */
int
rec_c (cl, interp, argc, argv)
ClientData cl;
Tcl_Interp *interp;
int argc;
char *argv[];
{
	char typ, val, extra;
/*	fprintf(stderr,"=%d %c %c\n",argc,*argv[1],*argv[2]);  */
	if (!cur_event) {
		if (!events) {
			events = (event *) malloc(sizeof(event));
			events->next_event = 0;
		}
		cur_event = events;
	} else if (!cur_event->next_event) {
		cur_event->next_event = (event *) malloc(sizeof(event));
		cur_event->next_event->next_event = 0;
		cur_event = cur_event->next_event;
	} else
		cur_event = cur_event->next_event;
	cur_event->typ = *argv[1];
	cur_event->val = *argv[2];
	return tk_result("1");
}

/* input proc for nn code */
int
get_c()
{
        char v;
	static char s = ' ';
	static event *n_event = 0;
	int mc;

    if (do_macro_processing)
	switch (m_getc(&mc)) {
	 case 0: break;
	 case 1: return mc;
	 case 2: return K_interrupt;
	}


	if (!n_event) {
       		do {
			/* This goes back into tcl/tk */
               		Tk_DoOneEvent(0); 
       		} while (!cur_event);
		n_event = events;
	}
	s = n_event->typ;
	v = n_event->val;
/* fprintf(stderr,"e=%c c=%d %d\n",s,v,n_event == cur_event); */
	if (n_event == cur_event) {
		cur_event = 0;
		n_event = 0;
	} else 
		n_event = n_event->next_event;
	if (s == '2') {
		return (v + GETC_COMMAND);
	} else if (s == '3') {
		return (v - 97 + K_ARTICLE_ID + GETC_COMMAND);
	} else if (s == '5') {
		return (v - 97 + K_ARTICLE_ID_C + GETC_COMMAND);
	} else if (s == '6') {
	  if (*read_mode == ' ') {
	    return (K_interrupt);
	  } else {
	    return(get_c());
	  }
	} else {
		return global_key_map[v];
	}
}

/* folder list */
static int
folder_list() {
	char tmp[100];

	tmp[0] = '+'; tmp[1] = 0;
	file_completion(tmp,1);
	compl_folder_directory();
	close_directory();
	return tk_result("1");
}

static int
more_lines(clientData,interp,argc,argv)
ClientData clientData;
Tcl_Interp *interp;
int argc;
char *argv[];
{
	tk_more_lines = atoi(argv[1]);
	return tk_result("1");
}

static int
lookup_group_pos(clientData,interp,argc,argv)
ClientData clientData;
Tcl_Interp *interp;
int argc;
char *argv[];
{
    group_header *gh;
    char buf[100];

    gh = lookup(argv[1]);
    if (gh) {
	sprintf(buf,"%d",gh->listbox_entry);
	return tk_result(buf);
    } else {
	return tk_result("0");
    }
}

static int
option_values(clientData,interp,argc,argv)
ClientData clientData;
Tcl_Interp *interp;
int argc;
char *argv[];
{
	menu_max = atoi(argv[1]);
	menu_min = atoi(argv[2]);
	mk_grp_menu = atoi(argv[3]);
	tk_more_lines = tk_default_lines = atoi(argv[4]);
	mime_handling = atoi(argv[5]);
	strncpy(xterm_path,argv[6],100);
	group_list_read = atoi(argv[7]);
	group_list_unsub = atoi(argv[8]);
	group_list_all = atoi(argv[9]);
	group_list_width = atoi(argv[10]);
	group_menu_read  = atoi(argv[11]);
	group_menu_unsub = atoi(argv[12]);
	nntp_progress = atoi(argv[13]);
	return tk_result("1");
}

static int
nn_variables(clientData,interp,argc,argv)
ClientData clientData;
Tcl_Interp *interp;
int argc;
char *argv[];
{
  int x;

  x = atoi(argv[1]);
  nn_vars(x);
  return tk_result("1");
}

static int
nn_set_var(clientData,interp,argc,argv)
ClientData clientData;
Tcl_Interp *interp;
int argc;
char *argv[];
{
  char *variable, *value;

  variable = argv[1];
  value = argv[2];
  set_variable(variable,1,value);
  return tk_result("1");
}


static int
nn_get_var(clientData,interp,argc,argv)
ClientData clientData;
Tcl_Interp *interp;
int argc;
char *argv[];
{
  char *variable;

  return nn_var(argv[1]);
}

void
tk_nn_var(name,str,type,tag)
char *name, *str, *type, *tag;
{
  char tg;
  tk_set_var("var_str",str);

  if (*tag == '*') {
    tg = 'm';
  } else if (*tag == '>') {
    tg = 'p';
  } else {
    tg = 'u';
  }
  tk("variables_ent %s %s %c",name,type,tg);
}

static int
application_destroyed(clientData,interp,argc,argv)
ClientData clientData;
Tcl_Interp *interp;
int argc;
char *argv[];
{
  nn_exitmsg(1, "NN terminated, X application destroyed");
}


/*
	process newsgroup list to produce
	cascaded group menus
*/

typedef struct  {
	char *t;
	int l;
} gx_t;

gx_t group_x[] = {
	{"alt.",4},
	{"comp.sys.",9},
	{"comp.",5},
	{"rec.",4},
	{"sci.",4},
	{"bit.listserv.",13},
	{"soc.culture.",12},
	0
};

static char prev_group[300] = "";

static char
*lcase(txt)
char *txt;
{
    static char x[200];
    char *p;
    
    strncpy(x,txt,200);
    for (p = x; *p; p++) {
	if (*p >= 'A' && *p <= 'Z') {
	    *p += 32;
	}
    }
    return x;
}

static void
group(g)
char *g;
{
	char b[300],left[300];
	char *right;
	int l;

	right = strrchr(g,'.');
	if (right) {
		l = right - g;
		strncpy(left,g,l);
		left[l] = 0;
		if (strncmp(g,prev_group,l) || (prev_group[l] != '.')) {
			group(left);
		}
	} else {
		*left = '\0';
	}

	tk("menu .top.m.menu.%s",lcase(g));
	if (*left) {
		tk(".top.m.menu.%s add cascade -label \"%s->\" -menu \".top.m.menu.%s\"",lcase(left),right+1,g);
	} else {
		tk(".top.m.menu add cascade -label \"%s->\" -menu \".top.m.menu.%s\"",g,lcase(g));
	}

}

void
grp(g)
char *g;
{
	char b1[300],b2[300],left[300];
	char *b,*c,*t,*right;
	gx_t *gx = group_x;
	int n,i,l;


	/* match starts of group names against gx list,
	expanding with first letter of next token */
	strcpy(b1,g);
	b=b1;
	c=b2;
	while (gx->t) {
		l = gx->l;
		if (!strncmp(gx->t,b,l)) {
			strncpy(c,b,l+1);
			c[l+1] = '.';
			strcpy(c+l+2,b+l);
			t = b; b = c; c = t;
		}
	gx++;
	}

	/* split off right most token comparing the rest
	against the previous group, recursing to create
	menu's not matching */
	right = strrchr(b,'.');
	if (right) {
		l = right - b;
		strncpy(left,b,l);
		left[l] = 0;
		if (strncmp(left,prev_group,l) || (prev_group[l] != '.')) {
			group(left);
		}
		right = right+1;
		if (! *right) { /* a null string for right causes problem */
		    right = "_";
		}
		tk(".top.m.menu.%s add command -label %s -command \"gg %s %s\"",lcase(left),right,g,lcase(left));
	} else {
		tk(".top.m.menu add command -label %s -command \"gg %s\"",g,lcase(g));
	}

	strcpy(prev_group,b);
}
#endif /* TK */
