#
# Tcl/Tk based news reader
#
# Copyright 1995 - Koert Zeilstra
#
# No warranty - use at your own risk
#

#
# SetupDialog
#
# Public attributes:
#   -close_command	command when close is selected
#   -main		main object
#
# Methods:
#
itcl_class SetupDialog \
{
  constructor {config} \
  {
    #
    #  Create a window with the same name as this object
    #
    set class [$this info class]
    ::rename $this $this-tmp-
    ::toplevel $this -class $class
    ::rename $this $this-win-
    ::rename $this-tmp- $this

    wm title $this $title

    LabelEntry $this.nntp_server -labeltext "NNTP server" -labelwidth 15 \
		-entrywidth 35
    LabelEntry $this.nntp_port -labeltext "NNTP port" -labelwidth 15 \
		-entrywidth 10
    LabelEntry $this.email -labeltext "Email" \
		-labelwidth 15 -entrywidth 35
    LabelEntry $this.name -labeltext "Name" \
		-labelwidth 15 -entrywidth 35
    LabelEntry $this.organization -labeltext "Organization" \
		-labelwidth 15 -entrywidth 35
    LabelEntry $this.signature -labeltext "Signature File" \
		-labelwidth 15 -entrywidth 35
    pack $this.nntp_server $this.nntp_port $this.email $this.name \
		$this.organization $this.name $this.signature \
		-side top -padx 4 -fill x

    frame $this.buttons -relief sunken -bd 1
    button $this.buttons.cancel -text "Cancel" -width 8 \
		-command "$this cancel"
    button $this.buttons.ok -text "OK" -width 8 \
		-command "$this ok"
    pack $this.buttons.cancel $this.buttons.ok \
		-side right -fill x -pady 2 -padx 3
    pack $this.buttons -side top -fill x

    wm protocol . WM_DELETE_WINDOW "$this close"
  }

  destructor \
  { ::rename $this-win- {} }

  method config {config} {}

  method ok {} \
  { saveConfig
    close
    eval $ok_command
  }

  method cancel {} \
  { close
  }

  method readConfig {} \
  { global env
    catch { $this.nntp_server setEntry $env(NNTP_SERVER) }
    $this.nntp_port setEntry 119
    $this.nntp_server setEntry [$appconfig get nntp_server]
    $this.nntp_port setEntry [$appconfig get nntp_port]
    $this.email setEntry [$appconfig get email]
    $this.name setEntry [$appconfig get name]
    $this.organization setEntry [$appconfig get organization]
    $this.signature setEntry [$appconfig get signature]
  }

  method saveConfig {} \
  {
    $appconfig put nntp_server [$this.nntp_server getEntry]
    $appconfig put nntp_port [$this.nntp_port getEntry]
    $appconfig put email [$this.email getEntry]
    $appconfig put name [$this.name getEntry]
    $appconfig put organization [$this.organization getEntry]
    $appconfig put signature [$this.signature getEntry]
  }

  method close {} \
  { eval $close_command }

  method takeFocus {} \
  {
  }

  public ok_command ""
  public close_command ""
  public main ""
  public title ""
  public appconfig ""

  protected parent ""
  protected group_list ""
  protected nntp_socket ""
}

itcl_class ApplicationConfig \
{
  constructor {config} \
  { }

  destructor \
  { }

  method config {config} {}

  method clear {} \
  { catch { unset app_config } }

  method load {filename} \
  { if {[catch {set fp [open $filename r]}] == 0} \
    { while {[gets $fp line] >= 0} \
      { set items [split $line :]
        set id [string trim [lindex $items 0]]
        set app_config($id) [string trim [lindex $items 1]]
      }
      ::close $fp
    }
  }

  method save {filename} \
  { if {[catch {set fp [open $filename w]} msg] == 0} \
    { set config_list [array names app_config]
      foreach id $config_list \
      { puts $fp "$id:$app_config($id)" }
      ::close $fp
    }
  }

  method loadOld {filename} \
  {
    if {[catch {gdbm_open $filename r}] == 0} \
    { set config_list [gdbm_list $filename]
      foreach item $config_list \
      { set app_config($item) [gdbm_fetch $filename $item] }
      gdbm_close $filename
    }
  }

  method saveOld {filename} \
  {
    if {[catch {gdbm_open $filename n}] == 0} \
    { set config_list [array names app_config]
      foreach item $config_list \
      { gdbm_insert $filename $item $app_config($item) }
      gdbm_close $filename
    }
  }

  method get {item} \
  { if [info exists app_config($item)] \
    { return $app_config($item) } \
    else \
    { return "" }
  }

  method put {item value} \
  { set app_config($item) $value }

  protected app_config
}




