#
# bindings.tcl
#
# 10-05-1994
# Koert Zeilstra
#
proc InstallStandardBindings {} {
    bind Text <Key-Right> {
	%W mark set insert {insert + 1 chars}
	%W yview -pickplace insert
    }
    bind Text <Key-Left> {
	%W mark set insert {insert - 1 chars}
	%W yview -pickplace insert
    }
    bind Text <Key-Up> {
	%W mark set insert {insert - 1 lines}
	%W yview -pickplace insert
    }
    bind Text <Key-Down> {
	%W mark set insert {insert + 1 lines}
	%W yview -pickplace insert
    }
    bind Text <Key-End> {
	%W mark set insert {insert lineend}
	%W yview -pickplace insert
    }
    bind Text <Key-Home> {
	%W mark set insert {insert linestart}
	%W yview -pickplace insert
    }
    bind Text <Control-Key-Left> {
	%W mark set insert {insert wordstart - 1 chars}
	%W yview -pickplace insert
    }
    bind Text <Control-Key-Right> {
	%W mark set insert {insert wordend}
	%W yview -pickplace insert
    }
    bind Text <Key-Delete> {
	%W delete [%W index insert]
    }
#    bind Text <Key-BackSpace> {
#	%W delete [%W index insert - 1 chars]
#    }
#    bind Text <ButtonRelease-2> \
#    {
#      set s [selection get STRING]
#      %W insert @%x,%y $s
#    }
    bind Entry <ButtonRelease-2> \
    {
      set s [selection get STRING]
      %W insert @%x $s
    }
    bind Entry <Control-ButtonRelease-2> {
	%W delete 0 end
	%W insert @%x [selection get STRING]
    }
    bind Entry <Key-Right> {
	%W icursor [expr [%W index insert] + 1]
    }
    bind Entry <Key-Left> {
	%W icursor [expr [%W index insert] - 1]
    }
    bind Entry <Key-End> {
	%W icursor end
    }
    bind Entry <Key-Home> {
	%W icursor 0
    }
    bind Entry <Key-Delete> {
	%W delete [%W index insert]
    }
}




