#
# Tcl/Tk based news reader
#
# Copyright 1995 - Koert Zeilstra
#
# No warranty - use at your own risk
#

lappend auto_path $env(NF_LIBDIR)/nftcl
wm title . "NewsFlash - All Groups"

option add *font "-adobe-helvetica-medium-r-normal-*-14-*-*-*-*-*-*-*" widgetDefault
option add *MenuBar*font "-adobe-helvetica-bold-r-normal-*-14-*-*-*-*-*-*-*" widgetDefault
option add *background DarkSeaGreen widgetDefault
option add *activeBackground DarkSeaGreen widgetDefault
option add *MenuBar*activeForeground Blue widgetDefault
option add *highlightBackground DarkSeaGreen widgetDefault
option add *Text.background Gray80 widgetDefault
option add *Text.selectBackground White widgetDefault
option add *Button.background Gray80 widgetDefault
option add *Button.activeBackground Gray90 widgetDefault
option add *Scrollbar.foreground DarkSeaGreen widgetDefault
option add *Scrollbar.activeBackground 	Gray90 widgetDefault
option add *Scrollbar.background DarkSeaGreen widgetDefault
option add *Entry.background White widgetDefault
loadAppDefaults {TkEdit TKEDIT} userDefault

InstallStandardBindings

#
# AllGroupsWindow
#
# Public attributes:
#   -close_command	command when close is selected
#
# Methods:
#
itcl_class AllGroupsWindow \
{
  constructor {config} \
  {
    global ${this}_font ${this}_fontsize
    #
    #  Create a window with the same name as this object
    #
    set class [$this info class]
    ::rename $this $this-tmp-
    ::frame $this -class $class -relief flat
    ::rename $this $this-win-
    ::rename $this-tmp- $this

#    set group_list [MultiColumnList $this.groups 2 \
#		{Group Description} -size 5x10 \
#		-select_command "$this clickGroup"]
#
#    pack $group_list -expand yes -fill both

    frame $this.groups
    scrollbar $this.groups.scroll -command "$this.groups.list yview"
    listbox $this.groups.list -yscroll "$this.groups.scroll set" \
		-setgrid 1
    pack $this.groups.scroll -side right -fill y
    pack $this.groups.list -side left -expand yes -fill both
    pack $this.groups -side top -expand yes -fill both

    bind $this.groups.list <Any-ButtonPress-1> \
		"$this clickGroupList %x %y"

    frame $this.search
    button $this.search.button -text "Search" -width 8
    entry $this.search.entry -width 25
    pack $this.search.button $this.search.entry -side left
#    pack $this.search -fill x -side top

    frame $this.buttons -relief sunken -bd 1
    button $this.buttons.read -text "Open Group" -width 8 \
		-command "$this read"
    button $this.buttons.subscribe -text "Subscribe" -width 8 \
		-command "$this subscribe"
    button $this.buttons.reload -text "Reload List" -width 8 \
		-command "$this reload"
    button $this.buttons.close -text "Close" -width 8 \
		-command "$this close"
    pack $this.buttons.read $this.buttons.subscribe \
		$this.buttons.reload -side left -fill x \
		-pady 2 -padx 3
    pack $this.buttons.close -side right -pady 2 -padx 3
    pack $this.buttons -side top -fill x

    wm protocol . WM_DELETE_WINDOW "$this close"
  }

  destructor {
    ::rename $this-win- {}
  }

  method config {config} {}

  method read {} \
  { if {$selected_group != ""} \
    { send $parentapp openGroup $selected_group }
  }

  method subscribe {} \
  { if {$selected_group != ""} \
    { send $parentapp addGroup $selected_group }
  }

  method reload {} \
  { $this.groups.list delete 0 end
    set selected_group ""
    if [catch {set fp [::open $group_file w]} msg] \
    { tkerror $msg } \
    else \
    { set nntp_socket [lindex [dp_connect $nntp_server \
		$nntp_port] 0]
      dp_send $nntp_socket "list"
      gets $nntp_socket line
      gets $nntp_socket line
      if {[lindex $line 0] < 300} \
      { set done 0
        while {$done == 0 && [gets $nntp_socket line] >= 0} \
        { set line [string trimright $line]
          if {$line == "."} \
          { set done 1 } \
          else \
          { $this.groups.list insert end $line
            puts $fp "[lindex $line 0]"
          }
        }
      }
      ::close $fp
      ::close $nntp_socket
      set nntp_socket ""
    }
  }

  method close {} \
  { eval $close_command }

  method readGroupList {} \
  { $this.groups.list delete 0 end
    set selected_group ""
    if {[catch {set fp [open $group_file r]}] == 0} \
    { set max_name 0
      set max_descr 0
      set i 0
if 1 {
      while {[gets $fp line] >= 0} \
      { set group_name $line
        $this.groups.list insert end $group_name
        incr i
        if {$i > 100} \
        { set i 0
          ::update
        }
      }
}
      ::close $fp
    }
  }

  method readGroupListOld {} \
  {
    if {[catch {gdbm_open $group_file r}] == 0} \
    { set max_name 0
      set max_descr 0
      set groups [gdbm_list $group_file]
      foreach group $groups \
      { set group_info [gdbm_fetch $group_file $group]
        $group_list addRow [list $group $group_info]
        if {[string length $group] > $max_name} \
        { set max_name [string length $group] }
        if {[string length $group_info] > $max_descr} \
        { set max_descr [string length $group_info] }
      }
      gdbm_close $group_file

      if {$max_name > 0} {$group_list setWidth 0 [expr $max_name*2/3]}
      if {$max_descr > 0} {$group_list setWidth 1 [expr $max_descr*2/3]}
    }
  }

  method loadRcFile {} \
  { global config
    
    if {$rcfile != ""} \
    { if {[catch {gdbm_open $rcfile r}] == 0} \
      { set config_list [gdbm_list $rcfile]
        foreach item $config_list \
        { set config($item) [gdbm_fetch $rcfile $item]
        }
        gdbm_close $rcfile
      }
    }
  }

  method readGroupsFromNNTP {command} \
  {
    set nntp_socket [dp_connect $nntp_server $nntp_port]
    dp_send $nntp_socket $command
    while {[gets $file line] >= 0 && $line != "."} \
    { set line [string trimright $line] }
    close $nntp_socket
    set nntp_socket ""
  }

  method clickGroupList {x y} \
  { set selected_group [$this.groups.list get @$x,$y] }

  method clickGroup {row} \
  { set row_items [$group_list getRow $row]
    set selected_group [lindex $row_items 0]
  }

  method takeFocus {} \
  {
  }

  public rcfile ""
  public nntp_server ""
  public nntp_port ""
  public group_file ""
  public close_command ""
  public parentapp ""

  protected group_list ""
  protected nntp_socket ""
  protected selected_group ""
}

proc quitApplication {} \
{ global main
  $main close
}

# Process command line arguments
set parent_app ""
set nntp_server ""
set nntp_port ""
for {set i 0} \$i<[llength $argv] {incr i} \
{
  set arg [lindex $argv $i]; set val [lindex $argv [expr $i+1]]
  switch -glob -- $arg \
  {
    -parent \
    {
      set parent_app $val
      incr i
    }
    -nntpserver \
    {
      set nntp_server $val
      incr i
    }
    -nntpport \
    {
      set nntp_port $val
      incr i
    }
  }
}

set main [AllGroupsWindow .main -close_command "exit" \
	-nntp_server $nntp_server -nntp_port $nntp_port \
	-group_file "$env(HOME)/.flashrc/allgroups" \
	-parentapp $parent_app]
# $main loadRcFile
pack $main -expand yes -fill both
$main takeFocus

update idletasks
$main readGroupList

if {$parent_app != ""} \
{ send $parent_app registerChildApplication allgroups.tcl [winfo name .] }









