# mxedit.local
#	Site-specific customization for mxedit
#
# Copyright (c) 1992 Xerox Corporation.
# Use and copying of this software and preparation of derivative works based
# upon this software are permitted. Any distribution of this software or
# derivative works must comply with all applicable United States export
# control laws. This software is made available AS IS, and Xerox Corporation
# makes no warranty about the software, its performance or its conformity to
# any specification.

# Set up OpenLook bindings for Sun keyboards

# This must depend on the X server keycode-to-keysym mappings that
# is defined in some default way on the server and can also be modified
# by users.  So, while this works for me, it might not work for you.
# I used the "xev" program to see what keysyms were reported.

proc mxLocalBindings {} {
    mxSun4Bindings
}

proc mxSun4Bindings {} {
    # F12 is labeled Again/L2
    mxBind <Key-F12> { mxHistory ignore mxRedo }
    # F14 is labeled Undo/L4
    mxBind <Key-F14> { mxUndo }
    # F16 is labeled Copy/L6
    mxBind <Key-F16> { mxCopySave }
    # F18 is labeled Paste/L8
    mxBind <Key-F18> { mxPaste }
    # F20 is labeled Cut/L10
    mxBind <Key-F20> { mxDeleteSave }
    # F17 is labeled Open/L7, but window managers bind this to icon control
    # F19 is labeled Find/L9
    mxBind <Key-F19> { mxFind }
    mxBind <Key-Help> { global mxLibrary ; mxOpen $mxLibrary/mxedit.tutorial }
    
    # Right hand keypad
    
    # 8/R8 has the up arrow
    mxBind <Key-Up> { mxUp1Line }
    # 2/R14 has the down arrow
    mxBind <Key-Down> { mxDown1Line }
    # F32 is labeld 6/R12 and has the right arrow
    mxBind <Key-F32> { mxForw1char }
    # F30 is labeled 4/R10 and has the left arrow
    mxBind <Key-F30> { mxBack1char }
    # F29 is labeled 9/R9/PgUp
    mxBind <Key-F29> { mxPageUp }
    # F35 is labeled 3/R15/PgDown
    mxBind <Key-F35> { mxPageDown }
    # F27 is labeled 7/R7/Home
    mxBind <Key-F27> { mxCaretMove 1.0 ; mxSee caret }
    # R13 is labeled 1/End/R13
    mxBind <Key-R13> { mxCaretMove [mxMark eof] ; mxSee caret }
}

proc mxR6000Bindings {} {
    mxSun4Bindings
    # F32 is labeld 6/R12 and has the right arrow
    mxBind <Key-Right> { mxForw1char }
    # F30 is labeled 4/R10 and has the left arrow
    mxBind <Key-Left> { mxBack1char }
}
