/*******************************************************************************
    This VMS header file defines macro's for manipulating file descriptor
    bit masks (see SELECT(2)).
*******************************************************************************/


#ifndef fd_DEFINED
#define fd_DEFINED


/* Under VMS, the documentation for SELECT() (part of UCX) suggests a
   limit of 32 on the size of the "fd_set" bit mask, but the actual
   implementation works with "fd_set"s of arbitrary size.  A width of
   128 bits is chosen here; if I remember correctly, SunOS 4.0 used a
   value of 256.  Because VMS SELECT()'s method of scanning bit masks
   is inefficient, it is recommended that applications calling SELECT()
   specify the highest socket number (plus one) instead of FD_SETSIZE
   as the width of the "fd_set" bit mask. */

#define  FD_SETSIZE  128

typedef  struct  fd_set {
    long  descriptors[FD_SETSIZE/sizeof (long)] ;
}  fd_set ;


/* The standard definitions of the FD_XXX macros result in very poor VAX
   machine code (e.g., extended multiplies and divides, etc.).  Knowing
   that the size of a "descriptors" element is 32 bits, we can take
   advantage of shifting instead of division. */

#    define	FD_SET(fd, mask)	\
        ((mask)->descriptors[(fd) >> 5]  |=  (1 << ((fd) & (32-1))))
#    define	FD_CLR(fd, mask)	\
        ((mask)->descriptors[(fd) >> 5]  &=  ~(1 << ((fd) & (32-1))))
#    define	FD_ISSET(fd, mask)	\
        ((mask)->descriptors[(fd) >> 5]  &  (1 << ((fd) & (32-1))))
#    pragma builtins
#    define	FD_ZERO(mask)	\
        _MOVC5 (0, (char *) NULL, '\0', sizeof (*(mask)), (char *) (mask))


#endif				/* If this file was not INCLUDE'd previously. */
