#
# showfocus.tcl - show the current widget with the focus in a kind of Motif
#                 way and handle keyboard focus somewhat
#
# Copyright 1994, Nat Pryce
#
# Permission is hereby granted, without written agreement and without
# license or royalty fees, to use, copy, modify, and distribute this
# software and its documentation for any purpose, provided that the
# above copyright notice and the following two paragraphs appear in
# all copies of this software.
#
# IN NO EVENT SHALL THE AUTHOR BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT, 
# SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF 
# THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE AUTHOR HAS BEEN ADVISED 
# OF THE POSSIBILITY OF SUCH DAMAGE.
#
# THE AUTHOR SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING, BUT NOT 
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
# PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS" 
# BASIS, AND THE AUTHOR HAS NO OBLIGATION TO PROVIDE  MAINTENANCE, SUPPORT,
# UPDATES, ENHANCEMENTS, OR MODIFICATIONS.


# Data required by this module is hidden in the __showfocus array
#
set __showfocus(slave) {}
set __showfocus(master) {}
set __showfocus(policy) [option get . focusPolicy FocusPolicy]
if [string match "" $__showfocus(policy)] {
   set __showfocus(policy) explicit
}
set __showfocus(hwidth) [option get . focusHighlightWidth FocusHighlightWidth]
if [string match "" $__showfocus(hwidth)] {
   set __showfocus(hwidth) 2
}
set __showfocus(color) [option get . focusHighlightColor FocusHighlightColor]
if [string match "" $__showfocus(color)] {
   set __showfocus(color) red
}


# This trace removes the focus highlight whenever the focus policy gets set
# to "pointer".
#
trace variable __showfocus(policy) w {
   uplevel #0 {
      if [string match pointer $__showfocus(policy)] {
         __showfocus {}
      } else {
         __showfocus [focus]
      }
   }
} ;#



proc __showfocus {w} {
   upvar #0 __showfocus showfocus
   
   if [string match {} $w] {
      catch { destroy $showfocus(slave) }
      set showfocus(master) {}
      set showfocus(slave) {}
   } else {
      if { [string match "pointer" $showfocus(policy)]
      ||   [string match $w [winfo toplevel $w]] } {
          return
      }
      set p [winfo parent $w]
      if [string match "." $p] {
         set f .__showfocus
      } else {
         set f $p.__showfocus
      }
      
      catch { destroy $showfocus(slave) }
      
      frame $f -class ShowFocus -relief flat -bd 0 -bg $showfocus(color)
      place $f -in $w -bordermode outside \
         -x -$showfocus(hwidth) \
         -y -$showfocus(hwidth) \
         -width [expr {[winfo width $w] + 2*$showfocus(hwidth)}] \
         -height [expr {[winfo height $w] + 2*$showfocus(hwidth)}]
      lower $f $w
      
      set showfocus(master) $w
      set showfocus(slave) $f
   }
}

proc __resizefocus {w} {
   upvar #0 __showfocus showfocus
   
   if [string match "pointer" $showfocus(policy)] {
      return
   }
   
   if [string match $showfocus(master) $w] {
      place $showfocus(slave) -in $w -bordermode outside \
         -x -$showfocus(hwidth) \
         -y -$showfocus(hwidth) \
         -width [expr {[winfo width $w] + 2*$showfocus(hwidth)}] \
         -height [expr {[winfo height $w] + 2*$showfocus(hwidth)}]
      lower $showfocus(slave) $w
   }
}


proc focuspolicy {{p {}}} {
   upvar #0 __showfocus showfocus
   
   if [string match {} $p] {
      return $showfocus(policy)
   } elseif {[string match explicit $p] || [string match pointer $p]} {
      set showfocus(policy) $p
   } else {
      error "unknown focus policy type \"$p\""
   }
}




###############################################################################
#
# Bindings for focus feedback
#

foreach class {Entry Text Button Radiobutton Checkbutton all} {
   bind $class <FocusIn>	{+__showfocus %W}
   bind $class<FocusOut>	{+__showfocus {}}
   bind $class <Configure>	{+__resizefocus %W}
}

foreach class {Toplevel Frame Tk} {
   bind $class <FocusIn>	{;}
   bind $class <FocusOut>	{;}
   bind $class <Configure>	{;}
   bind $class <Any-Enter>	{;}
   bind $class <Any-Leave>	{;}
}




