#
# bindkbd.tcl - bindings for keyboard interaction with widgets
#
# Copyright 1994, Nat Pryce
#
# Permission is hereby granted, without written agreement and without
# license or royalty fees, to use, copy, modify, and distribute this
# software and its documentation for any purpose, provided that the
# above copyright notice and the following two paragraphs appear in
# all copies of this software.
#
# IN NO EVENT SHALL THE AUTHOR BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT, 
# SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF 
# THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE AUTHOR HAS BEEN ADVISED 
# OF THE POSSIBILITY OF SUCH DAMAGE.
#
# THE AUTHOR SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING, BUT NOT 
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
# PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS" 
# BASIS, AND THE AUTHOR HAS NO OBLIGATION TO PROVIDE  MAINTENANCE, SUPPORT,
# UPDATES, ENHANCEMENTS, OR MODIFICATIONS.



# -----------------------------------------------------------------------------
# Button bindings

set __showfocus(relief) {}
set __showfocus(borderwidth) {}

bind Button <Key-space> {
   if ![string match "disabled" [lindex [%W configure -state] 4]] {
      if {$tk_strictMotif} {
         set __showfocus(relief) [lindex [%W configure -relief] 4]
         %W configure -relief sunken; update idletasks
         %W invoke
         catch {%W configure -relief $__showfocus(relief)}
      } else {
         %W invoke;
         catch {%W flash}
      }
   }
}


bind Radiobutton <Key-space> {
   if ![string match "disabled" [lindex [%W configure -state] 4]] {
      if {$tk_strictMotif} {
         set __showfocus(relief) [lindex [%W configure -relief] 4]
         %W configure -relief sunken; update idletasks
         %W invoke
         catch {%W configure -relief $__showfocus(relief)}
      } else {
         %W invoke;
         catch {%W flash}
      }
   }
}


bind Checkbutton <Key-space> {
   if ![string match "disabled" [lindex [%W configure -state] 4]] {
      if {$tk_strictMotif} {
         set __showfocus(relief) [lindex [%W configure -relief] 4]
         %W configure -relief sunken; update idletasks
         %W invoke
         catch {%W configure -relief $__showfocus(relief)}
      } else {
         %W invoke;
         catch {%W flash}
      }
   }
}




# -----------------------------------------------------------------------------
# Scrollbar bindings

tk_bindForTraversal Scrollbar

bind Scrollbar <Any-Home> {
   eval [lindex [%W configure -command] 4] 0
}

bind Scrollbar <Any-Prior> {
   eval [lindex [%W configure -command] 4] [expr {
      [lindex [%W get] 2]-[lindex [%W get] 1]
   }]
}

bind Scrollbar <Any-Next> {
   eval [lindex [%W configure -command] 4] [expr {
      [lindex [%W get] 2]+[lindex [%W get] 1]
   }]
}

bind Scrollbar <Any-Up> {
   if [string match vertical [lindex [%W configure -orient] 4]] {
      eval [lindex [%W configure -command] 4] [expr {[lindex [%W get] 2]-1}]
   }
}

bind Scrollbar <Any-Down> {
   if [string match vertical [lindex [%W configure -orient] 4]] {
      eval [lindex [%W configure -command] 4] [expr {[lindex [%W get] 2]+1}]
   }
}


bind Scrollbar <Any-Left> {
   if [string match horizontal [lindex [%W configure -orient] 4]] {
      eval [lindex [%W configure -command] 4] [expr {[lindex [%W get] 2]-1}]
   }
}

bind Scrollbar <Any-Right> {
   if [string match horizontal [lindex [%W configure -orient] 4]] {
      eval [lindex [%W configure -command] 4] [expr {[lindex [%W get] 2]+1}]
   }
}



# -----------------------------------------------------------------------------
# Listbox bindings

proc tk_listboxSingleSelect {args} {
   foreach w $args {
      bind $w <ButtonPress-1> {
         if [string match explicit [focuspolicy]] { focus %W }
         %W select from [%W nearest %y]
      }
      bind $w <Button1-Motion> [bind $w <ButtonPress-1>]
      bind $w <Shift-Button-1> [bind $w <ButtonPress-1>]
      bind $w <Shift-Button1-Motion> [bind $w <ButtonPress-1>]
      widget :: add_binding $w <FocusIn> {
         if [string match "" [%W curselection]] {
            %W select from [%W nearest 0]
         }
      }
      bind $w <Up> {
         %W select from [expr {[%W curselection] -1}]
         if {[%W curselection] < [%W nearest 0]} {
            %W yview [%W curselection]
         }
      }
      bind $w <Down> {
         %W select from [expr {[%W curselection] +1}]
         if {[%W curselection] > [%W nearest [winfo height %W]]} {
            %W yview [expr {[%W nearest 0] + 1}]
         }
      }
   }
}





