#
# Toplevel window module
#

# These routines only operate on toplevel windows.

# Given a toplevel widget, sets the nth item in [wm geometry .] to $value.
# So, for n: 0=width 1=height 2=xoffset 3=yoffset
proc th_geometry_change {w n value} {
  scan [wm geometry $w] "%dx%d+%d+%d" i(0) i(1) i(2) i(3)
  set i($n) $value
  if {$n < 2} {	wm geometry $w "$i(0)x$i(1)"
  } else { 	wm geometry $w "+$i(2)+$i(3)"
}}

# Like th_geometry_change, but alters the current value of the nth item by $inc
proc th_geometry_adjust {w n {inc +1}} {
  scan [wm geometry $w] "%dx%d+%d+%d" i(0) i(1) i(2) i(3)
  incr i($n) $inc

  if {$n < 2} {	wm geometry $w "$i(0)x$i(1)"
  } else { 	wm geometry $w "+$i(2)+$i(3)"
}}

# uuhhh...makes your window disappear.
proc th_iconify_window {w} {wm iconify [winfo toplevel $w]}

# Quick way to bring your window to the forefront.
proc th_raise_window {w} {
  wm deiconify [winfo toplevel $w]
  raise [winfo toplevel $w]
}
