#
# Widget resizing module
#

# Changes size by either chars or pixels, depending on the widget. Vertical is
# 1 if resize should be vertical, 0 for horizontal, inc is +1 for expand, -1
# for shrink.
proc th_resize_widget {w vertical inc {chars 1} {pixels 1}} {
  set units $pixels
  if $vertical {set option "-height"} else {set option "-width"}
  switch [winfo class $w] {
    "Message" {if $vertical {bell ; return}}
    "Entry" {if $vertical {bell ; return} ; set units $chars}
    "Label" - "Button" - "Checkbutton" - "Radiobutton" - "Menubutton" {
      if {([$w cget -image] == "") && ([$w cget -bitmap] == "")} {
        set units $chars}}
   "Text" - "Listbox" {set units $chars}
    "Scale" {if {([$w cget -orient] == "vertical") == $vertical} {
         set option "-length"} else {set option "-width"}}
    "Scrollbar" {if {([$w cget -orient] == "vertical") == $vertical} {
         bell ; return} else {set option "-width"}}
   }

  set value [eval expr [$w cget $option] + ($inc * $units)]
  if {$value < 0} {set value 0}
  $w configure $option $value
}
