#
# Module for balancing parens in Text widgets
#


# Returns the index (in the TH(Paren...) series) of the last right pair
# before insert.
proc th_Text_prev_exp {w {i 0}} {
  global TH
  for {set l [llength $TH(Paren,Right,$w)]} {$i < $l} {incr i} {
    set right [lindex $TH(Paren,Right,$w) $i]
    if {$right == [$w get "insert - [string length $right] chars" insert]} {
      return $i
  }}
  return -1
}

# Returns the index (in the TH(Paren...) series) of the next left pair
# after insert
proc th_Text_next_exp {w {i 0}} {
  global TH
  for {set l [llength $TH(Paren,Left,$w)]} {$i < $l} {incr i} {
    set left [lindex $TH(Paren,Left,$w) $i]
    if {$left == [$w get insert "insert + [string length $left] chars"]} {
      return $i
  }}
  return -1
}

# Returns the corresponding left-exp to the right-exp just before index.
proc th_Text_left_exp {w index left right nest} {
  set close_trace [$w index "$index - [string length $right] c - [string length $left] c + 1c"]
  set open_trace $close_trace
  while (1) {
    if {[set open_trace [$w search -backward -- $left $open_trace 1.0]] \
        == ""} {return ""}
    if {(!$nest) || ([set close_trace [$w search -backward -- $right \
	$close_trace $open_trace]] == "") || [$w compare $close_trace < $open_trace]} {
      return $open_trace}
}}

# Returns the corresponding right-exp to the left-exp at/after index.
proc th_Text_right_exp {w index left right nest} {
  set close_trace [$w index "$index + [string length $left]c -1c"]
  set open_trace $close_trace
  while (1) {
    if {[set close_trace [$w search -forward -- $right "$close_trace +1c" end]] 	== ""} {return ""}
    if {(!$nest) || ([set open_trace [$w search -forward -- $left \
        "$open_trace +1c" $close_trace]] == "") || [$w compare $open_trace > $close_trace]} {
      return "$close_trace + [string length $right] c"}
}}


# Returns a message for match being found (of exp_type). Match may be empty;
# in which case nothing is returned.
proc th_Text_report_exp {w start end left right nest} {
  global TH
  catch {$w tag remove $TH(Paren,Select,Text) 1.0 end}
  after cancel "$w tag remove $TH(Paren,Select,Text) 1.0 end"
  if {($start == "")} {return ""}

  set start_left "$start + [string length $left] c"
  if {$TH(Paren,Select,Text) == "sel"} {$w mark set anchor $start}
  $w tag add $TH(Paren,Select,Text) $start $start_left
  if {$TH(Paren,Select,Text) != "sel"} {
    eval $w tag configure $TH(Paren,Select,Text) $TH(Paren,Text,Tag) 
# Not used, this just forces the frame module to autoload so we can have
# TH(Label,Flash).
    set f [th_frame $w]
    after $TH(Label,Flash) $w tag remove $TH(Paren,Select,Text) 1.0 end
  }
  return [$w get "$start linestart" $start_left]
}

# Counts instances of $s between $start and $end in $w
proc th_Text_char_count {w s start end} {
  set offset 0 ; set count 0
  set trace [$w index "$start-1c"]
  while {([set trace [$w search -forward -- $s "$trace +1c" $end]] != "")} {
    if {[$w compare $trace >= $end]} {break}
    incr count
  }
  return $count
}
