#
# Module for managing grids in Listbox widgets
#

# Called by a Listbox widget to tell w what to view
proc th_Listbox_xview {w t x1 x2} {$t xview moveto $x1}

# Turns on or off the horizontal grid on w. Side indicates where to put it.
proc th_Listbox_toggle_grid_x {w {side bottom}} {
  if {[winfo manager $w] != "pack"} {
    set tl "[set w].gridx"
    set g "[set tl].g"
  } else {
    set tl ""
    set g "[set w]_gridx"}

  global TH
  if {[winfo exists $g]} {
# turn grid off
    set TH(Grid_X,$w) 0

# Reset w's xscrollcommand to its scrollbar or nothing if it didn't have one.
    if {[scan [$g cget -xscrollcommand] "%s set" sc] >= 0} {
      $w configure -xscrollcommand "$sc set"
    } else {$w configure -xscrollcommand {}}
    if {$tl != ""} {destroy $tl} else {destroy $g}
  } else {
    set TH(Grid_X,$w) 1
# turn grid on
    set width [$w cget -width]
    if {$tl != ""} {
      toplevel $tl
      wm protocol $tl WM_DELETE_WINDOW { }
      wm transient $tl [winfo toplevel $w]
    }
    entry $g -relief ridge -font [$w cget -font] -width $width -borderwidth 2
    if {$tl != ""} {pack $g -expand yes -fill x
    } else {
      set w_side [lindex [pack info $w] end]
      eval pack $g -anchor n [lrange [pack info $w] 6 15] -expand 0 -side $side -before $w
      switch [list $w_side $side] {
        {top bottom} - {left right} - {bottom top} - {right left} {
          pack $g -after $w -side $w_side
      }}

      set fill [lindex [pack info $w] 7]
      if {$fill == "both"} {pack $g -fill x
      } elseif {$fill == "y"} {pack $g -fill none}}

# Disable scanning on g.
    bindtags $g "$g ."

# Fill g with column numbers
    set s [$w size]
    for {set c 0} {$c < $s} {incr c} {
      set l [string length [$w get $c]]
      if {$l > $width} {set width $l}
    }
    incr width -1
    $g delete 0 end
    for {set column 0} {$column <= $width} {incr column} {
      if {[expr $column % 10] == 0} {
        $g insert end $column
        incr column [expr [string length $column] - 1]
      } elseif {[expr $column % 5] == 0} {$g insert end "+"
      } else {$g insert end "-"}}
    $g configure -state disabled

# Tie w's xscrollcommand over to g.
    $w xview moveto 0 ; $g xview moveto 0
# Listboxes won't tell you how far along the x line they're scrolled.
    if {[scan [$w cget -xscrollcommand] "%s set" sc] >= 0} {
# Give g the responsibility of moving w's scrollbar.
      $g configure -xscrollcommand "$sc set"
    }
    $w configure -xscrollcommand "th_Listbox_xview $w $g"
}}


# Called by a Listbox widget to tell w what to view
proc th_Listbox_yview {w t y1 y2} {$t yview [$w nearest 0]}

# Turns on or off the horizontal grid on w. Side indicates where to put it.
proc th_Listbox_toggle_grid_y {w {side left}} {
  if {[winfo manager $w] != "pack"} {
    set tl "[set w].gridy"
    set g "[set tl].g"
  } else {
    set tl ""
    set g "[set w]_gridy"}

  global TH
  if {[winfo exists $g]} {
# turn grid off
    set TH(Grid_Y,$w) 0

# Reset w's yscrollcommand to its scrollbar or nothing if it didn't have one.
    if {[scan [$g cget -yscrollcommand] "%s set" sc] >= 0} {
      $w configure -yscrollcommand "$sc set"
    } else {$w configure -yscrollcommand {}}
    if {$tl != ""} {destroy $tl} else {destroy $g}
  } else {
    set TH(Grid_Y,$w) 1
# turn grid on
    set height [$w cget -height]
    set width [string length [$w size]]

    if {$tl != ""} {
      toplevel $tl
      wm protocol $tl WM_DELETE_WINDOW { }
      wm transient $tl [winfo toplevel $w]
    }
    listbox $g -relief ridge -font [$w cget -font] \
	-width $width -height $height -borderwidth 2
    if {$tl != ""} {pack $g -expand yes -fill x
    } else {
      set w_side [lindex [pack info $w] end]
      eval pack $g -anchor w [lrange [pack info $w] 6 15] -expand 0 -side $side -before $w
      switch [list $w_side $side] {
        {top bottom} - {left right} - {bottom top} - {right left} {
          pack $g -after $w -side $w_side
      }}

      set fill [lindex [pack info $w] 7]
      if {$fill == "both"} {pack $g -fill y
      } elseif {$fill == "x"} {pack $g -fill none}}

# Disable scanning on g.
    bindtags $g "$g ."

# Fill g with column numbers
    set lines [$w size] ; incr lines
    for {set line 0} {$line < $lines} {incr line} {
      $g insert end $line}

# Tie w's yscrollcommand over to g.
    $g yview [$w nearest 0]
    if {[scan [$w cget -yscrollcommand] "%s set" sc] >= 0} {
# Give g the responsibility of moving w's scrollbar.
      $g configure -yscrollcommand "$sc set"
    }
    $w configure -yscrollcommand "th_Listbox_yview $w $g"
}}
