#
# Provides functions necessary for elsbeth, but not needed during startup
#


# Visit-file command

proc elsbeth_function_parse {w index {line_var ""} {column_var ""}} {
  if {$line_var != ""} {upvar $line_var line}
  if {$column_var != ""} {upvar $column_var column}
  set file ""
  set word [$w get "$index wordstart" "$index wordend"]
  if {[string length $word] == 1} {return ""}
  set l [winfo children .] ; set i [lsearch $l [winfo parent $w]]
  foreach tl [concat [winfo parent $w] [lreplace $l $i $i]] {
    for {set i [lindex [$tl.t tag nextrange FUNCTION 1.0] 0]} {($i != "")} \
	{set i [lindex [$tl.t tag nextrange FUNCTION "$i +1c"] 0]} {
      set text [$tl.t get "$i linestart" "$i lineend"]
      if {([set column [string first $word $text]] >= 0) &&
        	($column == [string wordstart $text [expr $column + 1]]) && 
		([expr $column + [string length $word]] == [string wordend $text $column])} {
        scan [$tl.t index $i] "%d.%d" line dummy
        global TH
        return $TH(File,$tl.t)
  }}}
  return ""
}


# Brings up a window on a new file, or revisits an old one.
proc elsbeth_visit_file {w {index ""} {msg "File to Visit:"}} {
  global TH
  set old $TH(File,$w)
  if {$index == ""} {
    set TH(File,$w) "[th_file_dirname $TH(File,$w)]/"
    th_file_prompt $w "elsbeth_visit_file_aux $w" $msg
  } else {
    set line "" ; set column ""
    if {([set TH(File,New,$w) [elsbeth_function_parse $w $index line column]] != "") || ([set TH(File,New,$w) [th_file_parse $w $index line column]] != "")} {
      elsbeth_visit_file_aux $w $line $column
    } else {bell ; return}
  }
  set TH(File,$w) $old
}

proc elsbeth_visit_file_aux {w {line ""} {column ""}} {
  global TH
  set file $TH(File,New,$w)
  return [elsbeth_goto_file $w $file $line $column]
}

# Returns window of file, which may be new or old. Sets insert at line and
# column, if specified.
proc elsbeth_goto_file {w file {line ""} {column ""}} {
  global TH
  if {[file isdirectory $file]} {
    if {([string index $file [expr [string length $file] - 1]] != "/")} {
      set file "$file/$TH(File,Browse,Command)"
    } else {
      set file "$file$TH(File,Browse,Command)"
  }}
  set file [th_dedot_file $file]

# Add command to completion list
  if {[set l [string first "|" $file]] >= 0} {
    set newcmd [string range $file [incr l] end]
    if {[lsearch -exact $TH(Completions,File,Commands) $newcmd] < 0} {
      lappend TH(Completions,File,Commands) $newcmd
  }}

  set window ""

# See if we're already visiting this file.
  if {([llength $file] > 1) && ![string match "*|" [lindex $file 0]]} {
    set match [lindex $file 0]} else {set match $file}

  foreach tl [winfo children .] {
    if {[lsearch "Toplevel Frame" [winfo class $tl]] >= 0} {
      if {![catch "set TH(File,$tl.t)" other_file]} {
        if {([llength $other_file] > 1) && ![string match "*|" [lindex $other_file 0]]} {
          set other_match [lindex $other_file 0]} else {set other_match $other_file}
        if {$other_match == $match} {
          set window $tl ; set widget $tl.t
          if {$file != $TH(File,$widget)} {
            set TH(File,$widget) $file
            th_read_file $widget}
          break
  }}}}

  if {$window == ""} {
# Oh well, gotta bring up a new window.
    if {[winfo class [winfo parent $w]] == "Toplevel"} {set pile 0
    } else {set pile 1}
    els_process_option $file $pile
    set l [llength [winfo children .]] ; incr l -1
    set window [lindex [winfo children .] $l]; set widget "$window.t"
  }

  th_focus "$window.t"
  if {$column != ""} {th_Text_goto $widget "$line.$column" 0
  } elseif {$line != ""} {th_Text_goto $widget $line 0}

  return "$window.t"
}

# Brings up help file, also fancies it up a bit.
proc elsbeth_help {w} {
  global Elsbeth_Help_File TH
  set l [winfo children .]
  set wh [elsbeth_goto_file $w $Elsbeth_Help_File]
  if {$l == [winfo children .]} {return}
  th_add_module paragrath $wh
  set Elsbeth_Help_File $TH(File,$wh)
  th_Text_paint_region_tag $wh 1.0 end HEADER {(The Elsbeth Editor|.* Functions)} {}
  $wh tag configure HEADER -underline 1 -relief raised
  $wh tag lower HEADER sel
  $wh delete 1.0 3.0
}

# Make command
proc elsbeth_make {w} {
  global Make_Cmd TH
  set f [th_frame $w]
  if {[winfo exists $f.file.e]} {
    set value [$f.file.e get]
    if {[string match "*|make*" $value]} {
      set Make_Cmd [string range $value [string first "|" $value] end]
  }}
  if {[catch "set Make_Cmd"]} {set Make_Cmd "|make |& cat"}

  set l [winfo children .]
  set old $TH(File,$w)
  set TH(File,$w) "[th_file_dirname $TH(File,$w)]/$Make_Cmd"
  th_file_prompt $w "set wm \[elsbeth_visit_file_aux $w\] ; if \{\"$l\" == \[winfo children .\]\} \{th_read_file \$wm\}" "Make command:"
  set TH(File,$w) $old
}

