#
# Module for editing Misc widgets
#


# Prints the last undoable command.
proc th_look_undo {w} {
  global TH
  if {[catch "set TH(Undo,Data,$w)"]} {set TH(Undo,Data,$w) ""}
  if {([llength $TH(Undo,Data,$w)] == 0)} {bell ; return}
  set text "Last: [lindex [lindex $TH(Undo,Data,$w) 0] 1]"
  if {([string length $text] > $TH(Undo,Label,Max))} {
    set text "[string range $text 0 $TH(Undo,Label,Max)]..."}
  th_flash_label $w -text $text
}

# Clears the undo log.
proc th_kill_undos {w} {
  global auto_index
  if {([info procs th_[winfo class $w]_kill_undos] != "") || \
     ([lsearch [array names auto_index] th_[winfo class $w]_kill_undos] >= 0)} {
    th_[winfo class $w]_kill_undos $w
  }
  global TH ; set TH(Undo,Data,$w) ""
}


# Quoting

# Sets up the quote function.
proc th_quote {w} {
  set f [th_frame $w]
  entry $f.quote -width 0
  $f.quote insert 0 "Quote"
  bindtags $f.quote "$f.quote . All"
  pack $f.quote -side right
  set old_focus [focus -displayof [winfo toplevel $w]]
  focus $f.quote
  bind $f.quote <Key> "th_quote_abort $w $old_focus %A"
  bind $f.quote <Control-Key> "th_unquote $w $old_focus %A"
}

# Cancel quote.
proc th_quote_abort {w focus c} {
  if {(![regexp . $c])} {return}
  bell
  destroy [th_frame $w].quote
  focus $focus
}

# Insert quoted character.
proc th_unquote {w focus c} {
  th_[winfo class $w]_insert $w $c
  set f [th_frame $w]
  destroy $f.quote
  focus $focus
}


# Entry for specifying indenting for text.

# Set up indent, use $fn as indent function.
proc th_indent {w fn} {
  if {[set f [th_show_entry $w indent]] == ""} {bell ; return}
  $f.l configure -text "Indent Prefix:"
  th_bind $f.e OK "$fn $w"
}

# Paste selection, to w. Args can be something like -selection CLIPBOARD.
proc th_paste_selection {w args} {
  if {[catch "selection get -displayof $w $args" chars]} {bell ; return 0}
  th_[winfo class $w]_undoable_insert $w $chars
}


# String filtering (for upper/lower/capitalize regions)

# Executes filter on i1 and i2 of string s.
proc th_string_filter {s start end filter} {
  return "[string range $s 0 [expr $start - 1]][$filter [string range $s $start $end]][string range $s [expr $end + 1] end]"
}

# Some filters to do to strings
proc th_string_tolower {s} {return [string tolower $s]}
proc th_string_toupper {s} {return [string toupper $s]}
proc th_string_capitalize {s} {return "[string toupper [string index $s 0]][string tolower [string range $s 1 end]]"
}


# Transposition

proc th_string_transpose_chars {s i} {
  set c1 [string index $s [expr "$i-1"]]
  set c2 [string index $s [expr "$i"]]
  return "[string range $s 0 [expr $i - 2]]$c2$c1[string range $s [expr $i+1] end]"
}

proc th_string_transpose_words {s i} {
  set end3 [expr [string wordend $s $i] - 1]
  set begin3 [string wordstart $s $end3]
  set c3 [string range $s $begin3 $end3]
  set begin2 [string wordstart $s [expr $begin3 - 1]]
  set c2 [string range $s $begin2 [expr $begin3 - 1]]
  set begin1 [string wordstart $s [expr $begin2 - 1]]
  set c1 [string range $s $begin1 [expr $begin2 - 1]]
  return "[string range $s 0 [expr $begin1 - 1]]$c3$c2$c1[string range $s [expr $end3 + 1] end]"
}


# Returns index of next newline, or end if no more newlines.
proc th_string_lineend {s i} {
  if {[set newline [string first "\n" [string range $s $i end]]] == -1} {
    return end
  } elseif {$newline == 0} {
    return $i
  } else {return [expr $i + $newline - 1]}
}


# Called whenever TH(Modified,$w) is changed.
proc th_modified_widget {w f args} {
  global TH
  if {![winfo exists $f]} {return}
  if {![catch {$w cget -state} result] && ($result == "disabled")} {return}
  if $TH(Modified,$w) {$f select} else {$f deselect}
}
