#
# Module to perform wish and exec commands
#


# Prompt for a wish command to execute.
proc th_cmd_wish_prompt {w} {
  set f [th_show_entry $w wish]
  global TH
  lappend TH(Completions,$f.e) {th_line_complete th_filter_cmds none}
  $f.l configure -text "Wish Command:"
  th_bind $f.e OK "th_hide_entry $w wish ; th_cmd_wish $w \[$f.e get\]"
}

# Execute a wish command, output (if any) to widget w (if possible).
proc th_cmd_wish {w cmd} {
  set output 0
  if {[string match *\| $cmd]} {
    set cmd [string range $cmd 0 [expr [string length $cmd] - 2]]
    set output 1
  }
  global TH
  if {[catch "set TH(Cmd,Output,$w)"]} {set TH(Cmd,Output,$w) 0}
  if $TH(Cmd,Output,$w) {set output 1}

  set er [catch {uplevel #0 $cmd} result]

  global auto_index
  if {$output && (![catch "$w cget -state" s]) && ($s != "disabled") && \
	(([info procs th_[winfo class $w]_undoable_ert] != "") || \
	       ([lsearch [array names auto_index] \
		th_[winfo class $w]_undoable_insert] >= 0))} {
      th_[winfo class $w]_undoable_insert $w $result
  } elseif {$result != ""} {
    if $er {tkerror $result} else {
    tk_dialog .th_cmd "Wish Output" $result info 0 OK
}}}


# No default value for the shell command.
set TH(Cmd,Default,Shell) ""

# Prompt for a shell command to execute.
proc th_cmd_exec_prompt {w {prompt "Command to Execute:"} {default_cmd Shell}} {
  global TH
  if {($default_cmd != "Shell")} {
    set TH(Cmd,Input,$w) 0 ; set TH(Cmd,Output,$w) 0 }
  if {[catch "set TH(Cmd,Default,$default_cmd,$w)"]} {
    set TH(Cmd,Default,$default_cmd,$w) $TH(Cmd,Default,$default_cmd)}

  set f [th_show_entry $w exec]
  $f.l configure -text $prompt
  $f.e delete 0 end
  $f.e insert 0 $TH(Cmd,Default,$default_cmd,$w)
  $f.e xview [expr [string length [$f.e get]] - [$f.e cget -width]]
  th_bind $f.e OK "th_hide_entry $w exec ; set TH(Cmd,Default,$default_cmd,$w) \[$f.e get\] ; th_cmd_exec $w \[$f.e get\]"
}

# Execute shell command, input may come from w or w's selection, output to w.
proc th_cmd_exec {w cmd} {
  set input 0 ; set output 0
  if {[string match \|* $cmd]} {
    set cmd [string range $cmd 1 [expr [string length $cmd] - 1]]
    set input 1
  }
  if {[string match *\| $cmd]} {
    set cmd [string range $cmd 0 [expr [string length $cmd] - 2]]
    set output 1
  }

  global TH
  if {[catch "set TH(Cmd,Output,$w)"]} {set TH(Cmd,Output,$w) 0}
  if {[catch "set TH(Cmd,Input,$w)"]} {set TH(Cmd,Input,$w) 0}
  if $TH(Cmd,Output,$w) {set output 1}
  if $TH(Cmd,Input,$w) {set input 1}

  if $input {
    if {$w == [selection own -displayof $w]} {
      set text [selection get]
    } else {switch [winfo class $w] {
	"Text" {set text [$w get 1.0 end]}
	"Entry" - "Scale" - "Scrollbar" {set text [$w get]}
	"Listbox" {set text [$w get 0 end]}
	"Canvas" {catch "$w itemcget \[$w focus\] -text" text}
	"Button" - "Checkbutton" - "Radiobutton" - "Menubutton" - \
	"Message" - "Label" {set text [$w cget -text]}
	default {set text ""}}}

    set p [open $TH(Tmpfile) w+]
    puts $p $text
    flush $p
    seek $p 0
    set er [catch "exec <@ $p $cmd" result]
    close $p
    exec rm $TH(Tmpfile)
  } else {set er [catch "exec $cmd" result]}

  global auto_index
  if {$output && (![catch "$w cget -state" s]) && ($s != "disabled") && \
	(([info procs th_[winfo class $w]_undoable_ert] != "") || \
	       ([lsearch [array names auto_index] \
		th_[winfo class $w]_undoable_insert] >= 0))} {
      th_[winfo class $w]_undoable_insert $w $result
  } elseif {$result != ""} {tk_dialog .th_cmd "Exec Output" $result info 0 OK
}}
