# TH bindings (created by makebeth) for Canvas widgets

set TH(Undo,Max,Canvas) -1
set TH(Undo,Label,Max) 30
set TH(Binding,Kill_Line) <Control-c>
set TH(Pipe,Enabled) 1
set TH(File,Pad) 0
set TH(Binding,Search_Forward) <Control-s>
set TH(Menuentry,Search_Forward) {Forward 0}
set TH(Binding,Search_Backward) <Control-r>
set TH(Menuentry,Search_Backward) {Reverse 0}
set TH(Binding,Toggle_Case_Sensitivity) <Meta-Control-c>
set TH(Menuentry,Toggle_Case_Sensitivity) {"Case Inensitive" 0}
set TH(Binding,Toggle_Incremental_Search) <Meta-C>
set TH(Menuentry,Toggle_Incremental_Search) {"Incremental Search" 0}
set TH(Search,Select,Canvas) sel
set TH(Search,Case,Implicit) 1
set TH(Completions,Canvas) {{th_substring_replace th_string_tcl_result {[}} {th_substring_replace th_string_global_value {$}} {th_substring_replace th_string_glob_files { }} {th_substring_complete th_filter_cmds {[}} {th_substring_complete th_filter_vars {$}} {th_substring_complete th_filter_glob { }}}
bind Canvas <Button-3> {th_toggle_menus %W}
bind Canvas <Control-b> {catch {th_Canvas_goto %W [expr [%W index [%W focus] insert] - 1]}}
bind Canvas <Control-f> {catch {th_Canvas_goto %W [expr [%W index [%W focus] insert] + 1]}}
bind Canvas <Meta-b> {catch {th_Canvas_goto %W [string wordstart [%W itemcget [%W focus] -text] [expr [%W index [%W focus] insert] -1]]}}
bind Canvas <Meta-f> {catch {th_Canvas_goto %W [string wordend [%W itemcget [%W focus] -text] [%W index [%W focus] insert]]}}
bind Canvas <Control-a> {th_Canvas_goto %W 0}
bind Canvas <Control-e> {th_Canvas_goto %W end}
bind Canvas <Control-K> {th_Canvas_select_next_line %W [%W focus]}
bind Canvas <Control-Shift-space> {th_Canvas_select_region %W [%W focus]}
bind Canvas <Control-slash> {catch {%W select from [%W focus] 0 ; %W select to [%W focus] end}}
bind Canvas <Control-space> {catch {set TH(Mark,%W,[%W focus]) [%W index [%W focus] insert]}}
bind Canvas <Control-x> {th_[winfo class %W]_exchange_mark %W}
bind Canvas <Meta-g> {th_goto %W}
bind Canvas <Control-backslash> {selection clear -displayof %W}
bind Canvas <Meta-w> {if {[selection own -displayof %W] == "%W"} {
	    clipboard clear -displayof %W
	    clipboard append -displayof %W -- [selection get -displayof %W]}}
bind Canvas <Control-g> {th_cancel_all %W}
bind Canvas <Meta-Control-u> {th_[winfo class %W]_undo %W}
bind Canvas <Meta-Control-l> {th_look_undo %W}
bind Canvas <Meta-Control-k> {th_kill_undos %W}
bind Canvas <Control-y> {th_paste_selection %W -selection CLIPBOARD}
bind Canvas <Control-v> {th_paste_selection %W}
bind Canvas <ButtonRelease-2> {if !$tkPriv(mouseMoved) {th_paste_selection %W}}
bind Canvas <Control-q> {th_quote %W}
bind Canvas <Control-w> {th_[winfo class %W]_kill_region %W}
foreach th_binding {<Control-BackSpace> <Delete>} {
 bind Canvas $th_binding {th_[winfo class %W]_delete_selection %W}}
bind Canvas <Meta-u> {th_[winfo class %W]_filter %W th_string_toupper}
bind Canvas <Meta-l> {th_[winfo class %W]_filter %W th_string_tolower}
bind Canvas <Meta-c> {th_[winfo class %W]_filter %W th_string_capitalize}
bind Canvas <Control-t> {th_[winfo class %W]_transpose_chars %W}
bind Canvas <Meta-t> {th_[winfo class %W]_transpose_words %W}
bind Canvas <Control-c> {th_Canvas_kill_line %W}
bind Canvas <Control-u> {catch {th_Canvas_kill_range %W [%W focus] 0 end}}
foreach th_binding {<Control-h> <BackSpace>} {
 bind Canvas $th_binding {catch {th_Canvas_delete_range %W [%W focus] [expr [%W index [%W focus] insert] - 1] [expr [%W index [%W focus] insert] - 1] 0}}}
bind Canvas <Control-d> {catch {th_Canvas_delete_range %W [%W focus] insert insert 0}}
foreach th_binding {<Meta-h> <Meta-BackSpace>} {
 bind Canvas $th_binding {catch {if {[%W index [%W focus] insert] != 0} {th_Canvas_delete_range %W [%W focus] [string wordstart [%W itemcget [%W focus] -text] [expr [%W index [%W focus] insert] -1]] [expr [%W index [%W focus] insert] -1]}}}}
bind Canvas <Meta-d> {catch {th_Canvas_delete_range %W [%W focus] insert [expr [string wordend [%W itemcget [%W focus] -text] [%W index [%W focus] insert]] - 1]}}
bind Canvas <Control-k> {catch {th_Canvas_delete_range %W [%W focus] insert [th_string_lineend [%W itemcget [%W focus] -text] [%W index [%W focus] insert]]}}
bind Canvas <Control-o> {th_Canvas_insert %W "\n" ; catch {th_Canvas_goto %W [expr [%W index [%W focus] insert] -1]}}
bind Canvas <Meta-s> {th_save_file %W}
bind Canvas <Meta-S> {th_save_file_prompt %W}
bind Canvas <Enter> {th_check_mtime %W}
bind Canvas <Control-s> {th_Misc_search %W forward string}
bind Canvas <Control-r> {th_Misc_search %W backward string}
bind Canvas <Control-S> {th_Misc_search %W forward regexp}
bind Canvas <Control-R> {th_Misc_search %W backward regexp}
bind Canvas <Meta-C> {th_toggle_incremental_search %W}
bind Canvas <Escape> {th_[winfo class %W]_complete_multiple %W [th_completions %W]}
bind Canvas <Control-Escape> {th_[winfo class %W]_completion_dialog %W}
bind Canvas <Meta-X> {th_toggle_scrollbar %W x bottom}
bind Canvas <Meta-Y> {th_toggle_scrollbar %W y left}



proc th_Canvas_menus {w} {
  th_Misc_menus $w
set code {

menubutton %W_mb.mb_browse -m %W_mb.mb_browse.m -text Browse -u 0
pack %W_mb.mb_browse -in %W_mb -side left
menu %W_mb.mb_browse.m
%W_mb.mb_browse.m add cascade -l Goto -u 0 -m %W_mb.mb_browse.m.goto
menu %W_mb.mb_browse.m.goto
%W_mb.mb_browse.m.goto add cascade -l Character -u 0 -m %W_mb.mb_browse.m.goto.character
menu %W_mb.mb_browse.m.goto.character
%W_mb.mb_browse.m.goto.character add command -l {Left} -u 0 -acc {<Control-b>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  catch {th_Canvas_goto %W [expr [%W index [%W focus] insert] - 1]}}}
%W_mb.mb_browse.m.goto.character add command -l {Right} -u 0 -acc {<Control-f>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  catch {th_Canvas_goto %W [expr [%W index [%W focus] insert] + 1]}}}
%W_mb.mb_browse.m.goto add cascade -l Word -u 0 -m %W_mb.mb_browse.m.goto.word
menu %W_mb.mb_browse.m.goto.word
%W_mb.mb_browse.m.goto.word add command -l {Left} -u 0 -acc {<Meta-b>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  catch {th_Canvas_goto %W [string wordstart [%W itemcget [%W focus] -text] [expr [%W index [%W focus] insert] -1]]}}}
%W_mb.mb_browse.m.goto.word add command -l {Right} -u 0 -acc {<Meta-f>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  catch {th_Canvas_goto %W [string wordend [%W itemcget [%W focus] -text] [%W index [%W focus] insert]]}}}
%W_mb.mb_browse.m.goto add cascade -l Edge -u 0 -m %W_mb.mb_browse.m.goto.edge
menu %W_mb.mb_browse.m.goto.edge
%W_mb.mb_browse.m.goto.edge add command -l {Left} -u 0 -acc {<Control-a>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_Canvas_goto %W 0}}
%W_mb.mb_browse.m.goto.edge add command -l {Right} -u 0 -acc {<Control-e>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_Canvas_goto %W end}}
%W_mb.mb_browse.m add cascade -l Select -u 1 -m %W_mb.mb_browse.m.select
menu %W_mb.mb_browse.m.select
%W_mb.mb_browse.m.select add command -l {Line} -u 0 -acc {<Control-K>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_Canvas_select_next_line %W [%W focus]}}
%W_mb.mb_browse.m.select add command -l {Region} -u 0 -acc {<Control-Shift-space>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_Canvas_select_region %W [%W focus]}}
%W_mb.mb_browse.m.select add command -l {All} -u 0 -acc {<Control-slash>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  catch {%W select from [%W focus] 0 ; %W select to [%W focus] end}}}
%W_mb.mb_browse.m add command -l {Anchor} -u 0 -acc {<Control-space>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  catch {set TH(Mark,%W,[%W focus]) [%W index [%W focus] insert]}}}
%W_mb.mb_browse.m.goto add command -l {Anchor} -u 0 -acc {<Control-x>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_[winfo class %W]_exchange_mark %W}}
%W_mb.mb_browse.m.goto add command -l {Specify an Index} -u 11 -acc {<Meta-g>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_goto %W}}
%W_mb.mb_browse.m.select add command -l {Clear} -u 0 -acc {<Control-backslash>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  selection clear -displayof %W}}
%W_mb.mb_browse.m.select add command -l {Copy} -u 1 -acc {<Meta-w>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  if {[selection own -displayof %W] == "%W"} {
	    clipboard clear -displayof %W
	    clipboard append -displayof %W -- [selection get -displayof %W]}}}

menubutton %W_mb.mb_edit -m %W_mb.mb_edit.m -text Edit -u 0
pack %W_mb.mb_edit -in %W_mb -side left
menu %W_mb.mb_edit.m
%W_mb.mb_edit.m add cascade -l Undo -u 0 -m %W_mb.mb_edit.m.undo
menu %W_mb.mb_edit.m.undo
%W_mb.mb_edit.m.undo add command -l {Undo} -u 0 -acc {<Meta-Control-u>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_[winfo class %W]_undo %W}}
%W_mb.mb_edit.m.undo add command -l {Show Last} -u 5 -acc {<Meta-Control-l>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_look_undo %W}}
%W_mb.mb_edit.m.undo add command -l {Kill Undo Log} -u 0 -acc {<Meta-Control-k>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_kill_undos %W}}
%W_mb.mb_edit.m add cascade -l Paste -u 0 -m %W_mb.mb_edit.m.paste
menu %W_mb.mb_edit.m.paste
%W_mb.mb_edit.m.paste add command -l {Clipboard} -u 0 -acc {<Control-y>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_paste_selection %W -selection CLIPBOARD}}
%W_mb.mb_edit.m.paste add command -l {Selection} -u 0 -acc {<Control-v>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_paste_selection %W}}
%W_mb.mb_edit.m add command -l {Quote} -u 0 -acc {<Control-q>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_quote %W}}
%W_mb.mb_edit.m add cascade -l Cut -u 0 -m %W_mb.mb_edit.m.cut
menu %W_mb.mb_edit.m.cut
%W_mb.mb_edit.m.cut add command -l {Region} -u 0 -acc {<Control-w>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_[winfo class %W]_kill_region %W}}
%W_mb.mb_edit.m add cascade -l Delete -u 0 -m %W_mb.mb_edit.m.delete
menu %W_mb.mb_edit.m.delete
%W_mb.mb_edit.m.delete add command -l {Selection} -u 0 -acc {<Control-BackSpace>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_[winfo class %W]_delete_selection %W}}
%W_mb.mb_edit.m add cascade -l Case -u 1 -m %W_mb.mb_edit.m.case
menu %W_mb.mb_edit.m.case
%W_mb.mb_edit.m.case add command -l {Upper} -u 0 -acc {<Meta-u>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_[winfo class %W]_filter %W th_string_toupper}}
%W_mb.mb_edit.m.case add command -l {Lower} -u 0 -acc {<Meta-l>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_[winfo class %W]_filter %W th_string_tolower}}
%W_mb.mb_edit.m.case add command -l {Capitalize} -u 0 -acc {<Meta-c>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_[winfo class %W]_filter %W th_string_capitalize}}
%W_mb.mb_edit.m add cascade -l Transpose -u 0 -m %W_mb.mb_edit.m.transpose
menu %W_mb.mb_edit.m.transpose
%W_mb.mb_edit.m.transpose add command -l {Characters} -u 0 -acc {<Control-t>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_[winfo class %W]_transpose_chars %W}}
%W_mb.mb_edit.m.transpose add command -l {Words} -u 0 -acc {<Meta-t>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_[winfo class %W]_transpose_words %W}}
%W_mb.mb_edit.m.cut add command -l {Line} -u 0 -acc {<Control-c>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_Canvas_kill_line %W}}
%W_mb.mb_edit.m.cut add command -l {All} -u 0 -acc {<Control-u>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  catch {th_Canvas_kill_range %W [%W focus] 0 end}}}
%W_mb.mb_edit.m.delete add cascade -l Character -u 0 -m %W_mb.mb_edit.m.delete.character
menu %W_mb.mb_edit.m.delete.character
%W_mb.mb_edit.m.delete.character add command -l {Previous} -u 0 -acc {<Control-h>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  catch {th_Canvas_delete_range %W [%W focus] [expr [%W index [%W focus] insert] - 1] [expr [%W index [%W focus] insert] - 1] 0}}}
%W_mb.mb_edit.m.delete.character add command -l {Next} -u 0 -acc {<Control-d>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  catch {th_Canvas_delete_range %W [%W focus] insert insert 0}}}
%W_mb.mb_edit.m.delete add cascade -l Word -u 0 -m %W_mb.mb_edit.m.delete.word
menu %W_mb.mb_edit.m.delete.word
%W_mb.mb_edit.m.delete.word add command -l {Previous} -u 0 -acc {<Meta-h>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  catch {if {[%W index [%W focus] insert] != 0} {th_Canvas_delete_range %W [%W focus] [string wordstart [%W itemcget [%W focus] -text] [expr [%W index [%W focus] insert] -1]] [expr [%W index [%W focus] insert] -1]}}}}
%W_mb.mb_edit.m.delete.word add command -l {Next} -u 0 -acc {<Meta-d>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  catch {th_Canvas_delete_range %W [%W focus] insert [expr [string wordend [%W itemcget [%W focus] -text] [%W index [%W focus] insert]] - 1]}}}
%W_mb.mb_edit.m.delete add command -l {Line} -u 0 -acc {<Control-k>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  catch {th_Canvas_delete_range %W [%W focus] insert [th_string_lineend [%W itemcget [%W focus] -text] [%W index [%W focus] insert]]}}}
%W_mb.mb_edit.m add command -l {Split Line} -u 0 -acc {<Control-o>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_Canvas_insert %W "\n" ; catch {th_Canvas_goto %W [expr [%W index [%W focus] insert] -1]}}}

menubutton %W_mb.mb_file -m %W_mb.mb_file.m -text File -u 0
pack %W_mb.mb_file -in %W_mb -side left
menu %W_mb.mb_file.m
%W_mb.mb_file.m add command -l {Save} -u 0 -acc {<Meta-s>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_save_file %W}}
%W_mb.mb_file.m add command -l {Save As} -u 5 -acc {<Meta-S>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_save_file_prompt %W}}
%W_mb.mb_file.m add checkbutton -variable TH(Pipe)\
  -onvalue 1 -offvalue 0 -l {Use a Pipe} -u 6 -acc {} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_checkbutton_variable Pipe}}

menubutton %W_mb.mb_search -m %W_mb.mb_search.m -text Search -u 0
pack %W_mb.mb_search -in %W_mb -side left
menu %W_mb.mb_search.m
%W_mb.mb_search.m add cascade -l String -u 0 -m %W_mb.mb_search.m.string
menu %W_mb.mb_search.m.string
%W_mb.mb_search.m.string add command -l {Forward} -u 0 -acc {<Control-s>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_Misc_search %W forward string}}
%W_mb.mb_search.m.string add command -l {Reverse} -u 0 -acc {<Control-r>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_Misc_search %W backward string}}
%W_mb.mb_search.m add cascade -l Regexp -u 0 -m %W_mb.mb_search.m.regexp
menu %W_mb.mb_search.m.regexp
%W_mb.mb_search.m.regexp add command -l {Forward} -u 0 -acc {<Control-S>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_Misc_search %W forward regexp}}
%W_mb.mb_search.m.regexp add command -l {Reverse} -u 0 -acc {<Control-R>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_Misc_search %W backward regexp}}
%W_mb.mb_search.m add checkbutton -variable TH(Search,Incremental,%W)\
  -onvalue 1 -offvalue 0 -l {Incremental Search} -u 0 -acc {<Meta-C>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_toggle_incremental_search %W}}
%W_mb.mb_extras.m add command -l {Complete} -u 0 -acc {<Escape>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_[winfo class %W]_complete_multiple %W [th_completions %W]}}
%W_mb.mb_extras.m add command -l {Show Completions} -u 0 -acc {<Control-Escape>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_[winfo class %W]_completion_dialog %W}}
%W_mb.mb_window.m add checkbutton -variable TH(Scrollbar,X,%W)\
  -onvalue 1 -offvalue 0 -l {X Scrollbar} -u 0 -acc {<Meta-X>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_toggle_scrollbar %W x bottom}}
%W_mb.mb_window.m add checkbutton -variable TH(Scrollbar,Y,%W)\
  -onvalue 1 -offvalue 0 -l {Y Scrollbar} -u 0 -acc {<Meta-Y>} -co {if {![winfo exists %W]} {destroy %W_mb} else {
  th_toggle_scrollbar %W y left}}


}

global TH
regsub -all "%W_mb" $code $TH(Menubar,$w) new_code
regsub -all %W $new_code $w code
eval $code
}


