# Shared mail routines

proc tag_section {w heading tag} {
  if {[set start [$w search -regexp -- "^$heading:" 1.0]] == ""} {return}
  if {[set end1 [$w search -- ": " "$start lineend"]] == ""} {set end1 end}
  if {[set end2 [$w search -regexp {^$} $start]] == ""} {set end2 end}
  if {($end1 == "end") && ($end2 == "end")} {set end "$start +1l"
  } elseif {[$w compare $end1 <= $end2]} {set end $end1} else {set end $end2}
  lappend end linestart
  $w tag add $tag $start $end
  $w tag add important $start $end
  $w tag add protect $start $end
}

proc add_section_tags {w} {
  global section_tags body_start
  if {[set body_start [$w search -regexp -- {^$} 1.0 end]] == ""} {
    set body_start end
  }
  foreach tag $section_tags {tag_section $w $tag $tag}
}

set mail_dir "$env(HOME)/Mail"

lappend section_tags To From Date Subject Cc cc
after 200 {
$w tag configure To -foreground yellow
$w tag configure CC -foreground yellow
$w tag configure Cc -foreground yellow
$w tag configure cc -foreground yellow
$w tag configure From -foreground cyan
$w tag configure Date -foreground red
$w tag configure Subject -foreground green
}
