#
# Bindings for Paragrath
#


set Bindings(Paragraph) {
  {Next_Para		{th_Text_goto %W [th_para_next %W insert]}}
  {Prev_Para		{th_Text_goto %W [th_para_prev %W insert]}}
  {Select_Para		{th_Text_select_group %W th_para_begin th_para_end}}
  {Split_Para 		{th_Text_para_change %W th_Text_split}}
  {Join_Para 		{th_Text_para_change %W th_Text_join}}
  {Reformat_Para	{th_Text_para_change %W th_Text_format}}
  {Newline 		{if $TH(Para,Narrow,%W) {th_Text_split %W [th_para_begin %W insert-1c] insert-1c}}}
  {Indent_Region 	{if $TH(Para,Narrow,%W) {th_bind "[th_frame %W].indent.e" OK "th_Text_para_indent %W"}}}
  {Delete_Indent 	{if $TH(Para,Narrow,%W) {th_bind "[th_frame %W].indent.e" OK "th_Text_para_indent %W 1"}}}
  {Narrow_Para 	 	{th_checkbutton_variable Para,Narrow,%W}}
}


# th_bind.tcl needs this to set up the Function menu and Key label.
set Local_Bindings {Next_Para Prev_Para Select_Para Split_Para Newline
	Join_Para Reformat_Para Indent_Region Delete_Indent Narrow_Para}


set TH_Bindings_Help {
Paragraph Functions

This module introduces the concept of paragraphs to text widgets. A paragraph
is any text bounded by two newlines (i.e. one blank line) on beginning and end.
It adds some simple editing and browsing commands for paragraphs. One can
traverse between paragraphs with Control-N and Control-P. Control-N puts the
cursor at the beginning of the next paragraph, and Control-P puts the cursor at
the beginning of the previous paragraph (or current one if it is not already
there). Also, one can select the current paragraph with Control-j.

				Control-
Paragraph:	Traversal:	 P - N
		Select:		   j

Text widgets with the paragraph module use word-wrap mode. This means that if a
line has more characters than the text widget can hold in one line, the excess
caracters are displayed on the next line, with the line break occuring between
words. While this is useful for making documents readable, it permits an
ambiguity in paragraph formats to exist. If a single line of characters wraps
across several lines in the text widget, we can call that a wide paragraph, or
a one-line paragraph. If, however, we break up that single line into several
lines by adding newlines at the 'virtual' line breaks, the paragraph looks
visibly unchanged, but certain aspects about it change. We call such a
paragraph a narrow paragraph (because all the lines are narrower than the
widget width) or a multi-line paragraph. The two types of paragraphs look
alike, but have very different behavior. For example, if you enlarge the text
widget, the narrow paragraph remains unchanged, but the wide paragraph expands
to fill the new window width. Also Tk's Up and Down arrow keys traverse single
lines in narrow paragraphs, but whole paragraphs in wide paragraphs. Paragrath
provides some support for both types of paragraphs, and allows you to convert
between them.

First, you can create a wide paragraph from a narrow paragraph by deleting all
of its interior newlines. The 'Join Paragraph' option does this automatically
for you, to use it, hit Control-J. Second, you can create a narrow paragraph
from a wide one by splitting the wide paragraph (a single line) into multiple
lines by adding newlines. The 'Split Paragraph' option does this for you; to
use it, hit Control-T. While editing narrow paragraphs, extra interior newlines
often appear in places where they are not necessary, breaking the paragraph
into more lines that are shorter than necessary. This can be fixed by doing a
join and then a split. The 'Format Paragraph' option does this for you; you can
use it by hitting Meta-j. All three options operate on the current selection,
or the paragraph containing the cursor if there are no selected characters. You
can split, join, or format multiple paragraphs with one keystroke...they all
ignore blank lines, so all the paragraphs remain autonomous.

Often you will want your paragraphs to be all wide or all narrow. The 'Narrow
Paragraphs' checkbutton should be set on if you want your paragraphs narrow,
otherwise it should be set off. You can toggle the checkbutton by typing
Meta-J. If on, it changes a few bindings to assist you in keeping your
paragraphs narrow. First, when you hit Return in narrow-paragraph mode, it
automatically splits the paragraph before the newline. Secondly, if you are
using edith's indent features, it improves the add-indent and delete-indent to
format your paragraph after indenting.

Paragraph:	Split:	   Control-T
		Join:	   Control-J
		Format:    Meta-j
		Narrow:	   Meta-J
}

