#  Bindings for Lispth 


set Bindings(Lisp) {
  {Next_Lisp_Fn		{th_Text_goto %W [th_defun_next %W insert]}}
  {Prev_Lisp_Fn		{th_Text_goto %W [th_defun_prev %W insert]}}
  {Select_Lisp_Fn	{th_Text_select_group %W th_defun_begin th_defun_end}}
  {Select_Lisp_Comment 	{th_Text_select_group %W th_lispcomment_begin th_lispcomment_end}}
  {Reformat_Lisp_Comment	{th_lispcomment_format %W [th_lispcomment_begin %W insert] [th_lispcomment_end %W insert]}}
}


# th_bind.tcl needs this to set up the Function menu and Key label.
set Local_Bindings {Next_Lisp_Fn Prev_Lisp_Fn Select_Lisp_Fn
	Select_Lisp_Comment Reformat_Lisp_Comment}


set TH_Bindings_Help {
Lisp Functions

This module introduces the concept of functions and comments in the Lisp
coding style to text widgets. It adds some simple editing and browsing
commands for functions and comments. One can traverse between functions with
Control-N and Control-P. Control-N puts the cursor at the beginning of the
next function, and Control-P puts the cursor at the beginning of the previous
function (or current one if it is not already there). One can select the
current function with Control-J. And one can select the current comment with
Control-j

There is one editing feature available. Meta-j will reformat the comment
containing the cursor, so that every line in the comment is as long as the
widget's width, but not longer.

				Control-
Function:	Traversal:	 P - N
		Select:		   J
Comment: 	Select: 	   j
		Reformat: 	Meta-j
}
