#
# Bindings for Edith
#

set Bindings(Edit) {
  {Undo 		{th_[winfo class %W]_undo %W}}
  {Show_Last_Undo 	{th_look_undo %W}}
  {Kill_Undo_Log 	{th_kill_undos %W}}
  {Yank 		{th_paste_selection %W -selection CLIPBOARD}}
  {Paste 		{th_paste_selection %W}}
  {B2-Paste		{if !$tkPriv(mouseMoved) {th_paste_selection %W}}}
  {Quote 		{th_quote %W}}
  {Kill_Region 		{th_[winfo class %W]_kill_region %W}}
  {Delete_Selection 	{th_[winfo class %W]_delete_selection %W}}
  {Uppercase_Region 	{th_[winfo class %W]_filter %W th_string_toupper}}
  {Lowercase_Region 	{th_[winfo class %W]_filter %W th_string_tolower}}
  {Capitalize_Region 	{th_[winfo class %W]_filter %W th_string_capitalize}}
  {Transpose_Chars 	{th_[winfo class %W]_transpose_chars %W}}
  {Transpose_Words 	{th_[winfo class %W]_transpose_words %W}}
}
set Bindings(Edit,Self_Insert) {
  {Toggle_Overwrite 	{th_checkbutton_variable Overwrite,%W}}
  {Self_Insert 		{th_[winfo class %W]_self_insert %W %A}}
}
set Bindings(Edit,Newline) {
  {Newline 		{th_[winfo class %W]_insert %W "\n"}}
}
set Bindings(Edit,Text) {
  {Kill_Line 		{th_Text_kill_line %W}}
  {Delete_Char_Backward	{th_Text_delete_range %W {insert -1 char} insert 0}}
  {Delete_Char_Forward	{th_Text_delete_range %W insert {insert +1 char} 0}}
  {Delete_Word_Backward	{th_Text_delete_range %W {insert -1 chars wordstart} insert}}
  {Delete_Word_Forward	{th_Text_delete_range %W insert {insert wordend}}}
  {Delete_Line 		{if [%W compare insert == {insert lineend}] {th_Text_delete_range %W insert insert+1c 1 1} else {th_Text_delete_range %W insert {insert lineend} 1 1}}}
  {Split_Line 		{th_Text_insert %W "\n" ; %W mark set insert "insert -1c" ; %W yview -pickplace insert}}
  {Indent_Region 	{th_indent %W th_Text_indent}}
  {Delete_Indent 	{th_indent %W th_Text_indent_delete}}
}
set Bindings(Edit,Entry) {
  {Kill_Line 		{th_Entry_kill_range %W insert end}}
  {Kill_All 		{th_Entry_kill_range %W 0 end}}
  {Delete_Char_Backward	{th_Entry_delete_range %W [expr [%W index insert] - 1] insert 0}}
  {Delete_Char_Forward	{th_Entry_delete_range %W insert [expr [%W index insert] + 1] 0}}
  {Delete_Word_Backward	{th_Entry_delete_range %W [string wordstart [%W get] [expr [%W index insert] - 1]] insert}}
  {Delete_Word_Forward	{th_Entry_delete_range %W insert [string wordend [%W get] [%W index insert]]}}
  {Delete_Line 		{th_Entry_delete_range %W insert end}}
}
set Bindings(Edit,Canvas) {
  {Kill_Line 		{th_Canvas_kill_line %W}}
  {Kill_All 		{catch {th_Canvas_kill_range %W [%W focus] 0 end}}}
  {Delete_Char_Backward	{catch {th_Canvas_delete_range %W [%W focus] [expr [%W index [%W focus] insert] - 1] [expr [%W index [%W focus] insert] - 1] 0}}}
  {Delete_Char_Forward	{catch {th_Canvas_delete_range %W [%W focus] insert insert 0}}}
  {Delete_Word_Backward	{catch {if {[%W index [%W focus] insert] != 0} {th_Canvas_delete_range %W [%W focus] [string wordstart [%W itemcget [%W focus] -text] [expr [%W index [%W focus] insert] -1]] [expr [%W index [%W focus] insert] -1]}}}}
  {Delete_Word_Forward	{catch {th_Canvas_delete_range %W [%W focus] insert [expr [string wordend [%W itemcget [%W focus] -text] [%W index [%W focus] insert]] - 1]}}}
  {Delete_Line 		{catch {th_Canvas_delete_range %W [%W focus] insert [th_string_lineend [%W itemcget [%W focus] -text] [%W index [%W focus] insert]]}}}
  {Split_Line 		{th_Canvas_insert %W "\n" ; catch {th_Canvas_goto %W [expr [%W index [%W focus] insert] -1]}}}
}


# th_bind.tcl needs this to set up the Function menu and Key label.
set Local_Bindings {Undo Show_Last_Undo Kill_Undo_Log Yank Paste B2-Paste
	Toggle_Overwrite Self_Insert Newline Quote Kill_Region Kill_All
	Delete_Char_Backward Delete_Char_Forward Delete_Word_Backward
	Delete_Word_Forward Delete_Selection Uppercase_Region Lowercase_Region
	Capitalize_Region Transpose_Chars Transpose_Words Split_Line
	Indent_Region Delete_Indent OK Cancel Delete_Line}


set TH_Bindings_Help {
Edit Functions

These are commands to alter the text contents in various widgets. They work on
text widgets, entry widgets, and text items in canvas widgets.

The most important are insertion commands. Pressing any key inserts that key
into the widget. If the Overwrite mode is on, then each key overwrites the
current character at the cursor, otherwise it gets inserted before the current
character. You can turn on or off the overwrite mode using Meta-o. Normally a
control character will not get inserted at all, even if it has no special
function. To insert a control character press Control-q before pressing the
control character.

Toggle overwrite mode:	Meta-o
Quote:			Control-q

One can erase text in one of two ways. You can 'cut' it, which removes it from
the window and puts it into a clipboard from which it can be retrieved later, or
you can delete text, which cannot be retrived again.

One can cut a line of text with Control-c. Control-c will remember the last
point where text was cut from, and one can increase the 'cut region' by hitting
Control-c repeatedly, which cuts another line, in text and canvas widgets, just
like the Control-k (Kill-line) command in Emacs. For entry widgets, Control-c
cuts the text from the insert to the end. In addition to Control-c, one can cut
the region between the insert cursor and the selection anchor with Control-w.
(In canvas widgets, you have to use browseth's features to set the anchor).
Control-w will cut the selection if the cursor is in text selected in the
current widget, othewise it tries to cut between cursor and anchor. Finally,
for entry and canvas widgets, Control-u kills all the text in the widget. (This
binding does not exist for text widgets; it would make it too easy to kill a
big file of text.)

Cut:	line:	Control-c
	region:	Control-w
	all:	Control-u

There are also two kinds of pasting.available. You can paste either the current
X selection, or the contents of Tk's clipboard, which get filled with a cut or
copy command (available from browseth). Use Control-v to paste the current
selection, or Control-y to paste the contents of the clipboard.

Paste:	Selection: 	Control-v
	Clipboard: 	Control-y

In lieu of cutting, one can delete characters or ranges of text. Unlike cut
text, deleted text cannot be pasted back. Control-d removes the character after
the insert cusror and Control-h removes the one before the cursor. The BackSpace
key has the same functionality as Control-h. You can delete words as well. The
Meta-d key deletes the range of the word from the cursor to the end, and the
Meta-h key deletes from beginning of the word containing the cursor to the
cursor. So does Meta-BackSpace. When the cursor is at a word boundary, these
delete the next and previous word, respectively. Also, you can delete the
current selection by hitting Control-BackSpace or just Delete. Finally, you can
delete the current line using Control-k. Control-k works just like Control-c
except that the deleted text doesn't get put on the clipboard.

		Next:			Previous:
Delete:	Char:	Control-d 		Control-h BackSpace
	Word:	Meta-d			Meta-h Meta-BackSpace
	Selection:	Control-BackSpace Delete
	Line: 		Control-k

There are a few functions to change the case of a range of letters. Meta-u, for
example, converts all letters within the selected region to UPPER CASE. If no
selected region exists, the characters between the cursor and the end of the
current word are UPPERCASED. Meta-l is similar, but it converts its range to
lower case. Finally, there is Meta-c, which Capitalizes Its Range Of Text.

Case:	Upper:	Meta-u
	Lower:	Meta-l
	Cap:	Meta-c

There are a handful of other editing features. Control-o inserts a newline
character *after* the insertion cursor, thereby splitting the cursor's line.
Control-t has the effect of transposing the two characters adjacent to the
cursor. For word transposition, Meta-t transposes two words around the cursor.
Actually, Both Control-t and Meta-t move the cursor further down the text, so
you can transpose characters or words repeatedly through the text. There is also
a command Control-i to indent the selected region. It prompts for an indentation
prefix, to be inserted at the start of every line. This is useful for indenting
a textual paragraph or commenting out lines of code, but is only available for
text widgets. Also there is Control-I which will delete an indentation prefix
from the selected lines of text.

Open line:		Control-o
Transpose:	Chars:	Control-t
		Words:	Meta-t
Indent:		Add:	Control-i 
		Delete:	Control-I

The last feature edith provides is the ability to undo almost every command
described above. The program keeps a log of the changes made by each command,
and so you can undo as many commands as you please. The key Meta-Control-u will
undo the last possible cmd.

All cut, paste, case-changing, transposition, and indent commands are all
undoable. So are deletions of words, lines, or regions. Basically, every command
is undoable except those that insert or remove a single character.

Undone commands do not reposition the insert cursor or the view of the widget.
For entry and canvas widgets, the entire contents are remembered for each
undoable command. Since text widgets usually contain too much text to make this
practical, text widgets use marks to indicate regions that recent commands
occurred in. This is much more efficient for text widgets, but it can sometimes
create confusion if undo marks get jumbled together during multiple undos.

If one is unsure about what might get undone by a Meta-Control-u press, one can
view the last command on the undo log, by typing Meta-Control-l. One can clear
the log with Meta-Control-k.

Log:	Last:	Meta-Control-l
	Kill:	Meta-Control-k
	Undo:	Meta-Control-u
}

