#
# Bindings for Cth
#


set Bindings(C) {
  {Next_C_Fn		{th_Text_goto %W [th_fn_next %W insert]}}
  {Prev_C_Fn		{th_Text_goto %W [th_fn_prev %W insert]}}
  {Select_C_Fn		{th_Text_select_group %W th_fn_begin th_fn_end}}
  {Select_C_Comment 	{th_Text_select_group %W th_ccomment_begin th_ccomment_end}}
  {Reformat_C_Comment	{th_ccomment_format %W [th_ccomment_begin %W insert] [th_ccomment_end %W insert]}}
}


# th_bind.tcl needs this to set up the Function menu and Key label.
set Local_Bindings {Next_C_Fn Prev_C_Fn Select_C_Fn Select_C_Comment
	Reformat_C_Comment}


set TH_Bindings_Help {
C Functions

This module introduces the concept of functions and comments in the C/C++
coding style to text widgets. It adds some simple editing and browsing
commands for functions and comments. One can traverse between functions with
Control-N and Control-P. Control-N puts the cursor at the beginning of the
next function, and Control-P puts the cursor at the beginning of the previous
function (or current one if it is not already there). One can select the
current function with Control-J. And, one can select the current comment with
Control-j.

There is one editing feature for comments. Meta-j can be used to reformat the
comment containing the cursor, so that every line in the comment is as long as
the widget's width, but not longer.

				Control-
Function:	Traversal:	 P - N
		Select:		   J
Comment: 	Select: 	   j
		Format: 	Meta-j
}
