# dv Installationsprogramm Version 1.0
#


#-----------------------------------------------------------------------------
# initvars {} initialisiert die Variablen
#-----------------------------------------------------------------------------
#
proc initvars {} {
  global vars diagdata

  # Vorgabe fuer die Installationspfade
  #
  set vars(startdir) "/usr/local/bin"
  set vars(miscdir)  "/usr/local/dv1.0b"
  set vars(progdir)  "/usr/local/dv1.0b/dvprogram"
  set vars(helpdir)  "/usr/local/dv1.0b/dvhelptext"
  set vars(datadir)  "/usr/local/dv1.0b/dvtestdata"

  # damit die Ladeanzeige richtig geloescht wird...
  #
  set diagdata(diagram) .
}

#-----------------------------------------------------------------------------
#  initprog {} initialisiert das Programm
#-----------------------------------------------------------------------------
#
proc initprog {} {

  global tk_version

  # fuer version 4.0 nicht installieren !
  #
  set version [cindex $tk_version 0]

  if {$version == "4"} {
     message .mesg -text "DataVision ist programmed for tcl3.6/tk7.3/tclx.\
     Please install that version of 'wishx' and start 'dvinstall' again.\
     If you like to install more than one version of 'wishx', then you can set\
     the variable 'WISHX_PATH' to the appropriate older version of 'wishx'." 
     pack .mesg
     button .but -text OK -command exit
     pack .but
     tkwait window . 
  }
  
  # Cursortasten links/rechts in Eingabefeldern realisieren
  #
  bindarrows

  # Focuswechsel bei Tab/Shift-Tab in Eingabefeldern realisieren
  #
  bindtabs

  # Focuswechsel bei Maus-Taste-1 gedrueckt
  #
  changefocus

  # fuer X11R6 Border Option setzen (fuer Darstellung der 3-d Reliefs)
  #
  global argv0 ;# in argv0 steht der Name des Interpreters
  option add dvinstall*BorderWidth 2
}

#-----------------------------------------------------------------------------
# getfilessize {} ermittelt die Groesse der uebergebenen Datei(baeume)
#            args   : Liste von  Dateien bzw. Directorys
#            return   GesamtGroesse der files in Bytes
#-----------------------------------------------------------------------------
# 
proc getfilessize {args} {

 set size 0
 foreach FileOrDir $args {
   set sizeline [exec du -s -b $FileOrDir]
   incr size [lindex $sizeline 0] 
 } 
return $size
}

#-----------------------------------------------------------------------------
# setstatusline {} Setzt einen Text in die Statuszeile des Hauptfensters
#                  message : String, der in die Statuszeile geschrieben wird
#-----------------------------------------------------------------------------
#
proc setstatusline {message} {

 ._main.status configure -text $message
 update idletask
}

# ---------------------------------------------------------------------------
# savestring {} Diese Funktion speichert einen String in ein File ab
#               Dabei werden nicht vorhandene Zielverzeichnisse erzeugt
#               und die Ladeanzeige gesetzt
#               string: der zu speicherende string
#               dest  : Zieldatei mit Pfadangabe.
# ---------------------------------------------------------------------------
#
proc savestring {string dest} {

  global vars

  # Gibt es schon alle Zielverzeichnisse ?
  #
  set destpath [file dirname $dest]
  if {![file isdirectory $destpath]} {
     # Nein, gibt's noch nicht!
     # Alle nicht vorhandenen Verzeichnisse des Zielepfades erstellen
     #
     mkdir -path $destpath
  }

  # Sicherheitsabfrage
  #
  if {[file exists $dest]} {
     error "file $dest already exists"
  }

  # String speichern
  #
  set f [open $dest w]
  puts $f $string

  # Ladeanzeige setzen
  #
  incr vars(size) [tell $f]
  setloadview ._main.loadview $vars(size) $vars(maxsize)

  close $f
}
   
# ---------------------------------------------------------------------------
# cp{}    Diese Funktion kopiert ein File. Dabei werden nicht vorhandene
#         Zielverzeichnisse erzeugt und die Ladeanzeige gesetzt.
#  
#         source  Die zu kopierende Datei mit kompletten Pfad
#
#         dest    Zieldatei mit Pfadangabe. Der Filename kann sich von
#                 dem source Filenamen unterscheiden.
#
# ---------------------------------------------------------------------------
#
proc cp {source dest} {

  global vars

  # Gibt es schon alle Zielverzeichnisse ?
  #
  set destpath [file dirname $dest]
  if {![file isdirectory $destpath]} {
     # Nein, gibt's noch nicht!
     # Alle nicht vorhandenen Verzeichnisse des Zielpfades erstellen
     #
     mkdir -path $destpath
  }     

  # Sicherheitsabfrage
  #
  if {[file exists $dest]} {
     error "file $dest already exists"
  }

  # Files oeffnen 
  #
  set fpr [open $source r]
  set fpw [open $dest w]

  # Statuszeile setzen
  #
  setstatusline "Installing \"$dest\""

  # Das eingentliche Kopieren
  #
  copyfile $fpr $fpw
 
  # Ladeanzeige setzen
  #
  incr vars(size) [tell $fpr]
  setloadview ._main.loadview $vars(size) $vars(maxsize)
 
  close $fpr
  close $fpw
}

#-----------------------------------------------------------------------------
# xcopy {} kopiert files bzw. ganze Verzeichnisse 
#          source : Liste aus file/directory namen 
#          dest   : Zielverzeichniss
#-----------------------------------------------------------------------------
#
proc xcopy {source dest} {

 foreach name $source {

    # alle files des Baumes $source ermitteln
    #
    set files [exec find $name -type f]
   
    # files copieren 
    #
    foreach file $files {
       cp $file "$dest/$file"
    }
  }
}
  
#-----------------------------------------------------------------------------
# install {} installiert DataVision
#-----------------------------------------------------------------------------
#
proc install {} {

 global vars env

 # Groesse aller zu installierender Dateien feststellen
 #	 
 setstatusline "Getting size of all files"
 set vars(size) 0
 set vars(maxsize) [getfilessize ../dv1.0b]

 # Ladeanzeige erzeugen
 #
 createloadview ._main.loadview Installing...

 # Startscript einlesen
 # 
 setstatusline "Loading start script"
 set f [open dvstart/dv r]
    set startscript [read $f]
 close $f

 # Pfade im Startscript einbauen
 #
 setstatusline "Configuring start script"
 regsub -- ---path_of_wishx---    $startscript $env(WISHX_PATH) startscript 
 regsub -- ---home_of_dv---       $startscript $vars(progdir)   startscript
 regsub -- ---dir_of_helptext---  $startscript $vars(helpdir)   startscript

 # Startscript installieren
 #
 setstatusline "saving start script to \"$vars(startdir)/dv\""
 savestring $startscript $vars(startdir)/dv 
 chmod 0755 $vars(startdir)/dv

 # alle anderen Dateien kopieren
 #
 xcopy "COPYRIGHT README anleitung dvinstall install dvstart" $vars(miscdir)
 cd dvprogram
 xcopy [glob *] $vars(progdir)
 cd ../dvhelptext
 xcopy [glob *] $vars(helpdir)
 cd ../dvtestdata
 xcopy [glob *] $vars(datadir)

 # Ladeanzeige auf voll setzen
 #
 setloadview ._main.loadview 1 1

 # Ladeanzeige zerstoeren
 #
 destroyloadview ._main.loadview

 setstatusline "DataVision is installed!!! --- type \"dv\" to start program." 
}

#-----------------------------------------------------------------------------
# buildwindow {} erzeugt das Hauptfenster
#-----------------------------------------------------------------------------
#
proc buildwindow {} {

global vars
 
 wm geometry . 522x300+340+0
 wm title . "dv install"

 frame ._main
 pack  ._main 

 label ._main.intro -text "DataVision Installation V 1.0" \
        -font "-Adobe-times-bold-r*240*"
 pack  ._main.intro -padx 100

 label ._main.written -text "written by Michael Boese in 1995"
 pack  ._main.written 

 frame ._main.configure -relief raised
 pack  ._main.configure -padx 10 -pady 5

 label ._main.configure.request -text "Please configure here..."
 pack  ._main.configure.request -pady 5

 frame ._main.configure.requests
 pack  ._main.configure.requests -side left 

 label ._main.configure.requests.startdir -text "directory of start script:"
 label ._main.configure.requests.miscdir -text "base directory of misc files:"
 label ._main.configure.requests.progdir -text "base directory of program code:"
 label ._main.configure.requests.helpdir -text "base directory of help pages:"
 label ._main.configure.requests.datadir -text "base directory of testdata:"
 pack  ._main.configure.requests.startdir ._main.configure.requests.miscdir\
       ._main.configure.requests.progdir  ._main.configure.requests.helpdir\
       ._main.configure.requests.datadir\
       -anchor w -ipadx 20

  frame ._main.configure.input
  pack  ._main.configure.input -side left -padx 20

  entry ._main.configure.input.startdir -text vars(startdir) -relief sunken
  entry ._main.configure.input.miscdir  -text vars(miscdir)  -relief sunken
  entry ._main.configure.input.progdir  -text vars(progdir)  -relief sunken
  entry ._main.configure.input.helpdir  -text vars(helpdir)  -relief sunken
  entry ._main.configure.input.datadir  -text vars(datadir)  -relief sunken
  pack  ._main.configure.input.startdir ._main.configure.input.miscdir\
        ._main.configure.input.progdir ._main.configure.input.helpdir\
        ._main.configure.input.datadir\
        -anchor w -ipadx 20

  label ._main.status
  pack  ._main.status -fill x  

  frame ._main.control
  pack  ._main.control -pady 10 -fill x

  button ._main.control.install -text Install -command {busy install}
  button ._main.control.cancel -text Cancel -command "destroy ."
  pack   ._main.control.install ._main.control.cancel\
         -side left -expand true -ipady 5 -ipadx 5

  # Focus auf erstes Eingabefeld
  #
  focus ._main.configure.input.startdir

  # Return-Taste wie Install-Aktivierung
  #
  bindreturn [findentries .] "._main.control.install invoke"
}


#---------------------------main----------------------------------------------

#  Hilfsroutinen einlesen
#
source dvprogram/tools/tools.tcl
source dvprogram/tools/dialog.tcl
source dvprogram/tools/tkerror.tcl

# Programm initialisieren
#
initprog

# Variablen initialisieren
#
initvars

# Hauptfenster aufbauen
#
buildwindow
