#-------------------dv-allgemeineHilfsmittel---------------------------------
#

#----------------------------------------------------------------------------
# findentries {} findet alle nicht deaktivierten widgets der Klasse Entry
#                im angegebenen Fenster
#                path   : identifiziert fenster ;
#                return : liste, die pfade der widgets enthaelt ;
#----------------------------------------------------------------------------
#
proc findentries {path} {
 
  # fuelle die Liste list mit allen Kindern des Widget $w
  #
  set list [winfo children $path]
 
  set entrylist ""
  foreach w $list {
     set class [winfo class $w]
     if {$class == "Entry"} {
         # die Klasse des Kindes mit Pfad $w ist Entry
         #
         if {[lindex [ $w configure -state] 4] != "disabled"} {
             # das Entry-widget mit Pfad $w ist nicht deaktiviert
             # => widget an Ergebnisliste anhaengen
             #
             lappend entrylist $w
         }
     }

     if {$class == "Frame"} {
         # das Kind-widget $w ist ein Frame (kann also weitere entries
         # enthalten) => rekursiever Aufruf (haenge alle gefundenen Entrys
         # der tieferen Ebene an die Ergebnisliste)
         #
         set entrylist [concat $entrylist [findentries $w]]
     }
  }
  return $entrylist
}

#----------------------------------------------------------------------------
# bindreturn {} bindet die Fenster der Liste an das Ereigniss
#               "Return gedrueckt", so dass das angegebene Kommando
#               ausgefuehrt wird, wenn der Focus auf einem der Listenfenster
#               steht.
#               list    : liste der Fenster, die auf Return reagieren sollen
#               command : auszufuehrendes kommando
#----------------------------------------------------------------------------
#
proc bindreturn {list command} {

  # Bindungen erstellen
  # 
  foreach w $list {
    bind $w <Return> $command
  }
}

#----------------------------------------------------------------------------
# bindarrows {} bindet an alle widget vom Typ "entry" die
#               Cursortastenfunktionen links/rechts
#----------------------------------------------------------------------------
#
proc bindarrows {} {
  bind Entry <Left>  {%W icursor [expr [%W index insert] - 1]; \
                      tk_entrySeeCaret %W}
  bind Entry <Right> {%W icursor [expr [%W index insert] + 1]; \
                      tk_entrySeeCaret %W} 
}
  
#----------------------------------------------------------------------------
# bindtab  {} bindet die Fenster der Liste an die Ereignisse "Tab gedrueckt"
#             und "Shift-Tab gedrueckt" , so dass der Eingabefocus bei
#             bei Betaetigung einer der Tastenkombinationen auf das naechste
#             bzw auf das vorherige Fenster der Liste gesetzt wird ; ist das
#             letzte Fenster erreicht, so wird der Focus auf das erste gesetzt
#             und umgekehrt
#             list : liste der Fenster, die auf Tab/Shift-Tab reagieren sollen
#-----------------------------------------------------------------------------
#
proc bindtab {list} {
 
  # setze listend auf hoechsten vorkommenen Listenindex
  #
  set listend [expr [llength $list]-1]
 
  # fuer auftretende Spezialfaelle das letze Element der Liste vor das erste
  # stellen und ans letzte Element das erste anhaengen
  #
  set l [lindex $list $listend]
  append l { } $list { } [lindex $list 0]
 
  # Bindungen erstellen
  #
  loop i 1 [expr $listend+2] {
       set last [lindex $l [expr $i-1]]
       set actual [lindex $l $i]
       set next [lindex $l [expr $i+1]]
       bind $actual <KeyPress-Tab> "$actual view 0; focus $next;\
                                    tk_entrySeeCaret $next"
       bind $actual <Shift-KeyPress-Tab> "$actual view 0; focus $last;\
                                          tk_entrySeeCaret $last"
  }
}

#----------------------------------------------------------------------------
# nextfocus {} stellt den Focus auf das naechste aktive Fenster vom Typ
#              Entry
#              actual : Fenster, auf das der Focus zeigt
#----------------------------------------------------------------------------
#
proc nextfocus {actual} {
   
   # toplevel des aktuellen Focusfensters ermitteln
   #
   set top [winfo toplevel $actual]
  
   # Liste mit allen aktiven widgets vom Typ "Entry" ermitteln 
   #
   set list [findentries $top]

   # naechstes FocusFensters aus der Liste ermitteln 
   #
   set actindex [lsearch -exact $list $actual]
   if {$actindex == [expr [llength $list]-1]} {
       # aktuelles Fenster ist letztes aktive Fenster=> Focus auf erstes aktive
       # Fenster
       #
       set next [lindex $list 0]
   } { 
       # aktuelles Fenster ist nicht letztes aktive Fenster => Focus auf  
       # naechstes aktive Fenster
       #
       set next [lindex $list [expr $actindex+1]]
   }
   
   # altes Eingabefeld so weit wie moeglich nach rechts ruecken 
   #
   $actual view 0

   # Focus auf neues Eingabefeld
   #
   focus $next
  
   # Kursor sichtbar machen
   #
   tk_entrySeeCaret $next
}

#----------------------------------------------------------------------------
# prevfocus {} stellt den Focus auf das vorherige aktive Fenster vom Typ
#              Entry
#              actual : Fenster, auf das der Focus zeigt
#----------------------------------------------------------------------------
#
proc prevfocus {actual} {
 
   # toplevel des aktuellen Focusfensters ermitteln
   #
   set top [winfo toplevel $actual]
 
   # Liste mit allen aktiven widgets vom Typ "Entry" ermitteln
   #
   set list [findentries $top]
 
   # vorheriges FocusFensters aus der Liste ermitteln
   #
   set actindex [lsearch -exact $list $actual]
   if {$actindex == 0} {

       # aktuelles Fenster ist erstes aktive Fenster=> Focus auf letztes aktive
       # Fenster
       #
       set next [lindex $list [expr [llength $list]-1]]
   } {
       # aktuelles Fenster ist nicht erstes aktive Fenster => Focus auf
       # vorheriges aktive Fenster
       #
       set next [lindex $list [expr $actindex-1]]
   }
  
   # altes Eingabefeld so weit wie moeglich nach rechts ruecken
   #
   $actual view 0
 
   # Focus auf neues Eingabefeld
   #
   focus $next
 
   # Kursor sichtbar machen
   #
   tk_entrySeeCaret $next
}

#----------------------------------------------------------------------------
# bindtabs {} bindet an alle Fenster vom Typ "entry" die Ereignisse
#             "TAB gedrueckt" bzw "SHIFT-TAB gedrueckt", so dass der Focus
#             bei Betaetigung auf das nachste bzw. vorherige aktive
#             EingabeFeld in der Packordnung des jeweiligen Fensters wechselt
#----------------------------------------------------------------------------
#
proc bindtabs {} {

  bind Entry <KeyPress-Tab> "nextfocus %W"
  bind Entry <Shift-KeyPress-Tab> "prevfocus %W"
}   

#----------------------------------------------------------------------------
# createloadview {} erzeugt eine Ladeanzeige; ein Rahmen, in dem die
#                   Ladeanzeige gesetzt wird muss bereits existieren
#                    
#                   path : widget-Pfad, der Anzeige
#                   name : Ueberschrift der Anzeige
#----------------------------------------------------------------------------
#
proc createloadview {path name} {

 
  # Rahmen fuer Ladeanzeige erzeugen
  #
  frame $path -relief ridge 
  place $path -rely 0.5 -relx 0.5 -anchor c

  # Ueberschrift setzen
  #
  label $path.title -text $name
  pack $path.title
 
  # Skalierung erzeugen
  #
  set dist [replicate . 50]
  label $path.scale -text "0%${dist}50%${dist}100%"
  pack $path.scale

  # auesseren Frame setzen
  #
  frame $path.outside -height 30 -relief sunken
  pack $path.outside -padx 5 -pady 5 -expand true -fill x

  # aktiv-Farbe einer Scrollbar ermitteln
  #
  scrollbar $path.scrolldummy
  set color [lindex [$path.scrolldummy configure -activeforeground] 4] 

  # inneren Frame setzen
  # 
  frame $path.outside.inside -height 30 -background $color 
  pack $path.outside.inside -side left
 
  update
}

#-----------------------------------------------------------------------------
# setloadview {} setzt die Ladeanzeige auf actuellen Wert
#                path : Pfad der Ladeanzeige
#                act  : aktueller Wert, auf den die Anzeige zu setzen ist
#                max  : maximaler Wert der Anzeige; entspricht 100%
#-----------------------------------------------------------------------------
#
proc setloadview {path act max} {

  # Balkengroesse der Anzeige ermitteln
  #
  set width [winfo width $path.outside]

  # aktuellen Wert skalieren
  #
  set pos [expr [double $act]*$width/$max-4]

  # neue Position setzen
  #
  $path.outside.inside config -width $pos

  update idletask
}

#----------------------------------------------------------------------------
# destroyloadview {} zerstoert eine Ladeanzeige
#              path : widgetpfad, in den die Ladeanzeige eingebaut wird
#---------------------------------------------------------------------------
#
proc destroyloadview {path} {

   # Ladeanzeige zerstoeren
   #
   destroy $path
} 

#----------------------------------------------------------------------------
# savefocus {} speichert den aktuellen focus  
#             globale Variable: status(oldfocus) Liste gespeicherter Focusse
#----------------------------------------------------------------------------
#
proc savefocus {} {

   # Statusvariable sichtbar machen
   #
   global status

   # Focus an Focusliste anhaengen
   #
   lvarcat status(oldfocus) [focus] 
}

#-----------------------------------------------------------------------------
# setoldfocus {} setzt den zuletzt gesicherten gueltigen focus 
#             globale Variable: status(focusold) Liste gespeicherter Focusse
#-----------------------------------------------------------------------------
#
proc setoldfocus {} {


  # Statusvariablen sichtbar machen
  #
  global status
 

  # ermittle zuletzt gespeicherten Focuspfad, dessen Fenter noch existiert
  #
  while {! [lempty $status(oldfocus)]} { 
    
     # letzten Listeneintrag ermitteln und aus Liste entfernen
     #
     set foc [lvarpop status(oldfocus) end]

     if {[winfo exists $foc]} {
        # Focusfenster existiert noch
        # => Focus setzen 
        #
        focus $foc
     
        # schleife verlassen
        #
        break 
     }
  } 
}
  
#----------------------------------------------------------------------------
# changefocus {} stellt den focus auf das toplevel eines widgets, falls
#                der Mauszeiger ueber dem widget steht und der linke Knopf
#                der Maus gedrueckt wird
#----------------------------------------------------------------------------
#
proc changefocus {} {

  bind all <Button-1> {
       savefocus
       set top [winfo toplevel %W]
       focus $top
  }
}

#----------------------------------------------------------------------------
# isdouble {} testet, ob der uebergebene String eine gueltige Fliesskomma-
#             zahl enthaelt
#             number : String, der zu ueberpruefen ist
#             return : 1, falls der String eine gueltige Zahl enthaelt
#                      0, sonst
#----------------------------------------------------------------------------
#
proc isdouble {number} {
  # Trick : berechne Minimum von $number und 1; falls Minimum berechenbar;
  #         ist $number eine Zahl
  if {[catch {min $number 1}]} {
     return 0
  } {
    return 1
  }
}

#----------------------------------------------------------------------------
# isint {} testet, ob der uebergebene String eine gueltige Integerzahl 
#          number : String, der zu ueberpruefgen ist
#          return : 1, falls der String eine gueltige Zahl enthaelt
#                   0, sonst
#----------------------------------------------------------------------------
#
proc isint {number} {
   regexp {^\-?[0-9]+$} $number
}

#----------------------------------------------------------------------------
# busy {} waehrend "cmds" ausgefuehrt wird wechselt das Mausicon zur Uhr. Im
#         ". Fenster" findet nur im Frame "main" ein Wechsel statt. 
#         cmds               : Befehlsstring, der ausgefuehrt wird 
#         busy               : Liste der Fenster, die zum Zeitpunkt des Aufrufs
#                              noch nicht existieren 
#         status(busybuffer) : wird im globalen Kontext erzeugt; enthaelt Pfade
#                              und Mausicons von Fenstern, die durch "cmds" 
#                              erzeugt werden
#----------------------------------------------------------------------------
#
proc busy {cmds} {
    global errorInfo

    # alle derzeit geoeffneten Fenster busy setzen, d.h. alle toplevelmausicons
    # sowie umdefinierte Mausicons aendern und in Liste speichern
    #
    set busy ._main 
    set list [winfo children .]
    while {$list != ""} {
        set next {}
        foreach w $list {
            set cursor [lindex [$w config -cursor] 4]
            if {[winfo toplevel $w] == $w || $cursor != ""} {
                lappend busy [list $w $cursor]
            }
            set next [concat $next [winfo children $w]]
        }
        set list $next
    }

    foreach w $busy {
        catch {[lindex $w 0] config -cursor watch}
    }
    update idletasks

    # nachtraeglich geoeffnete Fenster busy setzen, falls noetig
    #
    bind all <Reparent> {
       set w %W
       set status(busybuffer) ""
       set cursor [lindex [$w config -cursor] 4]
       if {[winfo toplevel $w] == $w || $cursor != ""} {
           lappend status(busybuffer) $w $cursor
       }
       catch {[lindex $w 0] config -cursor watch}
    }

    # uebergebene Befehlsfolge ausfuehren
    #
    set error [catch {uplevel eval [list $cmds]} result]
    catch {set ei $errorInfo}

    # Mauscursor-aenderungen rueckgaengig machen
    #
    bind all <Reparent> {}
    upvar #0 status(busybuffer) b
    catch {lvarcat b $busy}
    foreach w $b {
        catch {[lindex $w 0] config -cursor [lindex $w 1]}
    }
    unset b
    
    if $error {
        error $result $ei
    } else {
        return $result
    }
}

#----------------------------------------------------------------------------
# myraise {} macht ein Fenster auf dem Bildschirm vollstaendig sichtbari
#          (es gibt Probleme mit dem standart-raise-Kommando mit olvwm/fvwm)
#          widget    : widgetpfad des sichtbar zu machenden Fensters
#          geometry  : [clear|noclear] gibt an, ob nach dem hervorheben die
#                      geometry geloescht werden soll; default: clear
#----------------------------------------------------------------------------
#
proc myraise {widget {geometry clear}} {
   regexp -- {([0-9]*)x([0-9]*)\+([0-9]*)\+([0-9]*)} [wm geometry $widget] \
 		m w h x y

   wm withdraw $widget
   wm geometry $widget ${w}x$h+$x+$y
   wm deiconify $widget
   if {$geometry == "clear"} {
       wm geometry $widget ""
   }
}

#----------------------------------------------------------------------------
# cutpath {} kuerzt den angegebenen WidgetPfad. Es werden "cut" Pfadsegmente
#            vom Ende des Pfades ausgehend geloescht. Ist cut nicht angegeben,
#            so wird nur das letzte Segment geloescht. 
#            p      : zu kuerzender Pfad
#            cut    : Anzahl der zu kuerzenden Segmente
#            return : gekuerzter Pfad
#----------------------------------------------------------------------------
#
proc cutpath {path {cut 1}} {

  # Pfad in Liste umwandeln
  #
  set pathlist [split $path .]

  # Anzahl der Segmente ermitteln 
  #
  set seglength [llength $pathlist]

  # Endsegmentindex des gekuerzten Pfades berechnen
  #
  set lastsegindex [expr $seglength-$cut-1]

  # Segmentliste des gekuerzten Pfades berechnen
  #
  set cutlist [lrange $pathlist 0 $lastsegindex]

  # Segmentliste in string umwandeln 
  #
  set cutpath [join $cutlist .]

  return $cutpath
}

#----------------------------------------------------------------------------
# refreshwindows {} Prozedur, die Fenster erneuert, die Werte des 
#                   Diagrammdatensatzes $dp enthalten. 
#                   Die Prozedur geht davon aus, dass alle Fenster, die
#                   erneutert werden muessen, eine refreshroutine 
#                   in der Form 
#                    [widgetpfad].refresh {Fensterpfad diagramwidgetpfad}
#                   generieren. Es werden nur das wish-Fenster, frames
#                   und toplevel auf Refreshroutinen untersucht
#                   dp    : aktueller Diagrammwidgetpfad
#                   args  : Startpfadliste der Widgetsuche 
#----------------------------------------------------------------------------
#
proc refreshwindows {dp args} {

  # Breitensuche mit Startpunkten "args"
  #
  while {$args != ""} {
    set widget [lvarpop args]
    if {[winfo exists $widget]} {
       # das vorher gefundene Fenster existiert
       # (ein Refresh haette ein Fenster zerstoeren koennen)
       #
       set class [winfo class $widget]
       if {$class == "Tk" || $class == "Toplevel" || $class == "Frame"} { 
         # widget enthaelt moeglicherweise (interessante) Kinder=>
         # Kinder an Argumentenliste anhaengen
         #            
         set children [winfo children $widget]
         lvarcat args $children
         if {[string match $dp* $widget]} { 
             # Fenster $widget stellt Daten aus Datensatz $dp dar =>
             # zugehoerigen Refresh aufrufen, falls vorhanden 
             #
             set callrefresh [info procs $widget.refresh]
             if {$callrefresh != ""} {
                 $callrefresh $widget $dp
                 update
             } ; # if Refreshprozedur existent
          } ; # if Fenster stellt Daten fuer $dp dar
       } ; # if widget enthaelt interessante Kinder
    } ; # if Fenster existiert noch
  } ; # while
}

#----------------------------------------------------------------------------
# setoptioncolors {} setzt die Farben uebergebenen Farbparameter
#                   in die Resource-Datenbasis. 
#                   background :  Farbattribut
#                   foreground :       "
#                   disabled   :       "
#                   active     :       "
#                   spot       :       "
#                   insertion  :       "
#----------------------------------------------------------------------------
#
proc setoptioncolors {background foreground disabled
                     active spot insertion} {


 # Programmname 
 #
 global argv
 set pname [lindex $argv 0]

 # setze Farben fuer Klasse Button
 #
 option add $pname*Button.activeBackground $active
 option add $pname*Button.activeForeground $foreground
 option add $pname*Button.background $background
 option add $pname*Button.disabledForeground $disabled
 option add $pname*Button.foreground $foreground

 # setze Farben fuer Klasse Canvas
 #
 option add $pname*Canvas.background $background
 option add $pname*Canvas.insertBackground $insertion
 option add $pname*Canvas.selectBackground $active
 option add $pname*Canvas.selectForeground $foreground
 
 # setze Farben fuer Klasse Checkbutton
 #
 option add $pname*Checkbutton.activeBackground $active
 option add $pname*Checkbutton.activeForeground $foreground
 option add $pname*Checkbutton.background $background
 option add $pname*Checkbutton.disabledForeground $disabled
 option add $pname*Checkbutton.foreground $foreground
 option add $pname*Checkbutton.selector $spot

 # setze Farben fuer Klasse Entry
 #
 option add $pname*Entry.background $insertion
 option add $pname*Entry.foreground $foreground
#option add $pname*Entry.insertBackground $insertion
 option add $pname*Entry.selectBackground $active
 option add $pname*Entry.selectForeground $foreground

 # setze Farben fuer Klasse Frame
 # 
 option add $pname*Frame.background $background

 # setze Farben fuer Klasse Label
 #
 option add $pname*Label.background $background
 option add $pname*Label.foreground $foreground

 # setze Farben fuer Klasse Listbox
 #
 option add $pname*Listbox.background $background
 option add $pname*Listbox.foreground $foreground
 option add $pname*Listbox.selectBackground $active
 option add $pname*Listbox.selectForeground $foreground

 # setze Farben fuer Klasse Menu
 #
 option add $pname*Menu.activeBackground $active
 option add $pname*Menu.activeForeground $foreground
 option add $pname*Menu.background $background
 option add $pname*Menu.disabledForeground $disabled
 option add $pname*Menu.foreground $foreground
 option add $pname*Menu.selector $spot

 # setze Farben fuer Klasse Menubutton
 #
 option add $pname*Menubutton.activeBackground $active
 option add $pname*Menubutton.activeForeground $foreground
 option add $pname*Menubutton.background $background
 option add $pname*Menubutton.disabledForeground $disabled
 option add $pname*Menubutton.foreground $foreground

 # setze Farben fuer Klasse Message
 #
 option add $pname*Message.background $background
 option add $pname*Message.foreground $foreground

 # setze Farben fuer Klasse Radiobutton
 #
 option add $pname*Radiobutton.activeBackground $active
 option add $pname*Radiobutton.activeForeground $foreground
 option add $pname*Radiobutton.background $background
 option add $pname*Radiobutton.disabledForeground $disabled
 option add $pname*Radiobutton.foreground $foreground
 option add $pname*Radiobutton.selector $spot

 # setze Farben fuer Klasse Scale
 #
 option add $pname*Scale.activeForeground $spot
 option add $pname*Scale.sliderForeground $active
 option add $pname*Scale.background $background
 option add $pname*Scale.foreground $foreground

 # setze Farben fuer Klasse Scrollbar
 #
 option add $pname*Scrollbar.activeForeground $spot
 option add $pname*Scrollbar.background $active
 option add $pname*Scrollbar.foreground $background

 # setze Farben fuer Klasse Text
 #
 option add $pname*Text.background $background
 option add $pname*Text.foreground $foreground
#option add $pname*Text.insertBackground $background
 option add $pname*Text.selectBackground $active
 option add $pname*Text.selectForeground $foreground

 # setze Farben fuer die Klasse Tk
 #
 option add $pname*Tk.background $background

 # setze Farben fuer Klasse Toplevel
 #
 option add $pname*Toplevel.background $background
}
 
#----------------------------------------------------------------------------
# setwidgetcolor {} setzt die Farbe eines widgets gemaess der uebergebenen
#                   Farbparameter, falls dieses Widget zu einer
#                   TK-Standartklasse gehoert; die Klasse Tk ("." Fenster)
#                   wird nicht gesetzt
#                   path       : Pfad des zu faerbenden widgets
#                   background :  Farbattribut
#                   foreground :       "
#                   disabled   :       "
#                   active     :       "
#                   spot       :       "
#                   insertion  :       "
#----------------------------------------------------------------------------
#                               
proc setwidgetcolor {path background foreground disabled
                          active spot insertion} {

   # Farbeinstellung fuer das  Widget je nach Klasse setzen
   #
   set class [winfo class $path]

   switch $class {
   
       Button {$path config -activebackground $active
               $path config -activeforeground $foreground
               $path config -background $background
               $path config -disabledforeground $disabled
               $path config -foreground $foreground
       }

       Canvas {$path config -background $background
               $path config -insertbackground $insertion
               $path config -selectbackground $active
               $path config -selectforeground $foreground
       }

       Checkbutton {
               $path config -activebackground $active
               $path config -activeforeground $foreground
               $path config -background $background
               $path config -disabledforeground $disabled
               $path config -foreground $foreground
               $path config -selector $spot
       }

       Entry {
               $path config -background $insertion
               $path config -foreground $foreground
              #$path config -insertbackground $insertion
               $path config -selectbackground $active
               $path config -selectforeground $foreground
       }
      
       Frame { $path config -background $background
       }

       Label { $path config -background $background
               $path config -foreground $foreground
       }

       Listbox {
              $path config -background $background
              $path config -foreground $foreground
              $path config -selectbackground $active
              $path config -selectforeground $foreground
       }

       Menu {
              $path config -activebackground $active
              $path config -activeforeground $foreground
              $path config -background $background
              $path config -disabledforeground $disabled
              $path config -foreground $foreground
              $path config -selector $spot
       }

       Menubutton {
              $path config -activebackground $active
              $path config -activeforeground $foreground
              $path config -background $background
              $path config -disabledforeground $disabled
              $path config -foreground $foreground
       }

       Message {
              $path config -background $background
              $path config -foreground $foreground
       }

       Radiobutton {
              $path config -activebackground $active
              $path config -activeforeground $foreground
              $path config -background $background
              $path config -disabledforeground $disabled
              $path config -foreground $foreground
              $path config -selector $spot
       }

       Scale {
              $path config -activeforeground $spot
              $path config -sliderforeground $active
              $path config -background $background
              $path config -foreground $foreground
             
       }
      
       Scrollbar {
              $path config -activeforeground $spot
              $path config -background $active
              $path config -foreground $background
       }
      
       Text {
              $path config -background $background
              $path config -foreground $foreground
             #$path config -insertbackground $background
              $path config -selectbackground $active
              $path config -selectforeground $foreground
            }

       Toplevel {
             $path config -background $background
       }
   } ; # switch
} ; # setwidgetcolor 
