#--------dv----Menue zum waehlen einer beliebigen Zeichenflaechengroesse----

#----------------------------------------------------------------------------
# decrslider {} hilfsroutine, die die aktuelle Position eines Schiebereglers
#             um 1 verkleinert  
#             path : widget-Pfad des zugehoerigen Schiebereglers
#----------------------------------------------------------------------------
#
proc decrslider {path} {
     
  set aktpos [$path get]
  set newpos [expr $aktpos-1]
  $path set $newpos 
}
 
#----------------------------------------------------------------------------
# incrslider {} hilfroutine, die die aktuelle Position eines Schiebereglers
#             um 1 vergroessert
#             path : widget-Pfad des zugehoerigen Schiebereglers
#----------------------------------------------------------------------------
#
proc incrslider {path} {
     
  set aktpos [$path get]
  set newpos [expr $aktpos+1]
  $path set $newpos
}

#-----------------------------------------------------------------------------
# diagothersizemenuok {} wird aufgerufen, falls in diagothersizemenu der
#                        ok-knopf aktiviert wird; kopiert die aktuellen Schiebe-
#                        reglerstellungen in die zugehoerigen Variablen;
#                        path : Pfad des diagothersizemenues
#                        dp   : Widget-Pfad des zugehoerigen Diagramms
#-----------------------------------------------------------------------------
#
proc diagothersizemenuok {path dp} {

  # Diagrammvariablen sichtbar machen
  #
  global diagdata 

  # Reglerstellungen ermitteln
  # 
  set xsize [$path.othersize.input.xsize get]
  set ysize [$path.othersize.input.ysize get] 

  # eingestellten Werte abspeichern 
  #
  set diagdata($dp.sizex) $xsize
  set diagdata($dp.sizey) $ysize
} 
                                      
#----------------------------------------------------------------------------
# diagothersizemenu {} erzeugt Menue, um eine beliebige Diagrammgroesse 
#                  zwischen 0 und 1100 Pixeln einstellen zu koennen
#                  path : Pfad, in den das Menue eingehaengt wird
#                  dp   : pfad des zugehoerigen Diagramms
#----------------------------------------------------------------------------
#
proc diagothersizemenu {path dp} {

  # falls toplevel schon existiert, Fenster hervorheben
  #
  if {[winfo exist $path.othersize]} {
      myraise $path.othersize
      return
  }

  # Diagramm und Statusvariablen sichtbar machen
  #
  global diagdata status

  # erzeuge toplevel fuer das othersizemenue
  #
  toplevel $path.othersize

  # Bitmap fuer icon setzen
  #
  global env
  wm iconbitmap $path.othersize @$env(DV_HOME)/bitmaps/statist.xbm
  wm iconname   $path.othersize Size

  # alten Focus speichern; focus auf dieses toplevelfenster
  #
  savefocus 
  focus $path.othersize

  # Titel des Menues setzen
  #
  wm title $path.othersize \
     "[string toupper $diagdata($dp.frametitle)] Size Menu"

  # Eingabeaufforderung setzen
  #
  label $path.othersize.heading -text "Choose Diagram Size" -relief raised
  pack $path.othersize.heading -expand true -fill x

  # erzeuge Frame fuer Schieberegler
  #
  frame $path.othersize.input -relief raised
  pack $path.othersize.input

  # ermittle aktuell gesetzten Hintergrund des toplevels
  #
  set bg [lindex [$path.othersize configure -background] 4]

   # erzeuge Schieberegler fuer Groesseneinstellung 
   #
   scale $path.othersize.input.ysize -from 1100 -to 100 -tickinterval 200\
         -label "ysize" -length 200 -showvalue true -bg $bg 
   pack $path.othersize.input.ysize -side right -pady 50 

   scale $path.othersize.input.xsize -from 100 -to 1100 -tickinterval 200\
        -label "xsize" -length 200 -showvalue true -orient horizontal -bg $bg

   pack $path.othersize.input.xsize -padx 10 -pady 10

   # definiere refreshprozedur
   #
   proc $path.othersize.refresh {path dp} {

      # Statusvariablen sichtbar machen
      #
      global status

      # Schieberegler auf aktuelle Werte setzen
      #
      $path.input.ysize set $status($dp.sizeybuffer)

      $path.input.xsize set $status($dp.sizexbuffer)

   } ; # refresh

   # refresh zur Initialisierung aufrufen
   #
   $path.othersize.refresh $path.othersize $dp 

   # erzeuge message-widget fuer Hinweiss-text
   #
   message $path.othersize.input.hint -font "-Adobe-times-*-r*180*" \
           -text "hint: use cursorkeys for soft-move of sliders"  
   pack $path.othersize.input.hint -expand true
   
  # bindings fuer soft-slider-Bewegung erzeugen
  #
  bind $path.othersize <Left>  "decrslider $path.othersize.input.xsize"
  bind $path.othersize <Right> "incrslider $path.othersize.input.xsize"
  bind $path.othersize <Up>    "incrslider $path.othersize.input.ysize"
  bind $path.othersize <Down>  "decrslider $path.othersize.input.ysize"

  # Return-Taste wie Ok-Knopf Bestaetigung einbinden
  #
  bind $path.othersize <Return> "$path.othersize.switch.ok invoke"
 
  # Frame fuer Ok-Knopf und Abbruch-Knopf realisieren
  #
  frame $path.othersize.switch
  pack $path.othersize.switch -expand true -fill x
 
   # Ok-Knopf realisieren ; falls ok gedrueckt Schiebereglerwerte uebernehmen
   #
   button $path.othersize.switch.ok -text "OK" \
          -command "busy {diagothersizemenuok $path $dp;
                          destroy $path.othersize;setoldfocus;
                          refreshwindows $dp .}"
   pack $path.othersize.switch.ok -side left -padx 5 -pady 5 -expand true \
        -fill both -ipady 5

   # update-Knopf realisieren
   #
   button $path.othersize.switch.update -text "update" \
          -command "busy {diagothersizemenuok $path $dp; refreshwindows $dp .}"
   pack $path.othersize.switch.update -side left -padx 5 -pady 5 -expand true \
        -fill both -ipady 5
 
   # Cancel-Knopf realisieren; falls cancel gedrueckt nur Fenster zerstoeren
   #
   button $path.othersize.switch.cancel  -text "Cancel" \
          -command "setoldfocus; destroy $path.othersize"
   pack $path.othersize.switch.cancel -side left -padx 5 -pady 5 -expand true\
        -fill both -ipady 5
} 
