/* Copyright (c) 1994
 *      Zbigniew Wieckowski (wieckows@cs.umn.edu)
 *
 * Permission is granted to freely use, copy, modify, and redistribute
 * this software under the terms of the GPL licence agreement.
 */

#ifdef __cplusplus
extern "C" {
#endif

void alert(char*);

void discardMeta();

int deactActMB();

int reqAltAction();

int resetStatus();

int sendName(
#if defined(__STDC__) || defined(__cplusplus)
const char*, const char
#endif
);

int sendContexts(
#if defined(__STDC__) || defined(__cplusplus)
const char*
#endif
);

int matchglob(
#if defined(__STDC__) || defined(__cplusplus)
const char*, const char*
#endif
);

#ifdef __cplusplus
};
#endif

#include "myScreen.h"
#include "agent.h"

const char* const META_STR = "\034";

extern void clear_tcl_in();

extern void setTimeoutValues(int, long, int, long, short);

void screen::process_line(char* &line_toappl, int* toappllen,
			  char* &line_touser, int* touserlen,
			  int* callback, char* &next_input, int* longwait)
{
   static line_link* cd_line;
   static int cd_pos;
   char tmpline[MAX_LINE];
   int tlen;
   int skip_proc_line = 0;
   int dont_discard = 0;
   mode proc_mode = 0 == *toappllen ? out : in;
   log_line(proc_mode, line_toappl, toappllen, line_touser, touserlen,
	    tmpline, &tlen);

   line_toappl[*toappllen] = '\0';
   line_touser[*touserlen] = '\0';
   if (kwrd_in && in == proc_mode) {
      int i = 0;
      while (line_toappl[i] != META_CHAR && i != *toappllen)
	 i++;
      if (!(i != *toappllen)) {
	 new_macro->macroName->add(line_toappl, *toappllen);
	 *toappllen = 0;
      }
      else {
	 line_toappl[i++] = '\0';
	 new_macro->macroName->add(line_toappl, *toappllen);
	 kwrd_in = 0;
	 curr_md = in;
	 new_macro->macro->empty();
	 for (int j = 0; j < new_macro->macroName->length(); j++) {
	    *new_macro->macro += META_CHAR;
	    new_macro->macro->add("x|del", 5);
	    *new_macro->macro += META_CHAR;
	 }
	 *new_macro->macro += META_CHAR;
	 new_macro->macro->add("x|hb", 4);
	 *new_macro->macro += META_CHAR;
	 *new_macro->macro += *new_macro->macroName;
	 *new_macro->macro += META_CHAR;
	 new_macro->macro->add("x|he", 4);
	 *new_macro->macro += META_CHAR;
	 insert_macro();
      }
      return;
   }
   if (curr_md != cmd && out == proc_mode && *touserlen != 0) {
      int matched = 0;
      int i = 0;
      *touserlen = 0;
      do {
	 macro_link* found = 0;
	 int advance = 1;
	 for (match_link* m = matches; m->match != 0;
	      advance ? m = m->next, advance : advance = 1)
	    if (tmpline[i] != m->match->macroName->realstr()[m->count++]) {
	       match_link* t = m->next;
	       *m = *t;
	       delete t;
	       advance = 0;
	    }
	    else {
	       matched = !(m->match->macroName->length() != m->count);
	       for (short ocn = 0; matched && m->match->context[ocn] &&
		    ocn < MAX_CONTEXTS; ocn++) {
		  short this_cont_found = 0;
		  for (short cn = 0; !this_cont_found && context[cn] &&
		       cn < MAX_CONTEXTS; cn++) {
		     if (strcmp("linemode", context[cn]->realstr()) &&
			 strcmp("nolongwait", context[cn]->realstr()) &&
			 matchglob(context[cn]->realstr(),
				   m->match->context[ocn]->realstr()))
			this_cont_found = 1;
		  }
		  matched = matched && this_cont_found;
	       }
	       if (matched) {
		  kwrd_line_cnt[curr_y]++;
		  total_keywords++;
		  found = m->match;
		  for (match_link* m1 = matches; m1->match != 0;
		       m1 = matches) {
		     matches = m1->next;
		     delete m1;
		  }
		  m = matches;
		  advance = 0;
		  char tmp[MAX_LINE];
		  line_touser[(*touserlen)++] = tmpline[i++];
		  memcpy(tmp, found->macro->realstr(),
			  found->macro->length());
		  int j = 0;
		  const int jmax = found->macro->length();
		  
		  do {
		     if (tmp[j] != META_CHAR)
			line_touser[(*touserlen)++] = tmp[j++];
		     else if (tmp[j + 1] != 'x' && tmp[j + 1] != 't') {
			cerr << "Unknown chichot control sequence" << endl;
			exit(1);
		     }
		     else if ('x' == tmp[j + 1]) {
			for(int k = j + 2; k < jmax &&
			    tmp[k] != META_CHAR; k++);

			char tmp1[MAX_NAME];
			memcpy(tmp1, &tmp[j + 2], k - j - 2);
			tmp1[k - j - 2] = '\0';
			for (macro_link* b1 = olexicon[*tmp1]; b1 &&
			     memcmp(b1->macroName->realstr(), tmp1,
				     b1->macroName->length());
			     b1 = b1->lexptr);
			if (0 == b1) {
			   cerr << "Macro not found:" << tmp1 << endl;
			   exit(1);
			}
			memcpy(&line_touser[*touserlen], b1->macro->realstr(),
				b1->macro->length());
			*touserlen += b1->macro->length();
			j = k + 1;
		     } else {
			for(int k = j + 2; k < jmax &&
			    tmp[k] != META_CHAR; k++);
			allcontexts = new string(&tmp[j + 2], k - j - 2);
			context_change = 0;
			for (short cn = 0; 0 != context[cn] &&
			     cn < MAX_CONTEXTS; cn++) {
			   context[cn]->empty();
			   context[cn] = 0;
			}
			short quote = 0;
			string *newcontexts = new string();
			for (int m = 0; m < allcontexts->length(); m++)
			   if (quote) {
			      if ('n' == allcontexts->realstr()[m]) {
				 *newcontexts += '\n';
			      } else {
				 *newcontexts += '\\';
				 *newcontexts += allcontexts->realstr()[m];
			      }
			      quote = 0;
			   } else {
			      if ('\\' == allcontexts->realstr()[m]) {
				 quote = 1;
			      } else {
				 *newcontexts += allcontexts->realstr()[m];
			      }
			   }
			allcontexts->empty();
			*allcontexts = *newcontexts;
			newcontexts->empty();
			delete newcontexts;
			int beg = 0;
			int ind = 0;
			cn = 0;
			short done = 0;
			while (!done) {
			   while (allcontexts->realstr()[ind] != '\n' &&
				  allcontexts->realstr()[ind] != '\0')
			      ind++;
			   if ('\0' == allcontexts->realstr()[ind]) {
			      done = 1;
			   } else {
			      allcontexts->realstr()[ind] = '\0';
			   }
			   if (MAX_CONTEXTS == cn) {
			      strcpy(&line_touser[(*touserlen)],
				     "Out of context space");
			      *touserlen += strlen("Out of context space");
			   }
			   context[cn++] =
			      new string(&allcontexts->realstr()[beg],
				       strlen(&allcontexts->realstr()[beg]));
			   if (!done) {
			      allcontexts->realstr()[ind] = '\n';
			   }
			   beg = ++ind;
			}
			if (!prevcontexts || strcmp(allcontexts->realstr(),
				   prevcontexts->realstr())) {
			   sendContexts(allcontexts->realstr());
			   updateStatus();
			}
			if (prevcontexts) {
			   prevcontexts->empty();
			   delete prevcontexts;
			}
			prevcontexts =
			   new string(allcontexts->realstr(),
				      strlen(allcontexts->realstr()));
			allcontexts->empty();
			delete allcontexts;
			allcontexts = 0;
			j = k + 1;
		     }
		  } while (j != jmax);
	       }
	    }
	 if (!found) {
	    for (macro_link* b = olexicon[tmpline[i]]; b != 0;
		 b = b->lexptr) {
	       match_link* m1 = new match_link();
	       m1->match = b;
	       m1->count = 1;
	       m1->next = matches;
	       matches = m1;
	    }
	    line_touser[(*touserlen)++] = tmpline[i++];
	 }
      } while (i != tlen);
      if (!agent_active)
	 return;
   }
   if (in == proc_mode && context_change) {
      int i = 0;
      while (line_toappl[i] != '\0' && line_toappl[i] != META_CHAR)
	 i++;
      if (META_CHAR == line_toappl[i]) {
	 line_toappl[i] = '\0';
	 allcontexts->add(&line_toappl[0], strlen(&line_toappl[0]));
	 context_change = 0;
	 curr_md = undef;
	 for (short cn = 0; 0 != context[cn] && cn < MAX_CONTEXTS; cn++) {
	    context[cn]->empty();
	    context[cn] = 0;
	 }
	 short quote = 0;
	 string *newcontexts = new string();
	 for (int m = 0; m < allcontexts->length(); m++)
	    if (quote) {
	       if ('n' == allcontexts->realstr()[m]) {
		  *newcontexts += '\n';
	       } else {
		  *newcontexts += '\\';
		  *newcontexts += allcontexts->realstr()[m];
	       }
	       quote = 0;
	    } else {
	       if ('\\' == allcontexts->realstr()[m]) {
		  quote = 1;
	       } else {
		  *newcontexts += allcontexts->realstr()[m];
	       }
	    }
	 allcontexts->empty();
	 *allcontexts = *newcontexts;
	 newcontexts->empty();
	 delete newcontexts;
	 int beg = 0;
	 int ind = 0;
	 cn = 0;
	 short done = 0;
	 while (!done) {
	    while (allcontexts->realstr()[ind] != '\n' &&
		   allcontexts->realstr()[ind] != '\0')
	       ind++;
	    if ('\0' == allcontexts->realstr()[ind]) {
	       done = 1;
	    } else {
	       allcontexts->realstr()[ind] = '\0';
	    }
	    if (MAX_CONTEXTS == cn) {
	       strcpy(&line_touser[(*touserlen)], "Out of context space");
	       *touserlen += strlen("Out of context space");
	    }
	    context[cn++] = new string(&allcontexts->realstr()[beg],
				       strlen(&(allcontexts->realstr()[beg])));
	    if (!done) {
	       allcontexts->realstr()[ind] = '\n';
	    }
	    beg = ++ind;
	 }
	 sendContexts(allcontexts->realstr());
	 updateStatus();
	 allcontexts->empty();
      }
      else {
	 allcontexts->add(&line_toappl[0], strlen(&line_toappl[0]));
	 line_toappl[0] = '\0';
	 *toappllen = 0;
      }
   }
   if (in == proc_mode && def_out) {
      if (name_out) {
	 int i = 0;
	 int inp = 0;
	 int j = 0;
	 while (line_toappl[i] != '\0' && line_toappl[i] != META_CHAR)
	    i++;
	 if (META_CHAR == line_toappl[i]) {
	    name_out = 0;
	    out_state = 0;
	    line_toappl[i++] = '\0';
	    j = i;
	    while (line_toappl[j] != '\0' && j != *toappllen)
	       j++;
	    if (META_CHAR == line_toappl[j]) {
	       def_out = 0;
	       insert_macro();
	       line_toappl[j++] = '\0';
	       inp = j;
	    }
	    new_macro->macro->add(&line_toappl[i], j - i);
	 }
	 new_macro->macroName->add(line_toappl, strlen(&line_toappl[0]));
	 if (inp) {
	    memcpy(line_toappl, &line_toappl[inp], *toappllen - j);
	 } else {
	    line_toappl[0] = '\0';
	    *toappllen = 0;
	 }
      }
      else {
	 int i = 0;
	 do {
	    switch (out_state) {
	       case 0: *new_macro->macro += line_toappl[i];
		       if (META_CHAR == line_toappl[i]) {
		          out_state = 1;
			  strcpy(&line_toappl[i], &line_toappl[i+1]);
			  i--;
		       }
	       break;
	       case 1: if ('x' == line_toappl[i] || 't' == line_toappl[i]) {
		          out_state = 2;
			  *new_macro->macro += line_toappl[i];
			  sub_macro.empty();
			  strcpy(&line_toappl[i], &line_toappl[i+1]);
			  i--;
		       }
		       else {
			  char buf[MAX_LINE];
			  def_out = 0;
			  curr_md = in;
			  strcpy(buf, new_macro->macro->realstr());
			  buf[new_macro->macro->length() - 1] = '\0';
			  new_macro->macro->assign(buf, strlen(buf));
			  for (short cn = 0; context[cn] != 0; cn++)
			     if (strcmp("linemode", context[cn]->realstr()) &&
				 strcmp("nolongwait", context[cn]->realstr()))
				   new_macro->context[cn] =
				      new string(context[cn]->realstr(),
					     strlen(context[cn]->realstr()));
			  insert_macro();
		       }
	       break;
	       case 2: if (META_CHAR == line_toappl[i]) {
		          out_state = 0;
			  *new_macro->macro += sub_macro;
		          *new_macro->macro += line_toappl[i];
		          strcpy(&line_toappl[i], &line_toappl[i+1]);
			  char* s = sub_macro.realstr();
			  for (macro_link* b = out_macros;
			       b->macroName != 0 &&
			       strcmp(s, b->macroName->realstr()) &&
			       b->macro_md == out;
			       b = b->next);
			  if (b->macro != 0) {
			     char tmp[MAX_LINE];
			     strcpy(tmp, &line_toappl[i]);
			     strcpy(&line_toappl[i], b->macro->realstr());
			     i = strlen(line_toappl) - 1;
			     strcat(line_toappl, tmp);
			  }
		       }
	               else {
			  sub_macro += line_toappl[i];
			  strcpy(&line_toappl[i], &line_toappl[i + 1]);
			  i--;
		       }
	       break;
	       default:
	       break;
	    }
	    i++;
	 } while (line_toappl[i] != '\0');
      }
      if ('\0' == line_toappl[0])
	 *toappllen = 0;
   }
   if (in == proc_mode && def_in) {
      if (name_in) {
	 int i = 0;
	 int inp = 0;
	 while (line_toappl[i] != '\0' && line_toappl[i] != META_CHAR)
	    i++;
	 if (META_CHAR == line_toappl[i]) {
	    name_in = 0;
	    line_toappl[i++] = '\0';
	    if (capture) {
	       def_in = 0;
	       for (short cn = 0; context[cn] != 0; cn++)
		  new_macro->context[cn] =
		     new string(context[cn]->realstr(),
				strlen(context[cn]->realstr()));
	       insert_macro();
	       curr_md = cmd;
	       inp = i;
	       capture = 0;
	    }
	    else {
	       int j = i;
	       while (line_toappl[j] != '\0' && line_toappl[j] != META_CHAR)
		  j++;
	       if (META_CHAR == line_toappl[j]) {
		  def_in = 0;
		  curr_md = cmd;
		  for (short cn = 0; context[cn] != 0; cn++)
		     new_macro->context[cn] =
			new string(context[cn]->realstr(),
				   strlen(context[cn]->realstr()));
		  insert_macro();
		  line_toappl[j++] = '\0';
		  inp = j;
	       }
	       new_macro->macro->add(&line_toappl[i], j - i);
	    }
	 }
	 new_macro->macroName->add(line_toappl, strlen(line_toappl));
	 strcpy(line_toappl, &line_toappl[i]);
	 if (inp)
	    strcat(line_toappl, &line_toappl[inp]);
      }
      else {
	 int i = 0;
	 while (line_toappl[i] != '\0' && line_toappl[i] != META_CHAR)
	    i++;
	 if (META_CHAR == line_toappl[i]) {
	    def_in = 0;
	    curr_md = cmd;
	    line_toappl[i++] ='\0';
	 }
	 new_macro->macro->add(line_toappl, strlen(line_toappl));
	 if (0 == def_in) {
	    for (short cn = 0; context[cn] != 0; cn++)
	       new_macro->context[cn] =
		  new string(context[cn]->realstr(),
			     strlen(context[cn]->realstr()));
	    insert_macro();
	 }
	 strcat(line_toappl, &line_toappl[i]);
      }
      if ('\0' == line_toappl[0])
	 strcpy(line_toappl, META_STR);
   }
   if (in == proc_mode && def_agent && name_agent) {
      int i = 0;
      int inp = 0;
      while (line_toappl[i] != '\0' && line_toappl[i] != META_CHAR)
	 i++;
      if (META_CHAR == line_toappl[i]) {
	 name_agent = 0;
         curr_md = undef;
	 line_toappl[i++] = '\0';
      }
      else
	 for (int t = 0; t < i; t++)
	    new_agent_name += line_toappl[t];
      strcpy(line_toappl, &line_toappl[i]);
      if (inp)
	strcat(line_toappl, &line_toappl[inp]);
      if ('\0' == line_toappl[0])
	*toappllen = 0;
      skip_proc_line = 1;
   }
   if (call_in && in == proc_mode) {
      int i = 0;
      while (line_toappl[i] != META_CHAR && line_toappl[i] != '\0')
	 i++;
      if ('\0' == line_toappl[i]) {
	 call_name.add(line_toappl, strlen(line_toappl));
	 line_toappl[0] = '\0';
	 *toappllen = 0;
      }
      else {
	 line_toappl[i] = '\0';
	 (*toappllen)--;
	 call_name.add(line_toappl, strlen(line_toappl));
	 call_in = 0;
	 curr_md = in;
	 char* s = call_name.realstr();
	 last_action = ag.actions;
	 short ag_found;
	 while (last_action->body != 0) {
	    ag_found = 1;
	    short nm_found = !strcmp(last_action->name->realstr(), s);
	    if (nm_found)
	       for (short acn = 0; ag_found && last_action->context[acn] &&
		    acn < MAX_CONTEXTS; acn++) {
		  short this_cont_found = 0;
		  for (short cn = 0; !this_cont_found && context[cn] &&
		       cn < MAX_CONTEXTS; cn++) {
		     if (matchglob(context[cn]->realstr(),
				   last_action->context[acn]->realstr()))
			this_cont_found = 1;
		  }
		  ag_found = ag_found && this_cont_found;
	       } else {
                  ag_found = 0;
               }
	    if (ag_found)
	       break;
	    last_action = last_action->next;
	 }
	 if (ag_found) {
	    agent_active = 1;
	    agent_scenario = last_action->body;
	    line_toappl[0] = '\0';
	    *toappllen = 0;
	    if (in == agent_scenario->line_md) {
	       *callback = 1;
	       strcpy(&next_input[0], agent_scenario->line->realstr());
	    }
	    return;
	 }
	 else {
	    for (macro_link* b = ilexicon[s[0]]; b &&
		 (strcmp(s, b->macroName->realstr()) || !b->valid);
		 b = b->lexptr) {
	       short bd_found = 1;
	       for (short bcn = 0; bd_found && b->context[bcn] &&
		    bcn < MAX_CONTEXTS; bcn++) {
		  short this_cont_found = 0;
		  for (short cn = 0; !this_cont_found && context[cn]
		       && cn < MAX_CONTEXTS; cn++) {
		     if (matchglob(context[cn]->realstr(),
				   b->context[bcn]->realstr()))
			this_cont_found = 1;
		  }
		  bd_found =bd_found && this_cont_found;
	       }
	    if (bd_found)
	       break;
	    }
	    if (b != 0) {
	       string t(&line_toappl[i + 1], *toappllen - i);
	       strcpy(line_toappl, b->macro->realstr());
	       strcat(line_toappl, t.realstr());
	       *toappllen += b->macro->length();
	    }
	    else {
	       cerr << "Macro not found: " << call_name;
	       strcpy(line_toappl, &line_toappl[i]);
	       *toappllen -= i;
	    }
	 }
      }
      if (!agent_active)
	 return;
   }
   if (add_context_in && in == proc_mode) {
      if (name_in) {
         int i = 0;
         while (line_toappl[i] != META_CHAR && line_toappl[i] != '\0')
            i++;
         if ('\0' == line_toappl[i]) {
            add_context_macro->macroName->add(line_toappl, strlen(line_toappl));
            line_toappl[0] = '\0';
            *toappllen = 0;
         }
         else {
            line_toappl[i] = '\0';
            (*toappllen)--;
            add_context_macro->macroName->add(line_toappl, strlen(line_toappl));
            name_in = 0;
            context_in = 1;
         }
      } else if (context_in) {
         int i = 0;
         while (line_toappl[i] != META_CHAR && line_toappl[i] != '\0')
            i++;
         if ('\0' == line_toappl[i]) {
            add_context_macro->context[0]->add(line_toappl, strlen(line_toappl));
            line_toappl[0] = '\0';                                              
            *toappllen = 0;
         }
         else {
            line_toappl[i] = '\0';
            (*toappllen)--;
            add_context_macro->context[0]->add(line_toappl, strlen(line_toappl));
            context_in = 0;
            add_context_in = 0;
            char* s = add_context_macro->macroName->realstr();
            last_action = ag.actions;
            short ag_found;
            while (last_action->body != 0) {
               ag_found = 1;
               short nm_found = !strcmp(last_action->name->realstr(), s);
               if (nm_found)
                  for (short acn = 0; ag_found && last_action->context[acn] &&
                       acn < MAX_CONTEXTS; acn++) {
                     short this_cont_found = 0;
                     for (short cn = 0; !this_cont_found && context[cn] &&
                          cn < MAX_CONTEXTS; cn++) {
                        if (matchglob(context[cn]->realstr(),
                                      last_action->context[acn]->realstr()))
                           this_cont_found = 1;
                      }
                      ag_found = ag_found && this_cont_found;
                  } else {
                     ag_found = 0;
                  }
               if (ag_found)
                  break;
               last_action = last_action->next;
            }
            if (ag_found) {
               for (short cn = 0; 0 != last_action->context[cn] &&
                                  MAX_CONTEXTS != cn; cn++)
               if (MAX_CONTEXTS == cn) {
                  cerr << "Out of context space when adding context" << endl;
                  exit(-1);
               } else {
                  last_action->context[cn] =
                     new string(add_context_macro->macroName->realstr(),
                        add_context_macro->macroName->length());
               }
               line_toappl[0] = '\0';
               *toappllen = 0;
               skip_proc_line = 1;
               add_context_macro->empty();
               delete add_context_macro;
               add_context_macro = 0;
               curr_md = undef;
            }
            else {
               for (macro_link* b = ilexicon[s[0]]; b &&
                    (strcmp(s, b->macroName->realstr()) || !b->valid);
                    b = b->lexptr) {
                  short bd_found = 1;
                  for (short bcn = 0; bd_found && b->context[bcn] &&
                       bcn < MAX_CONTEXTS; bcn++) {
                       short this_cont_found = 0;
                     for (short cn = 0; !this_cont_found && context[cn]
                          && cn < MAX_CONTEXTS; cn++) {
                        if (matchglob(context[cn]->realstr(),
                            b->context[bcn]->realstr()))
                           this_cont_found = 1;
                      }
                      bd_found =bd_found && this_cont_found;
                   }
                   if (bd_found)
                   break;
               }
               if (b != 0) {
                  for (short cn = 0; 0 != b->context[cn] &&
                                     MAX_CONTEXTS != cn; cn++);
                  if (MAX_CONTEXTS == cn) {
                     cerr << "Out of context space when adding context" << endl;
                     exit(-1);
                  } else {
                     b->context[cn] =
                        new string(add_context_macro->context[0]->realstr(),
                           add_context_macro->context[0]->length());
                  }
                  line_toappl[0] = '\0';
                  *toappllen = 0;
                  skip_proc_line = 1;
                  add_context_macro->empty();
                  delete add_context_macro;
                  add_context_macro = 0;
                  curr_md = undef;
               } else {
                  cerr << "Macro not found: "
                     << add_context_macro->macroName->realstr();
                  exit(-1);
               }
            }
         }
         if (!agent_active)
            return;
      }
   }
   if (erase_in && in == proc_mode) {
      int i = 0;
      while (line_toappl[i] != META_CHAR && line_toappl[i] != '\0')
	 i++;
      if ('\0' == line_toappl[i]) {
	 erase_name.add(line_toappl, strlen(line_toappl));
	 line_toappl[0] = '\0';
	 *toappllen = 0;
      }
      else {
	 line_toappl[i] = '\0';
	 (*toappllen)--;
	 erase_name.add(line_toappl, strlen(line_toappl));
	 erase_in = 0;
	 curr_md = in;
	 char* s = erase_name.realstr();
	 agent_link* last_action = ag.actions;
	 int ag_found = 0;
	 while (last_action->body != 0) {
	    ag_found = !strcmp(last_action->name->realstr(), s);
	    if (ag_found)
	       break;
	    last_action = last_action->next;
	 }
	 if (ag_found) {
	    agent_link* tag = last_action->next;
            last_action->empty();
	    *last_action = *tag;
	    delete tag;
	 }
	 else {
	    for (macro_link* b = ilexicon[s[0]]; b &&
		 (strcmp(s, b->macroName->realstr()) || !b->valid);
		 b = b->lexptr);
	    if (b != 0) {
	      b->valid = 0;
              macro_removed = 1;
	    }
	    else {
               for (macro_link* b = olexicon[s[0]]; b &&
                    (strcmp(s, b->macroName->realstr()) || !b->valid);
                   b = b->lexptr);
               if (b != 0) {
                  b->valid = 0;
                  macro_removed = 1;
               }
               else {
                  cerr << "Macro not found: " << erase_name;
                  strcpy(line_toappl, &line_toappl[i]);
                  *toappllen -= i;
               }
	    }
	 }
      }
      if (!agent_active)
	 return;
   }
   if (pattern_in && in == proc_mode) {
      if (META_CHAR != line_toappl[0]) {
	 *patt_val += line_toappl[0];
	 *toappllen = 0;
      } else {
	 pattern_in = 0;
	 skip_proc_line = 1;
	 /*lines->test = find_pattern;*/
	 lines->sample = new string();
	 short quote = 0;
	 for (int ind = 0; ind < patt_val->length(); ind++) {
	    if (quote) {
	       if ('n' == patt_val->realstr()[ind]) {
		  *lines->sample += '\n';
	       } else {
		  *lines->sample += '\\';
		  *lines->sample += patt_val->realstr()[ind];
	       }
	       quote = 0;
	    } else if ('\\' == patt_val->realstr()[ind]) {
	       quote = 1;
	    } else {
	       *lines->sample += patt_val->realstr()[ind];
	    }
	 }
	 if (quote) {
	    *lines->sample += '\\';
	 }
	 patt_val->empty();
	 delete patt_val;
	 patt_val = 0;
	 if (!found_pattern(lines->sample)) {
	    alert("Pattern not found");
	 }
      }
   }
   if (kwrd_threshold_in && in == proc_mode) {
      if (META_CHAR != line_toappl[0]) {
	 if (!isdigit(line_toappl[0]))
	    cerr << "Not a digit" << endl;
	 else {
	    kwrd_threshold *= 10;
	    kwrd_threshold += line_toappl[0] - '0';
	    *toappllen = 0;
	 }
      } else {
	 kwrd_threshold_in = 0;
	 if ('<' == kwrd_relation && total_keywords < kwrd_threshold ||
             '>' == kwrd_relation && total_keywords > kwrd_threshold) {
	    cerr << "Assertion about the number of keywords doesn't hold"
	       << endl;
	 }
      }
   }
   if (num_threshold_in && in == proc_mode) {
      if (META_CHAR != line_toappl[0]) {
	 if (!isdigit(line_toappl[0])) {
	    cerr << "Not a digit" << endl;
	    exit(-1);
	 } else {
	    *lines->sample += line_toappl[0];
	    num_comp_threshold *= 10;
	    num_comp_threshold += line_toappl[0] - '0';
	    *toappllen = 0;
	 }
      } else {
	 num_threshold_in = 0;
	 if ('<' == num_comp_rel && num_comp_threshold <= num_comp_val ||
	     '=' == num_comp_rel && num_comp_threshold != num_comp_val ||
             '>' == num_comp_rel && num_comp_threshold >= num_comp_val) {
	    cerr << "Relation doesn't hold";
	    exit(-1);
	 }
      }
   }
   if (timeout_in && in == proc_mode) {
      if (META_CHAR != line_toappl[0]) {
	 if (!isdigit(line_toappl[0]))
	    cerr << "Not a digit" << endl;
	 else
	    switch (timeout_state) {
	       case 0: arrSec *= 10;
		       arrSec += line_toappl[0] - '0';
	       break;
	       case 1: arrUsec *= 10;
		       arrUsec += line_toappl[0] - '0';
	       break;
	       case 2: iarrSec *= 10;
		       iarrSec += line_toappl[0] - '0';
	       break;
	       case 3: iarrUsec *= 10;
		       iarrUsec += line_toappl[0] - '0';
	       break;
	       default: cerr << "No such state" << endl;
	       break;
	    }
      } else if (4 == ++timeout_state) {
	 timeout_in = 0;
	 skip_proc_line = 1;
	 setTimeoutValues(arrSec, arrUsec, iarrSec, iarrUsec, timeout_std);
      }
      if (!agent_active) {
	 line_toappl[0] = '\0';
	 *toappllen = 0;
      }
   }
   if (!def_in && !call_in && !erase_in && !def_out && !kwrd_in &&
       !context_change && !pattern_in && !timeout_in && !add_context_in &&
       !num_threshold_in &&
       (cmd == curr_md || in == proc_mode && META_CHAR == line_toappl[0]) &&
       !skip_proc_line) {
      if (!search)
	 if (isdigit(line_toappl[0]))
	    if (!sel_area) {
	       int reg_nr = line_toappl[0] - '0';
	       strcpy(&line_toappl[0], reg[reg_nr].realstr());
	       *toappllen = reg[reg_nr].length();
	       return;
	    }
	    else
	       save_to_reg(line_toappl[0] - '0');
	 else
	    switch (line_toappl[0]) {
	    case ' ' :
	    if (cd_mode) {
	       cd_line = lines;
	       cd_pos = 0;
	       cd_mode = 0;
	    }
	    char ch;
	    if (!(cd_pos != cd_line->line->length()))
	       if (cd_line->next->line) {
		  cd_line = cd_line->next;
		  cd_pos = 0;
		  ch = (*(cd_line->line))[cd_pos];
	       }
	       else
		  break;
	    else
	       ch = (*(cd_line->line))[cd_pos];
	    cd_pos++;
	    {
	       char t1[2];
	       t1[0] = line_toappl[0];
	       t1[1] = '\0';
	       strcat(line_touser, t1);
	       if (in == cd_line->line_md)
		  strcat(line_touser, "(i): ");
	       else
		  strcat(line_touser, "(o): ");
	       if (isprint(ch)) {
		  t1[0] = ch;
		  strcat(line_touser, t1);
	       }
	       else {
		  char t2[4];
		  t2[0] = (int) ch / 64 + '0';
		  t2[1] = (int) ch / 8 % 8 + '0';
		  t2[2] = (int) ch % 8 + '0';
		  t2[3] = '\0';
		  strcat(line_touser, "(char) ");
		  strcat(line_touser, t2);
	       }
	    }
	    strcat(line_touser, "\r\n");
	    *toappllen = strlen(line_toappl);
	    if (capture && out == cd_line->line_md)
	       capt_str += ch;
	    break;
	    case 'a' :
	    if (def_agent) {
	       def_agent = 0;
	       sel_line = 0;
	       sel_area = 0;
	       ag.insert_action(&new_agent_name, agent_ptr, lines);
	       new_agent_name.empty();
	    }
	    else if (def_branch) {
	       def_branch = 0;
	       sel_line = 0;
	       sel_area = 0;
	       agent_active = 1;
	       strcpy(line_toappl, agent_scenario->line->realstr());
	       *toappllen = agent_scenario->line->length();
	       ag.insert_alt_action(agent_scenario, agent_ptr, lines);
	       select_parent = 1;
	       discardMeta();
	       clear_tcl_in();
	    }
	    else {
	       agent_ptr = lines;
	       for (short cn = 0; cn < MAX_CONTEXTS; cn++)
		  if (0 != context[cn])
		     agent_ptr->context[cn] =
			new string(context[cn]->realstr(),
				   strlen(context[cn]->realstr()));
		  else
		     agent_ptr->context[cn] = 0;
	       def_agent = 1;
	       name_agent = 1;
	    }
	    break;
	    case 'A' :
            add_context_in = 1;
            name_in = 1;
            add_context_macro = new macro_link();
            add_context_macro->context[0] = new string();
	    break;
	    case 'b' :
	    if ((def_agent || def_branch || agent_active) && sel_line) {
	       if (!sel_area) {
		  sel_area = 1;
		  if (sel_line) {
		     top_line = sel_line_nr;
		     top_pos = 0;
		     bottom_line = sel_line_nr;
		     bottom_pos = disp_width - 1;
		  }
		  else {
		     top_line = curr_y - 1;
		     top_pos = curr_x - 1;
		     bottom_line = curr_y - 1;
		     bottom_pos = curr_x - 1;
		  }
		  while (bottom_pos &&
			 (!isalpha(disp[(last_line + bottom_line + 1) %
					disp_height][bottom_pos]) &&
			  !isdigit(disp[(last_line + bottom_line + 1) %
					disp_height][bottom_pos])))
		     bottom_pos--;
		  while (bottom_pos &&
			 (isalpha(disp[(last_line + bottom_line + 1) %
				       disp_height][bottom_pos]) ||
			  isdigit(disp[(last_line + bottom_line + 1) %
				       disp_height][bottom_pos])))
		     bottom_pos--;
	       }
	       else {
		  if (!bottom_pos) {
		     bottom_line += disp_height - 1;
		     bottom_line %= disp_height;
		     bottom_pos = disp_width - 1;
		  }
		  while (bottom_pos &&
			 (!isalpha(disp[(last_line + bottom_line + 1) %
					disp_height][bottom_pos]) &&
			  !isdigit(disp[(last_line + bottom_line + 1) %
					disp_height][bottom_pos])))
		     bottom_pos--;
		  while (bottom_pos &&
			 (isalpha(disp[(last_line + bottom_line + 1) %
				       disp_height][bottom_pos]) ||
			  isdigit(disp[(last_line + bottom_line + 1) %
				       disp_height][bottom_pos])))
		     bottom_pos--;
	       }
	       show_sel_area(line_touser, touserlen);
	    }
	    break;
	    case 'B' :
	    if ((def_agent || def_branch || agent_active) && sel_line) {
	       if (!sel_area) {
		  sel_area = 1;
		  if (sel_line) {
		     top_line = sel_line_nr;
		     top_pos = 0;
		     bottom_line = sel_line_nr + 1;
		     bottom_line %= disp_width;
		     bottom_pos = 0;
		  }
		  else {
		     top_line = curr_y - 1;
		     top_pos = curr_x - 1;
		     bottom_line = curr_y - 1;
		     bottom_pos = curr_x - 1;
		  }
		  while (bottom_pos < disp_width - 1 &&
			 (!isalpha(disp[(last_line + bottom_line + 1) %
					disp_height][bottom_pos]) &&
			  !isdigit(disp[(last_line + bottom_line + 1) %
					disp_height][bottom_pos])))
		     bottom_pos++;
		  while (bottom_pos < disp_width - 1 &&
			 (isalpha(disp[(last_line + bottom_line + 1) %
				       disp_height][bottom_pos]) ||
			  isdigit(disp[(last_line + bottom_line + 1) %
				       disp_height][bottom_pos])))
		     bottom_pos++;
	       }
	       else {
		  if (disp_width - 1 == bottom_pos) {
		     bottom_line += disp_height + 1;
		     bottom_line %= disp_height;
		     bottom_pos = 0;
		  }
		  while (bottom_pos < disp_width - 1 &&
			 (!isalpha(disp[(last_line + bottom_line + 1) %
					disp_height][bottom_pos]) &&
			  !isdigit(disp[(last_line + bottom_line + 1) %
					disp_height][bottom_pos])))
		     bottom_pos++;
		  while (bottom_pos < disp_width - 1 &&
			 (isalpha(disp[(last_line + bottom_line + 1) %
				       disp_height][bottom_pos]) ||
			  isdigit(disp[(last_line + bottom_line + 1) %
				       disp_height][bottom_pos])))
		     bottom_pos++;
	       }
	       show_sel_area(line_touser, touserlen);
	    }
	    break;
	    case 'c' :
	    capture = 1;
	    capt_str.empty();
	    break;
	    case 'C' :
	    kwrd_threshold_in = 1;
	    kwrd_threshold = 0;
            kwrd_relation = '>';
	    break;
	    case 'd' :
	    if (new_macro_defined) {
	       if (in == new_macro->macro_md) {
		  ilexicon[new_macro->macroName->realstr()[0]] =
		     ilexicon[new_macro->macroName->realstr()[0]]->lexptr;
		  macro_link* t = in_macros;
		  in_macros = in_macros->next;
		  new_macro_defined = 0;
		  t->macroName->empty();
		  t->macro->empty();
		  delete t;
	       }
	       else {
		  olexicon[new_macro->macroName->realstr()[0]] =
		     olexicon[new_macro->macroName->realstr()[0]]->lexptr;
		  macro_link* t = out_macros;
		  out_macros = out_macros->next;
		  new_macro_defined = 0;
		  t->macroName->empty();
		  t->macro->empty();
		  delete t;
	       }
	    }
	    break;
	    case 'D':
	    top_line = 0;
	    top_pos = 0;
	    bottom_line = disp_height - 1;
	    bottom_pos = disp_width - 1;
	    save_to_reg(10);
	    break;
	    case 'e':
	    erase_in = 1;
	    erase_name.empty();
	    break;
	    case 'E':
	    strcpy(&line_toappl[0], reg[10].realstr());
	    *toappllen = reg[10].length();
	    dont_discard = 1;
	    break;
	    case 'f' :
            if (def_agent || def_branch || agent_active) {
               sel_line = 0;
               sel_area = 0;
            }
	    break;
	    case 'F' :
	    if (def_agent || def_branch) {
		kwrd_threshold_in = 1;
		kwrd_threshold = 0;
		kwrd_relation = '<';
		lines->sample = new string();
	    }
	    if (agent_active) {
	       kwrd_threshold = atoi(agent_scenario->sample->realstr());
	       if ('<' == kwrd_relation && total_keywords < kwrd_threshold ||
		   '>' == kwrd_relation && total_keywords > kwrd_threshold) {
		  if (0 == agent_scenario->alt_branch) {
		     agent_ptr = lines;
		     def_branch = 1;
		     agent_active = 0;
		     reqAltAction();
		  }
		  else {
		     pick_alt_branch = 1;
		  }
	       }
	    }
	    break;
	    case 'g' :
            total_keywords = 0;
	    break;
	    case 'h' :
	    if (!(def_agent || def_branch || agent_active)) {
	       strcpy(line_touser, "\
\r\r\n\' \' - character codes\
\r\n\'a\' - define action\
\r\n\'c\' - capture output macro\
\r\n\'d\' - delete last entered macro\
\r\n\'e\' - erase macro or action\
\r\n\'h\' - help\
\r\n\'i\' - define an input macro\
\r\n\'k\' - define keyword\
\r\n\'l\' - line mode\
\r\n\'o\' - define an output macro\
\r\n\'s\' - show screen image\
\r\n\'t\' - change context\
\r\n\'T\' - text compare\
\r\n\'w\' - write macros\
\r\n\'x\' - execute macro or action\
\r\n\'/\' - search\
\r\n\'\\034\' - end command mode\
\r\n");
	       *touserlen = strlen(line_touser);
	    }
	    if ((def_agent || def_branch || agent_active) && sel_line) {
	       if (!sel_area) {
		  sel_area = 1;
		  if (sel_line) {
		     top_line = sel_line_nr + disp_height - 1;
		     top_line %= disp_height;
		     top_pos = disp_width - 1;
		     bottom_line = sel_line_nr;
		     bottom_pos = disp_width - 1;
		  }
		  else {
		     top_line = curr_y - 1;
		     if (1 != curr_x)
			top_pos = curr_x - 1;
		     else {
			top_pos = disp_width - 1;
			top_line = (curr_y - 2) % disp_height;
		     }
		     bottom_line = curr_y - 1;
		     bottom_pos = curr_x - 1;
		  }
	       }
	       else {
		  if (0 == top_pos) {
		     top_line--;
		     top_line %= disp_height;
		     top_pos = disp_width - 1;
		  }
		  else
		     top_pos--;
	       }
	       show_sel_area(line_touser, touserlen);
	    }
	    break;
	    case 'H':
	    if ((def_agent || def_branch || agent_active) && sel_line) {
	       if (!sel_area) {
		  sel_area = 1;
		  if (sel_line) {
		     top_line = sel_line_nr;
		     top_pos = 1;
		     bottom_line = sel_line_nr;
		     bottom_pos = disp_width - 1;
		  }
		  else {
		     if (disp_width == curr_x)
			top_line = curr_y % disp_height;
		     else
			top_line = curr_y - 1;
		     top_pos = curr_x % disp_width;
		     bottom_line = curr_y - 1;
		     bottom_pos = curr_x - 1;
		  }
	       }
	       else {
		  if (disp_width - 1 == top_pos) {
		     top_line++;
		     top_line %= disp_height;
		     top_pos = 0;
		  }
		  else
		     top_pos++;
	       }
	       show_sel_area(line_touser, touserlen);
	    }
	    break;
	    case 'i' :
	    def_in = 1;
	    name_in = 1;
	    new_macro = new macro_link();
	    new_macro->macro_md = in;
	    break;
	    case 'j' :
	    if ((def_agent || def_branch || agent_active) && sel_line) {
	       if (!sel_area) {
		  sel_area = 1;
		  if (sel_line) {
		     top_line = sel_line_nr;
		     top_pos = 0;
		     bottom_line = sel_line_nr + 1;
		     bottom_line %= disp_height;
		     bottom_pos = disp_width - 1;
		  }
		  else {
		     top_line = curr_y - 1;
		     top_pos = curr_x - 1;
		     bottom_line = curr_y % disp_height;
		     bottom_pos = disp_width - 1;
		  }
	       }
	       else {
		  bottom_line++;
		  bottom_line %= disp_height;
		  bottom_pos = disp_width - 1;
	       }
	       show_sel_area(line_touser, touserlen);
	    }
	    break;
	    case 'J' :
	    if ((def_agent || def_branch || agent_active) && sel_line) {
	       if (!sel_area) {
		  sel_area = 1;
		  if (sel_line) {
		     top_line = sel_line_nr;
		     top_pos = 0;
		     bottom_line = sel_line_nr + disp_height - 1;
		     bottom_line %= disp_height;
		     bottom_pos = disp_width - 1;
		  }
		  else {
		     top_line = curr_y - 1;
		     top_pos = curr_x - 1;
		     if (1 != curr_y)
			bottom_line = curr_y - 2;
		     else
			bottom_line = disp_height - 1;
		     bottom_pos = disp_width - 1;
		  }
	       }
	       else {
		  bottom_line--;
		  bottom_line %= disp_height;
		  bottom_pos = disp_width - 1;
	       }
	       show_sel_area(line_touser, touserlen);
	    }
	    break;
	    case 'k' :
	    if (!(def_agent || def_branch)) {
	       kwrd_in = 1;
	       new_macro = new macro_link();
	       new_macro->macro_md = out;
	    }
	    if ((def_agent || def_branch || agent_active) && sel_line) {
	       if (!sel_area) {
		  sel_area = 1;
		  if (sel_line) {
		     top_line = sel_line_nr + disp_height - 1;
		     top_line %= disp_height;
		     top_pos = 0;
		     bottom_line = sel_line_nr;
		     bottom_pos = disp_width - 1;
		  }
		  else {
		     top_line = curr_y % disp_height;
		     top_pos = 0;
		     bottom_line = curr_y - 1;
		     bottom_pos = curr_x - 1;
		  }
	       }
	       else {
		  top_line += disp_height - 1;
		  top_line %= disp_height;
		  top_pos = 0;
	       }
	       show_sel_area(line_touser, touserlen);
	    }
	    break;
	    case 'K' :
	    if ((def_agent || def_branch || agent_active) && sel_line) {
	       if (!sel_area) {
		  sel_area = 1;
		  if (sel_line) {
		     top_line = sel_line_nr + 1;
		     top_line %= disp_height;
		     top_pos = 0;
		     bottom_line = sel_line_nr;
		     bottom_pos = disp_width - 1;
		  }
		  else {
		     top_line = curr_y % disp_height;
		     top_pos = 0;
		     bottom_line = curr_y - 1;
		     bottom_pos = curr_x -1;
		  }
	       }
	       else {
		  top_line++;
		  top_line %= disp_height;
		  top_pos = 0;
	       }
	       show_sel_area(line_touser, touserlen);
	    }
	    break;
	    case 'l' :
	    if (!(def_agent || def_branch)) {
	       if (cd_mode) {
		  cd_line = lines;
		  cd_pos = 0;
		  cd_mode = 0;
	       }
	       if (cd_line->line && (*(cd_line->line))[cd_pos] != 0) {
		  char* t3 = "a";
		  t3[0] = line_toappl[0];
		  strcat(line_touser, t3);
		  if (in == cd_line->line_md)
		     strcat(line_touser, "(i): ");
		  else
		     strcat(line_touser, "(o): ");
		  for (cd_pos = 0; cd_pos < cd_line->line->length();
		       cd_pos++) {
		     ch = (*(cd_line->line))[cd_pos];
		     if (isprint(ch)) {
			t3[0] = ch;
			strcat(line_touser, t3);
		     }
		     else {
			strcat(line_touser, "<");
			char* t4 = "123";
			t4[0] = (int) ch / 64 + '0';
			t4[1] = (int) ch / 8 % 8 + '0';
			t4[2] = (int) ch % 8 + '0';
			strcat(line_touser, t4);
			strcat(line_touser, ">");
		     }
		  }
		  if (cd_line->next->line) {
		     cd_line = cd_line->next;
		     cd_pos = 0;
		  }
		  strcat(line_touser, "<>\r\n");
	       }
	    }
	    if ((def_agent || def_branch || agent_active) && sel_line) {
	       if (!sel_area) {
		  sel_area = 1;
		  if (sel_line) {
		     top_line = sel_line_nr;
		     top_pos = 0;
		     bottom_line = sel_line_nr + 1;
		     bottom_line %= disp_height;
		     bottom_pos = 0;
		  }
		  else {
		     top_line = curr_y - 1;
		     bottom_line = curr_y % disp_height;
		     top_pos = curr_x - 1;
		     bottom_pos = disp_width - 1;
		  }
	       }
	       else {
		  if (disp_width - 1 == bottom_pos) {
		     bottom_line++;
		     bottom_line %= disp_height;
		     bottom_pos = 0;
		  }
		  else
		     bottom_pos++;
	       }
	       show_sel_area(line_touser, touserlen);
	    }
	    break;
	    case 'L':
	    if ((def_agent || def_branch || agent_active) && sel_line) {
	       if (!sel_area) {
		  sel_area = 1;
		  if (sel_line) {
		     top_line = sel_line_nr;
		     top_pos = 0;
		     bottom_line = sel_line_nr;
		     bottom_pos = disp_width - 2;
		  } else {
		     top_line = bottom_line = curr_y - 1;
		     top_pos = curr_x;
		     if (1 != curr_x)
			bottom_pos = curr_x - 2;
		     else {
			bottom_pos = disp_width - 1;
			if (bottom_line)
			   bottom_line--;
			else
			   bottom_line = disp_height - 1;
		     }
		  }
	       }
	       else {
		  if (0 == bottom_pos) {
		     bottom_line--;
		     bottom_line %= disp_height;
		     bottom_pos = disp_width - 1;
		  }
		  else
		     bottom_pos--;
	       }
	       show_sel_area(line_touser, touserlen);
	    }
	    break;
	    case 'n':
	    if (def_agent || def_branch || agent_active) {
	       sel_area = 0;
	       if (!sel_line) {
		  sel_line = 1;
		  sel_old_line = 0;
		  sel_line_nr = 0;
	       }
	       else {
		  if (!sel_old_line)
		     sel_old_line = 1;
		  sel_old_line_nr = sel_line_nr;
		  sel_line_nr++;
		  sel_line_nr = sel_line_nr % disp_height;
	       }
	       show_sel_line(line_touser, touserlen);
	    }
	    break;
	    case 'N':
	    if ((def_agent || def_branch) && (sel_line || sel_area)) {
	       lines->sample = new string(" ", 1);
	       /*lines->test = text_numeric;*/
	       if (!sel_area) {
		  for (short p = 0; p < disp_width; p++)
		     if (!isdigit(disp[(last_line + sel_line_nr + 1) %
				       disp_height][p])) {
			cerr << "Non-numeric field" << endl;
			exit(-1);
		     }
	       }
	       else {
		  short r = top_line;
		  short c = top_pos;
		  while (r != bottom_line || c != bottom_pos) {
		     if (!isdigit(disp[(last_line + r + 1) %
				       disp_height][c++])) {
			cerr << "Non-numeric field" << endl;
			exit(-1);
		     }
		     if (disp_width == c) {
			c = 0;
			r = (r + 1) % disp_height;
		     }
                  } 
		  if (!isdigit(disp[(last_line + bottom_line + 1) %
                      disp_height][bottom_pos])) {
		     cerr << "Non-numeric field" << endl;
		     exit(-1);
		  }
	       }
	    }
	    else if (agent_active && (sel_line || sel_area)) {
	       short r = top_line;
	       short c = top_pos;
	       int index = 0;
	       short numeric = 1;
	       while (numeric && (r != bottom_line || c != bottom_pos)) {
		  numeric = numeric &&
		     isdigit(disp[(last_line + r + 1) % disp_height][c++]);
		  if (disp_width == c) {
		     c = 0;
		     r = (r + 1) % disp_height;
		  }
	       }
	       numeric = numeric && isdigit(disp[(last_line + bottom_line + 1) %
                         disp_height][bottom_pos]);
	       if (!numeric) {
		  if (0 == agent_scenario->alt_branch) {
		     agent_ptr = lines;
		     agent_active = 0;
		     def_branch = 1;
		     reqAltAction();
		  }
		  else {
		     pick_alt_branch = 1;
		  }
	       }
	    }
            break;
	    case 'o':
	    def_out = 1;
	    name_out = 1;
	    new_macro = new macro_link();
	    new_macro->macro_md = out;
	    break;
	    case 'p':
	    if (def_agent || def_branch || agent_active) {
	       if (!sel_line) {
		  sel_line = 1;
		  sel_old_line = 0;
		  sel_line_nr = disp_height - 1;
	       }
	       else {
		  if (!sel_old_line)
		     sel_old_line = 1;
		  sel_old_line_nr = sel_line_nr;
		  sel_line_nr += disp_height - 1;
		  sel_line_nr = sel_line_nr % disp_height;
	       }
	       show_sel_line(line_touser, touserlen);
	    }
	    break;
	    case 'r':
	    if (def_agent || def_branch) {
	       pattern_in = 1;
	       patt_val = new string();
	    }
	    else if (agent_active) {
	       if (!found_pattern(agent_scenario->sample)) {
		  if (0 == agent_scenario->alt_branch) {
		     agent_ptr = lines;
		     def_branch = 1;
		     agent_active = 0;
		     reqAltAction();
		  }
		  else {
		     pick_alt_branch = 1;
		  }
	       }
	    }
	    break;
	    case 's':
	    show_blueprint(line_touser, touserlen);
	    break;
	    case 'S':
	    for (macro_link* b = out_macros; 0 != b->macroName; b = b->next)
	       if (0 == b->context[0] && '|' == b->macroName->realstr()[0])
		  sendName(b->macroName->realstr(), 's');
	    break;
	    case 't':
	    context_change = 1;
	    allcontexts = new string();
	    break;
	    case 'T':
	    if ((def_agent || def_branch) && (sel_line || sel_area)) {
	       /*lines->test = text_compare;*/
	       lines->sample = new string();
	       if (!sel_area) {
		  for (short p = 0; p < disp_width; p++)
		     *lines->sample +=
			disp[(last_line + sel_line_nr + 1) % disp_height][p];
	       }
	       else {
		  short r = top_line;
		  short c = top_pos;
		  do {
		     *lines->sample +=
			disp[(last_line + r + 1) % disp_height][c++];
		     if (disp_width == c) {
			*lines->sample += '\n';
			c = 0;
			r = (r + 1) % disp_height;
		     }
		  } while (r != bottom_line || c != bottom_pos);
		  *lines->sample +=
		     disp[(last_line + r + 1) % disp_height][c];
	       }
	    }
	    else if (agent_active && (sel_line || sel_area)) {
	       short r = top_line;
	       short c = top_pos;
	       int index = 0;
	       short match = 1;
	       do {
		  match = match &&
		     agent_scenario->sample->realstr()[index] ==
			disp[(last_line + r + 1) % disp_height][c++];
		  if (disp_width == c) {
		     match = match &&
			'\n' == agent_scenario->sample->realstr()[index];
		     c = 0;
		     r = (r + 1) % disp_height;
		  }
	       } while (match && ++index < agent_scenario->sample->length() &&
			(r != bottom_line || c != bottom_pos));
	       if (!match || ++index != agent_scenario->sample->length()) {
		  if (0 == agent_scenario->alt_branch) {
		     agent_ptr = lines;
		     agent_active = 0;
		     def_branch = 1;
		     reqAltAction();
		  }
		  else {
		     pick_alt_branch = 1;
		  }
	       }
	    }
	    break;
	    case 'u':
            case 'U':
	    if (def_agent || def_branch || agent_active) {
               timeout_std = 'u' == line_toappl[0];
	       timeout_in = 1;
	       timeout_state = 0;
	       arrSec = 0;
	       arrUsec = 0;
	       iarrSec = 0;
	       iarrUsec = 0;
	    }
	    break;
	    case 'w':
	    if (!(def_agent || def_branch)) {
	       save_macros();
	       init_macros();
	    }
	    if ((def_agent || def_branch || agent_active) && sel_line) {
	       if (!sel_area) {
		  sel_area = 1;
		  if (sel_line) {
		     top_line = sel_line_nr;
		     top_pos = 0;
		     bottom_line = sel_line_nr;
		     bottom_pos = disp_width - 1;
		  }
		  else {
		     top_line = curr_y - 1;
		     top_pos = curr_x - 1;
		     bottom_line = curr_y - 1;
		     bottom_pos = curr_x - 1;
		  }
		  while (top_pos < disp_width - 1 &&
			 (!isalpha(disp[last_line + top_line + 1]
				   [top_pos]) &&
			  !isdigit(disp[last_line + top_line + 1]
				   [top_pos])))
		     top_pos++;
		  while (top_pos < disp_width - 1 &&
			 (isalpha(disp[last_line + top_line + 1]
				  [top_pos]) ||
			  isdigit(disp[last_line + top_line + 1]
				  [top_pos])))
		     top_pos++;
	       }
	       else {
		  if (disp_width - 1 == top_pos) {
		     top_line++;
		     top_line %= disp_height;
		     top_pos = 0;
		  }
		  while (top_pos < disp_width - 1 &&
			 (!isalpha(disp[last_line + top_line + 1]
				   [top_pos]) &&
			  !isdigit(disp[last_line + top_line + 1]
				   [top_pos])))
		     top_pos++;
		  while (top_pos < disp_width - 1 &&
			 (isalpha(disp[last_line + top_line + 1]
				  [top_pos]) ||
			  isdigit(disp[last_line + top_line + 1]
				  [top_pos])))
		     top_pos++;
	       }
	       show_sel_area(line_touser, touserlen);
	    }
	    break;
	    case 'W' :
	    if ((def_agent || def_branch || agent_active) && sel_line) {
	       if (!sel_area) {
		  sel_area = 1;
		  if (sel_line) {
		     top_line = sel_line_nr + disp_height - 1;
		     top_line %= disp_height;
		     top_pos = disp_width - 1;
		     bottom_line = sel_line_nr;
		     bottom_pos = disp_width - 1;
		  }
		  else {
		     top_line = curr_y - 1;
		     top_pos = curr_x - 1;
		     bottom_line = curr_y - 1;
		     bottom_pos = curr_x - 1;
		  }
		  while (top_pos &&
			 (!isalpha(disp[last_line + top_line + 1]
				   [top_pos]) &&
			  !isdigit(disp[last_line + top_line + 1]
				   [top_pos])))
		     top_pos--;
		  while (top_pos &&
			 (isalpha(disp[last_line + top_line + 1]
				  [top_pos]) ||
			  isdigit(disp[last_line + top_line + 1]
				  [top_pos])))
		     top_pos--;
	       }
	       else {
		  if (!top_pos) {
		     top_line += disp_height - 1;
		     top_line %= disp_height;
		     top_pos = disp_width - 1;
		  }
		  while (top_pos &&
			 (!isalpha(disp[last_line + top_line + 1]
				   [top_pos]) &&
			  !isdigit(disp[last_line + top_line + 1]
				   [top_pos])))
		     top_pos--;
		  while (top_pos &&
			 (isalpha(disp[last_line + top_line + 1]
				  [top_pos]) ||
			  isdigit(disp[last_line + top_line + 1]
				  [top_pos])))
		     top_pos--;
	       }
	       show_sel_area(line_touser, touserlen);
	    }
	    break;
	    case 'x':
	    call_in = 1;
	    call_name.empty();
	    break;
	    case 'X':
	    call_in = 1;
	    call_name.empty();
	    cycle = 1;
	    break;
	    case 'y':
	    for (b = out_macros; 0 != b->macroName; b = b->next)
	       if (0 == b->context[0] && '|' != b->macroName->realstr()[0])
		  sendName(b->macroName->realstr(), 'k');
	    break;
	    case '<':
	    case '=':
	    case '>':
	    if (sel_line || sel_area) {
	       if (def_agent || def_branch || agent_active) {
		  num_comp_rel = line_toappl[0];
		  num_comp_val = 0;
		  short r = top_line;
		  short c = top_pos;
		  int index = 0;
		  while (r != bottom_line || c != bottom_pos) {
		     num_comp_val *= 10;
		     num_comp_val += disp[(last_line + r + 1) %
					  disp_height][c++] - '0';
		     if (disp_width == c) {
			c = 0;
			r = (r + 1) % disp_height;
		     }
                  }
		  num_comp_val *= 10;
		  num_comp_val += disp[(last_line + r + 1) %
				       disp_height][c++] - '0';
	       }
	       if (def_agent || def_branch) {
		  num_threshold_in = 1;
		  lines->sample = new string();
		  num_comp_threshold = 0;
	       }
	       if (agent_active) {
		  num_comp_threshold = atoi(agent_scenario->sample->realstr());
		  if ('<' == num_comp_rel &&
		      num_comp_threshold <= num_comp_val ||
		      '=' == num_comp_rel &&
		      num_comp_threshold != num_comp_val ||
		      '>' == num_comp_rel &&
		      num_comp_threshold >= num_comp_val) {
		     if (0 == agent_scenario->alt_branch) {
			agent_ptr = lines;
			agent_active = 0;
			def_branch = 1;
			reqAltAction();
		     }
		     else {
			pick_alt_branch = 1;
		     }
		  }
	       }
	    }
	    break;
	    case '/' :
	    if (def_agent || def_branch || agent_active) {
	       search = 1;
	       sel_line = 1;
	       sel_area = 1;
	       top_line = 0;
	       top_pos = 0;
	       bottom_line = disp_height - 1;
	       bottom_pos = disp_width - 1;
	       search_pattern.empty();
	    }
	    break;
	    case META_CHAR :
	    if (cmd == curr_md) {
	       curr_md = undef;
	    }
	    else {
	       curr_md = cmd;
	       cd_mode = 1;
	    }
	    if (capture) {
	       def_in = 1;
	       name_in = 1;
	       new_macro = new macro_link();
	       new_macro->macro_md = out;
	       *new_macro->macro = capt_str;
	       capt_str.empty();
	    }
	    
	    break;
	    default:
	    break;
	 }
      else {
	 search_pattern += line_toappl[0];
	 if (!next_char_lit && isalpha(line_toappl[0]))
	    switch(line_toappl[0]) {
	       case 'e':
	       int reg_end = search_pattern.length();
	       int reg_start = reg_end;
	       do
		  while (reg_start &&
			 'r' != search_pattern.realstr()[--reg_start]);
	       while (reg_start &&
		      '\\' == search_pattern.realstr()[reg_start - 1]);
	       int done = !reg_start++ && 'r' != search_pattern.realstr()[0];
	       int test_bot_line = bottom_line;
	       int test_bot_pos = bottom_pos;
	       while (!done) {
		  int test_ch_lit = 0;
		  for (int n = reg_start; n < reg_end && !done; n++) {
		     test_bot_pos++;
		     if (disp_width == test_bot_pos) {
			test_bot_pos = 0;
			test_bot_line++;
			if (disp_height == test_bot_line)
			   break;
		     }
		     if (!test_ch_lit &&
			 isalpha(search_pattern.realstr()[n]))
			switch(search_pattern.realstr()[n]) {
			   case 'e':
			   if (test_bot_pos)
			      test_bot_pos--;
			   else {
			      test_bot_pos = 0;
			      test_bot_line--;
			   }
			   break;
			   case 'n':
			   if (!isdigit(disp[(test_bot_line + last_line + 1) %
					     disp_height][test_bot_pos])) {
			      done = 1;
			      break;		      
			   }
			   else {
			      do {
				 test_bot_pos++;
				 if (disp_width == test_bot_pos) {
				    test_bot_pos = 0;
				    test_bot_line++;
				    if (disp_height == test_bot_line) {
				       done = 1;
				       break;
				    }
				 }
			      } while (isdigit(disp[(test_bot_line +
						     last_line + 1) %
						    disp_height]
					       [test_bot_pos]));
			      if (0 == test_bot_pos) {
				 test_bot_pos = disp_width - 1;
				 test_bot_line += disp_height - 1;
				 test_bot_line %= disp_height;
			      }
			      else
				 test_bot_pos--;
			   }
			   break;
			   case 'w':
			   if (!isalpha(disp[(test_bot_line + last_line + 1) %
					     disp_height][test_bot_pos])) {
			      done = 1;
			      break;		      
			   }
			   else {
			      do {
				 test_bot_pos++;
				 if (disp_width == test_bot_pos) {
				    test_bot_pos = 0;
				    test_bot_line++;
				    if (disp_height == test_bot_line) {
				       done = 1;
				       break;
				    }
				 }
			      } while (isalpha(disp[(test_bot_line +
						     last_line + 1) %
						    disp_height]
					       [test_bot_pos]) ||
				       isdigit(disp[(test_bot_line +
						     last_line + 1) %
						    disp_height]
					       [test_bot_pos]));
			      if (0 == test_bot_pos) {
				 test_bot_pos = disp_width - 1;
				 test_bot_line += disp_height - 1;
				 test_bot_line %= disp_height;
			      }
			      else
				 test_bot_pos--;
			   }
			   break;
			   default:
			   cerr << "Invalid search command inside repeat"
			      << endl;
			   exit(1);
			}
		     else if (!test_ch_lit &&
			      '\\' == search_pattern.realstr()[n])
			test_ch_lit = 1;
		     else {
			test_ch_lit = 0;
			if (search_pattern.realstr()[n] !=
			    disp[(last_line + test_bot_line + 1) %
				 disp_height][test_bot_pos]) {
			   done = 1;
			   break;
			}
		     }
		  }
		  if (!done) {
		     bottom_pos = test_bot_pos;
		     bottom_line = test_bot_line;
		  }
	       }
	       break;
	       case 'n':
	       bottom_pos++;
	       if (disp_width == bottom_pos) {
		  bottom_pos = 0;
		  bottom_line++;
		  bottom_line %= disp_height;
	       }
	       if (!isdigit(disp[(bottom_line + last_line + 1) %
				 disp_height][bottom_pos])) {
		  if (!search_next_match(line_touser, touserlen)) {
		     search = 0;
		     strcpy(line_touser, " \r\r\nNo match\r\n");
		     *touserlen = strlen(line_touser);
		  }
	       }
	       else {
		  do {
		     bottom_pos++;
		     if (disp_width == bottom_pos) {
			bottom_pos = 0;
			bottom_line++;
			bottom_line %= disp_height;
		     }
		  } while (isdigit(disp[(bottom_line + last_line + 1) %
					disp_height][bottom_pos]));
		  bottom_pos--;
		  if (0 == bottom_pos) {
		     bottom_pos = disp_width - 1;
		     bottom_line += disp_height - 1;
		     bottom_line %= disp_height;
		  }
	       }
	       break;
	       case 'r':
	       break;
	       case 'w':
	       bottom_pos++;
	       if (disp_width == bottom_pos) {
		  bottom_pos = 0;
		  bottom_line++;
		  bottom_line %= disp_height;
	       }
	       if (!isalpha(disp[(bottom_line + last_line + 1) %
				 disp_height][bottom_pos])) {
		  if (!search_next_match(line_touser, touserlen)) {
		     search = 0;
		     strcpy(line_touser, " \r\r\nNo match\r\n");
		     *touserlen = strlen(line_touser);
		  }
	       }
	       else {
		  do {
		     bottom_pos++;
		     if (disp_width == bottom_pos) {
			bottom_pos = 0;
			bottom_line++;
			bottom_line %= disp_height;
		     }
		  } while (isalpha(disp[(bottom_line + last_line + 1) %
					disp_height][bottom_pos]) ||
			   isdigit(disp[(bottom_line + last_line + 1) %
					disp_height][bottom_pos]));
		  bottom_pos--;
		  if (0 == bottom_pos) {
		     bottom_pos = disp_width - 1;
		     bottom_line += disp_height - 1;
		     bottom_line %= disp_height;
		  }
	       }
	       break;
	       default:
	       cerr << "No such search command" << endl;
	       exit(1);
	       }
	 else if (!next_char_lit && '\\' == line_toappl[0])
	    next_char_lit = 1;
	 else if (!next_char_lit && isdigit(line_toappl[0]))
	    save_to_reg(line_toappl[0] - '0');
	 else if (META_CHAR == line_toappl[0])
	    search = 0;
	 else {
	    next_char_lit = 0;
	    bottom_pos++;
	    if (disp_width == bottom_pos) {
	       bottom_pos = 0;
	       bottom_line++;
	       bottom_line %= disp_height;
	    }
	    if (line_toappl[0] != disp[(last_line + bottom_line + 1) %
				disp_height][bottom_pos])
	       if (!search_next_match(line_touser, touserlen)) {
		  search = 0;
		  strcpy(line_touser, " \r\r\nNo match\r\n");
		  *touserlen = strlen(line_touser);
	       }
	 }
	 if ('r' != search_pattern.realstr()[0] &&
	     ('\\' != search_pattern.realstr()[0] || !next_char_lit))
	    show_sel_area(line_touser, touserlen);
      }
      if (!dont_discard && !agent_active) {
	 line_toappl[0] = '\0';
	 *toappllen = 0;
      }
   }
   if (agent_active) {
      if (proc_mode != agent_scenario->line_md ||
	  in == proc_mode && !dont_discard &&
	  strcmp(agent_scenario->line->realstr(), line_toappl)) {
	 cerr << "Agent scenario sequence error" << endl;
	 exit(1);
      }
      if (0 == *touserlen) {
	 *longwait = 0;
	 if (0 == agent_scenario->next) {
	    agent_active = 0;
	 }
      }
      for (short cn = 0; context[cn] && cn < MAX_CONTEXTS; cn++)
	 if (!strcmp("nolongwait", context[cn]->realstr()) ||
	     !strcmp("linemode", context[cn]->realstr())) {
	    *longwait = 0;
	    if (0 == agent_scenario->next) {
	       agent_active = 0;
	    }
	    if (!strcmp("nolongwait", context[cn]->realstr())) {
	       context[cn]->empty();
	       delete context[cn];
	       for (short cn1 = cn; cn1 < MAX_CONTEXTS - 1; cn1++)
		  context[cn1] = context[cn1 + 1];
	    }
	 }
      if (in == agent_scenario->line_md && '\r' == *line_toappl)
	 for (short cn = 0; context[cn] && cn < MAX_CONTEXTS; cn++)
	    if (!strcmp("linemode", context[cn]->realstr())) {
	       context[cn]->empty();
	       delete context[cn];
	       for (short cn1 = cn; cn1 < MAX_CONTEXTS - 1; cn1++)
		  context[cn1] = context[cn1 + 1];
	       break;
	    }
      if (META_CHAR == line_toappl[0]) {
	 line_toappl[0] = '\0';
	 *toappllen = 0;
      }
      if (select_parent) {
	 agent_scenario = agent_scenario->parent;
	 select_parent = 0;
	 *callback = 1;
	 *longwait = 0; // probably not necessary
	 strcpy(&next_input[0], agent_scenario->line->realstr());
	 if (out == agent_scenario->line_md)
	    cerr << "Bad scenario parent setup" << endl;
      } else if (!*longwait)
	 if (0 == agent_scenario->next) {
	    if (cycle) {
	       agent_active = 1;
	       if (!(++numCycles % 100))
		  checkFromTimeToTime();
	       agent_scenario = last_action->body;
	       if (!dont_discard) {
		  line_toappl[0] = '\0';
		  *toappllen = 0;
	       }
	       if (in == agent_scenario->line_md) {
		  *callback = 1;
		  strcpy(&next_input[0], agent_scenario->line->realstr());
	       }
	    }
	    else {
	       agent_active = 0;
	    }
	 }
	 else {
	    if (pick_alt_branch) {
	       agent_scenario = agent_scenario->alt_branch;
	       pick_alt_branch = 0;
	    }
	    else
	       agent_scenario = agent_scenario->next;
	    if (in == agent_scenario->line_md) {
	       *callback = 1;
	       strcpy(&next_input[0], agent_scenario->line->realstr());
	    }
	    else {
	       *longwait = 1;
	       tmpline[0] = '\0';
	       for (short cn = 0; context[cn] && cn < MAX_CONTEXTS; cn++)
		  if (!strcmp("linemode", context[cn]->realstr())) {
		     *longwait = 0;
		     break;
		  }
	    }
	 }
      if (!dont_discard && cmd == curr_md) {
	 line_toappl[0] = '\0';
	 *toappllen = 0;
      }
      if (!agent_active) {
	 deactActMB();
      }
   }
   if (!dont_discard && skip_proc_line) {
      *toappllen = 0;
      line_toappl[0] = '\0';
   }
}

void
screen::updateStatus()
{
   resetStatus();
   for (macro_link* b = in_macros; 0 != b->macroName; b = b->next) {
      short in_ctxt = 1;
      for (short bcn = 0; in_ctxt && b->context[bcn] &&
	   bcn < MAX_CONTEXTS; bcn++) {
	 short this_cont_found = 0;
	 for (short cn = 0; !this_cont_found && context[cn]
	      && cn < MAX_CONTEXTS; cn++) {
	    this_cont_found =
	       matchglob(b->context[bcn]->realstr(),
			 context[cn]->realstr());
	 }
	 in_ctxt = in_ctxt && this_cont_found;
      }
      for (short cn = 0; in_ctxt && context[cn] &&
	   cn < MAX_CONTEXTS; cn++) {
         if (strcmp("linemode", context[cn]->realstr()) &&
             strcmp("nolongwait", context[cn]->realstr())) {
	    short this_cont_found = 0;
            for (short bcn = 0; !this_cont_found && b->context[bcn]
	         && bcn < MAX_CONTEXTS; bcn++) {
	       this_cont_found =
	          matchglob(context[cn]->realstr(),
			    b->context[bcn]->realstr());
	    }
	    in_ctxt = in_ctxt && this_cont_found;
         }
      }
      if (in_ctxt)
	 sendName(b->macroName->realstr(), 'i');
   }
   for (b = out_macros; 0 != b->macroName; b = b->next)
      if (0 != b->context[0] && '|' != b->macroName->realstr()[0]) {
	 short in_ctxt = 1;
	 for (short bcn = 0; in_ctxt && b->context[bcn] &&
	      bcn < MAX_CONTEXTS; bcn++) {
	    short this_cont_found = 0;
	    for (short cn = 0; !this_cont_found && context[cn]
		 && cn < MAX_CONTEXTS; cn++) {
	       this_cont_found =
		  matchglob(b->context[bcn]->realstr(),
			    context[cn]->realstr());
	    }
	    in_ctxt = in_ctxt && this_cont_found;
	 }
	 for (short cn = 0; in_ctxt && context[cn] &&
	      cn < MAX_CONTEXTS; cn++) {
            if (strcmp("linemode", context[cn]->realstr()) &&   
	        strcmp("nolongwait", context[cn]->realstr())) {
	       short this_cont_found = 0;
	       for (short bcn = 0; !this_cont_found && b->context[bcn]
		    && bcn < MAX_CONTEXTS; bcn++) {
	          this_cont_found =
		     matchglob(context[cn]->realstr(),
			       b->context[bcn]->realstr());
	       }
	       in_ctxt = in_ctxt && this_cont_found;
            }
	 }
	 if (in_ctxt)
	    sendName(b->macroName->realstr(), 'o');
      }
   for (agent_link* al = ag.actions; 0 != al->name; al = al->next) {
        short in_ctxt = 1;
	for (short acn = 0; in_ctxt && al->context[acn] &&
             acn < MAX_CONTEXTS; acn++) {
           short this_cont_found = 0;
           for (short cn = 0; !this_cont_found && context[cn] &&
                cn < MAX_CONTEXTS; cn++) {
              this_cont_found =
                 matchglob(al->context[acn]->realstr(),
                           context[cn]->realstr());
           }
           in_ctxt = in_ctxt && this_cont_found;
        }
	for (short cn = 0; in_ctxt && context[cn] &&
             cn < MAX_CONTEXTS; cn++) {
           if (strcmp("linemode", context[cn]->realstr()) &&   
	       strcmp("nolongwait", context[cn]->realstr())) {
              short this_cont_found = 0;
              for (short acn = 0; !this_cont_found && al->context[acn] &&
                   acn < MAX_CONTEXTS; acn++) {
                 this_cont_found =
                    matchglob(context[cn]->realstr(),
                              al->context[acn]->realstr());
              }
              in_ctxt = in_ctxt && this_cont_found;
           }
        }
        if (in_ctxt) {
            sendName(al->name->realstr(), 'a');
        }
    }
}

short
screen::found_pattern(string* pattern)
{
   for (short r = 1; r <= disp_height; r++)
      for (short c = 0; c < disp_width; c++) {
	 int index = 0;
	 short offs_r = 0;
	 short offs_c = 0;
	 short stuff = 0;
	 short match = 1;
	 do {
	    if ('\0' == pattern.realstr()[index]) {
	       match = 0;
	       break;
	    } else if ('\n' == pattern.realstr()[index]) {
	       offs_c = 0;
	       offs_r++;
	    } else if ('\\' == pattern.realstr()[index] && !stuff) {
	       stuff = 1;
	    } else if ('#' == pattern.realstr()[index]) {
	       if (stuff) {
		  if (r + offs_r <= disp_height && c + offs_c < disp_width &&
		      '#' == disp[(last_line + r + offs_r) % disp_height]
		      [c + offs_c]) {
		     offs_c++;
		     stuff = 0;
		  } else {
		     match = 0;
		     break;
		  }
	       } else {
		  offs_c++;
	       }
	    } else {
	       if (r + offs_r > disp_height || c + offs_c >= disp_width ||
		   pattern.realstr()[index] != 
		   disp[(last_line + r + offs_r) % disp_height]
		   [c + offs_c]) {
		  match = 0;
		  break;
	       } else {
		  offs_c++;
	       }
	       stuff = 0;
	    }
	    index++;
	 } while ('\0' != pattern->realstr()[index]);
	 if (match)
	    return 1;
      }
   return 0;
}

void
screen::checkFromTimeToTime()
{
   ;
}
