
#
#======================================================================
#     TkVSform - general-purpose forms facility for Tk4.X
#                   version: 1.0 beta 1
#
# Copyright (c) 1995, Steven B. Wahl
# See the file "license.terms" for information on usage and
# redistribution of this file, and for a DISCLAIMER OF ALL WARRANTIES.
#
#=====================================================================
#
# ---- Public Procedures ----
#===================  form composition procedures ====================
# formBEGIN fvar [title] [pos] [wtoposto] ["MAIN"]
#      begin composition of a new form
# 
# formGROUP fvar
#      start a new grouping of lines on the form
#
# formNEWLINE fvar
#      start a new line of items on the form
#
# formCHECK fvar statetag prompt var [elem] ["tkopts"]
#      create checkbox 
#
# formRADIO fvar statetag prompt var [elem] ["tkopts"]
#      create a radio button
#
# formBUTTON fvar statetag prompt cmd [cmdargs] [width] ["tkopts"]
#      create a button 
#
# formLABEL fvar statetag prompt [var] [elem] [width] ["tkopts"]
#      create a fixed string label, or prompt plus updateable string
#
# formMESSAGE fvar statetag var [elem] ["tkopts"]
#      create a message area
#
# formENTRY fvar statetag var [elem] [width] [cmd] [cmdargs] ["tkopts"]
#      create a type-in entry widget
#
# formPASSWORD fvar statetag var [elem] [width] [cmd] [cmdargs] ["tkopts"]
#      same as formENTRY, but echo "*" in place of characters
#
# formTEXT fvar statetag var [elem] [width] [height] ["tkopts"]
#      create a scrollable text area, associate with a variable
#
# formLIST fvar statetag invar inelem outvar [outelem] [width] [height] \
#          ["tkopts"] 
#      create a scrollable, single-selection list
#
# formEND fvar ["on" | "off"] [focuseditempath] ["hardfocus"]
#      completed form definition, display it (or not), set exclusive 
#      focus when displayed
# 
#=================== runtime form management procedures =================
#
# formSHOW fvar ["on" | "off"]
#      display a form or withdraw it from view
#
# formDIE fvar
#      destroy a form
#
# formPATHS fvar [pattern]
#      return widget paths list for widget paths meeting a glob-style 
#      pattern
#
# formSTATE fvar statetag ["on" | "off"]
#      make active or inactive (grayed out, non-selectable) all form 
#      widgets associated with "statetag" name
#
# formCURSOR fvar ["normal" | "busy" | "alt"] [altcursorname]
#      make cursor over form normal, hourglass, or some alternative
#
# formTEXTREFRESH fvar
#      update the contents of all TEXT widgets from their associated
#      variables for a form
#
# formTEXTTRACE fvar ["on" | "off"]
#      turn on/off two-way updating between TEXT widgets and their
#      associated data source variables
#
# formLISTCLEAR fvar [listitempath]
#      clear the contents of a LIST widget
#
# formLISTUPDATE fvar listitempath var [elem]
#      update the contents of a LIST widget
#
# ===================== internal use only procedures ======================
# formiMARK fvar itempath
#      mark a form widget as having been modified
# 
# formiUPDATEVAR fvar itempath
#      update the variable associated with a form widget
# 
# formiUPDATETEXT fvar itempath var elem optype
#      trace a variable associated with text widget and update form
# 
# formiLISTSELBEGIN w y
#      list selection initializer
# 
# formiLISTSELMOVE w y 
#      list selection motion
#
# formiLISTSELEND vflag fvar w y ivar ielem ovar oelem
#      list selection completion, perform update of selection 
#
# formiLISTSELKEYEND vflag fvar w ivar ielem ovar oelem
#      list selection via <Return> completion, perform update of selection 
#
# ----------------- form widget naming conventions ----------------------
#
# NOTES:
# path naming structure
# .$fvar                      top level form window
# .$fvar.g#                   frame for a group
# .$fvar.g#.s#                frame for a line of items
# .$fvar.g#.s#.if#            frame for an item
# .$fvar.g#.s#.if#.itemtype#  frame for subitem where "itemtype" is:
#                               CHK RAD BUT LAB MSG ENT TXT LST
#
# example:
#     .f.g1.s1.if1.BUT1    first item (Button) in first line in first group
#     .f.g3.s4.if3.ENT3    3rd item (Entry) in 4th linee in 3rd group
#
#=========================================================================
# Procedures:
#=========================================================================
#  formBEGIN -- create a new toplevel form, set its title and position
proc formBEGIN {fvar {title ""} {pos "+100+100"} {wtoposto ""} \
        {main "NOTMAIN"}} {
    global $fvar
    # -- initialize path name counters and other lists
    set ${fvar}(version) "1.0b1"
    set ${fvar}(gcnt) 0
    set ${fvar}(scnt) 0
    set ${fvar}(icnt) 0
    set ${fvar}(first) {}
    set ${fvar}(items) ""
    set ${fvar}(stripelist) {}
    # -- general form state information
    set ${fvar}(visible) 0
    set ${fvar}(focusitem) ""
    set ${fvar}(focustype) "soft"
    # -- create the toplevel window
    if {$main == "MAIN" && [wm state .] != "withdrawn"} {
        wm withdraw .
    }
    toplevel .$fvar
    wm title .$fvar $title
    wm geometry .$fvar $pos
    wm withdraw .$fvar
    # -- reminder, do something with relative positioning later...
}

#-----------------
# formGROUP -- create a new group of logically associated widgets
proc formGROUP {fvar} {
    global $fvar
    # -- see if previous line needs packing
    if {[string length [set ${fvar}(stripelist)]] > 0} {
        set a "pack [set ${fvar}(stripelist)] -side left -padx 1m -pady 1"
        eval $a
        set ${fvar}(stripelist) {}
    }
    incr ${fvar}(gcnt)
    set ${fvar}(scnt) 0
    set ${fvar}(icnt) 0
    set path ".$fvar.g[set ${fvar}(gcnt)]"
    frame $path -relief ridge -bd 3 
    pack $path -side top -fill x
    # -- reminder, do something with fvarGroup title later...
    return $path
}

#-----------------
# formNEWLINE -- create a new horizontal band of widgets in the current group
proc formNEWLINE {fvar} {
    global $fvar
    # -- see if previous line needs to be packed
    if {[string length [set ${fvar}(stripelist)]] > 0} {
        set a "pack [set ${fvar}(stripelist)] -side left -padx 1m -pady 1"
        eval $a
        set ${fvar}(stripelist) {}
    }
    incr ${fvar}(scnt)
    set ${fvar}(icnt) 0
    set path ".$fvar.g[set ${fvar}(gcnt)].s[set ${fvar}(scnt)]"
    frame $path
    pack $path -side top -fill x -expand yes
    return $path
}

#-----------------
# formCHECK -- create a checkbox widget on current line
proc formCHECK {fvar statetag prompt var {elem ""} {tkopts ""}} {
    global $fvar $var
    # -- increment item count, create a path and an item frame
    incr ${fvar}(icnt) 1
    set fpath \
      ".$fvar.g[set ${fvar}(gcnt)].s[set ${fvar}(scnt)].if[set ${fvar}(icnt)]"
    frame $fpath
    # -- set the item name in the widget path
    set path "${fpath}.chk"
    set tvar $var
    if {$elem != {}} {set tvar "${var}($elem)"}
    if {$tvar == {}} {
        error "formCHECK error: must specify "var" argument for $path"
    }
    checkbutton $path -text "$prompt" -variable "$tvar" -anchor w
    pack $path 
    lappend ${fvar}(items) $path
    set ${fvar}(state,$path) 1
    if {$statetag != ""} {lappend ${fvar}($statetag) $path}
    set ${fvar}(type,$path) "CHECK"
    if {$tkopts != ""} {eval "$path configure $tkopts"}
    if {[info exists ${fvar}(first)]} {set ${fvar}(first) $path}
    lappend ${fvar}(stripelist) $fpath
    if {$statetag != ""} {set ${fvar}($statetag,state) 1}
    return $path
}

#---------------------
# formRADIO -- create a radio button on current line
proc formRADIO {fvar statetag prompt var {elem ""} {tkopts ""}} {
    global $fvar $var
    # -- increment item count, create a path and an item frame
    incr ${fvar}(icnt) 1
    set fpath \
      ".$fvar.g[set ${fvar}(gcnt)].s[set ${fvar}(scnt)].if[set ${fvar}(icnt)]"
    frame $fpath
    # -- set the item name in the widget path
    set path "${fpath}.rad"
    set tvar $var
    if {$elem != {}} {set tvar "${var}($elem)"}
    if {$tvar == {}} {
        error "formRADIO error: must specify "var" argument for $path"
    }
    radiobutton $path -text "$prompt" -variable "$tvar" \
            -value "$prompt" -anchor w
    pack $path
    lappend ${fvar}(items) $path
    set ${fvar}(state,$path) 1
    if {$statetag != ""} {lappend ${fvar}($statetag) $path}
    set ${fvar}(type,$path) "RADIO"
    bind $path <Return> "$path invoke"
    if {$tkopts != ""} {eval "$path configure $tkopts"}
    if {[info exists ${fvar}(first)]} {set ${fvar}(first) $path}
    lappend ${fvar}(stripelist) $fpath
    if {$statetag != ""} {set ${fvar}($statetag,state) 1}
    return $path
}

#---------------------
# formBUTTON -- create a button on current line
proc formBUTTON {fvar statetag prompt cmd {cmdargs ""} {width ""} {tkopts ""}} {
    global $fvar 
    # -- increment item count, create a path and an item frame
    incr ${fvar}(icnt) 1
    set fpath \
      ".$fvar.g[set ${fvar}(gcnt)].s[set ${fvar}(scnt)].if[set ${fvar}(icnt)]"
    frame $fpath
    # -- set the item name in the widget path
    set path "${fpath}.but"
    if {$width == ""} {set width [string length "$prompt"]}
    button $path -text "$prompt" -width $width -command "$cmd [concat $cmdargs]"
    bind $path <Return> "$path flash; $path invoke;"
    bind $path <1> "$path flash;"
    set bt [bindtags $path]
    bindtags $path [list \
            [lindex $bt 1] [lindex $bt 0] [lindex $bt 2] [lindex $bt 3]]
    pack $path
    lappend ${fvar}(items) $path
    if {$statetag != ""} {lappend ${fvar}($statetag) $path}
    set ${fvar}(state,$path) 1
    set ${fvar}(type,$path) BUTTON
    if {$tkopts != ""} {eval "$path configure $tkopts"}
    if {[info exists ${fvar}(first)]} {set ${fvar}(first) $path}
    lappend ${fvar}(stripelist) $fpath
    if {$statetag != ""} {set ${fvar}($statetag,state) 1}
    return $path
}

#---------------------
# formLABEL -- create a label (text string) on the current line
proc formLABEL {fvar statetag prompt {var ""} {elem ""} {width ""} \
                {tkopts ""}} {
    global $fvar 
    if {$var!=""} {global $var}
    # -- increment item count, create a path and an item frame
    incr ${fvar}(icnt) 1
    set fpath \
      ".$fvar.g[set ${fvar}(gcnt)].s[set ${fvar}(scnt)].if[set ${fvar}(icnt)]"
    frame $fpath
    # -- set the item name in the widget path
    set path "${fpath}.lab"
    if {$width == ""} {set width [string length "$prompt"]}
    set tvar $var
    if {$elem != ""} {set tvar "${var}($elem)"}
    if {$width == ""} {set width 25}
    if {$prompt != ""} {
        label $fpath.prompt -text "$prompt" -anchor w 
        if {$statetag != ""} {lappend ${fvar}($statetag) $fpath.prompt}
        pack $fpath.prompt -side left
        lappend ${fvar}(items) $fpath.prompt
        set ${fvar}(state,$fpath.prompt) "ON"
        set ${fvar}(type,$fpath.prompt) "LABEL"
        }
    if {$var != ""} {
        label $path -textvariable "$tvar" -width $width \
            -anchor w \
            -font -Adobe-Helvetica-Medium-R-Normal--*-120-*-*-*-*-*-*
        pack $path -side left 
        lappend ${fvar}(items) $path
        if {$statetag != ""} {lappend ${fvar}($statetag) $path}
        set ${fvar}(state,$path) "ON"
        set ${fvar}(type,$path) "LABEL"
    }
    if {$tkopts != ""} {eval "$path configure $tkopts"}
    if {[info exists ${fvar}(first)]} {set ${fvar}(first) $path}
    lappend ${fvar}(stripelist) $fpath
    if {$statetag != ""} {set ${fvar}($statetag,state) 1}
    return $path
}

#------------------
# formMESSAGE -- create a message area (multiline label) on current line
proc formMESSAGE {fvar statetag var {elem ""} {tkopts ""}} {
    global $fvar $var
    # -- increment item count, create a path and an item frame
    incr ${fvar}(icnt) 1
    set fpath \
      ".$fvar.g[set ${fvar}(gcnt)].s[set ${fvar}(scnt)].if[set ${fvar}(icnt)]"
    frame $fpath
    # -- set the item name in the widget path
    set path "${fpath}.msg"
    set tvar $var
    if {$elem != ""} {set tvar "${var}($elem)"}
    if {$var == ""} {
        error "Item:  (MESSAGE widget) must specify variable for $path"
    }
    if {[info exists $var]} {
        message $path -textvariable "$tvar" \
                -justify left -aspect 1000 -anchor w \
                -font -Adobe-Helvetica-Medium-R-Normal--*-120-*-*-*-*-*-*
    } else {
        message $path -text [set $tvar] \
                -justify left -aspect 1000 -anchor w \
                -font -Adobe-Helvetica-Medium-R-Normal--*-120-*-*-*-*-*-*
    }
    pack $path -side left
    lappend ${fvar}(items) $path
    if {$statetag != ""} {lappend ${fvar}($statetag) $path}
    set ${fvar}(state,$path) "ON"
    set ${fvar}(type,$path) "MESSAGE"
    if {$tkopts != ""} {eval "$path configure $tkopts"}
    if {[info exists ${fvar}(first)]} {set ${fvar}(first) $path}
    lappend ${fvar}(stripelist) $fpath
    if {$statetag != ""} {set ${fvar}($statetag,state) 1}
    return $path
}

#------------------
# formENTRY -- create a type-in entry widget on current line
proc formENTRY {fvar statetag var {elem ""} {width ""} {cmd ""} \
                {cmdargs ""} {tkopts ""}} {

    global $fvar 
    if {$var!=""} {global $var}
    # -- increment item count, create a path and an item frame
    incr ${fvar}(icnt) 1
    set fpath \
      ".$fvar.g[set ${fvar}(gcnt)].s[set ${fvar}(scnt)].if[set ${fvar}(icnt)]"
    frame $fpath
    # -- set the item name in the widget path
    set path "${fpath}.ent"
    if {$width == ""} {set width 25}
    set tvar $var
    if {$elem != ""} {set tvar "${var}($elem)"}
    if {$var == ""} {
        error "Item:  (ENTRY widget) must specify variable for $path"
    }
    entry $path -textvariable "$tvar" -width $width -relief sunken -bd 2
    pack $path -side left
    lappend ${fvar}(items) $path
    if {$cmd != ""} {
        bind $path <Return> \
                "focus [tk_focusNext $path]; eval [list $cmd $fvar $path $var $elem $cmdargs]; break"
    } else {
        bind $path <Return> {focus [tk_focusNext %W]; break}
    }
    if {$statetag != ""} {lappend ${fvar}($statetag) $path}
    set ${fvar}(state,$path) "ON"
    set ${fvar}(type,$path) "ENTRY"
    if {$tkopts != ""} {eval "$path configure $tkopts"}
    if {[info exists ${fvar}(first)]} {set ${fvar}(first) $path}
    lappend ${fvar}(stripelist) $fpath
    if {$statetag != ""} {set ${fvar}($statetag,state) 1}
    return $path
}

#------------------
# formPASSWORD -- create a type-in password widget on current line
proc formPASSWORD {fvar statetag var {elem ""} {width ""} {cmd ""} \
                {cmdargs ""} {tkopts ""}} {
    global $fvar 
    if {$var!=""} {global $var}
    # -- increment item count, create a path and an item frame
    incr ${fvar}(icnt) 1
    set fpath \
      ".$fvar.g[set ${fvar}(gcnt)].s[set ${fvar}(scnt)].if[set ${fvar}(icnt)]"
    frame $fpath
    # -- set the item name in the widget path
    set path "${fpath}.ent"
    if {$width == ""} {set width 25}
    set tvar $var
    if {$elem != ""} {set tvar "${var}($elem)"}
    if {$var == ""} {
        error "Item:  (PASSWORD widget) must specify variable for $path"
    }
    entry $path -textvariable "$tvar" -show "*" -width $width \
            -relief sunken -bd 2
    pack $path -side left
    lappend ${fvar}(items) $path
    if {$cmd != ""} {
        bind $path <Return> \
                "focus [tk_focusNext $path]; eval [list $cmd $fvar $path $var $elem $cmdargs]; break"
    } else {
        bind $path <Return> {focus [tk_focusNext %W]; break}
    }
    if {$statetag != ""} {lappend ${fvar}($statetag) $path}
    set ${fvar}(state,$path) "ON"
    set ${fvar}(type,$path) "ENTRY"
    if {$tkopts != ""} {eval "$path configure $tkopts"}
    if {[info exists ${fvar}(first)]} {set ${fvar}(first) $path}
    lappend ${fvar}(stripelist) $fpath
    if {$statetag != ""} {set ${fvar}($statetag,state) 1}
    return $path
}

#-----------------
# formTEXT -- create a scrollable text area widget
proc formTEXT {fvar statetag var {elem ""} {width ""} {height ""} \
        {tkopts ""}} {
    global $fvar 
    if {$var!=""} {global $var}
    # -- increment item count, create a path and an item frame
    incr ${fvar}(icnt) 1
    set fpath \
      ".$fvar.g[set ${fvar}(gcnt)].s[set ${fvar}(scnt)].if[set ${fvar}(icnt)]"
    frame $fpath
    # -- set the item name in the widget path
    set path "${fpath}.txt"
    if {$width == ""} {set width 45}
    if {$height == ""} {set height 8}
    set tvar $var
    if {$elem != ""} {set tvar "${var}($elem)"}
    if {$var == ""} {
        error "Item:  (TEXT widget) must specify variable for $path"
    }
    text $path -relief sunken -bd 2 -yscrollcommand "$fpath.vscroll set" \
            -width $width -height $height -wrap word
    pack $path -side left
    if {$statetag != ""} {lappend ${fvar}($statetag) $path}
    scrollbar $fpath.vscroll -relief sunken -command "$path yview"
    pack $fpath.vscroll -side right -fill y
    if {$statetag != ""} {lappend ${fvar}($statetag) $fpath.vscroll}
    bind $fpath <Any-Enter> "focus $path"
    $path delete 1.0 end
    $path insert end [set $tvar]
    bind $path <Any-Enter> "focus %W"
    bind $path <Leave> "formiUPDATEVAR $fvar %W"
    bind $path <Tab> {focus [tk_focusNext %W]; break}
    bind $path <Shift-Tab> {focus [tk_focusPrev %W]; break}
    bind $path <FocusIn> "focus %W;"
    bind $path <FocusOut> "formiUPDATEVAR $fvar %W;"
    bind $path <Any-KeyPress> "formiMARK $fvar %W;"
    bindtags $path [linsert [bindtags $path] 0 $path] 
    trace variable $tvar w "formiUPDATETEXT $fvar $path"
    lappend ${fvar}(textitems) $path
    lappend ${fvar}(items) $path
    lappend ${fvar}(items) $fpath.vscroll
    set ${fvar}(state,$fpath.vscroll) "ON"
    set ${fvar}(type,$fpath.vscroll) "SCROLL"
    set ${fvar}(state,$path) "ON"
    set ${fvar}(type,$path) "TEXT"
    set ${fvar}(dirty,$path) 0
    set ${fvar}(var,$path) $var
    set ${fvar}(elem,$path) $elem
    if {$tkopts != ""} {eval "$path configure $tkopts"}
    if {[info exists ${fvar}(first)]} {set ${fvar}(first) $path}
    lappend ${fvar}(stripelist) $fpath
    if {$statetag != ""} {set ${fvar}($statetag,state) 1}
    return $path
}

#---------------------
# formLIST -- add a scrollable single-selection list widget to line
# formLIST fvar statetag invar inelem outvar outelem width height ["tkopts"] 
proc formLIST {fvar statetag invar inelem outvar {outelem ""} {width ""} \
               {height ""} {tkopts ""}} {
    global $fvar 
    if {$invar != ""} {global $invar}
    if {$outvar != ""} {global $outvar}
    # -- increment item count, create a path and an item frame
    incr ${fvar}(icnt) 1
    set fpath \
      ".$fvar.g[set ${fvar}(gcnt)].s[set ${fvar}(scnt)].if[set ${fvar}(icnt)]"
    frame $fpath
    # -- set the item name in the widget path
    set path "${fpath}.lst"
    if {$width == ""} {set width 15}
    if {$height == ""} {set height 5}
    set tvar $invar
    if {$inelem != ""} {set tvar "${invar}($inelem)"}
    if {$invar == ""} {
        error "Item:  (LIST widget) must specify list source for $path"
    }
    if {$outvar == ""} {
        error "Item:  (LIST widget) must specify output variable for $path"
    }
    set vflag 0
    if {[info exists $invar]} {set vflag 1}
    set inproc ""
    if {[info procs $invar] != ""} {
        set vflag 2
        set inproc $invar
        set inprocarg $inelem
        set outproc $outvar
        set outprocarg $outelem
    }
    set ovflag 0
    if {[info procs $outvar] != ""} {
        set ovflag 2
    } elseif {[info exists $outvar]} {
        set ovflag 1
    }
    # -- implement listbox here...
    # -- create and pack and bind listbox widgets
    eval [list listbox $path \
            -yscrollcommand [list $fpath.vscroll set] \
            -xscrollcommand [list $fpath.p.hscroll set] \
            -width $width -height $height -setgrid true \
            -selectmode single]
    lappend ${fvar}(items) $path
    lappend #{fvar}(listitems) $path
    set ${fvar}(state,$path) "ON"
    set ${fvar}(type,$path) "LIST"
    scrollbar $fpath.vscroll -orient vertical \
            -command [list $path yview]
    frame $fpath.p
    scrollbar $fpath.p.hscroll -orient horizontal \
            -command [list $path xview]
    set pad [expr [$fpath.vscroll cget -width] + 2 * \
            ([$fpath.vscroll cget -bd] + \
            [$fpath.vscroll cget -highlightthickness])] 
    frame $fpath.p.it -width $pad -height $pad
    pack $fpath.p -side bottom -fill x
    pack $fpath.p.it -side right
    pack $fpath.p.hscroll -side bottom -fill x
    pack $fpath.vscroll -side right -fill y
    pack $path -side left -fill both -expand true
    if {$statetag != ""} {
        lappend ${fvar}($statetag) $path
        lappend ${fvar}($statetag) $fpath.p.hscroll
        lappend ${fvar}($statetag) $fpath.vscroll
    }
    lappend ${fvar}(items) $fpath.vscroll
    set ${fvar}(state,$fpath.vscroll) "ON"
    set ${fvar}(type,$fpath.vscroll) "SCROLL"
    lappend ${fvar}(items) $fpath.p.hscroll
    set ${fvar}(state,$fpath.p.hscroll) "ON"
    set ${fvar}(type,$fpath.p.hscroll) "SCROLL"
    bind $path <ButtonPress-1> {formiLISTSELBEGIN %W %y}
    bind $path <B1-Motion> {formiLISTSELMOVE %W %y}
    bind $path <ButtonRelease-1> \
            [list formiLISTSELEND $fvar %W %y $vflag $invar $inelem $ovflag $outvar $outelem]
    bind $path <Return> \
            [list formiLISTSELKEYEND $fvar %W $vflag $invar $inelem $ovflag $outvar $outelem]
    bind $path <Up> {
        tkCancelRepeat
        tkListboxBeginSelect %W [%W index active]
        %W activate [%W index active]
    }
    bind $path <Down> {
        # tkListboxUpDown %W 1
        tkCancelRepeat
        tkListboxBeginSelect %W [%W index active]
        %W activate [%W index active]
    }
    # -- Insert choises into list
    if {$vflag == 2} {
        # -- make note of special list insertion handler
        formLISTUPDATE $fvar $path $inproc $inprocarg
        set ${fvar}(listinproc,$path) $inproc
        lappend ${fvar}(listinprocs) $path
        set ${fvar}(listoutproc,$path) $outproc
        lappend ${fvar}(listoutprocs) $path
    } else {
        formLISTUPDATE $fvar $path $invar $inelem
    }
    set ${fvar}(dirty,path) 0
    if {$tkopts != ""} {eval "$path configure $tkopts"}
    if {[info exists ${fvar}(first)]} {set ${fvar}(first) $path}
    lappend ${fvar}(stripelist) $fpath
    if {$statetag != ""} {set ${fvar}($statetag,state) 1}
    return $path
}    

#-----------------
# formEND -- close definition of the form, display it
#
proc formEND {fvar {showit "on"} {focuseditem ""} {focustype ""}} {
    global $fvar
    # -- see if previous stripe needs to be packed
    if {[string length [set ${fvar}(stripelist)]] > 0} {
        set a "pack [set ${fvar}(stripelist)] -side left -padx 1m -pady 1"
        eval $a
        set ${fvar}(stripelist) {}
    }
    # -- if a focus item was provide, set focus to it
    set ${fvar}(focuseditem) $focuseditem
    if {$focuseditem != ""} {
        focus -force $focuseditem
    } else {
        if {![info exists ${fvar}(first)]} {
            focus [set ${fvar}(first)]
        }
    }
    set ${fvar}(focustype) $focustype
    update
    if {$showit == "on"} {
        wm deiconify .$fvar
        tkwait visibility .$fvar
        set ${fvar}(visibility) 1
        if {$focustype == "lockinput"} {
            grab -global .$fvar
        } else {
            grab .$fvar
        }
    } else {
        set ${fvar}(visibility) 0
    }        
}

#----------------
# formDIE -- delete the form, free resources, delete control variable
proc formDIE {fvar} {
    global $fvar
    grab release .$fvar
    wm withdraw .$fvar
    formTEXTTRACE $fvar off
    destroy .$fvar
    unset $fvar
}

#-----------------
# formSHOW -- display or withdraw a form (non-destructive)
proc formSHOW {fvar {showit "on"}} {
    global $fvar
    if {$showit == "on"} {
        if {[set ${fvar}(focuseditem)] != ""} {
            focus [set ${fvar}(focuseditem)]
        } else {
            if {![info exists ${fvar}(first)]} {
                focus [set ${fvar}(first)]
            }
        }
        wm deiconify .$fvar
        tkwait visibility .$fvar
        set ${fvar}(visibility) 1
        if {[set ${fvar}(focustype)] == "hardfocus"} {
            grab -global .$fvar
        } else {
            grab .$fvar
        }
    } else {
        set ${fvar}(visibility) 0
        grab release .$fvar
        wm withdraw .$fvar
    }
}

#----------------
# formPATHS -- return all widget paths matching path pattern
proc formPATHS {fvar {pattern "*"}} {
    global $fvar
    set l [set ${fvar}(items)]
    set r ""
    foreach x $l {
        if {[string match $pattern $x]} {
            lappend r $x
        }
    }
    return [lsort $r]
}

#----------------
# formSTATE -- activate / deactivate all widgets associated with statetag
#
proc formSTATE {fvar statetag {opcode "on"}} {
    global $fvar
    foreach i [set ${fvar}($statetag)] {
        if {$opcode == "on"} {
            switch [set ${fvar}(type,$i)] {
                BUTTON -
                RADIO -
                CHECK {
                    $i configure -state normal
                    $i configure -takefocus 1
                }
                ENTRY -
                LIST {
                    $i configure -foreground black
                    $i configure -takefocus 1
                }
                TEXT {
                    $i configure -foreground black
                    $i configure -state normal
                    $i configure -takefocus 1
                }
                MESSAGE -
                LABEL {
                    $i configure -foreground black
                }
                SCROLL {
                    $i configure -activebackground black
                    $i configure -takefocus 0
                }
                default {}
            }
        } else {
            switch [set ${fvar}(type,$i)] {
                BUTTON -
                RADIO -
                CHECK {
                    $i configure -state disabled
                    $i configure -takefocus 0
                }
                ENTRY -
                LIST {
                    $i configure -foreground gray75
                    $i configure -takefocus 0
                }
                TEXT {
                    $i configure -foreground gray75
                    $i configure -state disabled
                    $i configure -takefocus 0
                }
                MESSAGE -
                LABEL {
                    $i configure -foreground gray75
                }
                SCROLL {
                    $i configure -activebackground gray75
                    $i configure -takefocus 0
                }
                default {}
            }
        }
    }
}

#-----------------
# formCURSOR -- set the cursor appearance when over the form
proc formCURSOR {fvar {type "normal"} {altcursor ""}} {
     global $fvar
    switch $type {
        normal {
            .$fvar configure -cursor {}
        }
        busy {
            .$fvar configure -cursor watch
        }
        alt {
            if {$altcursor != ""} {
                .$fvar configure -cursor $altcursor
            }
        }
        default { }
    }
    update
    update idletasks
}

#-----------------
# formTEXTTRACE -- turn on or off watching variables for change for variables
#                  associated with text widgets on form
proc formTEXTTRACE {fvar {opcode "on"}} {
    global $fvar
    # -- if fvar has TEXT widgets, set/unset traces
    if {[info exists ${fvar}(textitems)]} {
        foreach p [set ${fvar}(textitems)] {
            set var [set ${fvar}(var,$p)]
            global $var
            set elem [set ${fvar}(elem,$p)]
            if {$elem != ""} {set var "${var}($elem)"}
            if {$opcode == "on"} {
                trace variable $var w "formiUPDATETEXT $fvar $p"
            } else {
                trace vdelete $var w "formiUPDATETEXT $fvar $p"
            }
        }
    }
}

#-----------------
# formTEXTREFRESH -- update display of in text widgets from associated
#                    variable data source
proc formTEXTREFRESH {fvar} {
    global $fvar
    if {[info exists ${fvar}(textitems)]} {
        foreach titem [set ${fvar}(textitems)] {
            set var [set ${fvar}(var,$titem)]
            set elem [set ${fvar}(elem,$titem)]
            global $var
            if {$elem != {}} {set var "${var}($elem)"}
            trace vdelete $var w "formiUPDATETEXT $fvar $titem"
            $titem delete 1.0 end
            $titem insert end [set $var]
            trace variable $var w "formiUPDATETEXT $fvar $titem"
            set ${fvar}(dirty,$titem) 0
        }
    }
}

#-----------------
# formLISTCLEAR -- clears the contents of a (or all) scrollable list 
#                  widget(s) on form

proc formLISTCLEAR {fvar {path ""}} {
    global $fvar
    if {$path != ""} {
        $path delete 0 end
    } else {
        foreach item [set ${fvar}(listpaths)] {
            $item delete 0 end
        }
    }
}

#-----------------
# formLISTUPDATE -- insert items into a scrollable list on the form
#
proc formLISTUPDATE {fvar path var {elem {}}} {
    global $fvar $var
    formLISTCLEAR $fvar $path
    set vflag 0
    if {[info procs $var] != ""} {
        set vflag 2
    } elseif {[info exists $var]} {
        set vflag 1
    }
    if {$vflag == 0} {
        # -- insert literal list given in var
        foreach item $var {$path insert end $item}
        return
    }
    if {$vflag == 1} {
        global $var
        # -- insert values from a variable
        set tvar $var
        if {$elem != ""} {set tvar "${tvar}($elem)"}
        foreach item [set $tvar] {$path insert end $item}
        return
    }
    if {$vflag == 2} {
        # -- insert values from list returned from procedure
        if {$elem == {}} {
            set tlist [eval [concat $var $fvar $path]]
        } else { 
            set tlist [eval [concat $var $fvar $path $elem]]
        }
        foreach item $tlist {$path insert end $item}
    }
}


#=================
# INTERNAL PROCEDURES
#-----------------
#-----------------
# formiMARK -- mark a TEXT widget associated with an external 
#              variable as modified
proc formiMARK {fvar path} {
    global $path $fvar
    set ${fvar}(dirty,$path) 1
} 

#-----------------
# formiUPDATEVAR -- update a variable a TEXT widget on the form
#                    with the contents of the TEXT item 
proc formiUPDATEVAR {fvar path} {
    global $fvar $path
    set var [set ${fvar}(var,$path)]
    set elem [set ${fvar}(elem,$path)]
    set dirty [set ${fvar}(dirty,$path)]
    global $var
    if {$dirty} {
        if {$elem == {}} {
            set ${var} [$path get 1.0 end]
        } else {
            set ${var}($elem) [$path get 1.0 end]
        }
    }
    set ${fvar}(dirty,$path) 0
}
    
#-----------------
# formiUPDATETEXT -- update a TEXT widget with the new contents of its
#                     associated variable (via trace)
proc formiUPDATETEXT {fvar path var elem op} {
    global $fvar $path $var
    if {$elem != {}} {set var "${var}($elem)"}
    trace vdelete $var w "formiUPDATETEXT $fvar $path"
    $path delete 1.0 end
    $path insert end "[set $var]"
    trace variable $var w "formiUPDATETEXT $fvar $path"
    set ${fvar}(dirty,$path) 0
}

#-----------------
# formiLISTSELBEGIN -- initiate a LIST selection
proc formiLISTSELBEGIN {w y} {
    $w select anchor [$w nearest $y]
}

#-----------------
# formiLISTSELMOVE -- handle movement during LIST selection
proc formiLISTSELMOVE {w y} {
    $w select set anchor [$w nearest $y]
}

#-----------------
# formiLISTSELEND -- finalize a LIST selection
proc formiLISTSELEND {fvar w y ivflag ivar ielem ovflag ovar oelem} {
    global $fvar 
    $w select set anchor [$w nearest $y]
    set selindex [lindex [$w curselection] 0]
    if {$ivflag == 0} {
        if {$ovflag == 1} {
            global $ovar
            if {$oelem != ""} {set ovar "${ovar}($oelem)"}
            set $ovar [lindex $ivar $selindex]
        } elseif {$ovflag == 2} {
            if {oelem != ""} {
                catch "eval [list $ovar $fvar $selindex "[lindex $ivar $selindex]" $oelem]"
            } else { 
                catch "eval [list $ovar $fvar $selindex "[lindex $ivar $selindex]"]"
            }
        }
    }
    if {$ivflag == 1} {
        global $ivar
        if {$elem != ""} {set ivar "${ivar}($elem)"}
        if {$ovflag == 1} {
            global $ovar
            if {$oelem != ""} {set ovar "${ovar}($oelem)"}
            set $ovar [lindex $ivar $selindex]
        } elseif {$ovflag == 2} {
            if {oelem != ""} {
                catch "eval [list $ovar $fvar $selindex "[lindex [set $ivar] $selindex]" $oelem]"
            } else { 
                catch "eval [list $ovar $fvar $selindex "[lindex [set $ivar] $selindex]"]"
            }
        }
    }
    if {$ivflag == 2} {
        set tmp ""
        if {$ielem == ""} {
            catch "eval $ivar" tmp
        } else {
            catch "eval $ivar $ielem" tmp
        }
        if {$ovflag == 1} {
            global $ovar
            if {$oelem != ""} {set ovar "${ovar}($oelem)"}
            set $ovar [lindex $tmp $selindex]
        } elseif {$ovflag == 2} {
            if {$oelem != ""} {
                catch "eval [list $ovar $fvar [lindex $tmp $selindex]]"
            } else { 
                catch "eval [list $ovar $fvar [lindex $tmp $selindex] $oelem]"
            }
        }
    }
}

#-----------------
# formiLISTSELKEYEND -- finalize a LIST selection performed by <Return>
proc formiLISTSELKEYEND {fvar w ivflag ivar ielem ovflag ovar oelem} {
    global $fvar 
    $w select set anchor [$w index active]
    set selindex [lindex [$w curselection] 0]
    if {$ivflag == 0} {
        if {$ovflag == 1} {
            global $ovar
            if {$oelem != ""} {set ovar "${ovar}($oelem)"}
            set $ovar [lindex $ivar $selindex]
        } elseif {$ovflag == 2} {
            if {oelem != ""} {
                catch "eval [list $ovar $fvar $selindex "[lindex $ivar $selindex]" $oelem]"
            } else { 
                catch "eval [list $ovar $fvar $selindex "[lindex $ivar $selindex]"]"
            }
        }
    }
    if {$ivflag == 1} {
        global $ivar
        if {$elem != ""} {set ivar "${ivar}($elem)"}
        if {$ovflag == 1} {
            global $ovar
            if {$oelem != ""} {set ovar "${ovar}($oelem)"}
            set $ovar [lindex $ivar $selindex]
        } elseif {$ovflag == 2} {
            if {oelem != ""} {
                catch "eval [list $ovar $fvar $selindex "[lindex [set $ivar] $selindex]" $oelem]"
            } else { 
                catch "eval [list $ovar $fvar $selindex "[lindex [set $ivar] $selindex]"]"
            }
        }
    }
    if {$ivflag == 2} {
        set tmp ""
        if {$ielem == ""} {
            catch "eval $ivar" tmp
        } else {
            catch "eval $ivar $ielem" tmp
        }
        if {$ovflag == 1} {
            global $ovar
            if {$oelem != ""} {set ovar "${ovar}($oelem)"}
            set $ovar [lindex $tmp $selindex]
        } elseif {$ovflag == 2} {
            if {$oelem != ""} {
                catch "eval [list $ovar $fvar [lindex $tmp $selindex]]"
            } else { 
                catch "eval [list $ovar $fvar [lindex $tmp $selindex] $oelem]"
            }
        }
    }
}

#=================
# END OF FILE



