#
# $Header: /home/rockware/cvs-main/operator/tcl/opMailComments.tcl,v 1.20 1995/03/16 12:43:21 erez Exp $
# Written by: Erez Strauss (C) All Rights Reserved 1994, 1995.
#
# send mail.

itcl_class OpSendMail {
    inherit OpTopLevel
    constructor config {
        set tmp_menus "[.control get_tl_menus] $m_menus"
        OpTopLevel::constructor -name "Send Mail" \
            -title "Send Mail" \
            -buttons $m_buttons \
            -iconbitmap {} \
            -menus $tmp_menus \
            -menu_bar $m_menubar

        # *** add suport for iconbitmap
        global OPMailInfo
        opLabeledEntry $work_space.name Name: {} 20
        opLabeledEntry $work_space.addr Address: {} 40
        $work_space.addr.entry insert 0 $dflt_mail_destination
        opLabeledEntry $work_space.subject Subject: {} 16
        opLabeledEntry $work_space.system "System Type:" {} 20
        opLabeledEntry $work_space.command "Mail command:" {} 40
        label $work_space.textlabel -text "- Text -"
        ::pack $work_space.textlabel -fill x
        text $work_space.text -width 40 -height 12 -relief sunken -bd 1
        ::pack $work_space.text -expand on -fill both
        set was_sent 0
    }
    destructor {}
    method config config {}
    method send_mail {} {
        puts {OpSendMail::send_mail Start...}
        if {[$work_space.addr.entry get] != {}} {
            set destination [$work_space.addr.entry get]
        } {
            set destination $dflt_mail_destination
        }
        global env OPVersion OPMailInfo
        if [::info exists env(USER)] {
            set user $env(USER)
        } {
            set user {Unknown user}
        }
        set f [open "|mail -s $subject $destination" w]
        puts $f "Mail from: $user"
        puts $f "Operator version: $OPVersion"
        puts $f "Name: [$work_space.name.entry get]"
        puts $f "Address: [$work_space.addr.entry get]"
        puts $f "Subject: [$work_space.subject.entry get]"
        puts $f "System: [$work_space.system.entry get]"
        puts $f "Mail-Command: [$work_space.command.entry get]"
        puts $f " -- Message Start ... --"
        puts $f [$work_space.text get 0.0 end]
        puts $f " -- Message End. --"
        close $f
        puts {OpSendMail::send_mail End.}
        set was_sent 1
    }
    method quit? {} {
    # popup do you really want ??
        if $was_sent {
            $this delete
        } {
            $this delete ; # *** Really Quit ?
        }
    }
    public dflt_mail_destination {100274.260@Compuserve.Com} {}
    public subject {Comments} {}
    # when the fields are updated the was_sent flag should become 0 !
    protected was_sent 0 ; # Did we send the message ?
    common m_buttons {
        {"Mail It" . {THIS send_mail} {} {send mail}}
        {"Cancel" . {THIS quit?} {} {Cancel the mail operation}}
    }
    common m_menus {
        {m_file {
            {command -label Load   -underline 0 -command {}}
            {command -label Save   -underline 0 -command {}}
            {command -label Print  -underline 0 -command {}}
            {command -label Quit  -underline 0 -command {THIS quit?}}}
        }
        {m_edit {
            {command -label Empty  -underline 0 -command {}}}
        }
    }
    common m_menubar {{File 0 m_file} {Edit 0 m_edit} {Help 0 tl_help right}}
}
