#
# $Header: /home/rockware/cvs-main/operator/tcl/opActions.tcl,v 1.13 1995/03/16 12:43:19 erez Exp $
# Written by: Erez Strauss (C) All Rights Reserved 1994, 1995.
#
#  6. Files Activation
# Specific files operations.
#
proc opFileActivateOriginal { {filename {}} } {
    global dfltCmnd
    if {$filename == {}} return
    if [file isdirectory $filename] "OpDirView :: open $filename
        return"
    if [info exists dfltCmnd($filename)] {$dfltCmnd($filename)} {
        switch -regexp --  $filename                    \
            ^.*~$      {.fileRemove on -src $filename}       \
            ^.*,v$     {puts "co $filename disabled"}       \
            ^.*\.pnm$  {exec xv $filename &}                \
            ^.*\.gif$  {exec xv $filename &}                \
            ^.*\.GIF$  {exec xv $filename &}                \
            ^.*\.jpg$  {exec xv $filename &}                \
            ^.*\.JPG$  {exec xv $filename &}            \
            ^.*\.jpeg$ {exec xv $filename &}            \
            ^.*\.JPEG$ {exec xv $filename &}            \
            ^.*\.c$    {opFileEdit $filename}           \
            ^.*\.cc$   {opFileEdit $filename}           \
            ^.*\.h$    {opFileEdit $filename}           \
            ^.*\.tcl$  {opFileEdit $filename}           \
            ^.*\.z$    {exec gzip -d $filename}         \
            ^.*\.gz$   {exec gzip -d $filename}         \
            ^.*\.tgz$  {exec gzip -dc < $filename | tar tvf - } \
            ^.*\.xbm$  {exec xv -nolimit $filename &}   \
            ^.*\.xbm$  {exec bitmap $filename &}        \
            ^.*\.ps$   {exec ghostview $filename &}     \
            ^.*\.doc$  {exec decwrite $filename &}      \
            default    {if {[file executable $filename]} {exec $filename &} {
                opFileEdit $filename
            }
            }
    }
}
proc opFileActivate { {filename {}} } {
    global DefaultCmnd ListActivateRegexp ListActivateCommand
    if {$filename == {}} return
    if [file isdirectory $filename] {
        OpDirView :: open $filename
        return
    }
    if [info exists DefaultCmnd($filename)] {
        $dfltCmnd($filename)
    } {
        foreach name [lsort -integer [array names ListActivateRegexp]] {
            if [regexp $ListActivateRegexp($name) $filename] {
                eval [format $ListActivateCommand($name) $filename]
                return
            }
        }
        if [file executable $filename] {
            exec $filename &
        } {
            opFileEdit $filename
        }
    }
}
set ListActivateRegexp(1)          ^.*~$
set ListActivateCommand(1)         {.fileRemove on -src %s}
set ListActivateRegexp(2)          ^.*,v$
set ListActivateCommand(2)         {puts "co %s disabled"}
set ListActivateRegexp(3)          ^.*\\.pnm$
set ListActivateCommand(3)         {exec xv %s &}
set ListActivateRegexp(4)          ^.*\\.gif$
set ListActivateCommand(4)         {exec xv %s &}
set ListActivateRegexp(5)          ^.*\\.GIF$
set ListActivateCommand(5)         {exec xv %s &}
set ListActivateRegexp(6)          ^.*\\.jpg$
set ListActivateCommand(6)         {exec xv %s &}
set ListActivateRegexp(7)          ^.*\.JPG$
set ListActivateCommand(7)         {exec xv %s &}
set ListActivateRegexp(8)          ^.*\.jpeg$
set ListActivateCommand(8)         {exec xv %s &}
set ListActivateRegexp(9)          ^.*\.JPEG$
set ListActivateCommand(9)         {exec xv %s &}
set ListActivateRegexp(10)         ^.*\.c$
set ListActivateCommand(10)        {opFileEdit %s}
set ListActivateRegexp(11)         ^.*\.cc$
set ListActivateCommand(11)        {opFileEdit %s}
set ListActivateRegexp(12)         ^.*\.h$
set ListActivateCommand(12)        {opFileEdit %s}
set ListActivateRegexp(13)         ^.*\.tcl$
set ListActivateCommand(13)        {opFileEdit %s}
set ListActivateRegexp(14)         ^.*\.z$
set ListActivateCommand(14)        {exec gzip -d %s}
set ListActivateRegexp(15)         ^.*\.gz$
set ListActivateCommand(15)        {exec gzip -d %s}
set ListActivateRegexp(16)         ^.*\.tgz$
set ListActivateCommand(16)        {exec gzip -dc < %s | tar tvf -}
set ListActivateRegexp(17)         ^.*\.xbm$
set ListActivateCommand(17)        {exec xv -nolimit %s &}
set ListActivateRegexp(18)         ^.*\.xbm$
set ListActivateCommand(18)        {exec bitmap %s &}
set ListActivateRegexp(19)         ^.*\.ps$
set ListActivateCommand(19)        {exec ghostview %s &}
set ListActivateRegexp(20)         ^.*\.doc$
set ListActivateCommand(20)        {exec decwrite %s &}
set ListActivateRegexp(21)         ^.*\\.tif$
set ListActivateCommand(21)        {exec xv %s &}
set ListActivateRegexp(22)          ^.*core$
set ListActivateCommand(22)         {.fileRemove on -src %s}

proc opFilesActionsEdit {} {
    global ListActivateRegexp ListActivateCommand
    foreach name [lsort -integer [array names ListActivateRegexp]] {
        lappend entries "{Reg exp # $name: } ListActivateRegexp($name)"
        lappend entries "{Command # $name: } ListActivateCommand($name)"
    }
    opEntriesMenu .actupdate {Update Files Activation Commands} $entries \
        {{OK {.destroy .actupdate}}}
}

set OPNameToIcon(file,default) File_plain
set OPNameToIcon(file,file,default) File_plain
set OPNameToIcon(file,dir,default) Dir_plain
set OPNameToIcon(file,file,0,exp)  {.*\.c$}
set OPNameToIcon(file,file,0,icon) File_c
set OPNameToIcon(file,file,1,exp)  {.*~$}
set OPNameToIcon(file,file,1,icon) File_backup
set OPNameToIcon(file,file,2,exp)  {(^|(.*/))core$}
set OPNameToIcon(file,file,2,icon) File_core
set OPNameToIcon(file,file,3,exp)  {.*\.h$}
set OPNameToIcon(file,file,3,icon) File_h
set OPNameToIcon(file,file,3,exp)  {.*\.s$}
set OPNameToIcon(file,file,3,icon) File_s
set OPNameToIcon(file,file,4,exp)  {.*\.o$}
set OPNameToIcon(file,file,4,icon) File_o
set OPNameToIcon(file,file,5,exp)  {.*\.tar$}
set OPNameToIcon(file,file,5,icon) File_tar
set OPNameToIcon(file,file,6,exp)  {.*\.((tar.gz)|(tgz))$}
set OPNameToIcon(file,file,6,icon) File_tgz

proc opNameToBitmapFile {name {type file}} {
    global OPNameToIcon
    if {$type == "file"} {
        if {$name == {}} {
            return [opNameToFile $OPNameToIcon($type,default) bitmap]
        }
        if [file isdirectory $name] {set d dir} {set d file}

        set i 0
        while {[info exists OPNameToIcon($type,$d,$i,exp)]} {
            if [regexp $OPNameToIcon($type,$d,$i,exp) $name] {
                return [opNameToFile $OPNameToIcon($type,$d,$i,icon) bitmap]
            }
            incr i
        }
        if [info exists OPNameToIcon($type,$d,default)] {
            return [opNameToFile $OPNameToIcon($type,$d,default) bitmap]
        }
    }
    # all the other type don't have the d flag.
    if {$name == {}} {
        return [opNameToFile $OPNameToIcon($type,default) bitmap]
    }
    set i 0
    while {[info exists OPNameToIcon($type,$i,exp)]} {
        if [regexp $OPNameToIcon($type,$i,exp) $name] {
            return [opNameToFile $OPNameToIcon($type,$i,icon) bitmap]
        }
        incr i
    }
    if [info exists OPNameToIcon($type,default)] {
        return [opNameToFile $OPNameToIcon($type,default) bitmap]
    }
}



