#==============================================================================
#                                 teapot.tcl
#------------------------------------------------------------------------------
# A port of SIPP demo program teapot.c to Tcl-SIPP.
#------------------------------------------------------------------------------
# $Id: teapot.tcl,v 5.0 1994/09/05 01:21:52 markd Rel $
#------------------------------------------------------------------------------

if {[info commands DoRendering] == ""} {
    if [file exists ./demoutil.tlib] {
        loadlibindex ./demoutil.tlib
    } else {
        set demoutil [searchpath $auto_path demos/demoutil.tlib]
        if [lempty $demoutil] {
            error "Can't find \"demos/demoutil.tlib\" on auto_path"
        }
        loadlibindex $demoutil
    }
}
ParseDemoArgs

set RESOLUTION 9

#
# The SIPP demo defines special shaders (hole_shared & floor_shared)), but we
# can't do that in TSIPP (yet).  We live with it.
#
set teapotShader [SippShaderBasic 0.4 0.5 0.1 {0.9 0.6 0.6} {0.45 0.45 0.45}]
set floorShader [SippShaderBasic 0.4 0.0 0.1 {0.9900 0.9000 0.7900} \
                                             {1.0 1.0 1.0}]


SippShowBackFaces true
SippBackground {0.078 0.361 0.753}  ;# UNC sky blue

SippLightSourceCreate {-3.0 -2.0 6.0} {0.35 0.35 0.35} DIRECTION
SippSpotLightCreate {-3.0 -2.0 6.0} {0.0 0.0 0.0} 25.0 {0.45 0.45 0.45} \
                     SOFT true
set teapot [SippTeapot $RESOLUTION $teapotShader WORLD]
set bottom [SippCylinder 0.375 0.01 [expr $RESOLUTION * 4] $teapotShader WORLD]
SippObjectMove $bottom {0.0 0.0 0.005}
SippObjectAddSubobj $teapot $bottom

SippObjectAddSubobj WORLD $teapot


# The floor will never cast a shadow on anything so
# we render the shadowmaps before creating it.

SippShadowMapsCreate [expr ($G_size < 512) ? (2 * $G_size) : $G_size]

set floor [SippBlock {7.0 7.0 0.2} $floorShader WORLD]
SippObjectMove $floor {0.0 0.0 -0.1}
SippObjectAddSubobj WORLD $floor
 
SippCameraParams STDCAMERA {1.65 -7.7 3.3}  {0.0 0.0 0.4} {0.0 0.0 1.0} \
                 0.125

DoRendering "teapot"
