#==============================================================================
#                                  vwbf.tcl
#------------------------------------------------------------------------------
# Defines the VW back fender surface.
#
# Copyright (c) Evans & Sutherland - ok to distribute if copyright appears.
#------------------------------------------------------------------------------
# $Id: vwbf.tcl,v 4.0 1993/11/27 21:25:29 markd Rel $
#==============================================================================

proc SippVWBackFender {side shader} {

    set pnt(1)  {28.750   28.250    8.500}
    set pnt(2)  {29.500   30.000    8.500}
    set pnt(3)  {26.750   27.000   11.500}
    set pnt(4)  {28.250   27.500   11.000}
    set pnt(5)  {28.750   28.000   10.500}
    set pnt(6)  {29.750   30.000    8.500}
    set pnt(7)  {29.750   31.500   10.500}
    set pnt(8)  {27.000   27.000   11.500}
    set pnt(9)  {28.250   27.750   13.250}
    set pnt(10) {29.250   28.500   13.000}
    set pnt(11) {29.500   29.500   12.750}
    set pnt(12) {29.750   31.500   12.500}
    set pnt(13) {27.500   28.250   19.500}
    set pnt(14) {28.500   29.500   18.750}
    set pnt(15) {29.500   30.250   18.250}
    set pnt(16) {30.000   31.750   17.875}
    set pnt(17) {30.125   33.000   17.500}
    set pnt(18) {27.500   32.750   26.250}
    set pnt(19) {28.500   33.500   26.250}
    set pnt(20) {29.500   34.250   25.250}
    set pnt(21) {30.125   35.750   24.250}
    set pnt(22) {30.250   36.750   23.000}
    set pnt(23) {26.250   39.750   31.000}
    set pnt(24) {27.750   40.000   30.250}
    set pnt(25) {29.125   41.000   29.250}
    set pnt(26) {30.000   42.000   28.000}
    set pnt(27) {30.250   42.500   25.750}
    set pnt(28) {24.250   47.750   33.000}
    set pnt(29) {26.125   48.500   32.250}
    set pnt(30) {28.250   49.000   30.750}
    set pnt(31) {29.750   49.750   28.750}
    set pnt(32) {30.250   50.000   25.750}
    set pnt(33) {21.000   57.000   30.750}
    set pnt(34) {25.250   57.250   29.000}
    set pnt(35) {28.250   57.500   26.750}
    set pnt(36) {29.750   57.000   24.750}
    set pnt(37) {30.125   56.000   22.750}
    set pnt(38) {18.250   61.750   26.000}
    set pnt(39) {22.750   62.250   25.750}
    set pnt(40) {23.750   62.500   24.250}
    set pnt(41) {27.500   62.250   22.500}
    set pnt(42) {29.500   60.000   20.250}
    set pnt(43) {30.000   58.750   19.000}
    set pnt(44) {17.200   64.000   24.000}
    set pnt(45) {19.250   64.100   23.750}
    set pnt(46) {24.000   64.500   22.250}
    set pnt(47) {26.750   63.250   21.500}
    set pnt(48) {15.100   68.000   20.500}
    set pnt(49) {19.000   67.500   20.250}
    set pnt(50) {18.750   66.000   23.500}
    set pnt(51) {24.000   65.250   21.750}
    set pnt(52) {26.750   64.500   19.000}
    set pnt(53) {28.750   63.000   16.750}
    set pnt(54) {29.500   62.000   14.250}
    set pnt(55) {23.500   67.000   19.500}
    set pnt(56) {26.250   67.500   17.750}
    set pnt(57) {28.750   65.250   13.000}
    set pnt(58) {22.750   67.750   18.500}
    set pnt(59) {25.250   70.250   11.000}
    set pnt(60) {21.000   68.750   18.000}
    set pnt(61) {21.250   73.500   10.500}
    set pnt(62) {15.000   70.000   18.500}
    set pnt(63) {14.500   75.200    9.750}
    set pnt(64) {21.500   65.750   25.250}
    set pnt(65) {23.000   66.250   23.750}
    set pnt(66) {23.250   67.500   21.250}
    set pnt(67) {22.750   68.250   19.750}
    set pnt(68) {21.000   69.000   18.500}
    set pnt(69) {19.500   68.250   20.750}
    set pnt(70) {19.500   67.000   22.500}
    set pnt(71) {20.250   66.250   24.000}
    set pnt(72) {21.500   68.250   24.250}
    set pnt(73) {22.500   68.750   23.500}
    set pnt(74) {22.750   69.250   21.250}
    set pnt(75) {22.250   69.500   20.750}
    set pnt(76) {21.125   69.750   19.000}
    set pnt(77) {19.750   69.500   20.250}
    set pnt(78) {20.125   68.750   23.000}
    set pnt(79) {22.750   53.000   32.100}
    set pnt(80) {19.750   69.250   21.500}

    SippVW:DefPoly $side pnt { 1  5  4}
    SippVW:DefPoly $side pnt { 1  2  6  5}
    SippVW:DefPoly $side pnt { 2  7  6}
    SippVW:DefPoly $side pnt { 3  4  9  8}
    SippVW:DefPoly $side pnt { 4  5 10  9}
    SippVW:DefPoly $side pnt { 5  6 11 10}
    SippVW:DefPoly $side pnt { 6  7 12 11}
    SippVW:DefPoly $side pnt { 8  9 14 13}
    SippVW:DefPoly $side pnt { 9 10 15 14}
    SippVW:DefPoly $side pnt {10 11 16 15}
    SippVW:DefPoly $side pnt {11 12 17 16}
    SippVW:DefPoly $side pnt {13 14 19 18}
    SippVW:DefPoly $side pnt {14 15 20 19}
    SippVW:DefPoly $side pnt {15 16 21 20}
    SippVW:DefPoly $side pnt {16 17 22 21}
    SippVW:DefPoly $side pnt {18 19 24 23}
    SippVW:DefPoly $side pnt {19 20 25 24}
    SippVW:DefPoly $side pnt {20 21 26 25}
    SippVW:DefPoly $side pnt {21 22 27 26}
    SippVW:DefPoly $side pnt {23 24 29 28}
    SippVW:DefPoly $side pnt {24 25 30 29}
    SippVW:DefPoly $side pnt {25 26 31 30}
    SippVW:DefPoly $side pnt {26 27 32 31}
    SippVW:DefPoly $side pnt {28 29 30 34 33}
    SippVW:DefPoly $side pnt {30 31 36 35 34}
    SippVW:DefPoly $side pnt {31 32 37 36}
    SippVW:DefPoly $side pnt {33 34 39 38}
    SippVW:DefPoly $side pnt {34 35 40 39}
    SippVW:DefPoly $side pnt {35 36 42 41 40}
    SippVW:DefPoly $side pnt {36 37 43 42}
    SippVW:DefPoly $side pnt {40 41 47 46}
    SippVW:DefPoly $side pnt {41 42 53 52 47}
    SippVW:DefPoly $side pnt {42 43 54 53}
    SippVW:DefPoly $side pnt {46 47 52 51}
    SippVW:DefPoly $side pnt {51 52 56 55}
    SippVW:DefPoly $side pnt {52 53 54 57 56}
    SippVW:DefPoly $side pnt {55 56 57 59 58}
    SippVW:DefPoly $side pnt {58 59 61 60}
    SippVW:DefPoly $side pnt {60 61 63}
    SippVW:DefPoly $side pnt {60 63 62}
    SippVW:DefPoly $side pnt {48 49 60 62}
    SippVW:DefPoly $side pnt {48 50 49}
    SippVW:DefPoly $side pnt {44 45 50 48}
    SippVW:DefPoly $side pnt {38 39 45 44}
    SippVW:DefPoly $side pnt {79 28 33}

    SippSurfaceCreate $shader
}
