 #########################################################################
 #                                                                       #
 # Copyright (C) 1993 by General Electric company.  All rights reserved. #
 #                                                                       #
 # Permission to use, copy, modify, and distribute this                  #
 # software and its documentation for any purpose and without            #
 # fee is hereby granted, provided that the above copyright              #
 # notice appear in all copies and that both that copyright              #
 # notice and this permission notice appear in supporting                #
 # documentation, and that the name of General Electric not be used in   #
 # advertising or publicity pertaining to distribution of the            #
 # software without specific, written prior permission.                  #
 #                                                                       #
 # General Electric makes no representations about the suitability of    #
 # this software for any purpose.  It is provided ``as is''              #
 # without express or implied warranty.                                  #
 #                                                                       #
 # This work was supported in part by the DARPA Initiative in Concurrent #
 # Engineering (DICE) through DARPA Contracts MDA972-88-C-0047 and       #
 # MDA972-92-C-0027.                                                     #
 #                                                                       #
 # This work was supported in part by the Tri-Services Microwave and     #
 # Millimeter-Wave Advanced Computational Environment (MMACE) program    #
 # under Naval Research Laboratory contract N00014-92-C-2044.            #
 #                                                                       #
 #########################################################################


# File:	textAux.tcl
#
# Description:
#	Additional bindings for Text widgets.
#
#	At present, most of the Tk library default bindings are used
#	for text widgets.  The exceptions are as follows.
#
#	- The <ButtonPress-1> event is handled locally, to support the
#	  hybrid focus model.
#
#	- Bindings are established on <Control-Tab> and <Control-Shift-Tab>
#	  for keyboard traversal of the widgets.
#
#	The plan is eventually to incorporate Andrew Payne's `emacs' bindings
#	into the binding set.

 # $Id: textAux.tcl,v 1.11 1993/11/01 18:20:46 kennykb Exp $
 # $Source: /homedisk/julius/u0/kennykb/src/tkauxlib_ship/RCS/textAux.tcl,v $
 # $Log: textAux.tcl,v $
 # Revision 1.11  1993/11/01  18:20:46  kennykb
 # Beta release to be announced on comp.lang.tcl
 #
 # Revision 1.10  1993/10/27  15:52:49  kennykb
 # Package for alpha release to the Net, and for MMACE 931101 release.
 #
 # Revision 1.9  1993/10/20  19:10:47  kennykb
 # Alpha release #1 was thawed for bug fixes in tk 3.3.  Now frozen again at this
 # point.
 #
 # Revision 1.8  1993/10/20  19:06:24  kennykb
 # Repaired copyright notice so that it doesn't look like structured commentary.
 #
 # Revision 1.7  1993/10/14  18:15:42  kennykb
 # Cleaned up alignment of log messages, to avoid problems extracting
 # structured commentary.
 #
 # Revision 1.6  1993/10/14  18:06:59  kennykb
 # Added GE legal notice to head of file in preparation for release.
 #
 # Revision 1.5  1993/10/14  14:02:02  kennykb
 # Alpha release #1 frozen at this point.
 #
 # Revision 1.4  1993/07/21  19:44:36  kennykb
 # Finished cleaning up structured commentary.
 #
 # Revision 1.3  1993/07/20  19:17:12  kennykb
 # Improved structured comments.
 # Changed modules through `g' in the alphabet to follow `:' and `_' naming
 # conventions.
 #
 # Revision 1.2  1993/07/16  15:58:00  kennykb
 # Renamed all commands that start with `wiget.' to either `widget_' or
 # `widget:'.  Added the code for creating composite widgets.
 #
 # Revision 1.1  1993/06/03  15:32:16  kennykb
 # Initial revision
 #

# Procedure:	text.press
#
# Synopsis:
#	Handle <ButtonPress-1> event in a text widget.
#
# Usage:
#c	text.press pathName x y
#
# Parameters:
#c	pathName
#		Path name of a text widget.
#c	x
#		X co-ordinate of the mouse within the widget.
#c	y
#		Y co-ordinate of the mouse within the widget.
#
# Return value:
#	None
#
# Description:
#	`text.press' handles the <ButtonPress-1> event in a text widget.
#	It replaces Tk's default handler for the widget, and differs from it
#	only in that the `focus' command in the default handler is replaced
#	with `focus_goTo,' to enable focus management.

proc text.press {w x y} {
	global tk_priv
	set tk_priv(selectMode) char
	$w mark set insert @$x,$y
	$w mark set anchor insert
	if {[lindex [$w config -state] 4] == "normal"} {
		focus_goTo $w
	}
}
