'\"
'\" Copyright (c) 1990 The Regents of the University of California.
'\" All rights reserved.
'\"
'\" Permission is hereby granted, without written agreement and without
'\" license or royalty fees, to use, copy, modify, and distribute this
'\" documentation for any purpose, provided that the above copyright
'\" notice and the following two paragraphs appear in all copies.
'\"
'\" IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
'\" FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
'\" ARISING OUT OF THE USE OF THIS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
'\" CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'\"
'\" THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
'\" INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
'\" AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
'\" ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
'\" PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
'\" 
'\" Copyright (c) 1993, Mark G. Christenson.  All rights reserved.
'\" 
'\"
'\" $Header: /user6/ouster/wish/man/RCS/frame.n,v 1.9 93/04/01 09:52:40 ouster Exp $ SPRITE (Berkeley)
'/" 
.so man.macros
.HS input tk
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
input \- Create and manipulate input widgets
.SH SYNOPSIS
\fBinput\fI \fIpathName \fR?\fB\-class \fIclassName\fR? ?\fIoptions\fR?
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.VS
\fBcursor\fR	\fBgeometry\fR
.VE
.fi
.LP
See the ``options'' manual entry for details on the standard options.
.SH "WIDGET-SPECIFIC OPTIONS"
.LP
.nf
.VS
Name:	\fBheight\fR
Class:	\fBHeight\fR
Command-Line Switch:	\fB\-height\fR
.fi
.IP
Specifies the desired height for the window in any of the forms
acceptable to \fBTk_GetPixels\fR.
This option is only used if the \fB\-geometry\fR option is
unspecified.
If this option is less than or equal to zero (and \fB\-geometry\fR
is not specified) then the window will not request any size at
all.
.LP
.nf
Name:	\fBwidth\fR
Class:	\fBWidth\fR
Command-Line Switch:	\fB\-width\fR
.fi
.IP
Specifies the desired width for the window in any of the forms
acceptable to \fBTk_GetPixels\fR.
This option is only used if the \fB\-geometry\fR option is
unspecified.
If this option is less than or equal to zero (and \fB\-geometry\fR
is not specified) then the window will not request any size at
all.
.VE
.BE

.SH DESCRIPTION
.PP
The \fBinput\fR command creates a new window (given by the
\fIpathName\fR argument) and makes it into an input widget.
Additional
options, described above, may be specified on the command line
or in the option database
to configure aspects of the window such as its cursor and
geometry.  The \fBinput\fR command returns the
path name of the new window.
.PP
An input widget is a simple widget.  Its primary purpose is to provide
access to the Tk binding mechanisms.  It can, for example, be used to
provide a \fIbusy\fR window which is placed over another widget to change
the cursor and prevent input events from reaching the widgets it covers.
The only feature of an input widget is its cursor.
.PP
In addition to the standard options listed above, a \fB\-class\fR
option may be specified on the command line.  If it is specified, then
the new widget's class will be set to \fIclassName\fR instead of
\fBInput\fR.  Changing the class of an input widget may be useful
in order to use a special class name in database options referring
to this widget and its children.  Note:  \fB\-class\fR is handled
differently than other command-line options and cannot be specified
using the option database (it has to be processed
before the other options are even looked up, since the new class
name will affect the lookup of the other options).  In addition,
the \fB\-class\fR option may not be queried or changed using the
\fBconfig\fR command described below.

.SH "WIDGET COMMAND"
.PP
The \fBinput\fR command creates a new Tcl command whose
name is the same as the path name of the window.  This
command may be used to invoke various
operations on the widget.  It has the following general form:
.DS C
\fIpathName option \fR?\fIarg arg ...\fR?
.DE
\fIPathName\fR is the name of the command, which is the same as
the widget's path name.  \fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  The following
commands are possible for input widgets:
.TP
\fIpathName \fBconfigure\fR ?\fIoption\fR? \fI?value option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBinput\fR
command.

.SH BINDINGS
.PP
When a new input widget is created, it has no default event bindings.

.SH KEYWORDS
input, widget
